/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.helper.pricemodel.pojo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteConditonInfo;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteSchemeColl;
import kd.scmc.plat.common.consts.pricemodel.QuoteConst;

public class QuoteStrategeColl {
    private List<DynamicObject> quoteStrateges = new ArrayList<DynamicObject>();
    private Map<Object, List<QuoteConditonInfo>> mapping = new HashMap<Object, List<QuoteConditonInfo>>();
    private Map<Object, QuoteSchemeColl> schemeCollMapping = new HashMap<Object, QuoteSchemeColl>();

    public List<String> mergeDimension() {
        ArrayList<String> dimensionSet = new ArrayList<String>();
        this.mapping.forEach((k, v) -> v.forEach(s -> this.generateDimension(dimensionSet, s.getQs_preFilter())));
        this.schemeCollMapping.forEach((k, v) -> v.mergeDimension(dimensionSet));
        return dimensionSet;
    }

    public List<String> mergeAlias() {
        ArrayList<String> aliasSet = new ArrayList<String>();
        this.mapping.forEach((k, v) -> v.forEach(s -> this.generateAlias(aliasSet, s.getQs_preFilter())));
        this.schemeCollMapping.forEach((k, v) -> v.mergeAlias(aliasSet));
        return aliasSet;
    }

    private void generateDimension(List<String> dimensionSet, QFilter f) {
        if (!"1".equals(f.getProperty()) && !dimensionSet.contains(f.getProperty())) {
            dimensionSet.add(f.getProperty());
        }
        if (f.isExpressValue() && !dimensionSet.contains(f.getValue())) {
            dimensionSet.add(f.getValue().toString());
        }
        List listFilterNest = f.getNests(false);
        for (QFilter.QFilterNest nest : listFilterNest) {
            QFilter nestFilter = nest.getFilter();
            this.generateDimension(dimensionSet, nestFilter);
        }
    }

    private void generateAlias(List<String> aliasSet, QFilter f) {
        String valueAlias;
        String alias;
        if (!"1".equals(f.getProperty()) && !aliasSet.contains(alias = new StringBuffer(QuoteConst.LEFT).append(new StringBuffer(f.getProperty().replaceAll("\\.", "__"))).toString())) {
            aliasSet.add(alias);
        }
        if (f.isExpressValue() && !aliasSet.contains(valueAlias = new StringBuffer(QuoteConst.LEFT).append(new StringBuffer(f.getValue().toString().replaceAll("\\.", "__"))).toString())) {
            aliasSet.add(valueAlias);
        }
        List listFilterNest = f.getNests(false);
        for (QFilter.QFilterNest nest : listFilterNest) {
            QFilter nestFilter = nest.getFilter();
            this.generateAlias(aliasSet, nestFilter);
        }
    }

    public List<DynamicObject> getQuoteStrateges() {
        return this.quoteStrateges;
    }

    public Map<Object, List<QuoteConditonInfo>> getMapping() {
        return this.mapping;
    }

    public Map<Object, QuoteSchemeColl> getSchemeCollMapping() {
        return this.schemeCollMapping;
    }

    public QuoteSchemeColl getQuoteSchemeColl(Object quoteStrategePk) {
        QuoteSchemeColl coll = this.getSchemeCollMapping().get(quoteStrategePk);
        return coll;
    }
}

