/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.service.pricemodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scmc.plat.business.helper.pricemodel.helper.DataSetHelper;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteKeyInfo;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteParam;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuotePolicyParam;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteSchemeColl;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteSchemeInfo;
import kd.scmc.plat.business.service.pricemodel.QuoteDataSetPolicy;
import kd.scmc.plat.business.service.pricemodel.QuoteMultiPolicy;
import kd.scmc.plat.business.service.pricemodel.QuotePolicy;
import kd.scmc.plat.business.service.pricemodel.log.QuoteLogProxy;
import kd.scmc.plat.common.consts.pricemodel.QuoteConst;
import kd.scmc.plat.common.enums.price.ReturnPatternEnum;

public class QuoteEngine
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(QuoteEngine.class);
    protected QuoteLogProxy logProxy;

    public QuoteEngine(QuoteLogProxy logProxy) {
        this.logProxy = logProxy;
    }

    public Map<String, Object> startQuote(QuoteSchemeColl quoteSchemeColl, QuoteParam quoteParam) {
        ArrayList<QuotePolicy> quotePolicys = new ArrayList<QuotePolicy>(quoteSchemeColl.getQuoteSchemeInfos().size());
        for (int i = 0; i < quoteSchemeColl.getQuoteSchemeInfos().size(); ++i) {
            QuotePolicy policy;
            QuoteSchemeInfo qs = quoteSchemeColl.getQuoteSchemeInfos().get(i);
            if (!this.hasQuoteNext(quoteParam)) continue;
            QuotePolicyParam quotePolicyParam = new QuotePolicyParam(quoteParam.getQuoteOriginDataSet().copy(), (Long)quoteSchemeColl.getQuoteStratege().getDynamicObject("createorg").getPkValue(), quoteParam.getQccInfo());
            if (ReturnPatternEnum.TOP_LEVEL.getValue().equals(qs.getReturnPattern())) {
                policy = new QuoteDataSetPolicy(quotePolicyParam);
                quotePolicys.add(policy);
            } else {
                policy = new QuoteMultiPolicy(quotePolicyParam);
                quotePolicys.add(policy);
            }
            policy.query(quotePolicyParam, qs, this.logProxy);
            this.suplusDataSet(quoteParam, quotePolicyParam, qs);
        }
        Map<String, Object> result = this.buildResult(quotePolicys, quoteParam, quoteSchemeColl);
        this.logProxy.setEndTime(TimeServiceHelper.now());
        return result;
    }

    private void suplusDataSet(QuoteParam quoteParam, QuotePolicyParam quotePolicyParam, QuoteSchemeInfo quoteSchemeInfo) {
        String terminationSign = quoteSchemeInfo.getTerminationSign();
        if (StringUtils.isNotEmpty((CharSequence)terminationSign)) {
            DataSet quoteOriginDataSet = quoteParam.getQuoteOriginDataSet();
            DataSet result = null;
            try {
                log.info("midlog===1");
                result = quotePolicyParam.getResultSet().copy();
                log.info("midlog===2");
            }
            catch (AlgoException e) {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                catch (Throwable ex) {
                    e.addSuppressed(ex);
                }
                throw new KDBizException(e.getMessage());
            }
            String resultField = quoteSchemeInfo.getQuoteResultsAlias().get(0);
            String resultFieldAlias = new StringBuffer(QuoteConst.RESULT).append(resultField).toString();
            String resultSelector = new StringBuffer(quoteSchemeInfo.getQuoteResultsAlias().get(0)).append(" ").append(resultFieldAlias).toString();
            String filterStr = new StringBuffer(resultFieldAlias).append(" is null").toString();
            JoinHint hint = new JoinHint();
            hint.setNullAsZero(true);
            JoinDataSet resultSet = quoteOriginDataSet.join(result, JoinType.LEFT).hint(hint);
            for (String key : quoteParam.getQccInfo().getLEFTIDFIELDS()) {
                resultSet = resultSet.on(key, key);
            }
            Field[] quoteOriginFields = quoteOriginDataSet.getRowMeta().getFields();
            String[] fields = new String[quoteOriginFields.length];
            for (int i = 0; i < quoteOriginFields.length; ++i) {
                fields[i] = quoteOriginFields[i].getName();
            }
            quoteOriginDataSet = resultSet.select(fields, new String[]{resultSelector}).finish().where(filterStr);
            quoteOriginDataSet = quoteOriginDataSet.select(fields);
            quoteParam.setQuoteOriginDataSet(quoteOriginDataSet);
        }
    }

    protected Map<String, Object> buildResult(List<QuotePolicy> quotePolicys, QuoteParam quoteParam, QuoteSchemeColl quoteSchemeColl) {
        HashMap<String, Object> priceMapping = new HashMap<String, Object>();
        if (quotePolicys.size() == 0) {
            return priceMapping;
        }
        List[] resultFieldsAliasArray = quoteSchemeColl.divideHeadAndEntryResultsAlias();
        List headAliasFields = resultFieldsAliasArray[0];
        List entryAliasFields = resultFieldsAliasArray[1];
        for (int i = 0; i < quotePolicys.size(); ++i) {
            QuotePolicy p = quotePolicys.get(i);
            try (DataSet result = p.getQuotePolicyParam().getResultSet();){
                List<String> includeHeadAliasFields = DataSetHelper.getIncludeFields(headAliasFields, result);
                List<String> includeEntryAliasFields = DataSetHelper.getIncludeFields(entryAliasFields, result);
                for (Row row : result) {
                    Object priceResult;
                    String[] keys;
                    String priceField;
                    String[] subFields;
                    if (includeHeadAliasFields.size() > 0) {
                        for (String headAliasField : includeHeadAliasFields) {
                            subFields = headAliasField.split("__");
                            priceField = subFields[subFields.length - 1];
                            keys = this.generateHeadKey(row, priceField);
                            priceResult = row.get(headAliasField);
                            for (String key : keys) {
                                this.arrangeHeadPriceValue(priceMapping, key, priceResult);
                            }
                        }
                    }
                    if (includeEntryAliasFields.size() > 0) {
                        for (String entryAliasField : includeEntryAliasFields) {
                            subFields = entryAliasField.split("__");
                            priceField = subFields[subFields.length - 1];
                            keys = this.generateKey(quoteParam.getQccInfo(), row, priceField);
                            priceResult = row.get(entryAliasField);
                            for (String key : keys) {
                                priceMapping.put(key, priceResult);
                            }
                        }
                    }
                    this.setIscover(quoteParam, priceMapping, row);
                }
                continue;
            }
        }
        this.fillEmpty(quoteParam, quoteSchemeColl, priceMapping);
        priceMapping.put("success", Boolean.TRUE);
        return priceMapping;
    }

    protected void fillEmpty(QuoteParam quoteParam, QuoteSchemeColl quoteSchemeColl, Map<String, Object> priceMapping) {
        log.info("sub-stoplog===1");
        try (DataSet quoteOriginDataSet = quoteParam.getQuoteOriginDataSet();){
            this.logProxy.setMissedRecDataSet(quoteOriginDataSet);
        }
        log.info("sub-stoplog===2");
    }

    protected void setIscover(QuoteParam quoteParam, Map<String, Object> priceMapping, Row row) {
    }

    protected void arrangeHeadPriceValue(Map<String, Object> priceMapping, String key, Object priceResult) {
        if (priceResult == null) {
            priceMapping.put(key, priceResult);
        } else if (!priceMapping.containsKey(key)) {
            priceMapping.put(key, priceResult);
        } else {
            Object oldValue = priceMapping.get(key);
            if (oldValue != null && !priceResult.equals(oldValue)) {
                priceMapping.put(key, null);
            }
        }
    }

    private boolean hasQuoteNext(QuoteParam quoteParam) {
        try (DataSet quoteOriginDataSetCopy = null;){
            log.info("kiklog===1");
            quoteOriginDataSetCopy = quoteParam.getQuoteOriginDataSet().copy();
            log.info("kiklog===2");
            int i = 0;
            for (Row row : quoteOriginDataSetCopy) {
                log.info("kiklog===3");
                if (++i <= 0) continue;
                log.info("kiklog===4");
                boolean bl = true;
                return bl;
            }
            log.info("kiklog===5");
            boolean bl = false;
            return bl;
        }
    }

    protected String[] generateKey(QuoteKeyInfo quoteKeyInfo, Row row, String priceField) {
        String[] keys = new String[2];
        StringBuilder key = new StringBuilder();
        StringBuilder newKey = new StringBuilder();
        for (String idField : quoteKeyInfo.getLEFTIDFIELDS()) {
            key.append(String.valueOf(row.get(idField))).append('_');
            newKey.append(String.valueOf(row.get(idField))).append("$$");
        }
        key.append(priceField);
        newKey.append(priceField);
        keys[0] = key.toString();
        keys[1] = newKey.toString();
        return keys;
    }

    protected String[] generateHeadKey(Row row, String priceField) {
        String[] keys = new String[2];
        StringBuilder key = new StringBuilder();
        StringBuilder newKey = new StringBuilder();
        key.append(String.valueOf(row.get(QuoteKeyInfo.LEFT_ID))).append('_');
        newKey.append(String.valueOf(row.get(QuoteKeyInfo.LEFT_ID))).append("$$");
        key.append(priceField);
        newKey.append(priceField);
        keys[0] = key.toString();
        keys[1] = newKey.toString();
        return keys;
    }

    @Override
    public void close() {
    }
}

