/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.service.pricemodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.scmc.plat.business.helper.pricemodel.helper.QuoteHelper;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteParam;
import kd.scmc.plat.business.service.pricemodel.QuoteEngine;
import kd.scmc.plat.business.service.pricemodel.QuotePolicy;
import kd.scmc.plat.business.service.pricemodel.log.QuoteLogProxy;

public class QuoteMultiEngine
extends QuoteEngine {
    public QuoteMultiEngine(QuoteLogProxy logProxy) {
        super(logProxy);
    }

    protected Map<String, Object> buildResult(List<QuotePolicy> quotePolicys, QuoteParam quoteParam, List<String> resultFileds) {
        HashMap<String, Object> priceMapping = new HashMap<String, Object>();
        if (quotePolicys.size() == 0) {
            return priceMapping;
        }
        for (int i = 0; i < quotePolicys.size(); ++i) {
            QuotePolicy p = quotePolicys.get(i);
            try (DataSet result = p.getQuotePolicyParam().getResultSet();){
                Field[] fields = result.getRowMeta().getFields();
                for (Row row : result) {
                    String key = QuoteHelper.generateRowKey(quoteParam.getQccInfo(), row);
                    HashMap<String, Object> rowObj = new HashMap<String, Object>();
                    for (Field field : fields) {
                        if (quoteParam.getQccInfo().getLEFTIDFIELDS().contains(field.getName())) continue;
                        String[] subFields = field.getName().split("__");
                        String priceField = subFields[subFields.length - 1];
                        rowObj.put(priceField, row.get(field.getName()));
                    }
                    Object resultList = priceMapping.computeIfAbsent(key, k -> new ArrayList());
                    ((List)resultList).add(rowObj);
                }
                continue;
            }
        }
        this.fillEmpty(quoteParam, priceMapping);
        priceMapping.put("success", Boolean.TRUE);
        return priceMapping;
    }

    protected void fillEmpty(QuoteParam quoteParam, Map<String, Object> priceMapping) {
        this.logProxy.setMissedRecDataSet(quoteParam.getQuoteOriginDataSet());
        try (DataSet suplusResult = quoteParam.getQuoteOriginDataSet();){
            for (Row row : suplusResult) {
                String key = QuoteHelper.generateRowKey(quoteParam.getQccInfo(), row);
                priceMapping.computeIfAbsent(key, k -> new ArrayList());
            }
        }
    }
}

