/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.service.pricemodel;

import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteKeyInfo;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteParam;
import kd.scmc.plat.business.service.pricemodel.QuoteEngine;
import kd.scmc.plat.business.service.pricemodel.log.QuoteLogProxy;

public class QuoteParamEngine
extends QuoteEngine {
    private static final Log log = LogFactory.getLog(QuoteParamEngine.class);

    public QuoteParamEngine(QuoteLogProxy logProxy) {
        super(logProxy);
    }

    @Override
    protected String[] generateHeadKey(Row row, String priceField) {
        String[] keys = new String[1];
        StringBuilder newKey = new StringBuilder();
        newKey.append(String.valueOf(row.get(QuoteKeyInfo.LEFT_ID))).append("$$");
        newKey.append(priceField);
        keys[0] = newKey.toString();
        return keys;
    }

    @Override
    protected String[] generateKey(QuoteKeyInfo quoteKeyInfo, Row row, String priceField) {
        String[] keys = new String[1];
        StringBuilder newKey = new StringBuilder();
        for (String idField : quoteKeyInfo.getLEFTIDFIELDS()) {
            newKey.append(String.valueOf(row.get(idField))).append("$$");
        }
        newKey.append(priceField);
        keys[0] = newKey.toString();
        return keys;
    }

    @Override
    protected void setIscover(QuoteParam quoteParam, Map<String, Object> priceMapping, Row row) {
        String[] keys;
        for (String key : keys = this.generateKey(quoteParam.getQccInfo(), row, "iscover")) {
            priceMapping.put(key, row.get("iscover"));
        }
    }
}

