/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.service.pricemodel;

import java.util.ArrayList;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuotePolicyParam;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteSchemeInfo;
import kd.scmc.plat.business.service.pricemodel.log.QuoteLogProxy;
import kd.scmc.plat.business.service.pricemodel.step.QuoteStep;

public class QuotePolicy
implements AutoCloseable {
    private List<QuoteStep> steps = new ArrayList<QuoteStep>();
    private QuotePolicyParam quotePolicyParam;

    public QuotePolicy() {
    }

    public QuotePolicy(QuotePolicyParam quotePolicyParam) {
        this.quotePolicyParam = quotePolicyParam;
    }

    public void query(QuotePolicyParam quotePolicyParam, QuoteSchemeInfo quoteSchemeInfo, QuoteLogProxy logProxy) {
        try {
            for (QuoteStep s : this.steps) {
                s.excute(quotePolicyParam, quoteSchemeInfo, logProxy);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    @Override
    public void close() {
    }

    public void addStep(QuoteStep invStep) {
        this.steps.add(invStep);
    }

    protected List<QuoteStep> getSteps() {
        return this.steps;
    }

    public QuotePolicyParam getQuotePolicyParam() {
        return this.quotePolicyParam;
    }
}

