/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.service.pricemodel.log;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.plat.common.enums.price.LogTypeEnum;

public class QuoteExpLogProxy
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(QuoteExpLogProxy.class);
    private boolean open;
    private Long quoteOrgID;
    private Date startTime;
    private Date endTime;
    private String quoteBill;
    private String logResult;
    private boolean isCancle = true;

    public QuoteExpLogProxy(boolean open, Long quoteOrgID, String entityType) {
        this.open = open;
        this.quoteOrgID = quoteOrgID;
        this.quoteBill = entityType;
        this.start();
    }

    public void output() {
        if (this.open && !this.isCancle) {
            MainEntityType headType = EntityMetadataCache.getDataEntityType((String)"plat_quotelog");
            DynamicObject quoteLog = new DynamicObject((DynamicObjectType)headType);
            quoteLog.set("quoteorg", (Object)this.getQuoteOrgID());
            quoteLog.set("quotebill", (Object)this.getQuoteBill());
            quoteLog.set("logresult", (Object)this.getLogResult());
            quoteLog.set("quotestarttime", (Object)this.getStartTime());
            quoteLog.set("quoteendtime", (Object)this.getEndTime());
            quoteLog.set("logtype", (Object)LogTypeEnum.EXCEPTION.getValue());
            quoteLog.set("quoteuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
            try (TXHandle h = TX.requiresNew((String)this.getClass().getName());){
                try {
                    log.info("quote Occur exception 1" + this.getQuoteBill());
                    Thread.sleep(2000L);
                    QFilter orgFilter = new QFilter("quoteorg", "=", (Object)this.getQuoteOrgID());
                    QFilter quoteBillFilter = new QFilter("quotebill", "=", (Object)this.getQuoteBill());
                    QFilter logTypeFilter = new QFilter("logtype", "=", (Object)LogTypeEnum.EXCEPTION.getValue());
                    DeleteServiceHelper.delete((String)"plat_quotelog", (QFilter[])new QFilter[]{orgFilter, quoteBillFilter, logTypeFilter});
                    SaveServiceHelper.save((IDataEntityType)headType, (Object[])new DynamicObject[]{quoteLog});
                    log.info("quote Occur exception 2" + this.getQuoteBill());
                }
                catch (KDBizException kde) {
                    h.markRollback();
                }
                catch (Exception kde) {
                    h.markRollback();
                }
            }
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        this.end();
        this.output();
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    private final void start() {
        this.startTime = TimeServiceHelper.now();
        log.info("\u5f00\u59cb\u91c7\u96c6\u65e5\u5fd7\uff1a" + this.startTime);
    }

    public void end() {
        this.endTime = TimeServiceHelper.now();
        log.info("\u7ed3\u675f\u91c7\u96c6\u65e5\u5fd7\uff1a" + this.endTime);
    }

    public Long getQuoteOrgID() {
        return this.quoteOrgID;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public String getQuoteBill() {
        return this.quoteBill;
    }

    public String getLogResult() {
        return this.logResult;
    }

    public void setLogResult(String logresult) {
        this.logResult = logresult.length() > 100 ? logresult.substring(0, 100) : logresult;
    }

    public boolean isCancle() {
        return this.isCancle;
    }

    public void setCancle(boolean cancle) {
        this.isCancle = cancle;
    }
}

