/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.service.pricemodel.log;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.scmc.plat.business.helper.pricemodel.helper.QuoteHelper;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteKeyInfo;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteRowInfo;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteSchemeColl;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteSchemeInfo;
import kd.scmc.plat.business.service.pricemodel.log.QuoteLogRunnable;

public class QuoteLogProxy
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(QuoteLogProxy.class);
    private boolean open;
    private Long quoteOrgID;
    private Date startTime;
    private Date endTime;
    private String quoteBill;
    private QuoteKeyInfo qccInfo;
    private QuoteSchemeColl quoteSchemeColl;
    private Map<String, List<String>> missSchemeCache = new HashMap<String, List<String>>();
    private Map<String, List<String>> missPriceCache = new HashMap<String, List<String>>();
    private Map<String, List<String>> shootPriceCache = new HashMap<String, List<String>>();
    private Map<String, List<String>> multiPriceCache = new HashMap<String, List<String>>();
    private List<QuoteRowInfo> shootSourceCache = new ArrayList<QuoteRowInfo>();
    private Map<String, Map<String, List<String>>> matchAllPriceCache = new HashMap<String, Map<String, List<String>>>();
    private QuoteRowInfo missedRecDataSet;
    private boolean isCancle;
    private boolean isAuto = false;

    public QuoteLogProxy(boolean open, Long quoteOrgID, String entityType, QuoteKeyInfo qccInfo, QuoteSchemeColl quoteSchemeColl) {
        this.open = open;
        this.qccInfo = qccInfo;
        this.quoteSchemeColl = quoteSchemeColl;
        this.quoteOrgID = quoteOrgID;
        this.quoteBill = entityType;
        this.start();
    }

    public void addShootSourceCache(DataSet shootDataSet) {
        if (this.open) {
            this.getShootSourceCache().add(new QuoteRowInfo(shootDataSet));
        }
    }

    public void addMatchAllPriceCache(String schemeID, DataSet matchDataSet) {
        if (this.open) {
            try (DataSet quoteDataSetCopy = matchDataSet.copy();){
                HashMap<String, List> row2Result = new HashMap<String, List>();
                QuoteSchemeInfo schemeInfo = this.quoteSchemeColl.getQuoteSchemes(schemeID);
                TreeMap<String, String> nameMapping = new TreeMap<String, String>();
                String sourceBillTypeName = QuoteHelper.getResultNameMapping(schemeInfo.getQuoteSrcType(), schemeInfo.getQuoteSourceResultAlias(), nameMapping);
                for (Row row : quoteDataSetCopy) {
                    String key = QuoteHelper.generateRowKey(this.qccInfo, row);
                    String multiResultDes = this.getMultiResultDes(nameMapping, row, sourceBillTypeName);
                    List results = row2Result.computeIfAbsent(key, k -> new ArrayList());
                    results.add(multiResultDes);
                }
                this.getMatchAllPriceCache().put(schemeID, row2Result);
            }
        }
    }

    public void missSchemeCache(DataSet quoteDataSet, String schemeID, QuoteKeyInfo qccInfo) {
        this.handleSingleCache(quoteDataSet, schemeID, qccInfo, this.missSchemeCache);
    }

    public void multiPriceSchemeCache(DataSet quoteDataSet, String schemeID, QuoteKeyInfo qccInfo) {
        this.handleDoubleCache(quoteDataSet, schemeID, qccInfo, this.multiPriceCache, this.missPriceCache);
    }

    public void missPriceCache(DataSet quoteDataSet, String schemeID, QuoteKeyInfo qccInfo) {
        this.handleDoubleCache(quoteDataSet, schemeID, qccInfo, this.missPriceCache, this.missSchemeCache);
    }

    public void shootPriceCache(DataSet quoteDataSet, String schemeID, QuoteKeyInfo qccInfo) {
        this.handleDoubleCache(quoteDataSet, schemeID, qccInfo, this.shootPriceCache, this.missPriceCache);
    }

    private void handleDoubleCache(DataSet quoteDataSet, String schemeID, QuoteKeyInfo qccInfo, Map<String, List<String>> shootPriceCache, Map<String, List<String>> missPriceCache) {
        if (this.open) {
            try (DataSet quoteDataSetCopy = quoteDataSet.copy();){
                for (Row row : quoteDataSetCopy) {
                    String key = QuoteHelper.generateRowKey(qccInfo, row);
                    List schemeIDs = shootPriceCache.computeIfAbsent(key, k -> new ArrayList());
                    schemeIDs.add(schemeID);
                    List<String> missSchemeRecord = missPriceCache.get(key);
                    missSchemeRecord.remove(schemeID);
                }
            }
        }
    }

    private void handleSingleCache(DataSet quoteDataSet, String schemeID, QuoteKeyInfo qccInfo, Map<String, List<String>> missSchemeCache) {
        if (this.open) {
            try (DataSet quoteDataSetCopy = quoteDataSet.copy();){
                for (Row row : quoteDataSetCopy) {
                    String key = QuoteHelper.generateRowKey(qccInfo, row);
                    List schemeIDs = missSchemeCache.computeIfAbsent(key, k -> new ArrayList());
                    schemeIDs.add(schemeID);
                }
            }
        }
    }

    public void output() {
        if (this.open && !this.isCancle) {
            QuoteLogRunnable logRunnable = new QuoteLogRunnable(this);
            ThreadPools.executeOnce((String)QuoteLogProxy.class.getName(), (Runnable)logRunnable);
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        this.end();
        this.output();
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    private final void start() {
        this.startTime = TimeServiceHelper.now();
        log.info("\u5f00\u59cb\u91c7\u96c6\u65e5\u5fd7\uff1a" + this.startTime);
    }

    public void end() {
        this.endTime = TimeServiceHelper.now();
        log.info("\u7ed3\u675f\u91c7\u96c6\u65e5\u5fd7\uff1a" + this.endTime);
    }

    public Long getQuoteOrgID() {
        return this.quoteOrgID;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public String getQuoteBill() {
        return this.quoteBill;
    }

    public List<QuoteRowInfo> getShootSourceCache() {
        return this.shootSourceCache;
    }

    public QuoteRowInfo getMissedRecDataSet() {
        return this.missedRecDataSet;
    }

    public void setMissedRecDataSet(DataSet missedRecDataSet) {
        if (this.open) {
            this.missedRecDataSet = new QuoteRowInfo(missedRecDataSet);
        }
    }

    public boolean isCancle() {
        return this.isCancle;
    }

    public void setCancle(boolean cancle) {
        this.isCancle = cancle;
    }

    public Map<String, Map<String, List<String>>> getMatchAllPriceCache() {
        return this.matchAllPriceCache;
    }

    private String getMultiResultDes(TreeMap<String, String> nameMapping, Row row, String sourceBillTypeName) {
        ArrayList<String> quoteResultDescrip = new ArrayList<String>(nameMapping.size());
        String sourceBillNo = row.getString("quotesrcno");
        String seq = row.getString("quotesrcseq");
        quoteResultDescrip.add(sourceBillTypeName);
        if (StringUtils.isNotEmpty((CharSequence)sourceBillNo)) {
            quoteResultDescrip.add(sourceBillNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)seq)) {
            String seqStr = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"QuoteLogProxy_3", (String)"scmc-plat-business", (Object[])new Object[0]), seq);
            quoteResultDescrip.add(seqStr);
        }
        nameMapping.forEach((k, v) -> {
            Number value = null;
            if (!k.contains("bd_taxrate") && row.get(k) != null) {
                value = (Number)row.get(k);
                if (value == null) {
                    quoteResultDescrip.add((String)nameMapping.get(k) + ":");
                } else {
                    BigDecimal rs = BigDecimal.valueOf(value.doubleValue());
                    quoteResultDescrip.add((String)nameMapping.get(k) + ":" + String.valueOf(rs.stripTrailingZeros().toPlainString()));
                }
            }
        });
        return String.join((CharSequence)"/", quoteResultDescrip);
    }

    public QuoteKeyInfo getQccInfo() {
        return this.qccInfo;
    }

    public QuoteSchemeColl getQuoteSchemeColl() {
        return this.quoteSchemeColl;
    }

    public Map<String, List<String>> getMissSchemeCache() {
        return this.missSchemeCache;
    }

    public Map<String, List<String>> getMissPriceCache() {
        return this.missPriceCache;
    }

    public Map<String, List<String>> getShootPriceCache() {
        return this.shootPriceCache;
    }

    public Map<String, List<String>> getMultiPriceCache() {
        return this.multiPriceCache;
    }

    public void setAuto(boolean auto) {
        this.isAuto = auto;
    }

    public boolean isAuto() {
        return this.isAuto;
    }
}

