/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.service.pricemodel.log;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.plat.business.helper.pricemodel.helper.QuoteHelper;
import kd.scmc.plat.business.helper.pricemodel.helper.QuoteLogTreeNodeHelper;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteLogNode;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteRowInfo;
import kd.scmc.plat.business.service.pricemodel.log.QuoteExpLogProxy;
import kd.scmc.plat.business.service.pricemodel.log.QuoteLogProxy;
import kd.scmc.plat.common.enums.price.SceneTypeEnum;

public class QuoteLogRunnable
implements Runnable {
    private QuoteLogProxy proxy;
    private static final Log LOGGER = LogFactory.getLog(QuoteLogRunnable.class);

    public QuoteLogRunnable(QuoteLogProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public void run() {
        try {
            ArrayList<TreeNode> totalLogTreeNodes = new ArrayList<TreeNode>();
            Map taxRates = BusinessDataServiceHelper.loadFromCache((String)"bd_taxrate", (String)"id,number", (QFilter[])new QFilter[]{QFilter.of((String)"1=1", (Object[])new Object[0])});
            LOGGER.info("collect log start======");
            if (this.proxy.getShootSourceCache() != null) {
                LOGGER.info("collect log start======1");
                for (int i = 0; i < this.proxy.getShootSourceCache().size(); ++i) {
                    LOGGER.info("collect log start======X  " + i);
                    QuoteRowInfo quoteRowInfo = this.proxy.getShootSourceCache().get(i);
                    List<String> oneSchemeResultFields = Arrays.asList(quoteRowInfo.getRowMeta().getFieldNames());
                    LOGGER.info("collect log start======X2  " + i);
                    TreeMap<String, String> nameMapping = QuoteHelper.getQuoteResultAliasName(this.proxy.getQuoteSchemeColl(), this.proxy.getQuoteBill(), oneSchemeResultFields);
                    LOGGER.info("collect log start======X3  " + i);
                    for (Row row : quoteRowInfo.getRows()) {
                        LOGGER.info("collect log start======sub1 " + i);
                        String resultDes = this.getResultDes(nameMapping, row, taxRates);
                        LOGGER.info("collect log start======sub2 " + i);
                        QuoteLogNode node = new QuoteLogNode(row.getString("quotesrcno"), row.getString("quotesrcbill"), row.getString("quotesrcseq"), row, resultDes);
                        LOGGER.info("collect log start======sub3 " + i);
                        TreeNode treeRoot = this.getStrategyNode(row, node);
                        LOGGER.info("collect log start======sub4 " + i);
                        totalLogTreeNodes.add(treeRoot);
                    }
                    LOGGER.info("collect log start======X4 " + i);
                }
            }
            LOGGER.info("collect log start2======");
            if (this.proxy.getMissedRecDataSet() != null) {
                LOGGER.info("collect log start2======1");
                QuoteRowInfo mssedRecDataSet = this.proxy.getMissedRecDataSet();
                for (Row row : mssedRecDataSet.getRows()) {
                    LOGGER.info("collect log start2======sub1");
                    String quoteResultDescrip = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u4ef7\u683c", (String)"QuoteLogProxy_1", (String)"scmc-plat-business", (Object[])new Object[0]);
                    QuoteLogNode node = new QuoteLogNode(null, null, null, null, quoteResultDescrip);
                    TreeNode treeRoot = this.getStrategyNode(row, node);
                    LOGGER.info("collect log start2======sub2");
                    totalLogTreeNodes.add(treeRoot);
                }
            }
            LOGGER.info("collect log start2======X4 begin");
            QuoteLogTreeNodeHelper.createQuoteLog(totalLogTreeNodes, this.proxy);
            LOGGER.info("collect log start2======X4 end");
            LOGGER.info("collect log end======");
        }
        catch (KDBizException e) {
            try (QuoteExpLogProxy expLogProxy = new QuoteExpLogProxy(true, this.proxy.getQuoteOrgID(), this.proxy.getQuoteBill());){
                String quoteLogExp = ResManager.loadKDString((String)"\u53d6\u4ef7\u65e5\u5fd7\u91c7\u96c6\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e381\uff1a", (String)"QuoteLogProxy_2", (String)"scmc-plat-business", (Object[])new Object[0]);
                expLogProxy.setCancle(false);
                expLogProxy.setLogResult(quoteLogExp + e.getMessage());
            }
        }
        catch (Exception e1) {
            LOGGER.info(e1.getMessage());
            try (QuoteExpLogProxy expLogProxy = new QuoteExpLogProxy(true, this.proxy.getQuoteOrgID(), this.proxy.getQuoteBill());){
                String quoteLogExp = ResManager.loadKDString((String)"\u53d6\u4ef7\u65e5\u5fd7\u91c7\u96c6\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e382\uff1a", (String)"QuoteLogProxy_4", (String)"scmc-plat-business", (Object[])new Object[0]);
                expLogProxy.setCancle(false);
                expLogProxy.setLogResult(quoteLogExp + e1.getClass() + e1.getMessage());
            }
        }
    }

    private TreeNode getStrategyNode(Row row, QuoteLogNode node) {
        String key = QuoteHelper.generateRowKey(this.proxy.getQccInfo(), row);
        List<String> missSchemes = this.proxy.getMissSchemeCache().get(key);
        List<String> missPrice = this.proxy.getMissPriceCache().get(key);
        List<String> shootPrice = this.proxy.getShootPriceCache().get(key);
        List<String> multiPrice = this.proxy.getMultiPriceCache().get(key);
        ArrayList<TreeNode> schemesNodes = new ArrayList<TreeNode>();
        schemesNodes.addAll(QuoteLogTreeNodeHelper.buildSchemeNode(key, missSchemes, this.proxy.getQuoteSchemeColl(), SceneTypeEnum.TYPE_MISSSCHEMES, this.proxy.getMatchAllPriceCache()));
        schemesNodes.addAll(QuoteLogTreeNodeHelper.buildSchemeNode(key, missPrice, this.proxy.getQuoteSchemeColl(), SceneTypeEnum.TYPE_MISSPRICE, this.proxy.getMatchAllPriceCache()));
        schemesNodes.addAll(QuoteLogTreeNodeHelper.buildSchemeNode(key, shootPrice, this.proxy.getQuoteSchemeColl(), SceneTypeEnum.TYPE_SHOOTPRICE, this.proxy.getMatchAllPriceCache()));
        schemesNodes.addAll(QuoteLogTreeNodeHelper.buildSchemeNode(key, multiPrice, this.proxy.getQuoteSchemeColl(), SceneTypeEnum.TYPE_MULTIPRICE, this.proxy.getMatchAllPriceCache()));
        schemesNodes.sort((o1, o2) -> {
            if (Integer.parseInt(o1.getLongNumber()) > Integer.parseInt(o2.getLongNumber())) {
                return 1;
            }
            return -1;
        });
        TreeNode treeRoot = new TreeNode();
        treeRoot.setId(String.valueOf(this.proxy.getQuoteSchemeColl().getQuoteStratege().getPkValue()));
        treeRoot.setType(key);
        treeRoot.setData((Object)node);
        treeRoot.addChildren(schemesNodes);
        return treeRoot;
    }

    private String getResultDes(TreeMap<String, String> nameMapping, Row row, Map<Object, DynamicObject> taxRates) {
        ArrayList quoteResultDescrip = new ArrayList(nameMapping.size());
        nameMapping.forEach((k, v) -> {
            if (k.contains("bd_taxrate")) {
                StringBuilder descrip = new StringBuilder((String)nameMapping.get(k));
                if (row.get(k = k.replace("bd_taxrate", "")) != null) {
                    String value;
                    String string = value = taxRates.get(row.get(k)) != null ? ((DynamicObject)taxRates.get(row.get(k))).getString("number") : "";
                    if (StringUtils.isNotEmpty((CharSequence)value)) {
                        quoteResultDescrip.add(descrip.append(":").append(value == null ? "" : value).toString());
                    }
                }
            } else if (row.get(k) != null) {
                Number value = (Number)row.get(k);
                if (value == null) {
                    quoteResultDescrip.add((String)nameMapping.get(k) + ":");
                } else {
                    BigDecimal rs = BigDecimal.valueOf(value.doubleValue());
                    quoteResultDescrip.add((String)nameMapping.get(k) + ":" + String.valueOf(rs.stripTrailingZeros().toPlainString()));
                }
            }
        });
        return String.join((CharSequence)",", quoteResultDescrip);
    }
}

