/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.service.pricemodel.step;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.scmc.plat.business.helper.pricemodel.helper.QuoteNewHelper;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuotePolicyParam;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteSchemeInfo;
import kd.scmc.plat.business.service.pricemodel.log.QuoteLogProxy;
import kd.scmc.plat.business.service.pricemodel.step.QuoteStep;

public class QuoteBillPreFilterStep
extends QuoteStep {
    private static final Log logger = LogFactory.getLog(QuoteBillPreFilterStep.class);

    @Override
    public void excute(QuotePolicyParam quotePolicyParam, QuoteSchemeInfo quoteSchemeInfo, QuoteLogProxy logProxy) {
        logProxy.missSchemeCache(quotePolicyParam.getQuoteDataSet(), quoteSchemeInfo.getId(), quotePolicyParam.getQccInfo());
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)quoteSchemeInfo.getQuoteType());
        QFilter totalFilter = quoteSchemeInfo.getQuotePreFilter();
        List<QFilter> conditionFilters = quoteSchemeInfo.getQuotePreFilters();
        if (conditionFilters.size() > 0) {
            String conditionStr = QuoteNewHelper.dataTypeAdapte(totalFilter, headType);
            DataSet quoteDataSet = quotePolicyParam.getQuoteDataSet();
            quoteDataSet = quoteDataSet.filter(conditionStr);
            quotePolicyParam.setQuoteDataSet(quoteDataSet);
        }
        logProxy.missPriceCache(quotePolicyParam.getQuoteDataSet(), quoteSchemeInfo.getId(), quotePolicyParam.getQccInfo());
    }
}

