/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.service.pricemodel.step;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.plat.business.helper.pricemodel.helper.DataSetHelper;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuotePolicyParam;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteSchemeInfo;
import kd.scmc.plat.business.service.pricemodel.log.QuoteLogProxy;
import kd.scmc.plat.business.service.pricemodel.step.QuoteStep;
import kd.scmc.plat.common.consts.pricemodel.QuoteLogConst;

public class QuoteCollectStep
extends QuoteStep {
    private static final Log log = LogFactory.getLog(QuoteCollectStep.class);

    @Override
    public void excute(QuotePolicyParam quotePolicyParam, QuoteSchemeInfo quoteSchemeInfo, QuoteLogProxy logProxy) {
        DataSet result = quotePolicyParam.getResultSet();
        ArrayList<String> sorter = new ArrayList<String>();
        if (quoteSchemeInfo.getSortSignAlias().size() > 0) {
            for (int i = 0; i < quoteSchemeInfo.getSortSignAlias().size(); ++i) {
                String sign = quoteSchemeInfo.getSortSignAlias().get(i);
                sorter.add(new StringBuffer(sign).append(" ").append(quoteSchemeInfo.getSortOrders().get(i)).toString());
            }
        }
        if (sorter.size() > 0) {
            ArrayList<String> newSorter = new ArrayList<String>();
            newSorter.addAll(quotePolicyParam.getQccInfo().getLEFTIDFIELDS());
            newSorter.addAll(sorter);
            result = result.orderBy(newSorter.toArray(new String[0]));
            logProxy.addMatchAllPriceCache(quoteSchemeInfo.getId(), result);
            result = this.getTopRows(quotePolicyParam, quoteSchemeInfo, result);
            result = this.buildResult(quotePolicyParam, quoteSchemeInfo, result, logProxy);
            logProxy.shootPriceCache(result, quoteSchemeInfo.getId(), quotePolicyParam.getQccInfo());
            quotePolicyParam.setResultSet(result);
        } else {
            DataSet singleValueSet;
            DataSet resultG;
            GroupbyDataSet groupby;
            List<String> props = quotePolicyParam.getQccInfo().getLEFTIDFIELDS();
            if (logProxy.isOpen()) {
                logProxy.addMatchAllPriceCache(quoteSchemeInfo.getId(), result);
                groupby = result.copy().groupBy(props.toArray(new String[props.size()]));
                resultG = groupby.count().finish();
                singleValueSet = resultG.copy().where("count = 1 ").select(props.toArray(new String[props.size()]));
                logProxy.shootPriceCache(singleValueSet, quoteSchemeInfo.getId(), quotePolicyParam.getQccInfo());
                try (DataSet multiValueSet = resultG.where("count > 1 ").select(props.toArray(new String[props.size()]));){
                    logProxy.multiPriceSchemeCache(multiValueSet, quoteSchemeInfo.getId(), quotePolicyParam.getQccInfo());
                }
            } else {
                groupby = result.groupBy(props.toArray(new String[props.size()]));
                resultG = groupby.count().finish();
                singleValueSet = resultG.where("count = 1 ").select(props.toArray(new String[props.size()]));
            }
            JoinHint hint = new JoinHint();
            hint.setNullAsZero(true);
            JoinDataSet resultSet = result.join(singleValueSet, JoinType.INNER).hint(hint);
            for (String key : props) {
                resultSet = resultSet.on(key, key);
            }
            Field[] quoteFields = result.getRowMeta().getFields();
            String[] fields = new String[quoteFields.length];
            for (int i = 0; i < quoteFields.length; ++i) {
                fields[i] = quoteFields[i].getName();
            }
            result = resultSet.select(fields, new String[0]).finish();
            result = this.buildResult(quotePolicyParam, quoteSchemeInfo, result, logProxy);
            quotePolicyParam.setResultSet(result);
        }
    }

    protected DataSet buildResult(QuotePolicyParam quotePolicyParam, QuoteSchemeInfo quoteSchemeInfo, DataSet result, QuoteLogProxy logProxy) {
        int i;
        boolean include;
        if (StringUtils.isNotEmpty((CharSequence)quoteSchemeInfo.getTerminationSign()) && !(include = DataSetHelper.isIncludeField(quoteSchemeInfo.getTerminationSign(), result))) {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u5931\u8d25\uff1a\u5f53\u524d\u53d6\u4ef7\u7b56\u7565\u4e2d\u7684\u53d6\u4ef7\u65b9\u6848\u5bf9\u5e94\u7684\u53d6\u4ef7\u7ec8\u6b62\u5b57\u6bb5\u5728\u65b9\u6848\u4e2d\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u9519\u8bef\u65b9\u6848\u662f[%s]\u3002", (String)"QuoteEngine_1", (String)"scmc-plat-business", (Object[])new Object[0]);
            message = String.format(message, quoteSchemeInfo.getName());
            throw new KDBizException(message);
        }
        ArrayList<String> selector = new ArrayList<String>(quotePolicyParam.getQccInfo().getLEFTIDFIELDS().size() + quoteSchemeInfo.getQuoteSourceResultAlias().size() + QuoteLogConst.getQuotelogSearchfields().length + 1);
        quotePolicyParam.getQccInfo().getLEFTIDFIELDS().forEach(f -> selector.add((String)f));
        ArrayList<String> dulplicateResultFields = new ArrayList<String>(16);
        for (i = 0; i < quoteSchemeInfo.getQuoteSourceResultAlias().size(); ++i) {
            block9: {
                if (!dulplicateResultFields.contains(quoteSchemeInfo.getQuoteResultsAlias().get(i))) break block9;
                String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848[%s]\u7684\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\u4e2d\u5b58\u5728\u91cd\u590d\u914d\u7f6e\u7684\u53d6\u4ef7\u5b57\u6bb5\u3002", (String)"QuoteCollectStep_1", (String)"scmc-plat-business", (Object[])new Object[0]);
                message = String.format(message, quoteSchemeInfo.getName());
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    throw new KDBizException(message);
                }
                {
                }
            }
            dulplicateResultFields.add(quoteSchemeInfo.getQuoteResultsAlias().get(i));
        }
        for (i = 0; i < quoteSchemeInfo.getQuoteSourceResultAlias().size(); ++i) {
            selector.add(new StringBuffer(quoteSchemeInfo.getQuoteSourceResultAlias().get(i)).append(" ").append(new StringBuffer(quoteSchemeInfo.getQuoteResultsAlias().get(i))).toString());
        }
        for (String field : QuoteLogConst.getQuotelogSearchfields()) {
            selector.add(field);
        }
        selector.add("iscover");
        result = result.select(selector.toArray(new String[selector.size()]));
        log.info("beginlog===1");
        logProxy.addShootSourceCache(result);
        log.info("beginlog===2");
        if (this.needReduce()) {
            log.info("beginlog===3");
            List<String> selectorFinal = this.getFinalSelector(quotePolicyParam, quoteSchemeInfo);
            result = result.select(selectorFinal.toArray(new String[selectorFinal.size()]));
            log.info("beginlog===4");
        }
        return result;
    }

    private DataSet getTopRows(QuotePolicyParam quotePolicyParam, QuoteSchemeInfo quoteSchemeInfo, DataSet result) {
        List<String> props = quotePolicyParam.getQccInfo().getLEFTIDFIELDS();
        GroupbyDataSet groupby = result.groupBy(props.toArray(new String[props.size()]));
        ArrayList<String> quoteSourceResultField4Log = new ArrayList<String>(16);
        quoteSourceResultField4Log.addAll(quoteSchemeInfo.getQuoteSourceResultAlias());
        for (String field : QuoteLogConst.getQuotelogSearchfields()) {
            quoteSourceResultField4Log.add(field);
        }
        quoteSourceResultField4Log.add("iscover");
        for (int i = 0; i < quoteSourceResultField4Log.size(); ++i) {
            String fieldKey = (String)quoteSourceResultField4Log.get(i);
            groupby.agg((CustomAggFunction)new CustomAggFunction<Object>("getTopRec", result.getRowMeta().getField(fieldKey).getDataType()){
                private int i;
                {
                    this.i = 0;
                }

                public Object newAggValue() {
                    return null;
                }

                public Object addValue(Object o, Object o2) {
                    if (o == null) {
                        this.i = 0;
                    }
                    if (this.i == 0) {
                        ++this.i;
                        return DataSetHelper.defaultValue4Null(o2, this.getResultDataType());
                    }
                    return o;
                }

                public Object combineAggValue(Object o, Object t1) {
                    return o;
                }

                public Object getResult(Object o) {
                    return o;
                }
            }, fieldKey, fieldKey);
        }
        result = groupby.finish();
        return result;
    }

    private List<String> getFinalSelector(QuotePolicyParam quotePolicyParam, QuoteSchemeInfo quoteSchemeInfo) {
        ArrayList<String> selectorFinal = new ArrayList<String>(quoteSchemeInfo.getQuoteResultsAlias().size() + quotePolicyParam.getQccInfo().getLEFTIDFIELDS().size() + 1);
        quotePolicyParam.getQccInfo().getLEFTIDFIELDS().forEach(f -> selectorFinal.add((String)f));
        quoteSchemeInfo.getQuoteResultsAlias().forEach(f -> selectorFinal.add((String)f));
        selectorFinal.add("iscover");
        return selectorFinal;
    }

    protected boolean needReduce() {
        return true;
    }
}

