/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.service.pricemodel.step;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuotePolicyParam;
import kd.scmc.plat.business.helper.pricemodel.pojo.QuoteSchemeInfo;
import kd.scmc.plat.business.service.pricemodel.log.QuoteLogProxy;
import kd.scmc.plat.business.service.pricemodel.step.QuoteCollectStep;

public class QuoteMultiCollectStep
extends QuoteCollectStep {
    private static final Log log = LogFactory.getLog(QuoteMultiCollectStep.class);

    @Override
    public void excute(QuotePolicyParam quotePolicyParam, QuoteSchemeInfo quoteSchemeInfo, QuoteLogProxy logProxy) {
        DataSet result = quotePolicyParam.getResultSet();
        ArrayList<String> sorter = new ArrayList<String>();
        if (quoteSchemeInfo.getSortSignAlias().size() > 0) {
            for (int i = 0; i < quoteSchemeInfo.getSortSignAlias().size(); ++i) {
                String sign = quoteSchemeInfo.getSortSignAlias().get(i);
                sorter.add(new StringBuffer(sign).append(" ").append(quoteSchemeInfo.getSortOrders().get(i)).toString());
            }
        }
        if (sorter.size() > 0) {
            ArrayList<String> newSorter = new ArrayList<String>();
            newSorter.addAll(quotePolicyParam.getQccInfo().getLEFTIDFIELDS());
            newSorter.addAll(sorter);
            result = result.orderBy(newSorter.toArray(new String[0]));
        }
        logProxy.addMatchAllPriceCache(quoteSchemeInfo.getId(), result);
        logProxy.shootPriceCache(result, quoteSchemeInfo.getId(), quotePolicyParam.getQccInfo());
        result = this.buildResult(quotePolicyParam, quoteSchemeInfo, result, logProxy);
        quotePolicyParam.setResultSet(result);
    }

    @Override
    protected boolean needReduce() {
        return false;
    }
}

