/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.business.service.upgrade;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.UpgradeResult;

public class BillTplUpgradeHelper {
    public static Log logger = LogFactory.getLog(BillTplUpgradeHelper.class);

    public static UpgradeResult doUpdate(DBRoute dbRoute, UpgradeResult result, String t_old, String t_new, String[] fs, String f_key, Object pk) {
        Throwable throwable;
        StringBuilder sql_query = new StringBuilder(" SELECT ");
        StringBuilder sql_update = new StringBuilder(" UPDATE ").append(t_new).append(" ").append(" SET ");
        for (String f : fs) {
            sql_query.append(f).append(',');
            sql_update.append(f).append("=?,");
        }
        sql_query.append(f_key);
        sql_query.append(" From ").append(t_old);
        sql_query.append(" WHERE ").append(f_key).append("=?");
        sql_update = new StringBuilder(sql_update.substring(0, sql_update.length() - 1));
        sql_update.append(" WHERE ").append(f_key).append("=?");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        try {
            throwable = null;
            try (DataSet ds = DB.queryDataSet((String)"BillTplUpgradeHelper", (DBRoute)dbRoute, (String)sql_query.toString(), (Object[])new Object[]{pk});){
                for (Row row : ds) {
                    ArrayList<Object> params = new ArrayList<Object>();
                    for (String f : fs) {
                        params.add(row.get(f));
                    }
                    params.add(row.get(f_key));
                    paramList.add(params.toArray());
                }
            }
            catch (Throwable f) {
                throwable = f;
                throw f;
            }
        }
        catch (Throwable e) {
            result.setSuccess(false);
            String err = "query data field failed,errorMsgInfo\uff1a" + e.getMessage();
            result.setErrorInfo(err);
            result.setLog(err);
            logger.info(err);
            return result;
        }
        logger.info("query update successful.");
        throwable = null;
        try (TXHandle h = TX.required((String)"BillTplUpgradeHelper");){
            try {
                DB.executeBatch((DBRoute)dbRoute, (String)sql_update.toString(), paramList);
            }
            catch (Throwable e) {
                h.markRollback();
                result.setSuccess(false);
                String err = "database execution failed,errorInfo" + e.getMessage();
                result.setErrorInfo(err);
                result.setLog("database execution failed,errorMsgInfo" + e.getMessage());
                logger.info(err);
                UpgradeResult upgradeResult = result;
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        h.close();
                    }
                }
                return upgradeResult;
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        result.setSuccess(true);
        result.setLog("data update successful.");
        logger.info("data update successful.");
        return result;
    }
}

