/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.opplugin.changemodel;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.validation.ConditionValidation;
import kd.bos.service.operation.validate.ConditionValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.plat.business.helper.changemodel.ChangeModelHelper;
import kd.scmc.plat.common.enums.BizChangeStatusEnum;
import kd.scmc.plat.common.enums.BizChangeTypeEnum;
import kd.scmc.plat.common.util.CommonUtils;

public class XBillBizValidOp
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(XBillBizValidOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("sourcebillentity");
        e.getFieldKeys().add("sourcebillid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        if (this.billEntityType != null) {
            String opkey = (String)this.operateMeta.get("key");
            List vallist = ChangeModelHelper.getValidConditionList((String)this.billEntityType.getName(), (String)opkey);
            if (vallist != null && vallist.size() > 0) {
                for (int i = 0; i < vallist.size(); ++i) {
                    ConditionValidator XBillBizValidCV = new ConditionValidator();
                    XBillBizValidCV.setValidation(((ConditionValidation)vallist.get(i)).createValidate());
                    e.addValidator((AbstractValidator)XBillBizValidCV);
                }
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if ("bizvalid".equals(e.getOperationKey()) && !CommonUtils.isNull((Object)e.getDataEntities())) {
            DynamicObject[] bills;
            Long beginTime = System.currentTimeMillis();
            LOGGER.info("BizValidPerformance--BeginTime: " + new Date(beginTime));
            for (DynamicObject bill : bills = e.getDataEntities()) {
                String[] enablePropertys;
                DynamicObject srcBill;
                DynamicObject changeModel = ChangeModelHelper.getChangeModel4XBill((String)(bill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)bill.getDynamicObjectType().getName())).getDataEntityType().getName());
                if (CommonUtils.isNull((Object)changeModel)) continue;
                String sourcebillentity = bill.getString("sourcebillentity");
                Long sourcebillid = bill.getLong("sourcebillid");
                if (sourcebillid == null || sourcebillentity == null || CommonUtils.isNull((Object)(srcBill = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)sourcebillentity)))) continue;
                if (!changeModel.getBoolean("isnotupdateversion")) {
                    String version = srcBill.getString("version");
                    if (version == null || version.length() == 0 || version.equals("0") || version.startsWith("0.") || version.startsWith("1.")) {
                        version = "1";
                    }
                    int newVersion = 1;
                    try {
                        newVersion = Integer.parseInt(version) + 1;
                    }
                    catch (NumberFormatException ee) {
                        LOGGER.warn((Throwable)ee);
                    }
                    srcBill.set("version", (Object)String.valueOf(newVersion));
                    srcBill.set("subversion", (Object)"1");
                } else {
                    String subversion = srcBill.getString("subversion");
                    if (subversion == null || subversion.length() == 0 || subversion.equals("0") || subversion.startsWith("0.") || subversion.startsWith("1.")) {
                        subversion = "1";
                    }
                    int newSubVersion = 1;
                    try {
                        newSubVersion = Integer.parseInt(subversion) + 1;
                    }
                    catch (NumberFormatException ee) {
                        LOGGER.warn((Throwable)ee);
                    }
                    srcBill.set("subversion", (Object)String.valueOf(newSubVersion));
                }
                srcBill.set("changestatus", (Object)BizChangeStatusEnum.CHANGED.getValue());
                srcBill.set("changer", (Object)BusinessDataServiceHelper.loadSingle((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user"));
                srcBill.set("changedate", (Object)new Date(System.currentTimeMillis()));
                for (String string : enablePropertys = ChangeModelHelper.getCanWritebackProperty((IDataEntityType)bill.getDynamicObjectType())) {
                    try {
                        Object oldObject = srcBill.get(string);
                        Object newObject = bill.get(string);
                        if (!CommonUtils.isRealChanged((Object)oldObject, (Object)newObject)) continue;
                        srcBill.set(string, bill.get(string));
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                Long finishBillHeadValueTime = System.currentTimeMillis();
                LOGGER.info("BizValidPerformance--finishBillHeadValueTime: " + new Date(finishBillHeadValueTime));
                LOGGER.info("BizValidPerformance--finishBillHeadValueUse: " + (finishBillHeadValueTime - beginTime) + "ms");
                List xBillentryEntitys = ChangeModelHelper.getChildEntities((IDataEntityType)bill.getDataEntityType());
                HashMap<String, String[]> enableWBEntryPropertysMap = new HashMap<String, String[]>(16);
                for (EntityType xBillentryEntity : xBillentryEntitys) {
                    DynamicObjectCollection xBillEntrys;
                    String xBillEntryEntityKey = xBillentryEntity.getName();
                    Map<String, String> fieldmap = this.getXBillEntryAndField(changeModel).get(xBillEntryEntityKey);
                    String[] enableEntryPropertys = null;
                    if (XBillBizValidOp.checkToSonar(enableWBEntryPropertysMap, xBillEntryEntityKey)) {
                        enableEntryPropertys = (String[])enableWBEntryPropertysMap.get(xBillEntryEntityKey);
                    } else {
                        enableEntryPropertys = ChangeModelHelper.getCanWritebackProperty((IDataEntityType)bill.getDynamicObjectType(), (String)xBillEntryEntityKey);
                        if (enableEntryPropertys != null) {
                            enableWBEntryPropertysMap.put(xBillEntryEntityKey, enableEntryPropertys);
                        }
                    }
                    if (xBillentryEntity.getClass() != EntryType.class || CommonUtils.isNull((Object)(xBillEntrys = bill.getDynamicObjectCollection(xBillEntryEntityKey))) || CommonUtils.isNull((Object)enableEntryPropertys) || CommonUtils.isNull(fieldmap)) continue;
                    DynamicObjectCollection srcBillEntrys = srcBill.getDynamicObjectCollection(xBillentryEntity.getName());
                    block15: for (DynamicObject xBillEntry : xBillEntrys) {
                        if (BizChangeTypeEnum.UPDATE.getValue().equals(xBillEntry.get(fieldmap.get("changetype")))) {
                            for (DynamicObject srcBillEntry : srcBillEntrys) {
                                if (srcBillEntry.getLong("id") != xBillEntry.getLong(fieldmap.get("srcid"))) continue;
                                for (String entryProperty : enableEntryPropertys) {
                                    srcBillEntry.set(entryProperty, xBillEntry.get(entryProperty));
                                }
                                for (IDataEntityProperty entityProperty : xBillEntry.getDataEntityType().getProperties()) {
                                    String entityProName = entityProperty.getName();
                                    if (!(xBillEntry.get(entityProName) instanceof DynamicObjectCollection)) continue;
                                    String[] subEnableEntryPropertys = null;
                                    if (XBillBizValidOp.checkToSonar(enableWBEntryPropertysMap, entityProName)) {
                                        subEnableEntryPropertys = (String[])enableWBEntryPropertysMap.get(entityProName);
                                    } else {
                                        subEnableEntryPropertys = ChangeModelHelper.getCanWritebackProperty((IDataEntityType)bill.getDynamicObjectType(), (String)entityProName);
                                        if (subEnableEntryPropertys != null) {
                                            enableWBEntryPropertysMap.put(entityProName, subEnableEntryPropertys);
                                        }
                                    }
                                    Map<String, String> subfieldmap = this.getXBillEntryAndField(changeModel).get(entityProName);
                                    if (subEnableEntryPropertys == null || subEnableEntryPropertys.length == 0 || subfieldmap == null || subfieldmap.size() == 0) continue;
                                    DynamicObjectCollection subXBillEntrys = (DynamicObjectCollection)xBillEntry.get(entityProName);
                                    DynamicObjectCollection subSrcBillEntrys = srcBillEntry.getDynamicObjectCollection(entityProName);
                                    block19: for (DynamicObject subXBillEntry : subXBillEntrys) {
                                        if (BizChangeTypeEnum.CANCEL.getValue().equals(subXBillEntry.get(subfieldmap.get("changetype")))) {
                                            for (Object subSrcBillEntry : subSrcBillEntrys) {
                                                if (subSrcBillEntry.getLong("id") != subXBillEntry.getLong(subfieldmap.get("srcid"))) continue;
                                                subSrcBillEntrys.remove(subSrcBillEntry);
                                                continue block19;
                                            }
                                            continue;
                                        }
                                        if (BizChangeTypeEnum.ADDNEW.getValue().equals(subXBillEntry.get(subfieldmap.get("changetype")))) {
                                            Object subSrcBillEntry;
                                            DynamicObject subSrcBillEntry2 = subSrcBillEntrys.addNew();
                                            subSrcBillEntry = subSrcBillEntry2.getDataEntityType().getProperties().iterator();
                                            while (subSrcBillEntry.hasNext()) {
                                                String[] subEntityProperty = (String[])subSrcBillEntry.next();
                                                String subEntityProName = subEntityProperty.getName();
                                                if (subXBillEntry.get(subEntityProName) instanceof DynamicObjectCollection || subXBillEntry.get(subEntityProName) instanceof LinkEntryProp) continue;
                                                try {
                                                    if (subEntityProName.equals("id")) continue;
                                                    if (subEntityProName.equals(subfieldmap.get("changetype"))) {
                                                        subSrcBillEntry2.set(subEntityProName, (Object)BizChangeTypeEnum.UPDATE.getValue());
                                                        continue;
                                                    }
                                                    subSrcBillEntry2.set(subEntityProName, subXBillEntry.get(subEntityProName));
                                                }
                                                catch (Exception e1) {}
                                            }
                                            continue;
                                        }
                                        if (!BizChangeTypeEnum.UPDATE.getValue().equals(subXBillEntry.get(subfieldmap.get("changetype")))) continue;
                                        for (Object subSrcBillEntry : subSrcBillEntrys) {
                                            if (subSrcBillEntry.getLong("id") != subXBillEntry.getLong(subfieldmap.get("srcid"))) continue;
                                            for (String subEnableEntryProperty : subEnableEntryPropertys) {
                                                subSrcBillEntry.set(subEnableEntryProperty, subXBillEntry.get(subEnableEntryProperty));
                                            }
                                        }
                                    }
                                }
                                continue block15;
                            }
                            continue;
                        }
                        if (BizChangeTypeEnum.CANCEL.getValue().equals(xBillEntry.get(fieldmap.get("changetype")))) {
                            for (DynamicObject srcBillEntry : srcBillEntrys) {
                                if (srcBillEntry.getLong("id") != xBillEntry.getLong(fieldmap.get("srcid"))) continue;
                                try {
                                    srcBillEntrys.remove((Object)srcBillEntry);
                                    continue block15;
                                }
                                catch (Exception e1) {
                                }
                            }
                            continue;
                        }
                        if (!BizChangeTypeEnum.ADDNEW.getValue().equals(xBillEntry.get(fieldmap.get("changetype")))) continue;
                        DynamicObject srcBillEntry = srcBillEntrys.addNew();
                        for (IDataEntityProperty entityProperty : srcBillEntry.getDataEntityType().getProperties()) {
                            try {
                                String newEntityProName = entityProperty.getName();
                                if (!(xBillEntry.get(newEntityProName) instanceof DynamicObjectCollection) && !(xBillEntry.get(newEntityProName) instanceof LinkEntryProp)) {
                                    if (newEntityProName.equals(fieldmap.get("changetype"))) {
                                        srcBillEntry.set(newEntityProName, (Object)BizChangeTypeEnum.UPDATE.getValue());
                                    } else {
                                        srcBillEntry.set(newEntityProName, xBillEntry.get(newEntityProName));
                                    }
                                }
                                if (!(xBillEntry.get(newEntityProName) instanceof DynamicObjectCollection)) continue;
                                Map<String, String> newSubFieldmap = this.getXBillEntryAndField(changeModel).get(newEntityProName);
                                String subEntityChangeTypePro = newSubFieldmap.get("changetype");
                                DynamicObjectCollection subXBillEntrys = (DynamicObjectCollection)xBillEntry.get(newEntityProName);
                                DynamicObjectCollection subSrcBillEntrys = srcBillEntry.getDynamicObjectCollection(newEntityProName);
                                for (DynamicObject subXBillEntry : subXBillEntrys) {
                                    DynamicObject subSrcBillEntry = subSrcBillEntrys.addNew();
                                    for (IDataEntityProperty subEntityProperty : subSrcBillEntry.getDataEntityType().getProperties()) {
                                        String newSubEntityProName = subEntityProperty.getName();
                                        if (subXBillEntry.get(newSubEntityProName) instanceof DynamicObjectCollection || subXBillEntry.get(newSubEntityProName) instanceof LinkEntryProp) continue;
                                        if (StringUtils.isNotEmpty((CharSequence)subEntityChangeTypePro) && subEntityChangeTypePro.equals(newSubEntityProName)) {
                                            subSrcBillEntry.set(newSubEntityProName, (Object)BizChangeTypeEnum.UPDATE.getValue());
                                            continue;
                                        }
                                        subSrcBillEntry.set(newSubEntityProName, subXBillEntry.get(newSubEntityProName));
                                    }
                                }
                            }
                            catch (Exception e1) {
                            }
                        }
                    }
                }
                long l = System.currentTimeMillis();
                LOGGER.info("BizValidPerformance--finishBillEntryValueTime: " + new Date(l));
                LOGGER.info("BizValidPerformance--finishBillEntryValueUse: " + (l - finishBillHeadValueTime) + "ms");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{srcBill});
                long finishTime = System.currentTimeMillis();
                LOGGER.info("BizValidPerformance--finishTime: " + new Date(finishTime));
                LOGGER.info("BizValidPerformance--finishUse: " + (finishTime - beginTime) + "ms");
            }
        }
    }

    protected Map<String, Map<String, String>> getXBillEntryAndField(DynamicObject changeModel) {
        Map<String, Map<String, String>> result = new HashMap();
        result = ChangeModelHelper.getXBillEntryAndOp((DynamicObject)changeModel);
        if (result.size() != 0) {
            return result;
        }
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("entity", "billentry");
        value.put("changetype", "billentrychangetype");
        value.put("srcid", "billentrysrcid");
        result.put((String)value.get("entity"), (Map<String, String>)value);
        return result;
    }

    public static List<EntityType> getChildEntities(IDataEntityType entityType) {
        ArrayList<EntityType> childEntities = new ArrayList<EntityType>();
        for (IDataEntityProperty property : entityType.getProperties()) {
            ICollectionProperty collProp;
            if (!(property instanceof ICollectionProperty) || !((collProp = (ICollectionProperty)property).getItemType() instanceof EntityType)) continue;
            EntityType childEntity = (EntityType)collProp.getItemType();
            childEntities.add(childEntity);
            childEntities.addAll(XBillBizValidOp.getChildEntities((IDataEntityType)childEntity));
        }
        return childEntities;
    }

    public static boolean checkToSonar(Map<String, String[]> enableWBEntryPropertysMap, String xBillEntryEntityKey) {
        return enableWBEntryPropertysMap.containsKey(xBillEntryEntityKey);
    }
}

