/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.opplugin.changemodel;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.plat.common.enums.BizChangeStatusEnum;

public class XBillDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("sourcebillid");
        e.getFieldKeys().add("sourcebillentity");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if (e.getDataEntities() != null && e.getDataEntities().length != 0) {
            DynamicObject[] bills = e.getDataEntities();
            ArrayList<DynamicObject> srcBills = new ArrayList<DynamicObject>();
            ArrayList<Object> arBillPk = new ArrayList<Object>();
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject bill = bills[i];
                arBillPk.add(bill.getPkValue());
                Long sourceBillId = bill.getLong("sourcebillid");
                String sourceBillEntity = bill.getString("sourcebillentity");
                if (sourceBillId == null || sourceBillEntity == null) continue;
                DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)sourceBillEntity);
                if (null == srcBill.get("changer")) {
                    srcBill.set("changestatus", (Object)BizChangeStatusEnum.UNCHANGE.getValue());
                } else {
                    srcBill.set("changestatus", (Object)BizChangeStatusEnum.CHANGED.getValue());
                }
                srcBills.add(srcBill);
            }
            if (srcBills.size() != 0) {
                SaveServiceHelper.update((DynamicObject[])srcBills.toArray(new DynamicObject[0]));
            }
            if (arBillPk.size() != 0) {
                QFilter qFilter = new QFilter("xbillid", "in", arBillPk);
                DeleteServiceHelper.delete((String)"plat_xbilllog", (QFilter[])new QFilter[]{qFilter});
            }
        }
    }
}

