/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.opplugin.changemodel;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.entity.validation.ConditionValidation;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.validate.ConditionValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.plat.business.helper.changemodel.ChangeModelHelper;
import kd.scmc.plat.business.helper.changemodel.XBillLoglHelper;
import kd.scmc.plat.common.enums.BizChangeStatusEnum;

public class XBillSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("sourcebillid");
        e.getFieldKeys().add("changebillno");
        e.getFieldKeys().add("changebizdate");
        e.getFieldKeys().add("changereason");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        if (this.billEntityType != null) {
            String opkey = (String)this.operateMeta.get("key");
            List vallist = ChangeModelHelper.getValidConditionList((String)this.billEntityType.getName(), (String)opkey);
            if (vallist != null && vallist.size() > 0) {
                for (int i = 0; i < vallist.size(); ++i) {
                    ConditionValidator XBillCV = new ConditionValidator();
                    XBillCV.setValidation(((ConditionValidation)vallist.get(i)).createValidate());
                    e.addValidator((AbstractValidator)XBillCV);
                }
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        if (e.getDataEntities() != null && e.getDataEntities().length != 0) {
            DynamicObject[] bills = e.getDataEntities();
            DynamicObject changeModel = ChangeModelHelper.getChangeModel4XBill((String)bills[0].getDataEntityType().getName());
            if (changeModel == null) {
                return;
            }
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject bill = bills[i];
                ChangeModelHelper.excutePluginMethod((DynamicObject)changeModel, (String)"beforeXBillSubmit", (DynamicObject)bill);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if (e.getDataEntities() != null && e.getDataEntities().length != 0) {
            DynamicObject[] bills = e.getDataEntities();
            DynamicObject changeModel = ChangeModelHelper.getChangeModel4XBill((String)bills[0].getDataEntityType().getName());
            if (changeModel == null) {
                return;
            }
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject bill = bills[i];
                MainEntityType xlogdt = MetadataServiceHelper.getDataEntityType((String)"plat_xbilllog");
                DynamicObject srcBill = BusinessDataServiceHelper.loadSingleFromCache((Object)bill.get("sourcebillid"), (String)((String)changeModel.getDynamicObject("srcbill").getPkValue()));
                if (!BizChangeStatusEnum.CHANGING.getValue().equals(srcBill.get("changestatus"))) {
                    srcBill.set("changestatus", (Object)BizChangeStatusEnum.CHANGING.getValue());
                    SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{srcBill});
                } else if (bill.getPkValue() != null) {
                    QFilter qFilter = new QFilter("changebillno", "=", bill.get("changebillno"));
                    DynamicObject temp = BusinessDataServiceHelper.loadSingle((String)bill.getDataEntityType().getName(), (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (temp != null && !temp.getPkValue().equals(bill.getPkValue())) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u6b63\u5728\u53d8\u66f4\u7684\u6570\u636e\u8fdb\u884c\u53d8\u66f4\u64cd\u4f5c\u3002", (String)"XBillSubmitOp_0", (String)"scmc-plat-opplugin", (Object[])new Object[0]));
                    }
                }
                DynamicObject xBill = BusinessDataServiceHelper.loadSingleFromCache((Object)bill.getPkValue(), (String)((String)changeModel.getDynamicObject("xbill").getPkValue()));
                QFilter qFilter1 = new QFilter("srcbillid", "=", srcBill.getPkValue());
                QFilter qFilter2 = new QFilter("xbillid", "=", bill.getPkValue());
                DeleteServiceHelper.delete((String)"plat_xbilllog", (QFilter[])new QFilter[]{qFilter1, qFilter2});
                DynamicObject xBillLog = new DynamicObject((DynamicObjectType)xlogdt);
                xBillLog.set("srcbillid", srcBill.getPkValue());
                xBillLog.set("srcbillentity", (Object)srcBill.getDataEntityType().getName());
                xBillLog.set("srcbillno", (Object)srcBill.getString("billno"));
                xBillLog.set("srcbillversion", (Object)srcBill.getString("version"));
                xBillLog.set("xbillid", bill.getPkValue());
                xBillLog.set("xbillentity", (Object)xBill.getDataEntityType().getName());
                xBillLog.set("xbillno", (Object)bill.getString("changebillno"));
                xBillLog.set("creator", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user"));
                xBillLog.set("biztime", (Object)bill.getDate("changebizdate"));
                xBillLog.set("xreason", (Object)bill.getString("changereason"));
                Map map = XBillLoglHelper.compareSrcBillNXBill((DynamicObject)srcBill, (DynamicObject)xBill, (Map)ChangeModelHelper.getXBillEntryAndOp((DynamicObject)changeModel));
                String xmdlog = (String)map.get("mdText");
                xBillLog.set("xmdjson_tag", (Object)xmdlog);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{xBillLog});
                ChangeModelHelper.excutePluginMethod((DynamicObject)changeModel, (String)"afterXBillSubmit", (DynamicObject)bill);
            }
        }
    }
}

