/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.opplugin.pricemodel;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.plat.common.enums.price.QuotePatternEnum;

public class QuoteSchemeSubmitValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(QuoteSchemeSubmitValidator.class);

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            this.addMessage(data, bill);
        }
    }

    private void addMessage(ExtendedDataEntity data, DynamicObject bill) {
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
        if (bill.getDynamicObject("pricesourceentity") == null) {
            return;
        }
        if (bill.getDynamicObject("quoteentity") == null) {
            return;
        }
        String sourceEntity = bill.getDynamicObject("pricesourceentity").getString("number");
        String quoteEntity = bill.getDynamicObject("quoteentity").getString("number");
        ArrayList<String> sourceResult = new ArrayList<String>();
        ArrayList<String> quoteResult = new ArrayList<String>();
        if (entries != null && entries.size() > 0) {
            int flagA = 0;
            int flagB = 0;
            for (DynamicObject entry : entries) {
                String sourcesign = entry.getString("sourcesign");
                String quotesign = entry.getString("quotesign");
                String matchflag = entry.getString("matchflag");
                String quotepattern = entry.getString("quotepattern");
                if (QuotePatternEnum.RESULT.getValue().equals(quotepattern)) {
                    ++flagA;
                    if (StringUtils.isBlank((CharSequence)sourcesign) || StringUtils.isBlank((CharSequence)quotesign)) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\uff0c\u201c\u4ef7\u683c\u6765\u6e90\u5b57\u6bb5\u201d\u548c\u201c\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u201d\u5fc5\u987b\u6210\u5bf9\u51fa\u73b0\u3002", (String)"QuoteSchemeSubmitValidator_0", (String)"scmc-plat-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        return;
                    }
                    if (sourceResult.contains(sourcesign)) {
                        sourceResult.add(sourcesign + " " + sourcesign + flagA);
                    } else {
                        sourceResult.add(sourcesign);
                    }
                    if (quoteResult.contains(quotesign)) {
                        quoteResult.add(quotesign + " " + quotesign + flagA);
                    } else {
                        quoteResult.add(quotesign);
                    }
                }
                if (!QuotePatternEnum.CONDITION.getValue().equals(quotepattern)) continue;
                ++flagB;
                if (!StringUtils.isBlank((CharSequence)sourcesign) && !StringUtils.isBlank((CharSequence)quotesign) && !StringUtils.isBlank((CharSequence)matchflag)) continue;
                this.addMessage(data, ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\uff0c\u8bf7\u540c\u65f6\u5f55\u5165\u201c\u4ef7\u683c\u6765\u6e90\u5b57\u6bb5\u201d\u548c\u201c\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u201d\u548c\u201c\u6bd4\u8f83\u7b26\u201d\u3002", (String)"QuoteSchemeSubmitValidator_1", (String)"scmc-plat-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                return;
            }
            try {
                DataSet sourceDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)sourceEntity, (String)String.join((CharSequence)",", sourceResult), (QFilter[])new QFilter[]{QFilter.of((String)"1!=1", (Object[])new Object[0])}, (String)"id");
                DataSet quoteDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)quoteEntity, (String)String.join((CharSequence)",", quoteResult), (QFilter[])new QFilter[]{QFilter.of((String)"1!=1", (Object[])new Object[0])}, (String)"id");
                Field[] sourceFields = sourceDataSet.getRowMeta().getFields();
                Field[] quoteFields = quoteDataSet.getRowMeta().getFields();
                for (int s = 0; s < sourceFields.length; ++s) {
                    Field sourceField = sourceFields[s];
                    Field quoteField = quoteFields[s];
                    if (sourceField.getDataType().equals((Object)quoteField.getDataType())) continue;
                    this.addMessage(data, ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\uff0c\u53d6\u4ef7\u7ed3\u679c\u5b57\u6bb5\u7684\u201c\u4ef7\u683c\u6765\u6e90\u5b57\u6bb5\u201d\u548c\u201c\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u201d\u5b58\u5728\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"QuoteSchemeSubmitValidator_4", (String)"scmc-plat-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    return;
                }
            }
            catch (Exception e) {
                logger.info("dynamicform exists");
            }
            if (flagA == 0 || flagB == 0) {
                this.addMessage(data, ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\uff0c\u201c\u53c2\u4e0e\u53d6\u4ef7\u65b9\u5f0f\u201d\u81f3\u5c11\u6709\u4e00\u4e2a\u201c\u4f5c\u4e3a\u53d6\u4ef7\u6761\u4ef6\u201d\uff0c\u4e00\u4e2a\u201c\u4f5c\u4e3a\u53d6\u4ef7\u7ed3\u679c\u201d\u3002", (String)"QuoteSchemeSubmitValidator_2", (String)"scmc-plat-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                return;
            }
        } else {
            this.addMessage(data, ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\uff0c\u201c\u53c2\u4e0e\u53d6\u4ef7\u65b9\u5f0f\u201d\u81f3\u5c11\u6709\u4e00\u4e2a\u201c\u4f5c\u4e3a\u53d6\u4ef7\u6761\u4ef6\u201d\uff0c\u4e00\u4e2a\u201c\u4f5c\u4e3a\u53d6\u4ef7\u7ed3\u679c\u201d\u3002", (String)"QuoteSchemeSubmitValidator_2", (String)"scmc-plat-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            return;
        }
        DynamicObjectCollection sortEntries = bill.getDynamicObjectCollection("pricesortentity");
        if (sortEntries != null && sortEntries.size() > 0) {
            for (DynamicObject entry : sortEntries) {
                String sortSign = entry.getString("sortsign");
                String sortSignName = entry.getString("sortsignname");
                if (!StringUtils.isEmpty((CharSequence)sortSign) && !StringUtils.isEmpty((CharSequence)sortSignName)) continue;
                this.addMessage(data, ResManager.loadKDString((String)"\u4ef7\u683c\u6392\u5e8f\u5206\u5f55\uff0c\u4ef7\u683c\u6765\u6e90\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QuoteSchemeSubmitValidator_3", (String)"scmc-plat-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                return;
            }
        }
    }
}

