/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.opplugin.pricemodel;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;

public class QuoteStrategySaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
            if (entries != null && entries.size() > 0) {
                for (int i = 0; i < entries.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entries.get(i);
                    String qu_precondition = entry.getString("qu_preconditiondesc");
                    if (qu_precondition.length() > 2000) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u53d6\u4ef7\u524d\u7f6e\u6761\u4ef6\u8bbe\u7f6e\u957f\u5ea6\u8d85\u8fc7\u6307\u5b9a\u957f\u5ea6\uff0c\u8bf7\u4fee\u6539\u6761\u4ef6\u3002", (String)"QuoteStrategySaveValidator_0", (String)"scmc-plat-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        return;
                    }
                    String termination = entry.getString("terminationsigndesc");
                    if (!StringUtils.isEmpty((CharSequence)termination)) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u201c\u65b9\u6848\u6392\u5e8f\u201d\u5206\u5f55\u4e2d\u7b2c%1$s\u884c\u6ca1\u6709\u5f55\u5165\u201c\u53d6\u5230\u4ef7\u683c\u7ec8\u6b62\u201d,\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"QuoteStrategySaveValidator_1", (String)"scmc-plat-opplugin", (Object[])new Object[0]), i + 1);
                    this.addMessage(data, msg, ErrorLevel.Error);
                }
                continue;
            }
            this.addMessage(data, ResManager.loadKDString((String)"\u201c\u65b9\u6848\u6392\u5e8f\u201d\u5206\u5f55\u6ca1\u6709\u5f55\u5165\u6570\u636e\u4e0d\u5141\u8bb8\u4fdd\u5b58\u6216\u63d0\u4ea4\u3002", (String)"QuoteStrategySaveValidator_3", (String)"scmc-plat-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            return;
        }
    }
}

