/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.plat.mservice.price;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scmc.plat.business.helper.pricemodel.helper.FetchPriceHelper;
import kd.scmc.plat.mservice.api.price.QuoteService;

public class QuoteServiceImpl
implements QuoteService {
    private static String HEAD_FLAG = "header";
    private static String ENTRY_FLAG = "entry";
    private static String SUCCESS = "success";
    private static String RESULT = "result";
    private static String MSG = "msg";
    public static final String SPLIT = "\\.";
    private static final Log log = LogFactory.getLog(QuoteServiceImpl.class);

    public Map<Long, Map<String, List<String>>> queryMapKey(Long[] orgIDs, String entityType) {
        HashSet<Long> orgSet = new HashSet<Long>(8);
        for (Long id2 : orgIDs) {
            orgSet.add(id2);
        }
        Map keyResult = FetchPriceHelper.fetchPriceConditonKey(orgSet, (String)entityType);
        HashMap<Long, Map<String, List<String>>> keyResultTraster = new HashMap<Long, Map<String, List<String>>>();
        orgSet.forEach(id -> {
            Map keyMap = (Map)keyResult.get(id);
            if (!Boolean.TRUE.equals(keyMap.get(SUCCESS))) {
                throw new KDBizException(String.valueOf(keyMap.get(MSG)));
            }
            HashMap<String, List> keyMapTrasfter = new HashMap<String, List>();
            keyMapTrasfter.put(HEAD_FLAG, (List)keyMap.get(HEAD_FLAG));
            keyMapTrasfter.put(ENTRY_FLAG, (List)keyMap.get(ENTRY_FLAG));
            keyMapTrasfter.put(RESULT, (List)keyMap.get(RESULT));
            keyResultTraster.put((Long)id, (Map<String, List<String>>)keyMapTrasfter);
        });
        return keyResultTraster;
    }

    public Map<Long, Map<String, ?>> queryMapKeyIgnoreExp(Long[] orgIDs, String entityType) {
        HashMap quoteParam = new HashMap();
        Map priceMapKey = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"QuoteService", (String)"queryMapKeyIgnoreExp", (Object[])new Object[]{orgIDs, entityType, quoteParam});
        return priceMapKey;
    }

    public Map<Long, Map<String, Object>> quoteByMap(Map<Long, List<Map<String, Object>>> propertiesMap, String entityType) {
        HashMap quoteParam = new HashMap();
        Map priceMapObj = FetchPriceHelper.fetchPrice((String)entityType, propertiesMap, quoteParam);
        propertiesMap.forEach((id, conditonMap) -> {
            Map resultMap = (Map)priceMapObj.get(id);
            if (resultMap != null) {
                if (Boolean.TRUE.equals(resultMap.get(SUCCESS))) {
                    HashMap resultHistoryMap = new HashMap();
                    resultMap.forEach((key, value) -> {
                        if (key.contains("$$")) {
                            String newKey = key.replaceAll("\\$\\$", "_");
                            resultHistoryMap.put(newKey, value);
                        }
                    });
                    resultMap.putAll(resultHistoryMap);
                } else {
                    throw new KDBizException(String.valueOf(resultMap.get(MSG)));
                }
            }
        });
        return priceMapObj;
    }

    public Map<Long, Map<String, ?>> quoteByMapIgnoreExp(Map<Long, List<Map<String, Object>>> propertiesMap, String entityType) {
        HashMap quoteParam = new HashMap();
        Map priceMapObj = FetchPriceHelper.fetchPrice((String)entityType, propertiesMap, quoteParam);
        propertiesMap.forEach((id, conditonMap) -> {
            Map resultMap = (Map)priceMapObj.get(id);
            if (Boolean.TRUE.equals(resultMap.get(SUCCESS))) {
                HashMap resultHistoryMap = new HashMap();
                resultMap.forEach((key, value) -> {
                    if (key.contains("$$")) {
                        String newKey = key.replaceAll("\\$\\$", "_");
                        resultHistoryMap.put(newKey, value);
                    }
                });
                resultMap.putAll(resultHistoryMap);
            }
        });
        HashMap allPriceMap = new HashMap();
        allPriceMap.putAll(priceMapObj);
        return allPriceMap;
    }

    public Map<Long, Map<String, ?>> quoteByMapIgnoreExpWithParam(Map<Long, List<Map<String, Object>>> propertiesMap, String entityType, Map<String, Object> quoteParam) {
        Map priceMapObj = FetchPriceHelper.fetchPrice((String)entityType, propertiesMap, quoteParam);
        HashMap allPriceMap = new HashMap();
        allPriceMap.putAll(priceMapObj);
        return allPriceMap;
    }

    public Map<String, Object> quoteByDynObj(Long orgID, DynamicObject[] bills, String entityType, boolean isThrowException) {
        HashMap quoteParam = new HashMap();
        HashMap<Long, List<DynamicObject>> billMap = new HashMap<Long, List<DynamicObject>>();
        billMap.put(orgID, Arrays.asList(bills));
        Map priceMapObj = FetchPriceHelper.integrationFetchPrice(billMap, (String)entityType, quoteParam);
        Map resultMap = (Map)priceMapObj.get(orgID);
        if (resultMap != null) {
            if (Boolean.TRUE.equals(resultMap.get(SUCCESS))) {
                HashMap resultHistoryMap = new HashMap();
                resultMap.forEach((key, value) -> {
                    if (key.contains("$$")) {
                        String newKey = key.replaceAll("\\$\\$", "_");
                        resultHistoryMap.put(newKey, value);
                    }
                });
                resultMap.putAll(resultHistoryMap);
            } else if (isThrowException) {
                throw new KDBizException(String.valueOf(resultMap.get(MSG)));
            }
        }
        return resultMap;
    }

    public Map<String, Object> quoteByIDs(Long orgID, Long[] ids, String entityType, boolean isThrowException) {
        HashMap<Long, List<Long>> idsMap = new HashMap<Long, List<Long>>();
        idsMap.put(orgID, Arrays.asList(ids));
        HashMap quoteParam = new HashMap();
        Map priceMapObj = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"QuoteService", (String)"quoteByIDsIgnoreExpWithParam", (Object[])new Object[]{idsMap, entityType, quoteParam});
        Map resultMap = (Map)priceMapObj.get(orgID);
        if (resultMap != null) {
            if (Boolean.TRUE.equals(resultMap.get(SUCCESS))) {
                HashMap resultHistoryMap = new HashMap();
                resultMap.forEach((key, value) -> {
                    if (key.contains("$$")) {
                        String newKey = key.replaceAll("\\$\\$", "_");
                        resultHistoryMap.put(newKey, value);
                    }
                });
                resultMap.putAll(resultHistoryMap);
            } else if (isThrowException) {
                throw new KDBizException(String.valueOf(resultMap.get(MSG)));
            }
        }
        return resultMap;
    }

    public Map<String, Object> quoteByDynObj4VMI(Long orgID, DynamicObject[] bills, String entityType, Long schemeID) {
        Map<String, Object> result = this.quoteByDynObj(orgID, bills, entityType, false);
        if (result != null) {
            if (Boolean.TRUE.equals(result.get(SUCCESS))) {
                HashMap<String, Object> successResult = new HashMap<String, Object>(2);
                HashMap finalResult = new HashMap(bills.length);
                for (DynamicObject bill : bills) {
                    String id = bill.getPkValue().toString();
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
                    HashMap entryListMapping = new HashMap(entrys.size());
                    for (int i = 0; i < entrys.size(); ++i) {
                        HashMap<String, Object> entryInfoMapping = new HashMap<String, Object>(16);
                        DynamicObject entry = (DynamicObject)entrys.get(i);
                        String entryID = entry.getPkValue().toString();
                        String seq = String.valueOf(i + 1);
                        String priceField = "price";
                        String priceAndTaxField = "priceandtax";
                        String isTaxField = "istax";
                        String taxrateidField = "taxrateid";
                        String taxrateField = "taxrate";
                        String priceKey = new StringBuffer(String.valueOf(id)).append("_").append(new StringBuffer(String.valueOf(entryID))).append("_").append(new StringBuffer(String.valueOf(seq))).append("_").append(new StringBuffer(priceField)).toString();
                        if (result.get(priceKey) == null) {
                            entryInfoMapping.put(priceField, BigDecimal.ZERO);
                        } else {
                            entryInfoMapping.put(priceField, result.get(priceKey));
                        }
                        String priceAndTaxKey = new StringBuffer(String.valueOf(id)).append("_").append(new StringBuffer(String.valueOf(entryID))).append("_").append(new StringBuffer(String.valueOf(seq))).append("_").append(new StringBuffer(priceAndTaxField)).toString();
                        if (result.get(priceAndTaxKey) == null) {
                            entryInfoMapping.put(priceAndTaxField, BigDecimal.ZERO);
                        } else {
                            entryInfoMapping.put(priceAndTaxField, result.get(priceAndTaxKey));
                        }
                        String isTaxKey = new StringBuffer(String.valueOf(id)).append("_").append(new StringBuffer(String.valueOf(entryID))).append("_").append(new StringBuffer(String.valueOf(seq))).append("_").append(new StringBuffer(isTaxField)).toString();
                        if (result.get(isTaxKey) == null) {
                            entryInfoMapping.put(isTaxField, Boolean.FALSE);
                        } else {
                            entryInfoMapping.put(isTaxField, result.get(isTaxKey));
                        }
                        String taxrateidKey = new StringBuffer(String.valueOf(id)).append("_").append(new StringBuffer(String.valueOf(entryID))).append("_").append(new StringBuffer(String.valueOf(seq))).append("_").append(new StringBuffer(taxrateidField)).toString();
                        if (result.get(taxrateidKey) == null) {
                            entryInfoMapping.put(taxrateidField, 0L);
                        } else {
                            entryInfoMapping.put(taxrateidField, result.get(taxrateidKey));
                        }
                        String taxrateKey = new StringBuffer(String.valueOf(id)).append("_").append(new StringBuffer(String.valueOf(entryID))).append("_").append(new StringBuffer(String.valueOf(seq))).append("_").append(new StringBuffer(taxrateField)).toString();
                        if (result.get(taxrateKey) == null) {
                            entryInfoMapping.put(taxrateField, BigDecimal.ZERO);
                        } else {
                            entryInfoMapping.put(taxrateField, result.get(taxrateKey));
                        }
                        entryListMapping.put((Long)entry.getPkValue(), entryInfoMapping);
                    }
                    finalResult.put((Long)bill.getPkValue(), entryListMapping);
                }
                successResult.put("success", Boolean.TRUE);
                successResult.put("result", finalResult);
                return successResult;
            }
            result.put("success", Boolean.FALSE);
            result.put("result", result.get(MSG));
        }
        return result;
    }
}

