/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.common.om.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class PurOrderHelper {
    public static final String BILLENTRY = "billentry";
    public static final String BOMNAME = "bomname";
    public static final String BOMID = "bomid";
    public static final String PDM_MFTBOM = "pdm_mftbom";
    public static final String TYPE = "type";
    public static final String ID = "id";

    public static void cleanEntryBomWhenDiff(IDataModel model, Set<Long> bomTypeIds) {
        DynamicObjectCollection entryEntity = model.getEntryEntity(BILLENTRY);
        HashSet<Long> bomIds = new HashSet<Long>();
        for (DynamicObject entry : entryEntity) {
            bomIds.add(entry.getLong(BOMID));
        }
        if (bomIds.isEmpty()) {
            return;
        }
        String algoKey = "kd.scmc.pm.common.om.helper.PurOrderHelper.cleanEntryBomWhenDiff";
        QFilter[] qFilters = new QFilter[]{new QFilter(ID, "in", bomIds)};
        String sels = "type,id";
        HashMap<Long, Long> id_typeMap = new HashMap<Long, Long>(entryEntity.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)PDM_MFTBOM, (String)sels, (QFilter[])qFilters, null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                id_typeMap.put(next.getLong(ID), next.getLong(TYPE));
            }
        }
        for (DynamicObject entry : entryEntity) {
            long bomid = entry.getLong(BOMID);
            Long entryBomTypeId = (Long)id_typeMap.get(bomid);
            if (entryBomTypeId == null || bomTypeIds.contains(entryBomTypeId)) continue;
            entry.set(BOMNAME, null);
            entry.set(BOMID, null);
        }
    }

    public static BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        if (material != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(BigDecimal.ZERO) != 0) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                return srcQty;
            }
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)material.getPkValue()), (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null && muConv.getInt("numerator") != 0) {
                int precision = desUnit.getInt("precision");
                String precisionAccount = desUnit.getString("precisionaccount");
                if (StringUtils.isNotEmpty((CharSequence)precisionAccount)) {
                    return srcQty.multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), precision, PurOrderHelper.getPrecisionDeal(precisionAccount));
                }
            }
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getBaseQty(Map<String, Object> oprEntry, BigDecimal oprQty) {
        if (oprEntry == null || oprQty == null || BigDecimal.ZERO.compareTo(oprQty) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal operationQty = (BigDecimal)oprEntry.get("oprentryentity.operationqty");
        BigDecimal headQty = (BigDecimal)oprEntry.get("oprentryentity.headqty");
        headQty = oprQty.multiply(headQty);
        Long baseUnitId = (Long)oprEntry.get("baseunit");
        Long headUnitId = (Long)oprEntry.get("oprentryentity.headunit");
        Long materialId = (Long)oprEntry.get("material");
        BigDecimal bigDecimal = UnitConvertHelper.calculateNewQty((BigDecimal)headQty, (Long)baseUnitId, (Long)headUnitId, (Long)materialId, (StringBuilder)new StringBuilder());
        int precision = (Integer)oprEntry.get("baseunit.precision");
        String precisionAccount = (String)oprEntry.get("baseunit.precisionaccount");
        BigDecimal baseQty = bigDecimal.divide(operationQty, precision, PurOrderHelper.getPrecisionDeal(precisionAccount));
        return baseQty;
    }

    public static BigDecimal getOprQty(Map<String, Object> oprEntry, BigDecimal baseQty) {
        if (oprEntry == null || baseQty == null || BigDecimal.ZERO.compareTo(baseQty) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = UnitConvertHelper.calculateNewQty((BigDecimal)baseQty, (Long)((Long)oprEntry.get("oprentryentity.headunit")), (Long)((Long)oprEntry.get("baseunit")), (Long)((Long)oprEntry.get("material")), (StringBuilder)new StringBuilder());
        BigDecimal operationQty = (BigDecimal)oprEntry.get("oprentryentity.operationqty");
        operationQty = bigDecimal.multiply(operationQty);
        BigDecimal headQty = (BigDecimal)oprEntry.get("oprentryentity.headqty");
        BigDecimal decimal = operationQty.divide(headQty, (int)((Integer)oprEntry.get("oprentryentity.oprunit.precision")), PurOrderHelper.getPrecisionDeal((String)oprEntry.get("oprentryentity.oprunit.precisionaccount")));
        return decimal;
    }

    public static Map<String, Object> getManftechMap(DynamicObject manTechicsInfo, DynamicObject techisInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("baseunit", manTechicsInfo.getDynamicObject("baseunit").getPkValue());
        map.put("baseunit.precision", manTechicsInfo.getDynamicObject("baseunit").getInt("precision"));
        map.put("baseunit.precisionaccount", manTechicsInfo.getDynamicObject("baseunit").getString("precisionaccount"));
        map.put("material", manTechicsInfo.getDynamicObject("material") == null ? null : manTechicsInfo.getDynamicObject("material").getPkValue());
        map.put("oprentryentity.operationqty", techisInfo.getBigDecimal("operationqty"));
        map.put("oprentryentity.headqty", techisInfo.getBigDecimal("headqty"));
        map.put("oprentryentity.headunit", techisInfo.getDynamicObject("headunit").getPkValue());
        map.put("oprentryentity.oprunit.precision", techisInfo.getDynamicObject("oprunit").getInt("precision"));
        map.put("oprentryentity.oprunit.precisionaccount", techisInfo.getDynamicObject("oprunit").getString("precisionaccount"));
        return map;
    }

    public static int getPrecisionDeal(String precisionAccount) {
        int deal = 4;
        switch (precisionAccount) {
            case "1": {
                deal = 4;
                break;
            }
            case "2": {
                deal = 1;
                break;
            }
            case "3": {
                deal = 0;
                break;
            }
        }
        return deal;
    }

    public static Map<String, Object> getInternalCompanyBySup(Long supplierId) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)supplierId, (String)"bd_supplier");
        DynamicObject internal_company = supplier.getDynamicObject("internal_company");
        if (internal_company != null) {
            dataMap.put("internal_company", internal_company.getPkValue());
            Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)internal_company.getLong(ID), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            Integer fromOrg = map == null || map.isEmpty() ? Integer.valueOf(0) : map.get(ID);
            Long longFromOrg = (Long)((Object)fromOrg);
            dataMap.put("tosettleorg", longFromOrg);
        }
        return dataMap;
    }
}

