/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.common.om.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.pm.common.om.consts.WXPurOrderBillEntryConst;
import kd.scmc.pm.common.om.enums.ActiveStatusEnum;
import kd.scmc.pm.common.om.enums.BizCancelStatusEnum;
import kd.scmc.pm.common.om.enums.ChangeStatusEnum;
import kd.scmc.pm.common.om.enums.ChangeTypeEnum;
import kd.scmc.pm.common.om.enums.FeedTypeEnum;
import kd.scmc.pm.common.om.enums.StatusEnum;
import kd.scmc.pm.common.om.helper.PurOrderHelper;
import kd.scmc.pm.utils.CommonUtils;
import org.apache.commons.collections4.map.HashedMap;

public class WXPurOrderHelper {
    private static final Log logger = LogFactory.getLog(WXPurOrderHelper.class);

    public static void showBomList(AbstractBillPlugIn plugIn, IFormView view, IDataModel model, String sourcekey) {
        String entityNumber = "pdm_mftbom";
        EntryGrid entryGrid = (EntryGrid)view.getControl("billentry");
        if (entryGrid.getSelectRows().length == 0) {
            return;
        }
        int rowIndex = entryGrid.getSelectRows()[0];
        DynamicObject mftmaterial = (DynamicObject)model.getValue("material", rowIndex);
        if (mftmaterial == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7269\u6599\u3002", (String)"WXPurOrderHelper_0", (String)"scmc-mm-om", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)false);
        Object masterId = mftmaterial.getDynamicObject("masterid").getPkValue();
        List<QFilter> filters2 = WXPurOrderHelper.getQFilters(view, model, entityNumber, rowIndex, masterId);
        if (filters2 == null) {
            return;
        }
        showParameter.getListFilterParameter().setQFilters(filters2);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugIn, sourcekey);
        showParameter.setCloseCallBack(closeCallBack);
        view.showForm((FormShowParameter)showParameter);
    }

    public static List<QFilter> getQFilters(IFormView view, IDataModel model, String entityNumber, int rowIndex, Object masterId) {
        Object id;
        Row next;
        DynamicObjectCollection bomTypes;
        ArrayList<QFilter> filters_A = new ArrayList<QFilter>(6);
        ArrayList<QFilter> filters_B = new ArrayList<QFilter>(6);
        QFilter qfilter = new QFilter("material.masterid", "=", masterId);
        Object transId = model.getValue("transactiontype");
        String errMsg = ResManager.loadKDString((String)"\u59d4\u5916\u4e8b\u52a1\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"WXPurOrderHelper_1", (String)"scmc-mm-om", (Object[])new Object[0]);
        if (transId == null) {
            view.showTipNotification(errMsg);
            return null;
        }
        DynamicObject transactiontype = BusinessDataServiceHelper.loadSingleFromCache((Object)transId, (String)"mpdm_transactout");
        if (transactiontype == null) {
            view.showTipNotification(errMsg);
            return null;
        }
        String feedtype = transactiontype.getString("feedtype");
        if ("A".equals(feedtype) && (bomTypes = transactiontype.getDynamicObjectCollection("bomtypes")) != null && bomTypes.size() > 0) {
            HashSet<Long> bomTypeIds = new HashSet<Long>(16);
            for (DynamicObject bomType : bomTypes) {
                bomTypeIds.add(bomType.getLong("fbasedataid_id"));
            }
            qfilter.and(new QFilter("type", "in", bomTypeIds));
        }
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        qfilter.and(new QFilter("enable", "=", (Object)"1"));
        Object configuredCode = model.getValue("configuredcode", rowIndex);
        if (configuredCode instanceof DynamicObject) {
            qfilter.and(new QFilter("configuredcode.id", "=", ((DynamicObject)configuredCode).getPkValue()));
        }
        filters_A.add(qfilter);
        filters_B.add(qfilter);
        Date expendbomtime = (Date)model.getValue("expendbomtime", rowIndex);
        if (expendbomtime != null) {
            QFilter qfilter1 = new QFilter("version.effectdate", "<=", (Object)expendbomtime).and(new QFilter("version.invaliddate", ">", (Object)expendbomtime));
            filters_A.add(qfilter1);
        }
        filters_B.add(new QFilter("version", "=", (Object)0L));
        ArrayList<QFilter> filters2 = new ArrayList<QFilter>();
        HashSet<Object> ids = new HashSet<Object>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query-pdm_mftbom", (String)entityNumber, (String)"id", (QFilter[])filters_A.toArray(new QFilter[0]), null);){
            while (dataSet.hasNext()) {
                next = dataSet.next();
                id = next.get("id");
                ids.add(id);
            }
        }
        dataSet = QueryServiceHelper.queryDataSet((String)"query-pdm_mftbom", (String)entityNumber, (String)"id", (QFilter[])filters_B.toArray(new QFilter[0]), null);
        var17_17 = null;
        try {
            while (dataSet.hasNext()) {
                next = dataSet.next();
                id = next.get("id");
                ids.add(id);
            }
        }
        catch (Throwable throwable) {
            var17_17 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var17_17 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var17_17.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        filters2.add(new QFilter("id", "in", ids));
        return filters2;
    }

    public static Map<String, Object> getSelectData(IFormView view, IDataModel model, Object returnData) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(6);
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
            Object pk = rows.get(0).getPrimaryKeyValue();
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", pk)};
            StringBuilder selects = new StringBuilder();
            selects.append("id");
            selects.append(",number");
            selects.append(",auxproperty");
            selects.append(",version");
            selects.append(",ecn");
            selects.append(",replaceno");
            selects.append(",configuredcode.id");
            String sels = selects.toString();
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query-pdm_mftbom", (String)"pdm_mftbom", (String)sels, (QFilter[])qFilters, null, (int)1);){
                if (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    Arrays.stream(sels.split(",")).forEach(a -> dataMap.put((String)a, next.get(a)));
                }
            }
        }
        return dataMap;
    }

    public static Map<String, Object> queryMftbomData(Object bomNumber) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(6);
        if (bomNumber instanceof String) {
            QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", bomNumber)};
            StringBuilder selects = new StringBuilder();
            selects.append("id");
            selects.append(",number");
            selects.append(",auxproperty");
            selects.append(",version");
            selects.append(",ecn");
            selects.append(",replaceno");
            selects.append(",configuredcode.id");
            String sels = selects.toString();
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query-pdm_mftbom", (String)"pdm_mftbom", (String)sels, (QFilter[])qFilters, null, (int)1);){
                if (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    Arrays.stream(sels.split(",")).forEach(a -> dataMap.put((String)a, next.get(a)));
                }
            }
        }
        return dataMap;
    }

    public static void setEntryData(IFormView view, IDataModel model, Map<String, Object> selectData, int currentEntryIndex) {
        if (currentEntryIndex == -1) {
            return;
        }
        model.beginInit();
        model.setValue("bomname", selectData.get("number"), currentEntryIndex);
        model.setValue("bomid", selectData.get("id"), currentEntryIndex);
        model.setValue("auxpty", selectData.get("auxproperty"), currentEntryIndex);
        model.setValue("configuredcode", selectData.get("configuredcode.id"), currentEntryIndex);
        Object version = selectData.get("version");
        String versionSel = "name,id";
        QFilter[] versionQf = new QFilter[]{new QFilter("id", "=", version)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query-version", (String)"bd_bomversion", (String)versionSel, (QFilter[])versionQf, null);){
            if (dataSet.hasNext()) {
                Row next = dataSet.next();
                model.setValue("bomversionname", next.get("name"), currentEntryIndex);
                model.setValue("bomversion", next.get("id"), currentEntryIndex);
            } else {
                model.setValue("bomversionname", null, currentEntryIndex);
                model.setValue("bomversion", (Object)0, currentEntryIndex);
            }
        }
        Object ecn = selectData.get("ecn");
        String ecnSel = "number,id";
        QFilter[] ecnQf = new QFilter[]{new QFilter("id", "=", ecn)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query-version", (String)"pdm_ecnversion", (String)ecnSel, (QFilter[])ecnQf, null);){
            if (dataSet.hasNext()) {
                Row next = dataSet.next();
                model.setValue("ecnversionname", next.get("number"), currentEntryIndex);
                model.setValue("ecnversion", next.get("id"), currentEntryIndex);
            } else {
                model.setValue("ecnversionname", null, currentEntryIndex);
                model.setValue("ecnversion", (Object)0, currentEntryIndex);
            }
        }
        Object replaceno = selectData.get("replaceno");
        String replacenoSel = "name,id";
        QFilter[] replacenoQf = new QFilter[]{new QFilter("id", "=", replaceno)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query-version", (String)"mpdm_replaceno", (String)replacenoSel, (QFilter[])replacenoQf, null);){
            if (dataSet.hasNext()) {
                Row next = dataSet.next();
                model.setValue("bomreplacenoname", next.get("name"), currentEntryIndex);
                model.setValue("bomreplaceno", next.get("id"), currentEntryIndex);
            } else {
                model.setValue("bomreplacenoname", null, currentEntryIndex);
                model.setValue("bomreplaceno", (Object)0, currentEntryIndex);
            }
        }
        model.endInit();
    }

    public static void cleanEntryData(IFormView view, IDataModel model, int currentEntryIndex) {
        if (currentEntryIndex == -1) {
            return;
        }
        model.beginInit();
        model.setValue("bomname", null, currentEntryIndex);
        model.setValue("bomid", (Object)0, currentEntryIndex);
        model.setValue("auxpty", null, currentEntryIndex);
        model.setValue("bomversionname", null, currentEntryIndex);
        model.setValue("bomversion", (Object)0, currentEntryIndex);
        model.setValue("ecnversionname", null, currentEntryIndex);
        model.setValue("ecnversion", (Object)0, currentEntryIndex);
        model.setValue("bomreplacenoname", null, currentEntryIndex);
        model.setValue("bomreplaceno", (Object)0, currentEntryIndex);
        model.endInit();
    }

    public static int getSelectEntryRowIndex(IFormView view) {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)view.getControl("billentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    public static boolean check(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject bill = dataEntities[i];
            if (ActiveStatusEnum.UNACTIVE.getCode().equals(bill.get("activestatus")) && BizCancelStatusEnum.UNCANCEL.getCode().equals(bill.get("cancelstatus")) && StatusEnum.AUDIT.getCode().equals(bill.get("billstatus"))) continue;
            e.cancel = true;
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u751f\u6548\u5931\u8d25\uff0c\u59d4\u5916\u8ba2\u5355\u53d8\u66f4\u5355\u201c%1$s\u201d\u4e0d\u662f\u6709\u6548\u5355\u636e\u3002", (String)"WXPurOrderHelper_2", (String)"scmc-mm-om", (Object[])new Object[0]), bill.get("billno")));
            return false;
        }
        return true;
    }

    public static void updataPurOrder(DynamicObject[] bills) {
        HashMap techEntryId_dataMap = new HashMap(16);
        for (int i = 0; i < bills.length; ++i) {
            QFilter qFilter2;
            boolean isAddNewEntry = false;
            DynamicObject bill = bills[i];
            bill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)bill.getDynamicObjectType().getName());
            String modelType = bill.getString("modeltype");
            String srcBillNo = bill.getString("sourceno");
            Long orgId = (Long)bill.getDynamicObject("org").getPkValue();
            QFilter qFilter1 = new QFilter("org", "=", (Object)orgId);
            DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((String)"pm_om_purorderbill", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2 = new QFilter("billno", "=", (Object)srcBillNo)});
            if (srcBill == null) continue;
            srcBill = BusinessDataServiceHelper.loadSingle((Object)srcBill.getPkValue(), (String)"pm_om_purorderbill");
            srcBill.set("comment", bill.get("comment"));
            srcBill.set("operatorgroup", bill.get("operatorgroup"));
            srcBill.set("operator", bill.get("operator"));
            srcBill.set("dept", bill.get("dept"));
            srcBill.set("linkman", bill.get("linkman"));
            srcBill.set("provideraddress", bill.get("provideraddress"));
            srcBill.set("providerlinkman", bill.get("providerlinkman"));
            srcBill.set("totalallamount", bill.get("totalallamount"));
            srcBill.set("totalamount", bill.get("totalamount"));
            srcBill.set("totaltaxamount", bill.get("totaltaxamount"));
            srcBill.set("address", bill.get("address"));
            String version = bill.getString("version");
            if (version == null || version.equals("0") || version.equals("1.0")) {
                version = "1";
            }
            srcBill.set("version", (Object)(Integer.parseInt(version) + 1));
            srcBill.set("changestatus", (Object)ChangeStatusEnum.CHANGED.getCode());
            srcBill.set("changer", (Object)BusinessDataServiceHelper.loadSingle((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user"));
            srcBill.set("changedate", (Object)new Date(System.currentTimeMillis()));
            DynamicObjectCollection billEntrys = srcBill.getDynamicObjectCollection("billentry");
            DynamicObjectCollection xBillEntrys = bill.getDynamicObjectCollection("billentry");
            if (!CommonUtils.isNull((Object)xBillEntrys)) {
                Long billEntryID;
                DynamicObject billEntry;
                int i3;
                Long xSrcBillEntryID;
                DynamicObject xBillEntry;
                int i2;
                block1: for (i2 = 0; i2 < xBillEntrys.size(); ++i2) {
                    xBillEntry = (DynamicObject)xBillEntrys.get(i2);
                    xSrcBillEntryID = xBillEntry.getLong("sourceentryid");
                    if (!ChangeTypeEnum.UPDATE.getCode().equals(xBillEntry.get("entrychangetype"))) continue;
                    for (i3 = 0; i3 < billEntrys.size(); ++i3) {
                        billEntry = (DynamicObject)billEntrys.get(i3);
                        billEntryID = (Long)billEntry.getPkValue();
                        if (xSrcBillEntryID.longValue() != billEntryID.longValue()) continue;
                        if ("B".equals(modelType)) {
                            BigDecimal billBaseQty = billEntry.getBigDecimal("baseqty");
                            BigDecimal xbillBaseQty = xBillEntry.getBigDecimal("baseqty");
                            BigDecimal diffBaseQty = xbillBaseQty.subtract(billBaseQty);
                            if (diffBaseQty.compareTo(BigDecimal.ZERO) != 0) {
                                long oprEntryId = billEntry.getLong("oprentryid");
                                HashMap<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>(4);
                                dataMap.put("diffBaseQty", diffBaseQty);
                                techEntryId_dataMap.put(oprEntryId, dataMap);
                            }
                        }
                        billEntry.set("qty", xBillEntry.get("qty"));
                        billEntry.set("baseqty", xBillEntry.get("baseqty"));
                        billEntry.set("auxqty", xBillEntry.get("auxqty"));
                        billEntry.set("price", xBillEntry.get("price"));
                        billEntry.set("priceandtax", xBillEntry.get("priceandtax"));
                        billEntry.set("taxrate", xBillEntry.get("taxrate"));
                        billEntry.set("amount", xBillEntry.get("amount"));
                        billEntry.set("amountandtax", xBillEntry.get("amountandtax"));
                        billEntry.set("curamount", xBillEntry.get("curamount"));
                        billEntry.set("curamountandtax", xBillEntry.get("curamountandtax"));
                        billEntry.set("curtaxamount", xBillEntry.get("curtaxamount"));
                        billEntry.set("discountamount", xBillEntry.get("discountamount"));
                        billEntry.set("taxamount", xBillEntry.get("taxamount"));
                        billEntry.set("entrycomment", xBillEntry.get("entrycomment"));
                        billEntry.set("iscontrolqty", xBillEntry.get("iscontrolqty"));
                        billEntry.set("receiveqtydown", xBillEntry.get("receiveqtydown"));
                        billEntry.set("receiveqtyup", xBillEntry.get("receiveqtyup"));
                        billEntry.set("receivebaseqtyup", xBillEntry.get("receivebaseqtyup"));
                        billEntry.set("receivebaseqtydown", xBillEntry.get("receivebaseqtydown"));
                        billEntry.set("receiveratedown", xBillEntry.get("receiveratedown"));
                        billEntry.set("receiverateup", xBillEntry.get("receiverateup"));
                        billEntry.set("deliverdate", xBillEntry.get("deliverdate"));
                        continue block1;
                    }
                }
                block3: for (i2 = xBillEntrys.size() - 1; i2 >= 0; --i2) {
                    xBillEntry = (DynamicObject)xBillEntrys.get(i2);
                    xSrcBillEntryID = xBillEntry.getLong("sourceentryid");
                    if (!ChangeTypeEnum.CANCEL.getCode().equals(xBillEntry.get("entrychangetype"))) continue;
                    for (i3 = billEntrys.size() - 1; i3 >= 0; --i3) {
                        BigDecimal billBaseQty;
                        BigDecimal xbillBaseQty;
                        BigDecimal diffBaseQty;
                        billEntry = (DynamicObject)billEntrys.get(i3);
                        billEntryID = (Long)billEntry.getPkValue();
                        if (xSrcBillEntryID.longValue() != billEntryID.longValue()) continue;
                        DynamicObjectCollection deliverBillEntrys = billEntry.getDynamicObjectCollection("purbillentry_deliver");
                        if (!CommonUtils.isNull((Object)deliverBillEntrys)) {
                            deliverBillEntrys.clear();
                        }
                        if ("B".equals(modelType) && (diffBaseQty = (xbillBaseQty = BigDecimal.ZERO).subtract(billBaseQty = billEntry.getBigDecimal("baseqty"))).compareTo(BigDecimal.ZERO) != 0) {
                            long oprEntryId = billEntry.getLong("oprentryid");
                            HashMap<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>(4);
                            dataMap.put("diffBaseQty", diffBaseQty);
                            techEntryId_dataMap.put(oprEntryId, dataMap);
                        }
                        billEntrys.remove((Object)billEntry);
                        continue block3;
                    }
                }
                for (i2 = 0; i2 < xBillEntrys.size(); ++i2) {
                    xBillEntry = (DynamicObject)xBillEntrys.get(i2);
                    if (!ChangeTypeEnum.ADDNEW.getCode().equals(xBillEntry.get("entrychangetype"))) continue;
                    DynamicObject billEntry2 = billEntrys.addNew();
                    for (int ii = 0; ii < billEntry2.getDataEntityType().getProperties().size(); ++ii) {
                        IDataEntityProperty entityProperty = (IDataEntityProperty)billEntry2.getDataEntityType().getProperties().get(ii);
                        if (entityProperty instanceof EntryProp) continue;
                        String propertyName = entityProperty.getName();
                        if ("id".equals(propertyName)) {
                            isAddNewEntry = true;
                            xBillEntry.set("sourceentryid", billEntry2.getPkValue());
                        }
                        if (!xBillEntry.containsProperty(propertyName)) continue;
                        billEntry2.set(propertyName, xBillEntry.get(propertyName));
                    }
                }
            }
            DynamicObjectCollection payBillEntrys = srcBill.getDynamicObjectCollection("purbillentry_pay");
            DynamicObjectCollection xPayBillEntrys = bill.getDynamicObjectCollection("purbillentry_pay");
            if (!CommonUtils.isNull((Object)xPayBillEntrys)) {
                Long billEntryID;
                DynamicObject payBillEntry;
                Long xSrcBillEntryID;
                int i2;
                block7: for (i2 = 0; i2 < xPayBillEntrys.size(); ++i2) {
                    DynamicObject xPayBillEntry = (DynamicObject)xPayBillEntrys.get(i2);
                    xSrcBillEntryID = xPayBillEntry.getLong("sourcepayentryid");
                    if (!ChangeTypeEnum.UPDATE.getCode().equals(xPayBillEntry.get("payentrychangetype"))) continue;
                    for (int i3 = 0; i3 < payBillEntrys.size(); ++i3) {
                        payBillEntry = (DynamicObject)payBillEntrys.get(i3);
                        billEntryID = (Long)payBillEntry.getPkValue();
                        if (xSrcBillEntryID.longValue() != billEntryID.longValue()) continue;
                        payBillEntry.set("payname", xPayBillEntry.get("payname"));
                        payBillEntry.set("paydate", xPayBillEntry.get("paydate"));
                        payBillEntry.set("payrate", xPayBillEntry.get("payrate"));
                        payBillEntry.set("payamount", xPayBillEntry.get("payamount"));
                        payBillEntry.set("isprepay", xPayBillEntry.get("isprepay"));
                        payBillEntry.set("paidamount", xPayBillEntry.get("paidamount"));
                        continue block7;
                    }
                }
                block9: for (i2 = xPayBillEntrys.size() - 1; i2 >= 0; --i2) {
                    DynamicObject xPayBillEntry = (DynamicObject)xPayBillEntrys.get(i2);
                    xSrcBillEntryID = xPayBillEntry.getLong("sourcepayentryid");
                    if (!ChangeTypeEnum.CANCEL.getCode().equals(xPayBillEntry.get("payentrychangetype"))) continue;
                    for (int i3 = payBillEntrys.size() - 1; i3 >= 0; --i3) {
                        payBillEntry = (DynamicObject)payBillEntrys.get(i3);
                        billEntryID = (Long)payBillEntry.getPkValue();
                        if (xSrcBillEntryID.longValue() != billEntryID.longValue()) continue;
                        payBillEntrys.remove((Object)payBillEntry);
                        continue block9;
                    }
                }
                for (i2 = 0; i2 < xPayBillEntrys.size(); ++i2) {
                    DynamicObject xPayBillEntry = (DynamicObject)xPayBillEntrys.get(i2);
                    if (!ChangeTypeEnum.ADDNEW.getCode().equals(xPayBillEntry.get("payentrychangetype"))) continue;
                    DynamicObject payBillEntry2 = payBillEntrys.addNew();
                    for (int ii = 0; ii < payBillEntry2.getDataEntityType().getProperties().size(); ++ii) {
                        IDataEntityProperty entityProperty = (IDataEntityProperty)payBillEntry2.getDataEntityType().getProperties().get(ii);
                        if (xPayBillEntry.get(entityProperty.getName()) instanceof EntryProp || xPayBillEntry.get(entityProperty.getName()) instanceof LinkEntryProp) continue;
                        payBillEntry2.set(entityProperty.getName(), xPayBillEntry.get(entityProperty.getName()));
                    }
                }
            }
            WXPurOrderHelper.colseSrcBill(srcBill);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{srcBill});
            if (!isAddNewEntry) continue;
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
        }
        if (!techEntryId_dataMap.isEmpty()) {
            DynamicObject[] techs;
            StringBuilder selStr = new StringBuilder();
            selStr.append("id");
            selStr.append(",baseunit.id");
            selStr.append(",baseunit.precision");
            selStr.append(",baseunit.precisionaccount");
            selStr.append(",material.id");
            selStr.append(",oprentryentity.id");
            selStr.append(",oprentryentity.operationqty");
            selStr.append(",oprentryentity.headqty");
            selStr.append(",oprentryentity.headunit");
            selStr.append(",oprentryentity.oprunit");
            selStr.append(",oprentryentity.oprunit.precision");
            selStr.append(",oprentryentity.oprunit.precisionaccount");
            selStr.append(",oprentryentity.pushoproutorderbaseqty");
            selStr.append(",oprentryentity.pushoproutorderqty");
            selStr.append(",oprentryentity.totaloproutorderbaseqty");
            selStr.append(",oprentryentity.totaloproutorderqty");
            QFilter[] qfs = new QFilter[]{new QFilter("oprentryentity.id", "in", techEntryId_dataMap.keySet())};
            for (DynamicObject tech : techs = BusinessDataServiceHelper.load((String)"sfc_manftech", (String)selStr.toString(), (QFilter[])qfs, null)) {
                DynamicObjectCollection entryColl = tech.getDynamicObjectCollection("oprentryentity");
                for (DynamicObject entry : entryColl) {
                    long entryId = entry.getLong("id");
                    Map dataMap = (Map)techEntryId_dataMap.get(entryId);
                    if (dataMap == null) continue;
                    BigDecimal diffBaseQty = (BigDecimal)dataMap.get("diffBaseQty");
                    Map<String, Object> manftechMap = PurOrderHelper.getManftechMap(tech, entry);
                    BigDecimal opDiffQty = PurOrderHelper.getOprQty(manftechMap, diffBaseQty);
                    entry.set("pushoproutorderbaseqty", (Object)entry.getBigDecimal("pushoproutorderbaseqty").add(diffBaseQty));
                    entry.set("totaloproutorderbaseqty", (Object)entry.getBigDecimal("totaloproutorderbaseqty").add(diffBaseQty));
                    entry.set("pushoproutorderqty", (Object)entry.getBigDecimal("pushoproutorderqty").add(opDiffQty));
                    entry.set("totaloproutorderqty", (Object)entry.getBigDecimal("totaloproutorderqty").add(opDiffQty));
                }
            }
            SaveServiceHelper.save((DynamicObject[])techs);
        }
    }

    private static void colseSrcBill(DynamicObject srcBill) {
        Objects.requireNonNull(srcBill);
        String modelType = srcBill.getString("modeltype");
        if (!"B".equals(modelType)) {
            return;
        }
        DynamicObjectCollection billEntrys = srcBill.getDynamicObjectCollection("billentry");
        boolean isBillColse = true;
        for (DynamicObject billEntry : billEntrys) {
            BigDecimal baseQty;
            BigDecimal invBaseQty = billEntry.getBigDecimal("invbaseqty");
            if (invBaseQty.compareTo(baseQty = billEntry.getBigDecimal("baseqty")) >= 0) {
                billEntry.set("rowclosestatus", (Object)"B");
                continue;
            }
            isBillColse = false;
            billEntry.set("rowclosestatus", (Object)"A");
        }
        if (isBillColse) {
            srcBill.set("closestatus", (Object)"B");
            srcBill.set("closer", (Object)1L);
            srcBill.set("closedate", (Object)TimeServiceHelper.now());
        } else {
            srcBill.set("closestatus", (Object)"A");
            srcBill.set("closer", null);
            srcBill.set("closedate", null);
        }
    }

    public static OperateErrorInfo checkAndGenStocks(DynamicObject[] objs, List<DynamicObject> successObjs) {
        OperateErrorInfo operateErrorInfo = null;
        if (Objects.isNull(objs)) {
            return null;
        }
        for (int i = 0; i < objs.length; ++i) {
            DynamicObject obj = objs[i];
            String stockname = "om_componentlist";
            Object typeId = obj.get("transactiontype");
            Map<String, Object> typeMap = WXPurOrderHelper.queryTransactOut(typeId);
            if (typeMap.isEmpty()) {
                return null;
            }
            Object feedType = typeMap.get("feedtype");
            Object isAuditStock = typeMap.get("isauditstock");
            List<String> feedTypeEnums = Arrays.asList(FeedTypeEnum.ZBOM.getCode(), FeedTypeEnum.SGLR.getCode(), FeedTypeEnum.JWWJ.getCode());
            if (!Objects.nonNull(feedType) || !feedTypeEnums.contains(feedType.toString())) continue;
            WXPurOrderHelper.genStocksNew(obj, stockname);
            if (!Objects.nonNull(isAuditStock) || !Boolean.parseBoolean(isAuditStock.toString())) continue;
            Map<Object, DynamicObject> orders = WXPurOrderHelper.loadMtfOrders(objs);
            operateErrorInfo = WXPurOrderHelper.auditStock(orders, successObjs);
        }
        return operateErrorInfo;
    }

    public static void genStocksNew(DynamicObject obj, String stockname) {
        try {
            logger.info("\u5f00\u59cb\u8c03\u7528pom\u751f\u6210\u7ec4\u4ef6\u6e05\u5355 ");
            DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMPDMMftGenStocksUtils", (String)"genStocksNew", (Object[])new Object[]{obj, "save", stockname});
            logger.info("\u8c03\u7528pom\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\u7ed3\u675f ");
        }
        catch (Exception ex) {
            logger.error("\u8c03\u7528\u670d\u52a1\u51fa\u73b0\u5f02\u5e38" + ex.getMessage(), (Throwable)ex);
            ErrorCode ec = new ErrorCode("order", ex.getMessage());
            throw new KDBizException(ec, new Object[0]);
        }
    }

    public static OperateErrorInfo auditStock(Map<Object, DynamicObject> orders, List<DynamicObject> successObjs) {
        Object orderEntryId;
        Object stockId;
        OperateErrorInfo errorInfo = null;
        HashedMap orderEntryIdtoBillIds = new HashedMap(orders.size());
        HashedMap submitStockIdtoOrderEntryIds = new HashedMap(orders.size());
        HashedMap auditStockIdtoOrderEntryIds = new HashedMap(orders.size());
        HashedMap failOrderEntryIds = new HashedMap(orders.size());
        HashSet auditStockId = new HashSet(orders.size());
        for (DynamicObject order : orders.values()) {
            boolean isAuditStock;
            Map<String, Object> transactionType = WXPurOrderHelper.queryTransactOut(order.get("transactiontype"));
            if (transactionType.isEmpty() || !(isAuditStock = Boolean.parseBoolean(transactionType.get("isauditstock").toString()))) continue;
            DynamicObjectCollection entryCol = order.getDynamicObjectCollection("billentry");
            for (DynamicObject col : entryCol) {
                Object orderEntryId2 = col.getPkValue();
                orderEntryIdtoBillIds.put(orderEntryId2, order.getPkValue());
            }
        }
        if (orderEntryIdtoBillIds.isEmpty()) {
            successObjs.addAll(orders.values());
            return null;
        }
        String stockname = "om_componentlist";
        QFilter stockqfilter = new QFilter("orderentryid", "in", (Object)orderEntryIdtoBillIds.keySet().toArray());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"PurOrderAuditAfterExeOp.auditStock", (String)stockname, (String)"id,billstatus,orderentryid", (QFilter[])new QFilter[]{stockqfilter}, (String)"");){
            while (ds.hasNext()) {
                Row row = ds.next();
                Iterator stockId2 = row.get("id");
                Object orderEntryId3 = row.get("orderentryid");
                if ("A".equals(row.get("billstatus"))) {
                    submitStockIdtoOrderEntryIds.put(stockId2, orderEntryId3);
                    continue;
                }
                if (!"B".equals(row.get("billstatus"))) continue;
                auditStockIdtoOrderEntryIds.put(stockId2, orderEntryId3);
                auditStockId.add(stockId2);
            }
        }
        if (submitStockIdtoOrderEntryIds.isEmpty() && auditStockIdtoOrderEntryIds.isEmpty()) {
            successObjs.addAll(orders.values());
            return null;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        if (!submitStockIdtoOrderEntryIds.isEmpty()) {
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)stockname, (Object[])submitStockIdtoOrderEntryIds.keySet().toArray(), (OperateOption)option);
            HashSet submitSuccessIds = new HashSet(submitResult.getSuccessPkIds());
            if (submitSuccessIds.isEmpty()) {
                WXPurOrderHelper.setFailMes(submitResult, (Map<Object, Object>)submitStockIdtoOrderEntryIds, (Map<Object, String>)failOrderEntryIds);
            } else {
                auditStockId.addAll(submitSuccessIds);
                for (Map.Entry stockIdtoOrderEntryId : submitStockIdtoOrderEntryIds.entrySet()) {
                    stockId = stockIdtoOrderEntryId.getKey();
                    orderEntryId = stockIdtoOrderEntryId.getValue();
                    if (!submitSuccessIds.contains(stockId)) {
                        failOrderEntryIds.put(orderEntryId, WXPurOrderHelper.getErrorBystockId(stockId, submitResult));
                        continue;
                    }
                    auditStockIdtoOrderEntryIds.put(stockId, orderEntryId);
                }
            }
        }
        if (!auditStockId.isEmpty()) {
            option.setVariableValue("autoaudit", "1");
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)stockname, (Object[])auditStockId.toArray(), (OperateOption)option);
            HashSet auditSuccessIds = new HashSet(auditResult.getSuccessPkIds());
            for (Map.Entry stockIdtoOrderEntryId : auditStockIdtoOrderEntryIds.entrySet()) {
                stockId = stockIdtoOrderEntryId.getKey();
                orderEntryId = stockIdtoOrderEntryId.getValue();
                if (auditSuccessIds.contains(stockId)) continue;
                failOrderEntryIds.put(orderEntryId, WXPurOrderHelper.getErrorBystockId(stockId, auditResult));
            }
        }
        if (!failOrderEntryIds.isEmpty()) {
            for (DynamicObject order : orders.values()) {
                boolean errBoolean = false;
                DynamicObjectCollection entryCol = order.getDynamicObjectCollection("billentry");
                for (int i = 1; i <= entryCol.size(); ++i) {
                    orderEntryId = ((DynamicObject)entryCol.get(i - 1)).getPkValue();
                    String orderEntryStr = (String)failOrderEntryIds.get(orderEntryId);
                    if (!Objects.nonNull(orderEntryStr)) continue;
                    errBoolean = true;
                    errorInfo = WXPurOrderHelper.buildErrMessage(order, orderEntryStr, i);
                }
                if (errBoolean) continue;
                successObjs.add(order);
            }
        } else {
            successObjs.addAll(orders.values());
        }
        return errorInfo;
    }

    private static void setFailMes(OperationResult submitResult, Map<Object, Object> submitStockIdtoOrderEntryIds, Map<Object, String> failOrderEntryIds) {
        HashSet submitSuccessIds = new HashSet(submitResult.getSuccessPkIds());
        for (Map.Entry<Object, Object> stockIdtoOrderEntryId : submitStockIdtoOrderEntryIds.entrySet()) {
            Object stockId = stockIdtoOrderEntryId.getKey();
            Object orderEntryId = stockIdtoOrderEntryId.getValue();
            if (submitSuccessIds.contains(stockId)) continue;
            failOrderEntryIds.put(orderEntryId, WXPurOrderHelper.getErrorBystockId(stockId, submitResult));
        }
    }

    private static String getErrorBystockId(Object stockId, OperationResult submitResult) {
        for (IOperateInfo errInfo : submitResult.getAllErrorOrValidateInfo()) {
            if (!errInfo.getPkValue().toString().equals(stockId.toString())) continue;
            return errInfo.getMessage();
        }
        return "";
    }

    private static OperateErrorInfo buildErrMessage(DynamicObject order, String err, int i) {
        Object pkId = order.getPkValue();
        int dataIndex = 0;
        int rowIndex = i - 1;
        ErrorLevel errorLevel = ErrorLevel.Error;
        String msg = String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u7f16\u53f7%1$s\u7684\u7b2c%2$s\u884c\u5206\u5f55\u7ec4\u4ef6\u6e05\u5355\u81ea\u52a8\u5ba1\u6838\u5931\u8d25:%3$s", (String)"WXPurOrderHelper_3", (String)"scmc-mm-om", (Object[])new Object[0]), order.getString("billno"), i, err);
        return new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "OrderAuditAfterExeOp_auditStock_Fail", "order", msg, errorLevel);
    }

    private static Map<Object, DynamicObject> loadMtfOrders(DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return new HashedMap(0);
        }
        HashedMap orders = new HashedMap(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            orders.put(dataEntity.getPkValue(), dataEntity);
        }
        return orders;
    }

    public static Map<String, Object> queryTransactOut(Object typeId) {
        HashMap<String, Object> typeMap = new HashMap<String, Object>(6);
        Objects.requireNonNull(typeId);
        String algoKey = "queryTransactOut";
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",feedtype");
        sb.append(",isauditstock");
        String sels = sb.toString();
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", typeId)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mpdm_transactout", (String)sels, (QFilter[])qFilters, null, (int)1);){
            if (dataSet.hasNext()) {
                Row next = dataSet.next();
                Arrays.stream(sels.split(",")).forEach(a -> typeMap.put((String)a, next.get(a)));
            }
        }
        return typeMap;
    }

    public static Map<String, Object> queryMaterialPurchaseInfo(Object materialPurchaseInfoID) {
        HashMap<String, Object> materialPurchaseInfoMap = new HashMap<String, Object>(6);
        Objects.requireNonNull(materialPurchaseInfoID);
        String algoKey = "queryMaterialPurchaseInfo";
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",masterid");
        String sels = sb.toString();
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", materialPurchaseInfoID)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_materialpurchaseinfo", (String)sels, (QFilter[])qFilters, null, (int)1);){
            if (dataSet.hasNext()) {
                Row next = dataSet.next();
                Arrays.stream(sels.split(",")).forEach(a -> materialPurchaseInfoMap.put((String)a, next.get(a)));
            }
        }
        return materialPurchaseInfoMap;
    }

    public static Map<String, Object> queryMaterialMftInfo(QFilter filter) {
        HashMap<String, Object> materialMftInfoMap = new HashMap<String, Object>(6);
        String algoKey = "queryMaterialMftInfo";
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",masterid");
        String sels = sb.toString();
        QFilter[] qFilters = new QFilter[]{filter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_materialmftinfo", (String)sels, (QFilter[])qFilters, null, (int)1);){
            if (dataSet.hasNext()) {
                Row next = dataSet.next();
                Arrays.stream(sels.split(",")).forEach(a -> materialMftInfoMap.put((String)a, next.get(a)));
            }
        }
        return materialMftInfoMap;
    }

    public static Map<String, Object> queryMftBOM(List<QFilter> qFilters) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(6);
        StringBuilder selects = new StringBuilder();
        selects.append("id");
        selects.append(",number");
        selects.append(",auxproperty");
        selects.append(",version");
        selects.append(",ecn");
        selects.append(",replaceno");
        String sels = selects.toString();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryMftBOM", (String)"pdm_mftbom", (String)sels, (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), null, (int)1);){
            if (dataSet.hasNext()) {
                Row next = dataSet.next();
                Arrays.stream(sels.split(",")).forEach(a -> dataMap.put((String)a, next.get(a)));
            }
        }
        return dataMap;
    }

    public static Map<String, Object> queryMaterial(Object masterid) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(6);
        QFilter[] qFilters = new QFilter[]{new QFilter("masterid", "=", masterid)};
        StringBuilder selects = new StringBuilder();
        selects.append("id");
        selects.append(",number");
        selects.append(",name");
        String sels = selects.toString();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryMaterial", (String)"bd_material", (String)sels, (QFilter[])qFilters, null, (int)1);){
            if (dataSet.hasNext()) {
                Row next = dataSet.next();
                Arrays.stream(sels.split(",")).forEach(a -> dataMap.put((String)a, next.get(a)));
            }
        }
        return dataMap;
    }

    public static void setBomNameLock(IFormView view, IDataModel model) {
        Object transTypeId = model.getValue("transactiontype");
        Map<String, Object> transMap = WXPurOrderHelper.queryTransactOut(transTypeId);
        Object feedType = transMap.get("feedtype");
        Boolean falg = Boolean.FALSE;
        if (FeedTypeEnum.ZBOM.getCode().equals(feedType)) {
            falg = Boolean.TRUE;
        }
        DynamicObjectCollection billEntry = model.getEntryEntity("billentry");
        if (falg.booleanValue()) {
            for (int i = 0; i < billEntry.size(); ++i) {
                String entryChangeType = ((DynamicObject)billEntry.get(i)).getString("entrychangetype");
                if (ChangeTypeEnum.UPDATE.getCode().equals(entryChangeType)) {
                    view.setEnable(Boolean.FALSE, i, new String[]{"material", "bomname", "entryreqorg", "entryrecorg", "entrysettleorg", "entrypayorg", "discounttype", "deliveraddress", "owner", "project", "expendbomtime", "taxrateid"});
                    view.setEnable(Boolean.TRUE, i, WXPurOrderBillEntryConst.updateStr);
                    continue;
                }
                if (!ChangeTypeEnum.ADDNEW.getCode().equals(entryChangeType)) continue;
                view.setEnable(Boolean.TRUE, i, new String[]{"bomname"});
            }
        } else {
            for (int i = 0; i < billEntry.size(); ++i) {
                view.setEnable(falg, i, new String[]{"bomname"});
            }
        }
        view.updateView("billentry");
    }

    public static boolean isGenBizOp(Object sourceEntryId) {
        QFilter[] qfilter = new QFilter[]{new QFilter("orderentryid", "=", sourceEntryId)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"quertComponentlist", (String)"om_componentlist", (String)"id", (QFilter[])qfilter, null, (int)1);){
            if (dataSet.hasNext()) {
                Row next = dataSet.next();
                Object id = next.get("id");
                boolean bl = BFTrackerServiceHelper.isPush((String)"om_componentlist", (Long)Long.parseLong(id.toString()));
                return bl;
            }
        }
        return false;
    }

    public static boolean isProduceOrWT(Long orgId) {
        List fromOrgs;
        boolean flag = false;
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)orgId)};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"isProduceOrWT", (String)"bos_org", (String)"id,fisproduce", (QFilter[])qFilters, null);){
            Row next;
            if (dataSet.hasNext() && (next = dataSet.next()).getBoolean("fisproduce").booleanValue()) {
                flag = true;
            }
        }
        if (!flag && !(fromOrgs = OrgUnitServiceHelper.getFromOrgs((String)"02", (Long)orgId, null, (boolean)false)).isEmpty()) {
            flag = true;
        }
        return flag;
    }

    public static boolean checkBOMMustInput(Long typeId) {
        boolean bomMust = false;
        if (typeId != null && !"0".equals(typeId.toString())) {
            Map<String, Object> stransMap = WXPurOrderHelper.queryTransactOut(typeId);
            if (FeedTypeEnum.ZBOM.getCode().equals(stransMap.get("feedtype"))) {
                bomMust = true;
            }
        }
        return bomMust;
    }

    public static Set<String> getLocked(Set<String> ids) {
        DynamicObject[] loads;
        HashSet<String> lockIds = new HashSet<String>(16);
        if (ids == null || ids.isEmpty()) {
            return lockIds;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("objectid", "in", ids)};
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)"bos_datalock", (String)"objectid,entitykey.id", (QFilter[])qFilters)) {
            lockIds.add(load.getString("objectid"));
        }
        return lockIds;
    }
}

