/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.common.om.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.pm.common.om.enums.ChangeStatusEnum;

public class WXPurOrderOpHelper {
    public static final String DELETE = "delete";

    public static void updateSrcBillChangeStatus(DynamicObject[] wxPurOrderObjs) {
        ArrayList<DynamicObject> srcBills = new ArrayList<DynamicObject>();
        Set sourceIds = Arrays.stream(wxPurOrderObjs).map(x -> x.getLong("sourceid")).collect(Collectors.toSet());
        Map idMap = BusinessDataServiceHelper.loadFromCache((String)"pm_om_purorderbill", (QFilter[])new QFilter("id", "in", sourceIds).toArray());
        for (int i = 0; i < wxPurOrderObjs.length; ++i) {
            DynamicObject bill = wxPurOrderObjs[i];
            Long srcBillID = bill.getLong("sourceid");
            DynamicObject srcBill = (DynamicObject)idMap.get(srcBillID);
            if (srcBill == null) continue;
            if (null == srcBill.get("changedate") && null == srcBill.get("changer")) {
                srcBill.set("changestatus", (Object)ChangeStatusEnum.UNCHANGE.getCode());
            } else {
                srcBill.set("changestatus", (Object)ChangeStatusEnum.CHANGED.getCode());
            }
            srcBills.add(srcBill);
        }
        if (srcBills.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])srcBills.toArray(new DynamicObject[0]));
        }
    }

    public static void calMaterial(DynamicObject[] purOrderObjs) {
        for (int i = 0; i < purOrderObjs.length; ++i) {
            WXPurOrderOpHelper.calMaterial(purOrderObjs[i]);
        }
    }

    public static void calMaterial(DynamicObject purOrderObj) {
        DispatchServiceHelper.invokeBizService((String)"mmc", (String)"om", (String)"PurOrderCalMaterialUtils", (String)"calMaterial", (Object[])new Object[]{purOrderObj.getDataEntityType().getName(), purOrderObj.getPkValue()});
    }
}

