/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.om;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.JSONUtils;
import org.apache.commons.collections4.CollectionUtils;

public class OutApplyToOutOrderBotpPlugIn
extends AbstractConvertPlugIn {
    private static final Log log = LogFactory.getLog(OutApplyToOutOrderBotpPlugIn.class);

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        super.afterGetSourceData(e);
        Map fldProperties = e.getFldProperties();
        List sourceRows = e.getSourceRows();
        Map variables = this.getOption().getVariables();
        log.info("\u59d4\u5916\u7533\u8bf7\u5355\u4e0b\u63a8\u59d4\u5916\u8ba2\u5355\u7684\u53c2\u6570\u4e3a \uff1a" + variables);
        if (variables != null && "quota".equals(variables.get("isquota"))) {
            HashSet<String> fields = new HashSet<String>(16);
            Map<Long, Map<String, Object>> dataMap = this.parseCustomerVariables(variables, fields);
            for (DynamicObject bill : sourceRows) {
                this.updateEntryInfoFromVar(bill, dataMap, fldProperties);
            }
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] purOrderBill = targetExtDataEntitySet.FindByEntityKey(this.getTgtMainType().toString());
        ArrayList<DynamicObject> dataEntitys = new ArrayList<DynamicObject>(purOrderBill.length);
        for (ExtendedDataEntity purOrder : purOrderBill) {
            DynamicObject dynamicObject = purOrder.getDataEntity();
            dataEntitys.add(dynamicObject);
        }
        Map variables = this.getOption().getVariables();
        if (variables != null && "quota".equals(variables.get("isquota"))) {
            List numbers = CodeRuleServiceHelper.getNumbers((String)this.getTgtMainType().toString(), dataEntitys);
            Date bizTime = null;
            Object obj = variables.get("biztime");
            if (obj != null) {
                String string = (String)variables.get("biztime");
                bizTime = new Date(Long.parseLong(string));
            }
            for (ExtendedDataEntity entity : purOrderBill) {
                String billno;
                DynamicObject bill = entity.getDataEntity();
                DynamicObject org = bill.getDynamicObject("org");
                if (org == null) continue;
                if (bizTime != null) {
                    bill.set("biztime", (Object)bizTime);
                }
                if (StringUtils.isEmpty((CharSequence)(billno = bill.getString("billno"))) || numbers.isEmpty()) {
                    bill.set("billno", (Object)("QUTOGEN_" + System.currentTimeMillis()));
                    continue;
                }
                bill.set("billno", numbers.get(0));
                numbers.remove(0);
            }
        }
        if (!dataEntitys.isEmpty()) {
            Long startdate = System.currentTimeMillis();
            List dynamicObjects = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurOrderService", (String)"batchSetPODefValue", (Object[])new Object[]{dataEntitys});
            Long enddate = System.currentTimeMillis() - startdate;
            log.info("\u8c03\u7528\u59d4\u5916\u8ba2\u5355\u9ed8\u8ba4\u503c\u670d\u52a1\uff08PurOrderService\uff09\u5904\u7406\u9ed8\u8ba4\u503c--------------cost:" + enddate + "ms");
            MainEntityType mainEntityType = (MainEntityType)((DynamicObject)dataEntitys.get(0)).getDataEntityType();
            targetExtDataEntitySet.Parse(dynamicObjects.toArray(new DynamicObject[0]), mainEntityType);
            List<DynamicObject> dynamicObj = this.dealPurOrderhData(dataEntitys);
            dynamicObj.toArray(new DynamicObject[0]);
            targetExtDataEntitySet.Parse(dynamicObjects.toArray(new DynamicObject[0]), mainEntityType);
            e.setTargetExtDataEntitySet(targetExtDataEntitySet);
        }
    }

    private List<DynamicObject> dealPurOrderhData(List<DynamicObject> dataEntitys) {
        Set orgIds = dataEntitys.stream().map(t -> t.getDynamicObjectCollection("billentry")).flatMap(Collection::stream).map(this::getOrgId).filter(Objects::nonNull).collect(Collectors.toSet());
        QFilter id = new QFilter("id", "in", orgIds);
        Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])id.toArray());
        for (DynamicObject dataEntity : dataEntitys) {
            DynamicObjectCollection billentryntry = dataEntity.getDynamicObjectCollection("billentry");
            billentryntry.forEach(t -> this.setEntryValues((DynamicObject)t, orgMap));
        }
        return dataEntitys;
    }

    private Long getOrgId(DynamicObject entryObj) {
        DynamicObject entrySettleOrg = entryObj.getDynamicObject("entrysettleorg");
        OrgRelationParam param = this.buildOrgRelationParam(entrySettleOrg.getLong("id"), "10", "08", "toorg");
        List bizRelationOrgIds = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
        Long res = Long.valueOf("0");
        if (CollectionUtils.isNotEmpty((Collection)bizRelationOrgIds)) {
            res = (Long)bizRelationOrgIds.get(0);
        }
        return res;
    }

    private void setEntryValues(DynamicObject entryObj, Map<Object, DynamicObject> orgMap) {
        DynamicObject entrySettleOrg = entryObj.getDynamicObject("entrysettleorg");
        OrgRelationParam param = this.buildOrgRelationParam(entrySettleOrg.getLong("id"), "10", "08", "toorg");
        List bizRelationOrgIds = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
        if (CollectionUtils.isNotEmpty((Collection)bizRelationOrgIds) && Objects.nonNull(orgMap)) {
            entryObj.set("entrypayorg", (Object)orgMap.get(bizRelationOrgIds.get(0)));
        }
    }

    private void setEntryValues(DynamicObject entryObj) {
        DynamicObject entrySettleOrg = entryObj.getDynamicObject("entrysettleorg");
        OrgRelationParam param = this.buildOrgRelationParam(entrySettleOrg.getLong("id"), "10", "08", "toorg");
        List bizRelationOrgIds = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
        if (CollectionUtils.isNotEmpty((Collection)bizRelationOrgIds)) {
            entryObj.set("entrypayorg", (Object)BusinessDataServiceHelper.loadSingleFromCache(bizRelationOrgIds.get(0), (String)"bos_org", (String)"id"));
        }
    }

    private OrgRelationParam buildOrgRelationParam(Long orgId, String fromViewType, String toViewType, String getDirectOrgType) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(orgId.longValue());
        param.setFromViewType(fromViewType);
        param.setToViewType(toViewType);
        param.setDirectViewType(getDirectOrgType);
        return param;
    }

    private Map<Long, Map<String, Object>> parseCustomerVariables(Map<String, String> variables, Set<String> fields) {
        HashMap<Long, Map<String, Object>> allDataMap = new HashMap<Long, Map<String, Object>>(16);
        variables.remove("isquota");
        variables.remove("biztime");
        try {
            String data = variables.entrySet().iterator().next().getValue();
            HashMap castFields = (HashMap)JSONUtils.cast((String)data, HashMap.class);
            fields.addAll(castFields.keySet());
            Map<String, Class<?>> propMap = this.getFieldsProp(fields);
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                String dataJson = entry.getValue();
                Long billEntryId = Long.valueOf(entry.getKey());
                HashMap dataMap = (HashMap)JSONUtils.cast((String)dataJson, HashMap.class);
                if (dataMap == null) continue;
                for (Map.Entry entry2 : dataMap.entrySet()) {
                    String key = (String)entry2.getKey();
                    Object jsonValue = entry2.getValue();
                    Object value = JSONUtils.cast((String)jsonValue.toString(), propMap.get(key));
                    entry2.setValue(value);
                }
                dataMap.put("billcretype", "10");
                allDataMap.put(billEntryId, dataMap);
            }
        }
        catch (IOException e) {
            log.error(e.fillInStackTrace());
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u65f6JSON\u89e3\u6790\u9519\u8bef\u3002", (String)"QutobotpConvert_0", (String)"scmc-mm-om", (Object[])new Object[0]));
        }
        return allDataMap;
    }

    private Map<String, Class<?>> getFieldsProp(Set<String> fields) {
        BillEntityType srcMainType = this.getSrcMainType();
        HashMap map = new HashMap(fields.size());
        for (String field : fields) {
            IDataEntityProperty property = srcMainType.findProperty(field);
            if (property == null) continue;
            if (property instanceof BasedataProp) {
                map.put(field, Long.class);
                continue;
            }
            if (property instanceof DecimalProp) {
                map.put(field, BigDecimal.class);
                continue;
            }
            if (!(property instanceof BooleanProp)) continue;
            map.put(field, Boolean.class);
        }
        return map;
    }

    private void updateEntryInfoFromVar(DynamicObject bill, Map<Long, Map<String, Object>> dataMap, Map<String, DynamicProperty> fldProperties) {
        Long entryId = (Long)bill.get((IDataEntityProperty)fldProperties.get("billentry.id"));
        BigDecimal joinQty = (BigDecimal)bill.get((IDataEntityProperty)fldProperties.get("joinqty"));
        BigDecimal joinBaseQty = (BigDecimal)bill.get((IDataEntityProperty)fldProperties.get("joinbaseqty"));
        Map<String, Object> map = dataMap.get(entryId);
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                DynamicProperty dynamicProperty = fldProperties.get(key);
                if (dynamicProperty == null) continue;
                String name = dynamicProperty.getName();
                if (key.equals("qty")) {
                    BigDecimal resultQty = joinQty.add((BigDecimal)value);
                    bill.set(name, (Object)resultQty);
                    continue;
                }
                if (key.equals("baseqty")) {
                    BigDecimal resultBaseQty = joinBaseQty.add((BigDecimal)value);
                    bill.set(name, (Object)resultBaseQty);
                    continue;
                }
                bill.set(name, value);
            }
        }
    }
}

