/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.om;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.EntityOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.pm.business.helper.MetaDataHelper;
import kd.scmc.pm.common.om.enums.ChangeTypeEnum;
import kd.scmc.pm.common.om.helper.WXPurOrderHelper;

public class WXPurOrderBillPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
ClickListener,
EntryGridBindDataListener {
    public static final String BTN_CHANGEORG = "changeorg";
    public static final String BTN_CHANGESUPPLIER = "changesupplier";
    public static final String BTN_MODIFY_ENTRY = "modify_entry";
    public static final String BTN_MODIFY_PAY = "modify_pay";
    public static final String BTN_MODIFY_DELIVER = "modify_deliver";
    public static final String BTN_DELETEROW_ENTRY = "deleterow";
    public static final String BTN_DELETEROW_PAY = "deleterow_pay";
    public static final String BTN_DELETEROW_DELIVER = "deleterow_deliver";
    public static final String BTN_SEELOG = "seelog";
    private final BigDecimal ZERO = BigDecimal.ZERO;
    private String[] xpurfields = new String[]{"biztime", "reason", "comment", "provideraddress", "providerlinkman", "operator", "dept", "linkman", "address"};
    private String[] entryfields = new String[]{"deliverdate", "qty", "auxqty", "price", "taxrate", "priceandtax", "entrycomment", "iscontrolqty", "receiveratedown", "receiverateup"};
    private String[] payEntryfields = new String[]{"payname", "paydate", "payrate", "payamount"};
    private String[] deliverEntryfields = new String[]{"plandeliverdate", "planqty", "plancomment"};

    public void registerListener(EventObject e) {
        EntryGrid deliverEntryGrid;
        EntryGrid payEntryGrid;
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((payEntryGrid = (EntryGrid)this.getView().getControl("purbillentry_pay")) != null) {
            payEntryGrid.addRowClickListener((RowClickEventListener)this);
        }
        if ((deliverEntryGrid = (EntryGrid)this.getView().getControl("purbillentry_deliver")) != null) {
            deliverEntryGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        this.getView().setEnable(Boolean.FALSE, MetaDataHelper.getAllPropertyNameNoEntry((IDataEntityType)dt));
        this.getView().setEnable(Boolean.TRUE, this.xpurfields);
        String[] billEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"billentry");
        String[] billEntry2 = this.entryfields;
        String[] billEntry3 = this.getDifferentFromString(billEntry1, billEntry2);
        for (RowDataEntity row : e.getRows()) {
            int i = row.getRowIndex() - 1;
            if (ChangeTypeEnum.UPDATE.getCode().equals(this.getModel().getValue("entrychangetype", i))) {
                this.getView().setEnable(Boolean.FALSE, i, billEntry3);
                continue;
            }
            if (!ChangeTypeEnum.CANCEL.getCode().equals(this.getModel().getValue("entrychangetype", i))) continue;
            this.getView().setEnable(Boolean.FALSE, i, billEntry1);
        }
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().clearNoDataRow();
        this.getModel().forceClearNoDataRow();
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        this.getView().setEnable(Boolean.FALSE, MetaDataHelper.getAllPropertyNameNoEntry((IDataEntityType)dt));
        this.getView().setEnable(Boolean.TRUE, this.xpurfields);
        int billEntryCount = this.getModel().getEntryRowCount("billentry");
        String[] billEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"billentry");
        String[] billEntry3 = this.getDifferentFromString(billEntry1, this.entryfields);
        for (int i = 0; i < billEntryCount; ++i) {
            if (ChangeTypeEnum.UPDATE.getCode().equals(this.getModel().getValue("entrychangetype", i))) {
                this.getView().setEnable(Boolean.FALSE, i, billEntry3);
                continue;
            }
            if (!ChangeTypeEnum.CANCEL.getCode().equals(this.getModel().getValue("entrychangetype", i))) continue;
            this.getView().setEnable(Boolean.FALSE, i, billEntry1);
        }
        int payEntryCount = this.getModel().getEntryRowCount("purbillentry_pay");
        String[] payEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"purbillentry_pay");
        String[] payEntry3 = this.getDifferentFromString(payEntry1, this.payEntryfields);
        for (int i = 0; i < payEntryCount; ++i) {
            String changeType = (String)this.getModel().getValue("payentrychangetype", i);
            if (!ChangeTypeEnum.UPDATE.getCode().equals(changeType)) continue;
            this.getView().setEnable(Boolean.FALSE, i, payEntry3);
        }
        int deliverEntryCount = this.getModel().getEntryRowCount("purbillentry_deliver");
        String[] deliverEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"purbillentry_deliver");
        String[] deliverEntry3 = this.getDifferentFromString(deliverEntry1, this.deliverEntryfields);
        for (int i = 0; i < deliverEntryCount; ++i) {
            String changeType = (String)this.getModel().getValue("delentrychangetype", i);
            if (!ChangeTypeEnum.UPDATE.getCode().equals(changeType)) continue;
            this.getView().setEnable(Boolean.FALSE, i, deliverEntry3);
        }
        this.getView().setVisible(Boolean.FALSE, this.getUnVisibleField());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getSource() instanceof EntityOperate) {
            if ("unaudit".equals(((EntityOperate)afterDoOperationEventArgs.getSource()).getOperateKey())) {
                this.getView().updateView();
            }
            if ("changedetail".equals(((EntityOperate)afterDoOperationEventArgs.getSource()).getOperateKey())) {
                IDataModel bill = this.getModel();
                Long sourceID = (Long)bill.getValue("sourceid");
                String version = (String)bill.getValue("version");
                QFilter qFilter1 = new QFilter("srcbillid", "=", (Object)sourceID);
                QFilter qFilter2 = new QFilter("xbillid", "=", bill.getValue("id"));
                QFilter qFilter3 = new QFilter("srcbillversion", "=", (Object)version);
                DynamicObject xPurOrderBillLog = BusinessDataServiceHelper.loadSingleFromCache((String)"pm_xpurorderbilllog", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
                if (xPurOrderBillLog == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53d8\u66f4\u65e5\u5fd7", (String)"WXPurOrderBillPlugin_2", (String)"scmc-mm-om", (Object[])new Object[0]));
                    return;
                }
                String xMDJson = (String)xPurOrderBillLog.get("xmdjson_tag");
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("pm_mdlogshow");
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCaption("");
                fsp.setCustomParam("mdlog", (Object)xMDJson);
                this.getView().showForm(fsp);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof EntityOperate) {
            IDataModel model = this.getModel();
            IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
            if (BTN_MODIFY_ENTRY.equals(((EntityOperate)args.getSource()).getOperateKey())) {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
                int[] rows = entryGrid.getSelectRows();
                BigDecimal totalAmount = (BigDecimal)model.getValue("totalamount");
                BigDecimal totalTaxAmount = (BigDecimal)model.getValue("totaltaxamount");
                BigDecimal totalAllAmount = (BigDecimal)model.getValue("totalallamount");
                IPageCache pageCache = this.getPageCache();
                String deleteAmountCache = pageCache.get("deleteamount");
                String deleteTaxAmountCache = pageCache.get("deletetaxamount");
                String deleteAllAmountCache = pageCache.get("deleteallamount");
                if (StringUtils.isNotBlank((CharSequence)deleteAmountCache) && StringUtils.isNotBlank((CharSequence)deleteTaxAmountCache) && StringUtils.isNotBlank((CharSequence)deleteAllAmountCache)) {
                    totalAmount = totalAmount.add(new BigDecimal(deleteAmountCache));
                    totalTaxAmount = totalTaxAmount.add(new BigDecimal(deleteTaxAmountCache));
                    totalAllAmount = totalAllAmount.add(new BigDecimal(deleteAllAmountCache));
                    model.setValue("totalamount", (Object)totalAmount);
                    model.setValue("totaltaxamount", (Object)totalTaxAmount);
                    model.setValue("totalallamount", (Object)totalAllAmount);
                }
                pageCache.remove("deleteamount");
                pageCache.remove("deletetaxamount");
                pageCache.remove("deleteallamount");
                for (int i = 0; i < rows.length; ++i) {
                    Object eType = model.getValue("entrychangetype", rows[i]);
                    if (!ChangeTypeEnum.CANCEL.getCode().equals(eType)) continue;
                    model.setValue("entrychangetype", (Object)ChangeTypeEnum.UPDATE.getCode(), rows[i]);
                }
                String[] billEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"billentry");
                String[] billEntry3 = this.getDifferentFromString(billEntry1, this.entryfields);
                for (int i = 0; i < rows.length; ++i) {
                    Object eType = model.getValue("entrychangetype", rows[i]);
                    if (!ChangeTypeEnum.UPDATE.getCode().equals(eType)) continue;
                    this.getView().setEnable(Boolean.FALSE, rows[i], billEntry3);
                    this.getView().setEnable(Boolean.TRUE, rows[i], this.entryfields);
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETEROW_ENTRY});
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_ENTRY});
            } else if (BTN_MODIFY_PAY.equals(((EntityOperate)args.getSource()).getOperateKey())) {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("purbillentry_pay");
                int[] rows = entryGrid.getSelectRows();
                for (int i = 0; i < rows.length; ++i) {
                    model.setValue("payentrychangetype", (Object)ChangeTypeEnum.UPDATE.getCode(), rows[i]);
                }
                String[] payEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"purbillentry_pay");
                String[] payEntry3 = this.getDifferentFromString(payEntry1, this.payEntryfields);
                for (int i = 0; i < rows.length; ++i) {
                    this.getView().setEnable(Boolean.FALSE, rows[i], payEntry3);
                    this.getView().setEnable(Boolean.TRUE, rows[i], this.payEntryfields);
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETEROW_PAY});
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_PAY});
            } else if (BTN_MODIFY_DELIVER.equals(((EntityOperate)args.getSource()).getOperateKey())) {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("purbillentry_deliver");
                int[] rows = entryGrid.getSelectRows();
                for (int i = 0; i < rows.length; ++i) {
                    model.setValue("delentrychangetype", (Object)ChangeTypeEnum.UPDATE.getCode(), rows[i]);
                }
                String[] deliverEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"purbillentry_deliver");
                String[] deliverEntry3 = this.getDifferentFromString(deliverEntry1, this.deliverEntryfields);
                for (int i = 0; i < rows.length; ++i) {
                    this.getView().setEnable(Boolean.FALSE, rows[i], deliverEntry3);
                    this.getView().setEnable(Boolean.TRUE, rows[i], this.deliverEntryfields);
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETEROW_DELIVER});
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_DELIVER});
            }
        }
        super.beforeDoOperation(args);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        IDataModel bill = this.getModel();
        String entryName = e.getEntryProp().getName();
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        int[] rows = e.getRowIndexs();
        if (rows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"WXPurOrderBillPlugin_1", (String)"scmc-mm-om", (Object[])new Object[0]));
            e.setCancel(true);
        }
        int rowIndex = e.getRowIndexs()[0];
        if ("billentry".equals(entryName)) {
            if (ChangeTypeEnum.UPDATE.getCode().equals(bill.getValue("entrychangetype", rowIndex))) {
                if (((BigDecimal)this.getModel().getValue("receivebaseqty", rowIndex)).doubleValue() > 0.0 || ((BigDecimal)this.getModel().getValue("invbaseqty", rowIndex)).doubleValue() > 0.0 || ((BigDecimal)this.getModel().getValue("payablepriceqty", rowIndex)).doubleValue() > 0.0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u660e\u7ec6\u5df2\u53d1\u751f\u4e1a\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"WXPurOrderBillPlugin_3", (String)"scmc-mm-om", (Object[])new Object[0]), rowIndex + 1));
                } else if (WXPurOrderHelper.isGenBizOp(this.getModel().getValue("sourceentryid", rowIndex))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u660e\u7ec6\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355\u5df2\u751f\u6210\u4e0b\u6e38\u5355\u636e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"WXPurOrderBillPlugin_0", (String)"scmc-mm-om", (Object[])new Object[0]), rowIndex + 1));
                } else {
                    BigDecimal deleteAmount = this.ZERO;
                    BigDecimal deleteTaxAmount = this.ZERO;
                    BigDecimal deleteAllAmount = this.ZERO;
                    bill.setValue("entrychangetype", (Object)ChangeTypeEnum.CANCEL.getCode(), rowIndex);
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_ENTRY});
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_MODIFY_ENTRY});
                    String[] billEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"billentry");
                    for (int i = 0; i < rows.length; ++i) {
                        this.getView().setEnable(Boolean.FALSE, rows[i], billEntry1);
                        deleteAmount = deleteAmount.add((BigDecimal)bill.getValue("amount", rows[i]));
                        deleteTaxAmount = deleteTaxAmount.add((BigDecimal)bill.getValue("taxamount", rows[i]));
                        deleteAllAmount = deleteAllAmount.add((BigDecimal)bill.getValue("amountandtax", rows[i]));
                    }
                    IPageCache pageCache = this.getPageCache();
                    pageCache.put("deleteamount", deleteAmount.toString());
                    pageCache.put("deletetaxamount", deleteTaxAmount.toString());
                    pageCache.put("deleteallamount", deleteAllAmount.toString());
                }
                e.setCancel(true);
            } else if (ChangeTypeEnum.ADDNEW.getCode().equals(bill.getValue("entrychangetype", rowIndex))) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"entrychangetype"});
            } else {
                e.setCancel(true);
            }
        } else if ("purbillentry_pay".equals(entryName)) {
            if (ChangeTypeEnum.UPDATE.getCode().equals(bill.getValue("payentrychangetype", rowIndex))) {
                if (((BigDecimal)this.getModel().getValue("paidamount", rowIndex)).doubleValue() > 0.0) {
                    bill.setValue("payentrychangetype", (Object)ChangeTypeEnum.UPDATE.getCode(), rowIndex);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4ed8\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u4e1a\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"WXPurOrderBillPlugin_4", (String)"scmc-mm-om", (Object[])new Object[0]), rowIndex + 1));
                } else {
                    bill.setValue("payentrychangetype", (Object)ChangeTypeEnum.CANCEL.getCode(), rowIndex);
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"payentrychangetype"});
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_PAY});
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_MODIFY_PAY});
                    String[] payEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"purbillentry_pay");
                    for (int i = 0; i < rows.length; ++i) {
                        this.getView().setEnable(Boolean.FALSE, rows[i], payEntry1);
                    }
                }
                e.setCancel(true);
            } else if (ChangeTypeEnum.ADDNEW.getCode().equals(bill.getValue("payentrychangetype", rowIndex))) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"payentrychangetype"});
            } else {
                e.setCancel(true);
            }
        } else if ("purbillentry_deliver".equals(entryName)) {
            if (ChangeTypeEnum.UPDATE.getCode().equals(bill.getValue("delentrychangetype", rowIndex))) {
                bill.setValue("delentrychangetype", (Object)ChangeTypeEnum.CANCEL.getCode(), rowIndex);
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"delentrychangetype"});
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_DELIVER});
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_MODIFY_DELIVER});
                String[] deliverEntry1 = MetaDataHelper.getAllPropertyName4Entry((IDataEntityType)dt, (String)"purbillentry_deliver");
                for (int i = 0; i < rows.length; ++i) {
                    this.getView().setEnable(Boolean.FALSE, rows[i], deliverEntry1);
                }
                e.setCancel(true);
            } else if (ChangeTypeEnum.ADDNEW.getCode().equals(bill.getValue("delentrychangetype", rowIndex))) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"delentrychangetype"});
            } else {
                e.setCancel(true);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        IDataModel bill = this.getModel();
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rows = e.getRowDataEntities();
        if ("billentry".equals(entryName)) {
            for (RowDataEntity row : rows) {
                DynamicObject orgObj;
                int rowIndex = row.getRowIndex();
                bill.setValue("entrychangetype", (Object)ChangeTypeEnum.ADDNEW.getCode(), rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"entrychangetype"});
                Object org = bill.getValue("org");
                if (!(org instanceof DynamicObject) || WXPurOrderHelper.isProduceOrWT((orgObj = (DynamicObject)org).getLong("id"))) continue;
                bill.setValue("entryreqorg", null, rowIndex);
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_ENTRY});
        } else if ("purbillentry_pay".equals(entryName)) {
            for (RowDataEntity row : rows) {
                bill.setValue("payentrychangetype", (Object)ChangeTypeEnum.ADDNEW.getCode(), row.getRowIndex());
                this.getView().setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"payentrychangetype"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_PAY});
        } else if ("purbillentry_deliver".equals(entryName)) {
            for (RowDataEntity row : rows) {
                bill.setValue("delentrychangetype", (Object)ChangeTypeEnum.ADDNEW.getCode(), row.getRowIndex());
                this.getView().setEnable(Boolean.FALSE, row.getRowIndex(), new String[]{"delentrychangetype"});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_DELIVER});
        }
    }

    private String[] getDifferentFromString(String[] s1, String[] s2) {
        HashSet<String> hs1 = new HashSet<String>(Arrays.asList(s1));
        HashSet<String> hs2 = new HashSet<String>(Arrays.asList(s2));
        hs1.removeAll(hs2);
        return hs1.toArray(new String[0]);
    }

    private String[] getUnVisibleField() {
        String[] fields = new String[]{};
        return fields;
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int row = evt.getRow();
        if (evt.getSource() instanceof EntryGrid && row != -1) {
            String key = ((EntryGrid)evt.getSource()).getKey();
            if ("billentry".equals(key)) {
                String changeType = (String)this.getModel().getValue("entrychangetype", row);
                if (ChangeTypeEnum.CANCEL.getCode().equals(changeType)) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_MODIFY_ENTRY});
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_ENTRY});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_ENTRY});
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETEROW_ENTRY});
                }
            } else if ("purbillentry_pay".equals(key)) {
                String changeType = (String)this.getModel().getValue("payentrychangetype", row);
                if (ChangeTypeEnum.CANCEL.getCode().equals(changeType)) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_MODIFY_PAY});
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_PAY});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_PAY});
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETEROW_PAY});
                }
            } else if ("purbillentry_deliver".equals(key)) {
                String changeType = (String)this.getModel().getValue("delentrychangetype", row);
                if (ChangeTypeEnum.CANCEL.getCode().equals(changeType)) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_MODIFY_DELIVER});
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DELETEROW_DELIVER});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{BTN_MODIFY_DELIVER});
                    this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DELETEROW_DELIVER});
                }
            }
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        super.entryRowDoubleClick(evt);
    }
}

