/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.om;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.pm.common.om.enums.FeedTypeEnum;
import kd.scmc.pm.common.om.helper.OrderSelectLotMain;
import kd.scmc.pm.common.om.helper.WXPurOrderHelper;

public class WXPurOrderEdit
extends AbstractBillPlugIn
implements ClickListener,
RowClickEventListener,
BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final Log logger = LogFactory.getLog(WXPurOrderEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bomname"});
        BasedataEdit configuredcode = (BasedataEdit)this.getView().getControl("configuredcode");
        if (configuredcode != null) {
            configuredcode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"batchno"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void click(EventObject evt) {
        String key;
        Control sourceField = (Control)evt.getSource();
        switch (key = sourceField.getKey()) {
            case "bomname": {
                WXPurOrderHelper.showBomList(this, this.getView(), this.getModel(), "bomname");
                break;
            }
            case "batchno": {
                OrderSelectLotMain.showPageLotMainfileList((IFormPlugin)this, this.getView(), this.getModel(), "billentry");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        final ChangeData cd = e.getChangeSet()[0];
        switch (propertyName) {
            case "bomname": {
                this.bomNameChanged(e, view, model);
                WXPurOrderHelper.setBomNameLock(view, model);
                break;
            }
            case "material": {
                this.materialChanged(e, view, model);
                WXPurOrderHelper.setBomNameLock(view, model);
                Map<Integer, Boolean> rowBatchEnable = this.setBatchNoEnable((List<Integer>)new ArrayList<Integer>(){
                    {
                        this.add(cd.getRowIndex());
                    }
                });
                this.setBatchEnable(rowBatchEnable);
                break;
            }
            case "batchno": {
                this.batchNoChanged(e, view, model);
                break;
            }
            case "entryrecorg": {
                Map<Integer, Boolean> rowBatchEnable1 = this.setBatchNoEnable((List<Integer>)new ArrayList<Integer>(){
                    {
                        this.add(cd.getRowIndex());
                    }
                });
                this.setBatchEnable(rowBatchEnable1);
                break;
            }
            case "configuredcode": {
                this.propChangeConfiguredCode(cd);
                break;
            }
        }
    }

    private void propChangeConfiguredCode(ChangeData cd) {
        int rowIndex = cd.getRowIndex();
        if (rowIndex < 0) {
            return;
        }
        WXPurOrderHelper.cleanEntryData(this.getView(), this.getModel(), rowIndex);
        this.getView().updateView("billentry", rowIndex);
    }

    private void batchNoChanged(PropertyChangedArgs e, IFormView view, IDataModel model) {
        ChangeData cd = e.getChangeSet()[0];
        int rowIndex = cd.getRowIndex();
        DynamicObject dynamicObject = model.getEntryRowEntity("billentry", rowIndex);
        String lotnumber = dynamicObject.getString("batchno");
        if (lotnumber != null) {
            lotnumber = lotnumber.replaceAll("\u3000", "").trim();
            model.setValue("batchno", (Object)lotnumber, rowIndex);
        }
        model.setValue("lot", null, rowIndex);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control con = (Control)evt.getSource();
        String source = con.getKey();
        if ("configuredcode".equals(source)) {
            this.configuredCodeBeforeF7Select(evt);
        }
    }

    private void configuredCodeBeforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        if (material == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7269\u6599\u7f16\u7801\u3002", (String)"WXPurOrderEdit_3", (String)"scmc-mm-om", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Long materialId = material.getDynamicObject("masterid").getLong("id");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("material.id", "=", (Object)materialId));
    }

    private void materialChanged(PropertyChangedArgs e, IFormView view, IDataModel model) {
        ChangeData cd = e.getChangeSet()[0];
        Object newValue1 = cd.getNewValue();
        int rowIndex = cd.getRowIndex();
        if (newValue1 instanceof DynamicObject) {
            Object transTypeId = model.getValue("transactiontype");
            if (Objects.isNull(transTypeId)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u59d4\u5916\u4e8b\u52a1\u7c7b\u578b\u201d\u3002", (String)"WXPurOrderEdit_4", (String)"scmc-mm-om", (Object[])new Object[0]));
                return;
            }
            Map<String, Object> transMap = WXPurOrderHelper.queryTransactOut(transTypeId);
            Object feedType = transMap.get("feedtype");
            if (FeedTypeEnum.ZBOM.getCode().equals(feedType)) {
                DynamicObject material = (DynamicObject)newValue1;
                Object entryReqOrg = model.getValue("entryreqorg", rowIndex);
                Long entryReqOrgId = Long.valueOf("0");
                if (entryReqOrg instanceof DynamicObject) {
                    entryReqOrgId = ((DynamicObject)entryReqOrg).getLong("id");
                }
                Map<String, Object> materialPurMap = WXPurOrderHelper.queryMaterialPurchaseInfo(material.get("id"));
                Object masterId = materialPurMap.get("masterid");
                Map<String, Object> materialMap = WXPurOrderHelper.queryMaterial(masterId);
                QFilter filter = new QFilter("masterId", "=", masterId);
                filter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)entryReqOrgId));
                filter.and(new QFilter("status", "=", (Object)"C"));
                filter.and(new QFilter("enable", "=", (Object)"1"));
                Map<String, Object> materialMftMap = WXPurOrderHelper.queryMaterialMftInfo(filter);
                if (materialMftMap.isEmpty()) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599%s\u672a\u5339\u914d\u5230\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"WXPurOrderEdit_5", (String)"scmc-mm-om", (Object[])new Object[0]), materialMap.get("number")));
                    return;
                }
                List<QFilter> qFilters = WXPurOrderHelper.getQFilters(view, model, "pdm_mftbom", rowIndex, masterId);
                if (qFilters == null) {
                    return;
                }
                Map<String, Object> mftBOMMap = WXPurOrderHelper.queryMftBOM(qFilters);
                if (!mftBOMMap.isEmpty()) {
                    model.setValue("bomname", mftBOMMap.get("number"), rowIndex);
                    model.setValue("bomid", mftBOMMap.get("id"), rowIndex);
                } else {
                    model.setValue("bomname", null, rowIndex);
                    model.setValue("bomid", null, rowIndex);
                }
            }
        }
    }

    private void bomNameChanged(PropertyChangedArgs e, IFormView view, IDataModel model) {
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        int selectEntryRowIndex = changeSet.getRowIndex();
        if (Objects.isNull(newValue) || StringUtils.isEmpty((CharSequence)newValue.toString())) {
            WXPurOrderHelper.cleanEntryData(view, model, selectEntryRowIndex);
            return;
        }
        Map<String, Object> mftbomData = WXPurOrderHelper.queryMftbomData(newValue);
        if (mftbomData.isEmpty()) {
            WXPurOrderHelper.cleanEntryData(view, model, selectEntryRowIndex);
            view.showTipNotification(String.format(ResManager.loadKDString((String)"BOM\u7f16\u7801\u201c%1$s\u201d\u672a\u627e\u5230\u3002", (String)"WXPurOrderEdit_0", (String)"scmc-mm-om", (Object[])new Object[0]), newValue));
        } else {
            WXPurOrderHelper.setEntryData(view, model, mftbomData, selectEntryRowIndex);
        }
        view.updateView("billentry", selectEntryRowIndex);
    }

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        WXPurOrderHelper.setBomNameLock(view, model);
        DynamicObjectCollection entryCol = this.getModel().getEntryEntity("billentry");
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>(16);
        for (int i = 0; i < entryCol.size(); ++i) {
            rowIndexs.add(i);
        }
        Map<Integer, Boolean> rowBatchEnable = this.setBatchNoEnable(rowIndexs);
        this.setBatchEnable(rowBatchEnable);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List rows = e.getRows();
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>(16);
        for (RowDataEntity row : rows) {
            int rowIndex = row.getRowIndex();
            rowIndexs.add(rowIndex);
        }
        Map<Integer, Boolean> rowBatchEnable = this.setBatchNoEnable(rowIndexs);
        this.setBatchEnable(rowBatchEnable);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionKey = e.getActionId();
        Object returnData = e.getReturnData();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        switch (actionKey) {
            case "bomname": {
                if (!Objects.nonNull(returnData)) break;
                int selectEntryRowIndex = WXPurOrderHelper.getSelectEntryRowIndex(this.getView());
                Map<String, Object> selectData = WXPurOrderHelper.getSelectData(this.getView(), this.getModel(), returnData);
                WXPurOrderHelper.setEntryData(view, model, selectData, selectEntryRowIndex);
                WXPurOrderHelper.setBomNameLock(view, model);
                view.updateView("billentry", selectEntryRowIndex);
                break;
            }
            case "pm_om_selectlot": {
                if (!(returnData instanceof Map)) break;
                int rowIndex = model.getEntryCurrentRowIndex("billentry");
                Map lotAttr = (Map)returnData;
                model.setValue("batchno", lotAttr.get("lotnumber"), rowIndex);
                model.setItemValueByID("lot", lotAttr.get("lotid"), rowIndex);
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if (Objects.equals(entryName, "billentry")) {
            RowDataEntity[] rows = e.getRowDataEntities();
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            Object transTypeId = model.getValue("transactiontype");
            Map<String, Object> transMap = WXPurOrderHelper.queryTransactOut(transTypeId);
            Object feedType = transMap.get("feedtype");
            Boolean flag = Boolean.FALSE;
            if (FeedTypeEnum.ZBOM.getCode().equals(feedType)) {
                flag = Boolean.TRUE;
            }
            view.updateView("billentry");
            for (RowDataEntity row : rows) {
                int rowIndex = row.getRowIndex();
                if (flag.booleanValue()) {
                    view.setEnable(Boolean.TRUE, rowIndex, new String[]{"bomname"});
                    continue;
                }
                view.setEnable(flag, rowIndex, new String[]{"bomname"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if (StringUtils.equals((CharSequence)"genlotnum", (CharSequence)operateKey) && this.isSaveBill()) {
            this.afterDoGenLotNum();
        }
    }

    private boolean isSaveBill() {
        DynamicObject bill = this.getView().getModel().getDataEntity(true);
        boolean isFromDataBase = bill.getDataEntityState().getFromDatabase();
        Object pkValue = bill.getPkValue();
        if (pkValue == null || pkValue.equals(0L) || !isFromDataBase) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u672a\u4fdd\u5b58\uff0c\u65e0\u6cd5\u751f\u6210\u6279\u53f7\u3002", (String)"WXPurOrderEdit_6", (String)"scmc-mm-om", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void afterDoGenLotNum() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("entryfield", "billentry");
        paramMap.put("material", "material");
        paramMap.put("lotmap", "batchno");
        long begin = System.currentTimeMillis();
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"LotCodeRuleService", (String)"getLotCode", (Object[])new Object[]{dataEntity, paramMap});
        long end = System.currentTimeMillis();
        logger.info("\u83b7\u53d6\u6279\u53f7\u603b\u65f6\u95f4\uff1a" + (end - begin) + "ms");
        String lotKey = (String)paramMap.get("lotmap");
        StringBuilder sb = new StringBuilder();
        this.getView().getModel().beginInit();
        ArrayList<Integer> index = new ArrayList<Integer>(12);
        for (Map.Entry entry : map.entrySet()) {
            Integer seq = (Integer)entry.getKey();
            String value = (String)entry.getValue();
            if (value.startsWith("ERROR")) {
                sb.append(value.substring("ERROR".length()));
                sb.append('\n');
                continue;
            }
            this.getView().getModel().setValue(lotKey, (Object)value, seq - 1);
            index.add(seq - 1);
        }
        this.getView().getModel().endInit();
        index.forEach(p -> this.getView().updateView(lotKey, p.intValue()));
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u6279\u53f7\u5f02\u5e38", (String)"WXPurOrderEdit_7", (String)"scmc-mm-om", (Object[])new Object[0]), sb.toString(), MessageTypes.Commit);
        } else {
            this.handleLotMainFile();
        }
    }

    private void handleLotMainFile() {
        DynamicObject bill = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("billentry");
        String lotidField = "billentry.lot";
        String lotnumber = "batchno";
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"saveLotMainFileByBillOperate", (Object[])new Object[]{"genlotnum", bill, entryEntity, lotidField});
        StringBuilder sb = new StringBuilder();
        Set entrySet = result.entrySet();
        String[] paramNodes = lotidField.split("\\.");
        String lotIDKey = paramNodes.length > 1 ? paramNodes[paramNodes.length - 1] : lotidField;
        for (Map.Entry entry : entrySet) {
            Integer seq = (Integer)entry.getKey();
            String msg = (String)entry.getValue();
            if (msg.startsWith("ERROR")) {
                if (msg.startsWith("ERRORLOTNUMBERCLEAR")) {
                    sb.append(msg.substring("ERRORLOTNUMBERCLEAR".length())).append('\n');
                    this.getView().getModel().setValue(lotnumber, (Object)"", seq - 1);
                    continue;
                }
                sb.append(msg.substring("ERROR".length())).append('\n');
                continue;
            }
            this.getView().getModel().setValue(lotIDKey, (Object)msg, seq - 1);
        }
        this.getView().getModel().endInit();
        this.getView().updateView(entryEntity.getDynamicObjectType().getName());
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u201c\u6279\u53f7\u4e3b\u6863\u201d\u751f\u6210\u5f02\u5e38\u3002", (String)"WXPurOrderEdit_8", (String)"scmc-mm-om", (Object[])new Object[0]), sb.toString(), MessageTypes.Commit);
        }
    }

    private Map<Integer, Boolean> setBatchNoEnable(List<Integer> rowIndexs) {
        HashMap<Integer, Boolean> res = new HashMap<Integer, Boolean>(16);
        HashSet<String> orgIds = new HashSet<String>();
        HashSet<Object> materials = new HashSet<Object>();
        for (Integer rowIndex : rowIndexs) {
            Object materialObj = this.getModel().getValue("material", rowIndex.intValue());
            Object entryRecOrg = this.getModel().getValue("entryrecorg", rowIndex.intValue());
            if (!Objects.nonNull(entryRecOrg) || !Objects.nonNull(materialObj)) continue;
            if (entryRecOrg instanceof DynamicObject) {
                entryRecOrg = ((DynamicObject)entryRecOrg).getPkValue();
            }
            orgIds.add(String.valueOf(entryRecOrg));
            if (!(materialObj instanceof DynamicObject)) continue;
            materialObj = ((DynamicObject)materialObj).getDynamicObject("masterId").getPkValue();
            materials.add(materialObj);
        }
        Map<Long, String> masterIdMap = this.queryMaterialMap(materials);
        Map<Long, List<Long>> orgMaterialMap = this.queryOrgMaterialMap(orgIds);
        for (Integer rowIndex : rowIndexs) {
            Object materialObj = this.getModel().getValue("material", rowIndex.intValue());
            Object entryRecOrg = this.getModel().getValue("entryrecorg", rowIndex.intValue());
            Boolean flag = Boolean.FALSE;
            if (Objects.nonNull(materialObj) && Objects.nonNull(entryRecOrg)) {
                if (materialObj instanceof DynamicObject) {
                    materialObj = ((DynamicObject)materialObj).getDynamicObject("masterId").getPkValue();
                }
                if (masterIdMap.containsKey(materialObj)) {
                    if (entryRecOrg instanceof DynamicObject) {
                        entryRecOrg = ((DynamicObject)entryRecOrg).getPkValue();
                    }
                    if (orgMaterialMap.containsKey(entryRecOrg)) {
                        String[] split;
                        List<Long> ids = orgMaterialMap.get(entryRecOrg);
                        String s = masterIdMap.get(materialObj);
                        DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex.intValue());
                        if (s.contains("@") && (Objects.equals((split = s.split("@"))[1], "5") || ids.contains(material.getPkValue()))) {
                            flag = Boolean.TRUE;
                        }
                    }
                }
            }
            res.put(rowIndex, flag);
        }
        return res;
    }

    private Map<Long, String> queryMaterialMap(Set<Object> materials) {
        QFilter qFilter = new QFilter("masterId", "in", materials);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enablelot", "=", (Object)Boolean.TRUE));
        HashMap<Long, String> masterIdMap = new HashMap<Long, String>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "#setBatchNoEnable478"), (String)"bd_materialinventoryinfo", (String)"id,masterId,ctrlstrategy", (QFilter[])qFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                Long masterId = next.getLong("masterId");
                Long id = next.getLong("id");
                Object ctrlstrategy = next.get("ctrlstrategy");
                masterIdMap.put(masterId, id + "@" + ctrlstrategy);
            }
        }
        return masterIdMap;
    }

    private Map<Long, List<Long>> queryOrgMaterialMap(Set<String> orgIds) {
        HashMap<Long, List<Long>> res = new HashMap<Long, List<Long>>();
        if (Objects.isNull(orgIds) || orgIds.isEmpty()) {
            return res;
        }
        String join = orgIds.stream().collect(Collectors.joining(","));
        String sql = "select fuseorgid,fdataid from t_bd_materialinvinfo_u where fuseorgid in (" + join + ")";
        try (DataSet dataSet = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "setBatchNoEnable"), (DBRoute)DBRoute.of((String)"sys"), (String)sql);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                Long fuseorgid = next.getLong("fuseorgid");
                Long fdataid = next.getLong("fdataid");
                if (res.containsKey(fuseorgid)) {
                    ((List)res.get(fuseorgid)).add(fdataid);
                    continue;
                }
                ArrayList<Long> tempt = new ArrayList<Long>();
                tempt.add(fdataid);
                res.put(fuseorgid, tempt);
            }
        }
        return res;
    }

    private void setBatchNoEnable(int rowIndex) {
        Object materialObj = this.getModel().getValue("material", rowIndex);
        Object entryRecOrg = this.getModel().getValue("entryrecorg", rowIndex);
        if (materialObj == null || entryRecOrg == null) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"batchno"});
            this.getModel().setValue("batchno", null, rowIndex);
            return;
        }
        DynamicObject material = (DynamicObject)materialObj;
        DynamicObject recOrg = (DynamicObject)entryRecOrg;
        DynamicObject masterId = material.getDynamicObject("masterId");
        QFilter masterQf = new QFilter("masterId", "=", masterId.getPkValue());
        QFilter statusQf = new QFilter("status", "=", (Object)"C");
        QFilter orgQf = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)recOrg.getLong("id"));
        statusQf.and(orgQf);
        QFilter[] filters = new QFilter[]{masterQf, statusQf};
        DynamicObject materialInvInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialinventoryinfo", (String)"id,enablelot", (QFilter[])filters);
        if (materialInvInfo != null) {
            boolean flag = materialInvInfo.getBoolean("enablelot");
            this.getView().setEnable(Boolean.valueOf(flag), rowIndex, new String[]{"batchno"});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"batchno"});
            this.getModel().setValue("batchno", null, rowIndex);
        }
    }

    private void setBatchEnable(Map<Integer, Boolean> rowBatchEnable) {
        for (Map.Entry<Integer, Boolean> entry : rowBatchEnable.entrySet()) {
            Integer key = entry.getKey();
            Boolean value = entry.getValue();
            if (Objects.isNull(value)) continue;
            if (Boolean.TRUE.equals(value)) {
                this.getView().setEnable(Boolean.TRUE, key.intValue(), new String[]{"batchno"});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, key.intValue(), new String[]{"batchno"});
            this.getModel().setValue("batchno", null, key.intValue());
        }
    }
}

