/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.om.writeback;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.pm.formplugin.om.writeback.OmPurOrderManFetchBackWrite;

public class OutApplyManFetchBackWrite
extends AbstractWriteBackPlugIn {
    private static final Log logger = LogFactory.getLog(OmPurOrderManFetchBackWrite.class);

    public void preparePropertys(PreparePropertysEventArgs e) {
        super.preparePropertys(e);
        e.getFieldKeys().add("workproplanid");
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        if ("sfc_manftech".equals(e.getSrcSubMainType().getName())) {
            DynamicObject[] srcDataEntities = e.getSrcDataEntities();
            Set ids = Arrays.stream(srcDataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            DynamicObject[] objects = BusinessDataServiceHelper.load((String)"sfc_manftech", (String)"baseunit,material,headqty,headunit,operationqty,oprunit,pushoproutorderqty,pushoproutorderbaseqty,totaloproutorderqty,totaloproutorderbaseqty", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            for (int i = 0; i < objects.length; ++i) {
                DynamicObject object = objects[i];
                DynamicObjectCollection oprEntryEntity = object.getDynamicObjectCollection("oprentryentity");
                for (DynamicObject dynamicObject : oprEntryEntity) {
                    Map<String, Object> manftechMap = this.getManftechMap(object, dynamicObject);
                    dynamicObject.set("pushoproutorderqty", (Object)this.getOprQty(manftechMap, dynamicObject.getBigDecimal("pushoproutorderbaseqty")));
                }
            }
            SaveServiceHelper.save((DynamicObject[])objects);
        }
    }

    private Map<String, Object> getManftechMap(DynamicObject manTechicsInfo, DynamicObject techisInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("baseunit", manTechicsInfo.getDynamicObject("baseunit").getPkValue());
        map.put("baseunit.precision", manTechicsInfo.getDynamicObject("baseunit").getInt("precision"));
        map.put("baseunit.precisionaccount", manTechicsInfo.getDynamicObject("baseunit").getString("precisionaccount"));
        map.put("material", manTechicsInfo.getDynamicObject("material") == null ? null : manTechicsInfo.getDynamicObject("material").getPkValue());
        map.put("oprentryentity.operationqty", techisInfo.getBigDecimal("operationqty"));
        map.put("oprentryentity.headqty", techisInfo.getBigDecimal("headqty"));
        map.put("oprentryentity.headunit", techisInfo.getDynamicObject("headunit").getPkValue());
        map.put("oprentryentity.oprunit.precision", techisInfo.getDynamicObject("oprunit").getInt("precision"));
        map.put("oprentryentity.oprunit.precisionaccount", techisInfo.getDynamicObject("oprunit").getString("precisionaccount"));
        return map;
    }

    private BigDecimal getOprQty(Map<String, Object> oprEntry, BigDecimal baseQty) {
        if (oprEntry == null || baseQty == null || BigDecimal.ZERO.compareTo(baseQty) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = UnitConvertHelper.calculateNewQty((BigDecimal)baseQty, (Long)((Long)oprEntry.get("oprentryentity.headunit")), (Long)((Long)oprEntry.get("baseunit")), (Long)((Long)oprEntry.get("material")), (StringBuilder)new StringBuilder());
        BigDecimal operationQty = (BigDecimal)oprEntry.get("oprentryentity.operationqty");
        operationQty = bigDecimal.multiply(operationQty);
        BigDecimal headQty = (BigDecimal)oprEntry.get("oprentryentity.headqty");
        BigDecimal decimal = operationQty.divide(headQty, (int)((Integer)oprEntry.get("oprentryentity.oprunit.precision")), this.getPrecisionDeal((String)oprEntry.get("oprentryentity.oprunit.precisionaccount")));
        return decimal;
    }

    private int getPrecisionDeal(String precisionaccount) {
        int deal = 4;
        switch (precisionaccount) {
            case "1": {
                deal = 4;
                break;
            }
            case "2": {
                deal = 1;
                break;
            }
            case "3": {
                deal = 0;
                break;
            }
        }
        return deal;
    }
}

