/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.apply;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class OutPurApply4MftOrderOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(OutPurApply4MftOrderOp.class);
    public static final String OP_SAVE = "save";
    public static final String OP_DELETE = "delete";
    public static final String OP_SUBMIT = "submit";
    public static final String OP_UNSUBMIT = "unsubmit";
    public static final String OP_AUDIT = "audit";
    public static final String OP_UNAUDIT = "unaudit";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("billno");
        keys.add("org");
        keys.add("biztype");
        keys.add("billentry");
        keys.add("billentry.seq");
        keys.add("billentry.supplier");
        keys.add("billentry.material");
        keys.add("billentry.entryreqorg");
        keys.add("srcbillid");
        keys.add("srcbillentity");
        keys.add("srcbillentryid");
        keys.add("mftorderid");
        keys.add("mftorderentryid");
        keys.add("entryreqdept");
        keys.add("ecostcenter");
        keys.add("isredordermate");
        keys.add("bomtime");
        keys.add("deliverdate");
        keys.add("linetype");
        keys.add("linetype.storage");
        keys.add("qty");
        keys.add("baseunit");
        keys.add("unit");
        keys.add("baseqty");
        keys.add("auxunit");
        keys.add("auxpty");
        keys.add("auxqty");
        keys.add("applyqty");
        keys.add("material");
        keys.add("materialmasterid");
        keys.add("entryreqorg");
        keys.add("reqdate");
        keys.add("configuredcode");
        keys.add("tracknumber");
        keys.add("project");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        if (objs.length == 0) {
            return;
        }
        String biztypeNumber = objs[0].getDynamicObject("biztype").getString("number");
        if (!StringUtils.equals((CharSequence)"WX110", (CharSequence)biztypeNumber) && !StringUtils.equals((CharSequence)"4011", (CharSequence)biztypeNumber)) {
            return;
        }
        String option = e.getOperationKey();
        Object ec = null;
        switch (option) {
            case "save": {
                this.doAction(objs, OP_SAVE);
                break;
            }
            case "submit": {
                this.doAction(objs, OP_SUBMIT);
                break;
            }
            case "unsubmit": {
                this.doAction(objs, OP_UNSUBMIT);
                break;
            }
            case "audit": {
                this.doAction(objs, OP_AUDIT);
                break;
            }
            case "unaudit": {
                this.doAction(objs, OP_UNAUDIT);
                break;
            }
            case "delete": {
                this.doAction(objs, OP_DELETE);
                break;
            }
        }
    }

    private void doAction(DynamicObject[] objs, String option) {
        ErrorCode ec = null;
        if (objs.length > 0) {
            ec = this.createMftstockplan(objs, option);
        }
        if (ec != null) {
            throw new KDBizException(ec, new Object[0]);
        }
    }

    private ErrorCode createMftstockplan(DynamicObject[] object, String option) {
        ErrorCode ec = null;
        try {
            ec = (ErrorCode)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"om", (String)"IMftstockplanService", (String)"createMftstockplan", (Object[])new Object[]{object, option});
        }
        catch (Throwable throwable) {
            throw new KDBizException(new ErrorCode("create mftstockplan error", throwable.getMessage()), new Object[]{object[0]});
        }
        return ec;
    }
}

