/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.om;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ConfigureCodeRequiredValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Object> configCodeIds = new HashSet<Object>(16);
        HashSet<Object> materialIds = new HashSet<Object>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObjectCollection entryColl = entity.getDynamicObjectCollection("billentry");
            if (entryColl == null) continue;
            for (DynamicObject entry : entryColl) {
                DynamicObject material;
                DynamicObject configureCode = entry.getDynamicObject("configuredcode");
                if (configureCode != null) {
                    configCodeIds.add(configureCode.getPkValue());
                }
                if ((material = entry.getDynamicObject("materialmasterid")) == null) continue;
                materialIds.add(material.getPkValue());
            }
        }
        Map configCodeMap = BusinessDataServiceHelper.loadFromCache((Object[])configCodeIds.toArray(), (String)"bd_configuredcode");
        Map materialMap = BusinessDataServiceHelper.loadFromCache((Object[])materialIds.toArray(), (String)"bd_material");
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObjectCollection collection = entity.getDynamicObjectCollection("billentry");
            if (collection == null) continue;
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject materialInConfig;
                DynamicObject configureCode = ((DynamicObject)collection.get(i)).getDynamicObject("configuredcode");
                DynamicObject material = ((DynamicObject)collection.get(i)).getDynamicObject("materialmasterid");
                if (material == null) continue;
                material = (DynamicObject)materialMap.get(material.getPkValue());
                if (configureCode == null && "2".equals(material.getString("configproperties"))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5206\u5f55\u914d\u7f6e\u53f7\u5fc5\u5f55\u3002", (String)"ConfigureCodeRequiredValidator_0", (String)"scmc-mm-om", (Object[])new Object[0]), i + 1));
                    continue;
                }
                if (null == configureCode || !this.isCanUse(configureCode = (DynamicObject)configCodeMap.get(configureCode.getPkValue()), material, materialInConfig = configureCode.getDynamicObject("material"))) continue;
                String info = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5206\u5f55\u914d\u7f6e\u53f7\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185\u3002", (String)"ConfigureCodeRequiredValidator_1", (String)"scmc-mm-om", (Object[])new Object[0]), i + 1);
                this.addErrorMessage(dataEntity, info);
            }
        }
    }

    private boolean isCanUse(DynamicObject configureCode, DynamicObject material, DynamicObject materialInConfig) {
        return null != materialInConfig && (material.getLong("id") != materialInConfig.getLong("id") || "0".equals(configureCode.getString("enable")) || !"C".equals(configureCode.getString("status")));
    }
}

