/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.om;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OMPurApplyToSimpOrderBotpPlugin
extends AbstractConvertPlugIn {
    private static final String MASTERID = "masterid";

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(tgtMainType);
        Set orgIds = Arrays.stream(entitys).filter(Objects::nonNull).map(ExtendedDataEntity::getDataEntity).map(x -> x.getDynamicObject("org")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(t -> t instanceof Long ? (Long)t : null).filter(Objects::nonNull).map(this::getInwareOrgFilter).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", orgIds);
        Map orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])qFilter.toArray());
        for (int i = 0; i < entitys.length; ++i) {
            ExtendedDataEntity entity = entitys[i];
            if (entity == null) continue;
            DynamicObject obj = entity.getDataEntity();
            this.setRecordOrg(obj, orgs);
            this.setTransaction(obj);
            this.setBOM(obj);
        }
    }

    private void setRecordOrg(DynamicObject obj, Map<Object, DynamicObject> orgs) {
        DynamicObject org = obj.getDynamicObject("org");
        if (null != org) {
            DynamicObjectCollection colls = obj.getDynamicObjectCollection("billentry");
            DynamicObject entryrecorg = orgs.get(this.getInwareOrgFilter((Long)org.getPkValue()));
            for (DynamicObject dyn : colls) {
                dyn.set("entryrecorg", (Object)entryrecorg);
            }
        }
    }

    private void setTransaction(DynamicObject obj) {
        DynamicObject org = obj.getDynamicObject("org");
        QFilter qfilter = this.getTransQFilter(org);
        qfilter.and(new QFilter("isfault", "=", (Object)Boolean.TRUE));
        if (QueryServiceHelper.exists((String)"mpdm_transactout", (QFilter[])new QFilter[]{qfilter})) {
            DynamicObject transactiontype = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_transactout", (QFilter[])new QFilter[]{qfilter});
            obj.set("transactiontype", transactiontype.getPkValue());
            obj.set("transouttypeid", transactiontype.get("number"));
        } else {
            QFilter qf1 = this.getTransQFilter(org);
            if (QueryServiceHelper.exists((String)"mpdm_transactout", (QFilter[])new QFilter[]{qf1})) {
                DynamicObject transactiontype = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_transactout", (QFilter[])new QFilter[]{qf1});
                obj.set("transactiontype", transactiontype.getPkValue());
                obj.set("transouttypeid", transactiontype.get("number"));
            } else {
                ErrorCode ec = new ErrorCode("OMTRANSINFO", String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6709\u6548\u7684\u7b80\u5355\u59d4\u5916\u4e8b\u52a1\u7c7b\u578b\u3002", (String)"OMPurApplyToSimpOrderBotpPlugin_0", (String)"scmc-mm-om", (Object[])new Object[0]), new Object[0]));
                throw new KDBizException(ec, new Object[0]);
            }
        }
    }

    private QFilter getTransQFilter(DynamicObject org) {
        QFilter qfilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_transactout", (Long)org.getLong("id"));
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        qfilter.and(new QFilter("enable", "=", (Object)"1"));
        return qfilter;
    }

    private void setBOM(DynamicObject obj) {
        DynamicObjectCollection colls = obj.getDynamicObjectCollection("billentry");
        Long transId = obj.getLong("transactiontype");
        List<Object> ids = new ArrayList();
        for (DynamicObject dyn : colls) {
            DynamicObject replaceno;
            DynamicObject ecn;
            if (StringUtils.isNotEmpty((CharSequence)dyn.getString("bomname")) || (ids = this.getBomFilter(dyn, transId)).size() <= 0) continue;
            DynamicObject bom = BusinessDataServiceHelper.loadSingleFromCache((Object)ids.get(0), (String)"pdm_mftbom");
            DynamicObject bomversion = bom.getDynamicObject("version");
            if (null != bomversion) {
                dyn.set("bomversionname", bomversion.get("name"));
                dyn.set("bomversion", bomversion.getPkValue());
            }
            if (null != (ecn = bom.getDynamicObject("ecn"))) {
                dyn.set("ecnversionname", ecn.get("number"));
                dyn.set("ecnversion", ecn.getPkValue());
            }
            if (null != (replaceno = bom.getDynamicObject("replaceno"))) {
                dyn.set("bomreplacenoname", replaceno.get("name"));
                dyn.set("bomreplaceno", replaceno.getPkValue());
            }
            dyn.set("bomid", bom.getPkValue());
            dyn.set("bomname", bom.get("number"));
        }
    }

    private List<Long> getBomFilter(DynamicObject obj, Object transId) {
        Long id;
        Row next;
        String feedtype;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        ArrayList<QFilter> filters_1 = new ArrayList<QFilter>();
        DynamicObject mftmaterial = obj.getDynamicObject("material");
        QFilter qfilter = new QFilter("material.masterid", "=", mftmaterial.getDynamicObject(MASTERID).getPkValue());
        DynamicObject transactionType = BusinessDataServiceHelper.loadSingle((Object)transId, (String)"mpdm_transactout");
        if (null != transactionType && "A".equals(feedtype = transactionType.getString("feedtype"))) {
            ArrayList<Long> pkValues = new ArrayList<Long>(16);
            DynamicObjectCollection transBomTypes = transactionType.getDynamicObjectCollection("bomtypes");
            for (DynamicObject mulData : transBomTypes) {
                pkValues.add(mulData.getLong("fbasedataid_id"));
            }
            if (CollectionUtils.isNotEmpty(pkValues)) {
                qfilter.and(new QFilter("type", "in", pkValues));
            }
        }
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        qfilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject configuredcode = obj.getDynamicObject("configuredcode");
        if (null != configuredcode) {
            qfilter.and(new QFilter("configuredcode", "=", configuredcode.getPkValue()));
        }
        filters.add(qfilter);
        filters_1.add(qfilter);
        Date expendbomtime = obj.getDate("expendbomtime");
        if (expendbomtime != null) {
            QFilter qfilter1 = new QFilter("version.effectdate", "<=", (Object)expendbomtime).and(new QFilter("version.invaliddate", ">", (Object)expendbomtime));
            filters.add(qfilter1);
        }
        filters_1.add(new QFilter("version", "=", (Object)0L));
        ArrayList<Long> ids = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query-pdm_mftbom", (String)"pdm_mftbom", (String)"id", (QFilter[])filters.toArray(new QFilter[0]), null);){
            while (dataSet.hasNext()) {
                next = dataSet.next();
                id = (Long)next.get("id");
                ids.add(id);
            }
        }
        dataSet = QueryServiceHelper.queryDataSet((String)"query-pdm_mftbom", (String)"pdm_mftbom", (String)"id", (QFilter[])filters_1.toArray(new QFilter[0]), null);
        var12_12 = null;
        try {
            while (dataSet.hasNext()) {
                next = dataSet.next();
                id = (Long)next.get("id");
                ids.add(id);
            }
        }
        catch (Throwable throwable) {
            var12_12 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var12_12 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var12_12.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        return ids;
    }

    private Long getInwareOrgFilter(Long purOrg) {
        ArrayList filterList = new ArrayList();
        Long inOrgID = 0L;
        List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"02", (String)"05", (Long)purOrg);
        if (allToOrg.isEmpty()) {
            List fromOrgs = OrgUnitServiceHelper.getFromOrgs((String)"05", (Long)purOrg, (String)"02");
            filterList.add(fromOrgs.get(0));
        } else {
            filterList.add(allToOrg.get(0));
        }
        if (!filterList.isEmpty()) {
            inOrgID = filterList.contains(purOrg) ? purOrg : (Long)filterList.get(0);
        }
        return inOrgID;
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(entitys.length);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject dataEntity = entity.getDataEntity();
            bills.add(dataEntity);
        }
        if (!bills.isEmpty()) {
            List dynamicObjects = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurOrderService", (String)"batchSetPODefValue", (Object[])new Object[]{bills});
            MainEntityType mainType = (MainEntityType)((DynamicObject)bills.get(0)).getDataEntityType();
            entitySet.Parse(dynamicObjects.toArray(new DynamicObject[0]), mainType);
            e.setTargetExtDataEntitySet(entitySet);
        }
    }
}

