/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.om;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class OMPurOrderPushedValidator
extends AbstractValidator {
    private Map<Long, Map<String, Set<Long>>> queryDownBill(Set<Object> billIds) {
        List bfRowLinkDownNodeList = BFTrackerServiceHelper.loadLinkDownNodes((String)this.entityKey, (Long[])billIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
        HashSet<String> billTypes = new HashSet<String>(){
            {
                this.add("pm_om_wxpurorderbill");
                this.add("pur_order");
                this.add("om_componentlist");
            }
        };
        HashMap<Long, Map<String, Set<Long>>> res = new HashMap<Long, Map<String, Set<Long>>>();
        for (BFRowLinkDownNode bfRowLinkDownNode : bfRowLinkDownNodeList) {
            BFRowId srcRowId = bfRowLinkDownNode.getRowId();
            Long srcBillId = srcRowId.getBillId();
            Map var1 = res.get(srcBillId) == null ? new HashMap() : (Map)res.get(srcBillId);
            Map tNodes = bfRowLinkDownNode.getTNodes();
            for (Map.Entry entry : tNodes.entrySet()) {
                BFRowId rowId = ((BFRowLinkDownNode)entry.getValue()).getRowId();
                Long billId = rowId.getBillId();
                Long mainTableId = rowId.getMainTableId();
                String tEntityNumber = EntityMetadataCache.loadTableDefine((Long)mainTableId).getEntityNumber();
                if (billTypes.contains(tEntityNumber)) continue;
                if (var1.containsKey(tEntityNumber)) {
                    ((Set)var1.get(tEntityNumber)).add(billId);
                    continue;
                }
                HashSet<Long> var2 = new HashSet<Long>();
                var2.add(billId);
                var1.put(tEntityNumber, var2);
            }
            if (res.containsKey(srcBillId)) continue;
            res.put(srcBillId, var1);
        }
        return res;
    }

    private void deleteVirtualBill(Map<Long, Map<String, Set<Long>>> downBill, Set<Long> imSalout, Set<Long> imMdcOm) {
        if (imSalout != null) {
            String algoKey = "query-im_saloutbill";
            QFilter[] qfs = new QFilter[]{new QFilter("id", "in", imSalout), new QFilter("isvirtualbill", "=", (Object)Boolean.TRUE)};
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_saloutbill", (String)"id,isvirtualbill,billentry.srcbillid", (QFilter[])qfs, null);){
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    Long key = next.getLong("billentry.srcbillid");
                    Long value = next.getLong("id");
                    Map<Object, Object> var1 = downBill.get(key) == null ? new HashMap() : downBill.get(key);
                    Set imSalouts = var1.get("im_saloutbill") == null ? new HashSet() : (Set)var1.get("im_saloutbill");
                    imSalouts.remove(value);
                }
            }
            QFilter[] qfs1 = new QFilter[]{new QFilter("id", "in", imMdcOm), new QFilter("isvirtualbill", "=", (Object)Boolean.TRUE)};
            String algoKey1 = "query-im_mdc_omcmplinbill";
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey1, (String)"im_mdc_omcmplinbill", (String)"id,isvirtualbill,billentry.srcbillid", (QFilter[])qfs1, null);){
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    Long key = next.getLong("billentry.srcbillid");
                    Long value = next.getLong("id");
                    Map<Object, Object> var1 = downBill.get(key) == null ? new HashMap() : downBill.get(key);
                    Set imSalouts = var1.get("im_mdc_omcmplinbill") == null ? new HashSet() : (Set)var1.get("im_mdc_omcmplinbill");
                    imSalouts.remove(value);
                }
            }
        }
    }

    public void validate() {
        Set<Object> billIds = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).map(DataEntityBase::getPkValue).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<Long, Map<String, Set<Long>>> downBill = this.queryDownBill(billIds);
        Set<Long> imSalout = downBill.entrySet().stream().map(Map.Entry::getValue).map(Map::entrySet).flatMap(Collection::stream).filter(x -> "im_saloutbill".equals(x.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
        Set<Long> imMdcOm = downBill.entrySet().stream().map(Map.Entry::getValue).map(Map::entrySet).flatMap(Collection::stream).filter(x -> "im_mdc_omcmplinbill".equals(x.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
        this.deleteVirtualBill(downBill, imSalout, imMdcOm);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            boolean flag = false;
            Object pkValue = bill.getPkValue();
            Map<String, Set<Long>> var1 = downBill.get(pkValue);
            if (Objects.nonNull(var1) && var1.size() > 0) {
                for (Map.Entry<String, Set<Long>> entryset : var1.entrySet()) {
                    Set<Long> value = entryset.getValue();
                    if (!Objects.nonNull(value) || value.size() <= 0) continue;
                    flag = true;
                }
            }
            if (!flag) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u4e0b\u63a8\uff0c\u6709\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"OMPurOrderPushedValidator_0", (String)"scmc-mm-om", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }
}

