/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.om;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.util.JSONUtils;

public class OrderDefValueBotpPlugin
extends AbstractConvertPlugIn {
    private static final Log log = LogFactory.getLog(OrderDefValueBotpPlugin.class);

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        super.afterGetSourceData(e);
        Map fldProperties = e.getFldProperties();
        List sourceRows = e.getSourceRows();
        Map variables = this.getOption().getVariables();
        log.info("\u59d4\u5916\u7533\u8bf7\u5355\u4e0b\u63a8\u59d4\u5916\u5de5\u5355\u7684\u53c2\u6570\u4e3a \uff1a" + variables);
        if (variables != null && "quota".equals(variables.get("isquota"))) {
            HashSet<String> fields = new HashSet<String>(16);
            Map<Long, Map<String, Object>> dataMap = this.parseCustomerVariables(variables, fields);
            for (DynamicObject bill : sourceRows) {
                this.updateEntryInfoFromVar(bill, dataMap, fldProperties);
            }
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] omMftOrderBill = targetExtDataEntitySet.FindByEntityKey(this.getTgtMainType().toString());
        ArrayList<DynamicObject> dataEntitys = new ArrayList<DynamicObject>(omMftOrderBill.length);
        for (ExtendedDataEntity bill : omMftOrderBill) {
            DynamicObject dynamicObject = bill.getDataEntity();
            dataEntitys.add(dynamicObject);
        }
        Map variables = this.getOption().getVariables();
        if (variables != null && "quota".equals(variables.get("isquota"))) {
            List numbers = CodeRuleServiceHelper.getNumbers((String)this.getTgtMainType().toString(), dataEntitys);
            Date bizTime = null;
            Object obj = variables.get("biztime");
            if (obj != null) {
                String string = (String)variables.get("biztime");
                bizTime = new Date(Long.parseLong(string));
            }
            for (ExtendedDataEntity entity : omMftOrderBill) {
                String billno;
                DynamicObject bill = entity.getDataEntity();
                DynamicObject org = bill.getDynamicObject("org");
                if (org == null) continue;
                if (bizTime != null) {
                    bill.set("billdate", (Object)bizTime);
                }
                if (StringUtils.isEmpty((CharSequence)(billno = bill.getString("billno"))) || numbers.isEmpty()) {
                    bill.set("billno", (Object)("QUTOGEN_" + System.currentTimeMillis()));
                    continue;
                }
                bill.set("billno", numbers.get(0));
                numbers.remove(0);
            }
        }
        if (!dataEntitys.isEmpty()) {
            Long startdate = System.currentTimeMillis();
            List dynamicObjects = (List)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"om", (String)"IMftOrderService", (String)"batchSetDefValue", (Object[])new Object[]{dataEntitys});
            Long enddate = System.currentTimeMillis() - startdate;
            log.info("\u8c03\u7528\u59d4\u5916\u5de5\u5355\u9ed8\u8ba4\u503c\u670d\u52a1\uff08IMftOrderService\uff09\u5904\u7406\u9ed8\u8ba4\u503c--------------cost:" + enddate + "ms");
            dynamicObjects.toArray(new DynamicObject[0]);
            MainEntityType mainEntityType = (MainEntityType)((DynamicObject)dataEntitys.get(0)).getDataEntityType();
            targetExtDataEntitySet.Parse(dynamicObjects.toArray(new DynamicObject[0]), mainEntityType);
            e.setTargetExtDataEntitySet(targetExtDataEntitySet);
        }
    }

    private Map<Long, Map<String, Object>> parseCustomerVariables(Map<String, String> variables, Set<String> fields) {
        HashMap<Long, Map<String, Object>> allDataMap = new HashMap<Long, Map<String, Object>>(16);
        variables.remove("isquota");
        variables.remove("biztime");
        try {
            String data = variables.entrySet().iterator().next().getValue();
            HashMap castFields = (HashMap)JSONUtils.cast((String)data, HashMap.class);
            fields.addAll(castFields.keySet());
            Map<String, Class<?>> propMap = this.getFieldsProp(fields);
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                String dataJson = entry.getValue();
                Long billEntryId = Long.valueOf(entry.getKey());
                HashMap dataMap = (HashMap)JSONUtils.cast((String)dataJson, HashMap.class);
                if (dataMap == null) continue;
                for (Map.Entry entry2 : dataMap.entrySet()) {
                    String key = (String)entry2.getKey();
                    Object jsonValue = entry2.getValue();
                    Object value = JSONUtils.cast((String)jsonValue.toString(), propMap.get(key));
                    entry2.setValue(value);
                }
                allDataMap.put(billEntryId, dataMap);
            }
        }
        catch (IOException e) {
            log.error(e.fillInStackTrace());
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u65f6JSON\u89e3\u6790\u9519\u8bef\u3002", (String)"QutobotpConvert_0", (String)"scmc-mm-om", (Object[])new Object[0]));
        }
        return allDataMap;
    }

    private Map<String, Class<?>> getFieldsProp(Set<String> fields) {
        BillEntityType srcMainType = this.getSrcMainType();
        HashMap map = new HashMap(fields.size());
        for (String field : fields) {
            IDataEntityProperty property = srcMainType.findProperty(field);
            if (property == null) continue;
            if (property instanceof BasedataProp) {
                map.put(field, Long.class);
                continue;
            }
            if (property instanceof DecimalProp) {
                map.put(field, BigDecimal.class);
                continue;
            }
            if (!(property instanceof BooleanProp)) continue;
            map.put(field, Boolean.class);
        }
        return map;
    }

    private void updateEntryInfoFromVar(DynamicObject bill, Map<Long, Map<String, Object>> dataMap, Map<String, DynamicProperty> fldProperties) {
        Long entryId = (Long)bill.get((IDataEntityProperty)fldProperties.get("billentry.id"));
        BigDecimal joinBaseQty = (BigDecimal)bill.get((IDataEntityProperty)fldProperties.get("joinbaseqty"));
        Map<String, Object> map = dataMap.get(entryId);
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                DynamicProperty dynamicProperty = fldProperties.get(key);
                if (dynamicProperty == null) continue;
                String name = dynamicProperty.getName();
                if (key.equals("baseqty")) {
                    BigDecimal resultBaseQty = joinBaseQty.add((BigDecimal)value);
                    bill.set(name, (Object)resultBaseQty);
                    continue;
                }
                bill.set(name, value);
            }
        }
    }
}

