/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.om;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PurOmOrderImportOp
extends BatchImportPlugin {
    protected void beforeSave(List<ImportBillData> rowdatas, ImportLogger logger) {
        super.beforeSave(rowdatas, logger);
        this.cacheData(rowdatas);
    }

    private void cacheData(List<ImportBillData> rowdatas) {
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        Map<String, Object> res = this.getResMap(rowdatas);
        while (iterator.hasNext()) {
            ImportBillData rowData = iterator.next();
            JSONObject data = rowData.getData();
            Object tranTypeName = data.get((Object)"transouttypeid");
            if (tranTypeName != null && StringUtils.isNotEmpty((CharSequence)tranTypeName.toString())) {
                String key = "mpdm_transactout_" + tranTypeName;
                Object value = res.get(key);
                data.put("transactiontype", value);
            }
            List listData = (List)data.get((Object)"billentry");
            for (Map entry : listData) {
                Object bomName = entry.get("bomname");
                if (bomName == null || !StringUtils.isNotEmpty((CharSequence)bomName.toString())) continue;
                String key = "pdm_mftbom_" + bomName;
                Object value = res.get(key);
                entry.put("bomid", value);
            }
        }
    }

    private Map<String, Object> getResMap(List<ImportBillData> rowdatas) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        List datas = rowdatas.stream().map(ImportBillData::getData).collect(Collectors.toList());
        Set transNames = datas.stream().map(x -> x.get((Object)"transouttypeid")).filter(x -> x != null && StringUtils.isNotEmpty((CharSequence)x.toString())).collect(Collectors.toSet());
        QFilter qf = new QFilter("name", "in", transNames);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"querytransouttype", (String)"mpdm_transactout", (String)"id,name", (QFilter[])qf.toArray(), null);
        Object object = null;
        try {
            while (ds.hasNext()) {
                Row next = ds.next();
                Object id = next.get("id");
                Object name = next.get("name");
                map.put("mpdm_transactout_" + name, id);
            }
        }
        catch (Throwable next) {
            object = next;
            throw next;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable next) {
                        ((Throwable)object).addSuppressed(next);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashSet bomNames = new HashSet();
        for (JSONObject data : datas) {
            List listData = (List)data.get((Object)"billentry");
            Set entryBomNames = listData.stream().map(x -> x.get("bomname")).filter(x -> x != null && StringUtils.isNotEmpty((CharSequence)x.toString())).collect(Collectors.toSet());
            bomNames.addAll(entryBomNames);
        }
        QFilter qf1 = new QFilter("number", "in", bomNames);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"querybom", (String)"pdm_mftbom", (String)"id,name,number", (QFilter[])qf1.toArray(), null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                Object id = next.get("id");
                Object number = next.get("number");
                map.put("pdm_mftbom_" + number, id);
            }
        }
        return map;
    }
}

