/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.om;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scmc.pm.opplugin.om.OMPurOrderPushedValidator;
import kd.scmc.pm.validation.order.PurOrderPushedValidator;
import org.apache.commons.collections4.map.HashedMap;

public class PurOrderUnauditAfterExeOp
extends AbstractOperationServicePlugIn {
    private Map<Object, DynamicObject> res;

    public void onAddValidators(AddValidatorsEventArgs e) {
        Iterator iterator = e.getValidators().iterator();
        while (iterator.hasNext()) {
            AbstractValidator validator = (AbstractValidator)iterator.next();
            if (!(validator instanceof PurOrderPushedValidator)) continue;
            iterator.remove();
        }
        e.getValidators().add(new OMPurOrderPushedValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Map<Object, DynamicObject> orders = this.loadMtfOrders(e.getDataEntities());
        if (!orders.isEmpty()) {
            ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
            this.setRes(this.getResMap(e.getDataEntities()));
            this.unauditStock(orders, successObjs);
            e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> ids = new HashSet<Long>(16);
        for (DynamicObject de : dataEntities) {
            String billtype = de.getString("billtype.number");
            if (!"pm_om_purorderbill_POM_S".equals(billtype)) continue;
            Long id = (Long)de.getPkValue();
            ids.add(id);
        }
        Map ordersMap = BFTrackerServiceHelper.findTargetBills((String)"pm_om_purorderbill", (Long[])ids.toArray(new Long[0]));
        if (ordersMap == null || ordersMap.size() == 0) {
            return;
        }
        Set orders = (Set)ordersMap.get("pur_order");
        if (orders == null || orders.size() == 0) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("ids", new ArrayList(orders));
        param.put("entityName", "pur_order");
        try {
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"unAuditAndDeleteBill", (Object[])new Object[]{param});
            boolean success = (Boolean)result.get("success");
            if (!success) {
                String msg = (String)result.get("message");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4f9b\u5e94\u5546\u534f\u540c\u63d0\u4f9b\u7684\u5220\u9664\u534f\u540c\u8ba2\u5355\u63a5\u53e3\u5931\u8d25\uff1a", (String)"PurOrderUnauditAfterExeOp_0", (String)"scmc-mm-om", (Object[])new Object[0]), msg));
            }
        }
        catch (Exception ex) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u4f9b\u5e94\u5546\u534f\u540c\u63d0\u4f9b\u7684\u5220\u9664\u534f\u540c\u8ba2\u5355\u63a5\u53e3\u5931\u8d25, \u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"PurOrderUnauditAfterExeOp_3", (String)"scmc-mm-om", (Object[])new Object[0]));
        }
    }

    private Map<Object, DynamicObject> getResMap(DynamicObject[] dataEntities) {
        DynamicObject[] omComponts;
        DynamicObject[] load;
        HashSet<Long> tranIds = new HashSet<Long>();
        HashSet<Object> entryIds = new HashSet<Object>();
        HashMap<Object, DynamicObject> result = new HashMap<Object, DynamicObject>(16);
        if (Objects.isNull(dataEntities)) {
            return result;
        }
        for (DynamicObject bill : dataEntities) {
            String trans;
            if (Objects.equals(bill.getString("modeltype"), "B") || StringUtils.isEmpty((CharSequence)(trans = bill.getString("transactiontype")))) continue;
            tranIds.add(Long.parseLong(trans));
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entryEntity) {
                entryIds.add(entry.getPkValue());
            }
        }
        QFilter qFilter = new QFilter("id", "in", tranIds);
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"mpdm_transactout", (String)"id,isauditstock", (QFilter[])qFilter.toArray())) {
            Object pkValue = dynamicObject.getPkValue();
            result.put(pkValue, dynamicObject);
        }
        QFilter qf = new QFilter("orderentryid", "in", entryIds);
        qf.and(new QFilter("billstatus", "=", (Object)"C"));
        String stockname = "om_componentlist";
        for (DynamicObject omCompont : omComponts = BusinessDataServiceHelper.load((String)stockname, (String)"id,orderentryid", (QFilter[])qf.toArray())) {
            result.put("om_componentlist_" + omCompont.getDynamicObject("orderentryid").getPkValue(), omCompont);
        }
        return result;
    }

    public void setRes(Map<Object, DynamicObject> res) {
        this.res = res;
    }

    public Map<Object, DynamicObject> getRes(DynamicObject[] dataEntities) {
        if (this.res == null) {
            this.setRes(this.getResMap(dataEntities));
        }
        return this.res;
    }

    private void unauditStock(Map<Object, DynamicObject> orders, List<DynamicObject> successObjs) {
        Iterator<Object> orderEntryId;
        Map<Object, DynamicObject> resMap = this.getRes(this.dataEntities);
        ArrayList<DynamicObject> errorObjs = new ArrayList<DynamicObject>(3);
        HashedMap orderEntryIdtoBillIds = new HashedMap(orders.size());
        HashedMap unauditStockIdtoOrderEntryIds = new HashedMap(orders.size());
        HashedMap failOrderEntryIds = new HashedMap(orders.size());
        for (DynamicObject order : orders.values()) {
            Iterator col22;
            DynamicObjectCollection entryCol;
            DynamicObject transactiontype = resMap.get(Long.parseLong(order.getString("transactiontype")));
            boolean isAuditStock = transactiontype.getBoolean("isauditstock");
            if (isAuditStock) {
                entryCol = order.getDynamicObjectCollection("billentry");
                for (Iterator col22 : entryCol) {
                    Object orderEntryId2 = col22.getPkValue();
                    orderEntryIdtoBillIds.put(orderEntryId2, order.getPkValue());
                }
                continue;
            }
            entryCol = order.getDynamicObjectCollection("billentry");
            ArrayList orderEntryIds = new ArrayList(4);
            col22 = entryCol.iterator();
            while (col22.hasNext()) {
                DynamicObject col3 = (DynamicObject)col22.next();
                orderEntryId = col3.getPkValue();
                orderEntryIds.add(orderEntryId);
            }
            String stockname = "om_componentlist";
            boolean exists = false;
            for (Object e : orderEntryIds) {
                if (!resMap.containsKey("om_componentlist_" + e)) continue;
                exists = true;
            }
            if (!exists) continue;
            errorObjs.add(order);
            Object pkId = order.getPkValue();
            ErrorLevel errorLevel = ErrorLevel.Error;
            String msg = ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355\u5b58\u5728\u975e\u6682\u5b58\u72b6\u6001\uff0c\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"PurOrderUnauditAfterExeOp_1", (String)"scmc-mm-om", (Object[])new Object[0]);
            ValidationErrorInfo validationErrorInfo = new ValidationErrorInfo("", pkId, 0, 0, "auditStock_Fail", "order", msg, errorLevel);
            this.operationResult.addErrorInfo((OperateErrorInfo)validationErrorInfo);
        }
        if (orderEntryIdtoBillIds.isEmpty()) {
            successObjs.addAll(orders.values());
            if (!errorObjs.isEmpty()) {
                successObjs.removeAll(errorObjs);
            }
            return;
        }
        String stockname = "om_componentlist";
        QFilter stockqfilter = new QFilter("orderentryid", "in", (Object)orderEntryIdtoBillIds.keySet().toArray());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrdereAuditAfterExeOp.auditStock", (String)stockname, (String)"id,billstatus,orderentryid", (QFilter[])new QFilter[]{stockqfilter}, (String)"");){
            while (ds.hasNext()) {
                Row row = ds.next();
                Object stockId = row.get("id");
                Object orderEntryId4 = row.get("orderentryid");
                if (!"C".equals(row.get("billstatus"))) continue;
                unauditStockIdtoOrderEntryIds.put(stockId, orderEntryId4);
            }
        }
        if (unauditStockIdtoOrderEntryIds.isEmpty()) {
            successObjs.addAll(orders.values());
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        option.setVariableValue("autounaudit", "1");
        OperationResult unauditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)stockname, (Object[])unauditStockIdtoOrderEntryIds.keySet().toArray(), (OperateOption)option);
        HashSet unauditSuccessIds = new HashSet(unauditResult.getSuccessPkIds());
        if (unauditSuccessIds.isEmpty()) {
            this.setFailMes(unauditResult, (Map<Object, Object>)unauditStockIdtoOrderEntryIds, (Map<Object, String>)failOrderEntryIds);
        } else {
            for (Map.Entry stockIdtoOrderEntryId : unauditStockIdtoOrderEntryIds.entrySet()) {
                Object stockId = stockIdtoOrderEntryId.getKey();
                orderEntryId = stockIdtoOrderEntryId.getValue();
                if (unauditSuccessIds.contains(stockId)) continue;
                failOrderEntryIds.put(orderEntryId, this.getErrorBystockId(stockId, unauditResult));
            }
        }
        if (!failOrderEntryIds.isEmpty()) {
            for (DynamicObject order : orders.values()) {
                boolean errBoolean = false;
                DynamicObjectCollection entryCol = order.getDynamicObjectCollection("billentry");
                for (int i = 1; i <= entryCol.size(); ++i) {
                    Object orderEntryId5 = ((DynamicObject)entryCol.get(i - 1)).getPkValue();
                    String orderEntryStr = (String)failOrderEntryIds.get(orderEntryId5);
                    if (!Objects.nonNull(orderEntryStr)) continue;
                    errBoolean = true;
                    this.operationResult.addErrorInfo(this.buildErrMessage(order, orderEntryStr, i));
                }
                if (errBoolean) continue;
                successObjs.add(order);
            }
        } else {
            successObjs.addAll(orders.values());
        }
    }

    private Map<Object, DynamicObject> loadMtfOrders(DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return new HashedMap(0);
        }
        HashedMap orders = new HashedMap(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            String modelType = dataEntity.getString("modeltype");
            if ("B".equals(modelType)) continue;
            orders.put(dataEntity.getPkValue(), dataEntity);
        }
        return orders;
    }

    private DynamicObject loadTransactionType(Object transactionTypeId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)transactionTypeId, (String)"mpdm_transactout", (String)"isauditstock,isaudittechnis");
    }

    private void setFailMes(OperationResult submitResult, Map<Object, Object> submitStockIdtoOrderEntryIds, Map<Object, String> failOrderEntryIds) {
        HashSet submitSuccessIds = new HashSet(submitResult.getSuccessPkIds());
        for (Map.Entry<Object, Object> stockIdtoOrderEntryId : submitStockIdtoOrderEntryIds.entrySet()) {
            Object stockId = stockIdtoOrderEntryId.getKey();
            Object orderEntryId = stockIdtoOrderEntryId.getValue();
            if (submitSuccessIds.contains(stockId)) continue;
            failOrderEntryIds.put(orderEntryId, this.getErrorBystockId(stockId, submitResult));
        }
    }

    private String getErrorBystockId(Object stockId, OperationResult submitResult) {
        for (IOperateInfo errInfo : submitResult.getAllErrorOrValidateInfo()) {
            if (!errInfo.getPkValue().toString().equals(stockId.toString())) continue;
            return errInfo.getMessage();
        }
        return "";
    }

    private OperateErrorInfo buildErrMessage(DynamicObject order, String err, int i) {
        Object pkId = order.getPkValue();
        int dataIndex = 0;
        int rowIndex = i - 1;
        ErrorLevel errorLevel = ErrorLevel.Error;
        String msg = String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u7f16\u53f7%1$s\u7684\u7b2c%2$s\u884c\u5206\u5f55\u7ec4\u4ef6\u6e05\u5355\u81ea\u52a8\u53cd\u5ba1\u6838\u5931\u8d25:%3$s", (String)"PurOrderUnauditAfterExeOp_2", (String)"scmc-mm-om", (Object[])new Object[0]), order.getString("billno"), i, err);
        return new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "OrderUnAuditBeginOptOp_auditStock_Fail", "order", msg, errorLevel);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List filds = e.getFieldKeys();
        filds.add("transactiontype");
        filds.add("billentry");
        filds.add("modeltype");
        filds.add("isvirtualbill");
        filds.add("billtype");
    }
}

