/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.om;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scmc.pm.common.om.helper.WXPurOrderHelper;
import kd.scmc.pm.common.om.helper.WXPurOrderOpHelper;
import kd.scmc.pm.opplugin.om.WXPurorderBillActiveValidator;
import kd.scmc.pm.utils.CommonUtils;

public class WXPurOrderBillActiveOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(WXPurOrderBillActiveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("billno");
        keys.add("org");
        keys.add("supplier");
        keys.add("cancelstatus");
        keys.add("confirmstatus");
        keys.add("activestatus");
        keys.add("billstatus");
        keys.add("linkmanphone");
        keys.add("sourceid");
        keys.add("billtype");
        keys.add("activer");
        keys.add("activedate");
        keys.add("activestatus");
        keys.add("version");
        keys.add("billentry");
        keys.add("billentry.sourceentryid");
        keys.add("qty");
        keys.add("auxqty");
        keys.add("receivebaseqtyup");
        keys.add("entrychangetype");
        keys.add("purbillentry_pay");
        keys.add("payamount");
        keys.add("payentrychangetype");
        keys.add("modeltype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new WXPurorderBillActiveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "active": {
                if (CommonUtils.isNull((Object)dataEntities)) {
                    e.setCancel(true);
                    return;
                }
                if (WXPurOrderHelper.check(e)) break;
                e.setCancel(true);
                return;
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "active": {
                ArrayList<DynamicObject> successObjs;
                DynamicObject[] bills = dataEntities;
                WXPurOrderHelper.updataPurOrder(bills);
                HashSet<Object> ids = new HashSet<Object>(8);
                for (int i = 0; i < dataEntities.length; ++i) {
                    DynamicObject dataEntity = dataEntities[i];
                    String modelType = dataEntity.getString("modeltype");
                    if ("B".equals(modelType)) continue;
                    Object id = dataEntity.get("sourceid");
                    ids.add(id);
                }
                if (ids.isEmpty()) break;
                ORM orm = ORM.create();
                DynamicObject purOrder = orm.newDynamicObject("pm_om_purorderbill");
                DynamicObject[] load = (DynamicObject[])BusinessDataServiceHelper.load((Object[])ids.toArray(), (IDataEntityType)purOrder.getDataEntityType());
                OperateErrorInfo operateErrorInfo = WXPurOrderHelper.checkAndGenStocks(load, successObjs = new ArrayList<DynamicObject>());
                if (Objects.nonNull(operateErrorInfo)) {
                    this.operationResult.addErrorInfo(operateErrorInfo);
                }
                WXPurOrderOpHelper.calMaterial(load);
                break;
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        String entryname = "";
        switch (operationKey) {
            case "active": {
                DynamicObject[] bills = e.getDataEntities();
                if (bills == null || bills.length == 0) {
                    return;
                }
                ArrayList<Long> ids = new ArrayList<Long>(16);
                for (DynamicObject bill : bills) {
                    String string = bill.getString("modeltype");
                    if (!"B".equals(string)) continue;
                    entryname = bill.getDataEntityType().getName();
                    Long id = (Long)bill.getPkValue();
                    ids.add(id);
                }
                log.info("\u6536\u96c6\u5230\u7684\u6570\u636e\u4e3a:" + ids);
                if (ids.isEmpty()) {
                    return;
                }
                Map bfRows = BFTrackerServiceHelper.loadBillLinkUpNodes((String)entryname, (Long[])ids.toArray(new Long[0]), (boolean)true);
                log.info("\u67e5\u8be2\u6e90\u5355\u5f97\u5230\u7684\u7ed3\u679c" + bfRows);
                Long tableId = EntityMetadataCache.loadMainTableDefine((String)"pm_om_purorderbill").getTableId();
                ArrayList<String> res = new ArrayList<String>(16);
                for (Map.Entry entry : bfRows.entrySet()) {
                    List allSourceNodes = ((BFRowLinkUpNode)entry.getValue()).findAllSourceNodes();
                    for (BFRowLinkUpNode allSourceNode : allSourceNodes) {
                        BFRowId rowId = allSourceNode.getRowId();
                        Long mainTableId = rowId.getMainTableId();
                        if (!tableId.equals(mainTableId)) continue;
                        Long billId = rowId.getBillId();
                        res.add(String.valueOf(billId));
                    }
                }
                if (res == null || res.isEmpty()) {
                    return;
                }
                log.info("\u8f6c\u5316\u5f97\u5230\u7684\u7ed3\u679c\u96c6\u4e3a\uff1a" + res);
                try {
                    Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"PurXOrderOmService", (String)"activePurOrder", (Object[])new Object[]{res});
                    if (result.get("fail") == null || ((String)result.get("fail")).isEmpty()) break;
                    String string = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u534f\u540c\u91c7\u8d2d\u8ba2\u5355\u53d8\u66f4\u5355\u63d0\u4f9b\u7684\u66f4\u65b0\u534f\u540c\u8ba2\u5355\u751f\u6548\u72b6\u6001\u63a5\u53e3\u5931\u8d25\uff1a%1$s", (String)"WXPurOrderBillActiveOp_0", (String)"scmc-mm-om", (Object[])new Object[0]), result.get("fail"));
                    log.info(string);
                    break;
                }
                catch (Exception exception) {
                    String string = ResManager.loadKDString((String)"\u8c03\u7528\u534f\u540c\u91c7\u8d2d\u8ba2\u5355\u53d8\u66f4\u5355\u63d0\u4f9b\u7684\u66f4\u65b0\u534f\u540c\u8ba2\u5355\u751f\u6548\u72b6\u6001\u63a5\u53e3\u5931\u8d25, \u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"WXPurOrderBillActiveOp_1", (String)"scmc-mm-om", (Object[])new Object[0]);
                    log.info(string + exception.getMessage());
                }
            }
        }
    }
}

