/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.om;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.common.om.helper.PurOrderHelper;

public class WXPurOrderBillOpmValidator
extends AbstractValidator {
    public void validate() {
        Row next;
        Serializable dataMap2;
        Object modelType;
        HashSet<Long> oprEntryIds = new HashSet<Long>(16);
        HashSet<Long> sourceIds = new HashSet<Long>(16);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            modelType = bill.getString("modeltype");
            if (!"B".equals(modelType)) continue;
            DynamicObjectCollection entryColl = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entryColl) {
                long oprEntryId = entry.getLong("oprentryid");
                oprEntryIds.add(oprEntryId);
            }
            Long srcBillID = bill.getLong("sourceid");
            sourceIds.add(srcBillID);
        }
        HashMap srcBillEntryId_dataMap = new HashMap(16);
        if (!sourceIds.isEmpty()) {
            String algoKey = "query-pm_om_purorder";
            QFilter[] qfs = new QFilter[]{new QFilter("id", "in", sourceIds)};
            StringBuilder selStr = new StringBuilder();
            selStr.append("id");
            selStr.append(",billentry.id");
            selStr.append(",billentry.baseqty");
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pm_om_purorderbill", (String)selStr.toString(), (QFilter[])qfs, null);
            modelType = null;
            try {
                while (dataSet.hasNext()) {
                    dataMap2 = new HashMap<String, Number>(2);
                    next = dataSet.next();
                    Long entryId = next.getLong("billentry.id");
                    BigDecimal baseQty = next.getBigDecimal("billentry.baseqty");
                    dataMap2.put("entryId", entryId);
                    dataMap2.put("baseQty", baseQty);
                    srcBillEntryId_dataMap.put(entryId, dataMap2);
                }
            }
            catch (Throwable dataMap2) {
                modelType = dataMap2;
                throw dataMap2;
            }
            finally {
                if (dataSet != null) {
                    if (modelType != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable dataMap2) {
                            ((Throwable)modelType).addSuppressed(dataMap2);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        HashMap techEntryId_dataMap = new HashMap(16);
        if (!oprEntryIds.isEmpty()) {
            String algoKey = WXPurOrderBillOpmValidator.class.getName();
            QFilter[] qfs = new QFilter[]{new QFilter("oprentryentity.id", "in", oprEntryIds)};
            StringBuilder selStr = new StringBuilder();
            selStr.append("id");
            selStr.append(",baseunit.id");
            selStr.append(",baseunit.precision");
            selStr.append(",baseunit.precisionaccount");
            selStr.append(",material.id");
            selStr.append(",transactiontype.qtysource");
            selStr.append(",oprentryentity.id");
            selStr.append(",oprentryentity.operationqty");
            selStr.append(",oprentryentity.headqty");
            selStr.append(",oprentryentity.headunit");
            selStr.append(",oprentryentity.oprqty");
            selStr.append(",oprentryentity.oprtotalinqty");
            selStr.append(",oprentryentity.pushoproutorderbaseqty");
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sfc_manftech", (String)selStr.toString(), (QFilter[])qfs, null);
            dataMap2 = null;
            try {
                while (dataSet.hasNext()) {
                    next = dataSet.next();
                    HashMap<String, Object> oprEntry = new HashMap<String, Object>(16);
                    oprEntry.put("baseunit", next.getLong("baseunit.id"));
                    oprEntry.put("baseunit.precision", next.getInteger("baseunit.precision"));
                    oprEntry.put("baseunit.precisionaccount", next.getString("baseunit.precisionaccount"));
                    oprEntry.put("material", next.getLong("material.id"));
                    oprEntry.put("oprentryentity.operationqty", next.getBigDecimal("oprentryentity.operationqty"));
                    oprEntry.put("oprentryentity.headqty", next.getBigDecimal("oprentryentity.headqty"));
                    oprEntry.put("oprentryentity.headunit", next.getLong("oprentryentity.headunit"));
                    BigDecimal oprBaseQty = PurOrderHelper.getBaseQty(oprEntry, next.getBigDecimal("oprentryentity.oprqty"));
                    BigDecimal oprtotalInBaseQty = PurOrderHelper.getBaseQty(oprEntry, next.getBigDecimal("oprentryentity.oprtotalinqty"));
                    BigDecimal pushBaseQty = next.getBigDecimal("oprentryentity.pushoproutorderbaseqty");
                    HashMap<String, Object> dataMap3 = new HashMap<String, Object>(4);
                    String qtySource = next.getString("transactiontype.qtysource");
                    dataMap3.put("qtysource", qtySource);
                    dataMap3.put("oprBaseQty", oprBaseQty);
                    dataMap3.put("oprtotalInBaseQty", oprtotalInBaseQty);
                    dataMap3.put("pushBaseQty", pushBaseQty);
                    techEntryId_dataMap.put(next.getLong("oprentryentity.id"), dataMap3);
                }
            }
            catch (Throwable next2) {
                dataMap2 = next2;
                throw next2;
            }
            finally {
                if (dataSet != null) {
                    if (dataMap2 != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable next2) {
                            ((Throwable)dataMap2).addSuppressed(next2);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            String modelType2 = bill.getString("modeltype");
            if (!"B".equals(modelType2)) continue;
            DynamicObjectCollection entryColl = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entryColl) {
                long oprEntryId = entry.getLong("oprentryid");
                Map dataMap4 = (Map)techEntryId_dataMap.get(oprEntryId);
                if (dataMap4 == null) continue;
                String qtySource = (String)dataMap4.get("qtysource");
                BigDecimal techBaseQty = BigDecimal.ZERO;
                String filedName = "";
                if ("A".equals(qtySource)) {
                    techBaseQty = (BigDecimal)dataMap4.get("oprtotalInBaseQty");
                    filedName = ResManager.loadKDString((String)"\u5df2\u8f6c\u5165\u57fa\u672c\u6570\u91cf", (String)"WXPurOrderBillOpmValidator_0", (String)"scmc-mm-om", (Object[])new Object[0]);
                } else {
                    techBaseQty = (BigDecimal)dataMap4.get("oprBaseQty");
                    filedName = ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u57fa\u672c\u6570\u91cf", (String)"WXPurOrderBillOpmValidator_1", (String)"scmc-mm-om", (Object[])new Object[0]);
                }
                BigDecimal pushBaseQty = (BigDecimal)dataMap4.get("pushBaseQty");
                long srcEntryId = entry.getLong("sourceentryid");
                Map srcDataMap = (Map)srcBillEntryId_dataMap.get(srcEntryId);
                BigDecimal srcBaseQty = (BigDecimal)srcDataMap.get("baseQty");
                BigDecimal baseQty = entry.getBigDecimal("baseqty");
                BigDecimal diffQty = baseQty.subtract(srcBaseQty);
                BigDecimal canPushQty = pushBaseQty.add(diffQty);
                if (canPushQty.compareTo(techBaseQty) <= 0) continue;
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u57fa\u672c\u6570\u91cf\u5e94\u5c0f\u4e8e\u7b49\u4e8e%s\u3002", (String)"WXPurOrderBillOpmValidator_2", (String)"scmc-mm-om", (Object[])new Object[0]), filedName));
            }
        }
    }
}

