/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.service.event;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OutPurBillWriteBackEventService
implements IEventServicePlugin {
    private static Log logger = LogFactory.getLog(OutPurBillWriteBackEventService.class);

    public Object handleEvent(KDBizEvent e) {
        if (e instanceof EntityEvent) {
            EntityEvent event = (EntityEvent)e;
            String entityNumber = event.getEntityNumber();
            String operation = event.getOperation();
            List businesskeys = event.getBusinesskeys();
            logger.info("entityNumber:" + entityNumber);
            logger.info("operation:" + operation);
            logger.info("businesskeys:" + businesskeys);
            if ("bizvalid".equals(operation) && ("pm_xpurapplybill".equals(entityNumber) || "pm_xspurorderbill".equals(entityNumber))) {
                List<Long> ids = businesskeys.stream().map(item -> Long.parseLong(item)).collect(Collectors.toList());
                if (ids == null) {
                    return e.getEventId();
                }
                this.handleWrite(entityNumber, ids);
            }
        }
        return e.getEventId();
    }

    private void handleWrite(String entityNumber, List<Long> ids) {
        String algoKey = "kd.scmc.pm.service.event.OutPurBillWriteBackEventService.handleWrite";
        HashSet<Long> entrySrcids = new HashSet<Long>(ids.size());
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityNumber, (String)"billentry.entrysrcid entrysrcid", (QFilter[])new QFilter("id", "in", ids).toArray(), null);){
            for (Row row : dataset) {
                entrySrcids.add(row.getLong("entrysrcid"));
            }
        }
        logger.info("entrySrcids:" + entrySrcids);
        if (!entrySrcids.isEmpty()) {
            Object selectFields;
            HashMap<Long, BigDecimal> entrysrcid2baseqty;
            ArrayList<QFilter> qfilters = new ArrayList<QFilter>(4);
            qfilters.add(new QFilter("billentry.id", "in", entrySrcids));
            qfilters.add(new QFilter("billentry.mftorderid", "!=", (Object)0L));
            qfilters.add(new QFilter("billentry.mftorderentryid", "!=", (Object)0L));
            qfilters.add(new QFilter("billentry.srcbillentity", "=", (Object)"om_mftorder"));
            HashSet<Long> mftOrderEntryids = new HashSet<Long>(entrySrcids.size());
            String entityname = "pm_xpurapplybill".equals(entityNumber) ? "pm_purapplybill" : "pm_purorderbill";
            try (DataSet dataset = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityname, (String)"billentry.mftorderentryid mftorderentryid", (QFilter[])qfilters.toArray(new QFilter[0]), null);){
                for (Object row : dataset) {
                    mftOrderEntryids.add(row.getLong("mftorderentryid"));
                }
            }
            logger.info("mftOrderEntryids:" + mftOrderEntryids);
            if (!mftOrderEntryids.isEmpty()) {
                Object row;
                entrysrcid2baseqty = new HashMap<Long, BigDecimal>();
                selectFields = "pm_xpurapplybill".equals(entityNumber) ? "billentry.mftorderentryid mftorderentryid,billentry.qty baseqty" : "billentry.mftorderentryid mftorderentryid,billentry.baseqty baseqty";
                Object dataset = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityname, (String)selectFields, (QFilter[])new QFilter("billentry.mftorderentryid", "in", mftOrderEntryids).toArray(), null);
                dataset = dataset.groupBy(new String[]{"mftorderentryid"}).sum("baseqty").finish().select(new String[]{"mftorderentryid", "baseqty"});
                row = dataset.iterator();
                while (row.hasNext()) {
                    Row row2 = (Row)row.next();
                    entrysrcid2baseqty.put(row2.getLong("mftorderentryid"), row2.getBigDecimal("baseqty"));
                }
                if (!entrysrcid2baseqty.isEmpty()) {
                    ArrayList<Object[]> paramsList = new ArrayList<Object[]>(entrysrcid2baseqty.size());
                    for (Map.Entry entry : entrysrcid2baseqty.entrySet()) {
                        paramsList.add(new Object[]{entry.getValue(), entry.getKey()});
                    }
                    logger.info("paramsList:" + this.toString(paramsList));
                    logger.info("\u5f00\u59cb\u6267\u884c\u91c7\u8d2d\u57fa\u672c\u6570\u91cf\u66f4\u65b0");
                    DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)"update t_om_mftorderentry_e set fpurpushqty = ? where fentryid = ? ", paramsList);
                    logger.info("\u7ed3\u675f\u6267\u884c\u91c7\u8d2d\u57fa\u672c\u6570\u91cf\u66f4\u65b0");
                }
            }
            if ("pm_xspurorderbill".equals(entityNumber)) {
                qfilters.clear();
                qfilters.add(new QFilter("billentry.id", "in", entrySrcids));
                qfilters.add(new QFilter("billentry.mftorderid", "!=", (Object)0L));
                qfilters.add(new QFilter("billentry.mftorderentryid", "!=", (Object)0L));
                qfilters.add(new QFilter("billstatus", "=", (Object)"C"));
                qfilters.add(new QFilter("billentry.srcbillentity", "in", (Object)new String[]{"om_mftorder", "pm_purapplybill"}));
                mftOrderEntryids.clear();
                dataset = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityname, (String)"billentry.id mftorderentryid", (QFilter[])qfilters.toArray(new QFilter[0]), null);
                selectFields = null;
                try {
                    for (Object row : dataset) {
                        mftOrderEntryids.add(row.getLong("mftorderentryid"));
                    }
                }
                catch (Throwable dataset) {
                    selectFields = dataset;
                    throw dataset;
                }
                finally {
                    if (dataset != null) {
                        if (selectFields != null) {
                            try {
                                dataset.close();
                            }
                            catch (Throwable dataset) {
                                ((Throwable)selectFields).addSuppressed(dataset);
                            }
                        } else {
                            dataset.close();
                        }
                    }
                }
                logger.info("billentryids:" + mftOrderEntryids);
                if (!mftOrderEntryids.isEmpty()) {
                    entrysrcid2baseqty = new HashMap();
                    DataSet dataset = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityname, (String)"billentry.mftorderentryid mftorderentryid,billentry.baseqty baseqty", (QFilter[])new QFilter("billentry.id", "in", mftOrderEntryids).toArray(), null);
                    dataset = dataset.groupBy(new String[]{"mftorderentryid"}).sum("baseqty").finish().select(new String[]{"mftorderentryid", "baseqty"});
                    ArrayList<Object[]> paramsList = new ArrayList<Object[]>(entrysrcid2baseqty.size());
                    for (Row row : dataset) {
                        paramsList.add(new Object[]{row.getBigDecimal("baseqty"), row.getLong("mftorderentryid")});
                    }
                    if (!paramsList.isEmpty()) {
                        logger.info("paramsList:" + this.toString(paramsList));
                        logger.info("\u5f00\u59cb\u6267\u884c\u91c7\u8d2d\u6267\u884c\u6570\u91cf\u66f4\u65b0");
                        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)"update t_om_mftorderentry_e set fpurauditqty = ? where fentryid = ?", paramsList);
                        logger.info("\u7ed3\u675f\u6267\u884c\u91c7\u8d2d\u6267\u884c\u6570\u91cf\u66f4\u65b0");
                    }
                }
            }
        }
    }

    private String toString(List<Object[]> paramsList) {
        StringBuilder sb = new StringBuilder();
        if (paramsList == null || paramsList.isEmpty()) {
            return null;
        }
        sb.append('[');
        for (Object[] objs : paramsList) {
            for (int i = 0; i < objs.length; ++i) {
                sb.append(objs[i]).append('-');
            }
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }
}

