/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.business.helper.LockHelper;
import kd.mpscmm.msbd.business.service.TrackLogService;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.mservice.api.PurFiService;
import kd.scmc.pm.mservice.helper.DealServiceParamHelper;

public class PurFiServiceImpl
implements PurFiService {
    private static final Log log = LogFactory.getLog(PurFiServiceImpl.class);
    private static final TrackLogService trackLog = new TrackLogService(PurFiServiceImpl.class, "pm");
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal MULTIPLE = BigDecimal.valueOf(1.2);
    private static final char COMMA = ',';
    private static final char POINT = '.';
    private static final int MAX_BILL_COUNT = 100;
    private static final String KEY_MAINBILLENTITY = "mainbillentity";
    private static final String KEY_MAINBILLID = "mainbillid";
    private static final String KEY_MAINBILLENTRYID = "mainbillentryid";
    private static final String KEY_SETTLEORGID = "settleorgid";
    private static final String KEY_AMOUNT = "amount";
    private static final String KEY_BASEQTY = "baseqty";
    private static final String SUCCESS = "success";
    private static final String MESSAGE = "message";
    private final String ERROR_PARAM_ISNULL = ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\u5e38\uff1a\u5165\u53c2\u4e3a\u7a7a\u3002", (String)"PurFiServiceImpl_0", (String)"scmc-pm-mservice", (Object[])new Object[0]);
    private final String ERROR_PARAM_MAINBILLID_ISNULL = ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\u5e38\uff1a\u6838\u5fc3\u5355\u636eID\u4e3a\u7a7a\u3002", (String)"PurFiServiceImpl_9", (String)"scmc-pm-mservice", (Object[])new Object[0]);
    private final String ERROR_MAINBILLID_DATABASE_NOT_EXIST = ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570\u5f02\u5e38\uff1a\u6838\u5fc3\u5355\u636eID\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"PurFiServiceImpl_2", (String)"scmc-pm-mservice", (Object[])new Object[0]);

    public Map<String, Object> WbApQtyAndAmount(List<Map<String, Object>> list) {
        log.info("scmc-pm-PurFiServiceImpl.WbApQtyAndAmount begin-> param: " + list);
        if (DealServiceParamHelper.isNullValue(list)) {
            log.info("param exception is null");
            Map<String, Object> buildResult = DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_ISNULL);
            return buildResult;
        }
        Map<Long, List<Map<String, Object>>> billIDMap = this.buildParamBillMap(list);
        Map<String, Object> result = this.batchUpdateApQtyAndAmount(billIDMap);
        log.info("scmc-pm-PurFiServiceImpl.WbApQtyAndAmount end.");
        return result;
    }

    public Map<String, Object> WbPayAmountOnly(List<Map<String, Object>> list) {
        log.info("scmc-pm-PurFiServiceImpl.WbPayAmountOnly begin-> param: " + list);
        if (DealServiceParamHelper.isNullValue(list)) {
            log.info("param exception is null");
            Map<String, Object> buildResult = DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_ISNULL);
            return buildResult;
        }
        Map<Long, List<Map<String, Object>>> billIDMap = this.buildParamBillMap(list);
        Map<String, Object> result = this.batchUpdatePayAmountOnly(billIDMap);
        log.info("scmc-pm-PurFiServiceImpl.WbPayAmountOnly end.");
        return result;
    }

    public Map<String, Object> WbPayPlanJoinAmountOnly(List<Map<String, Object>> list) {
        log.info("scmc-pm-PurFiServiceImpl.WbPayPlanJoinAmountOnly begin-> param: " + list);
        if (DealServiceParamHelper.isNullValue(list)) {
            log.info("param exception is null");
            Map<String, Object> buildResult = DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_ISNULL);
            return buildResult;
        }
        Map<Long, List<Map<String, Object>>> billIDMap = this.buildParamBillMap(list);
        Map<String, Object> result = this.batchUpdatePayPlanJoinAmountOnly(billIDMap);
        log.info("scmc-pm-PurFiServiceImpl.WbPayPlanJoinAmountOnly end.");
        return result;
    }

    public Map<String, Object> WbPreAmount(List<Map<String, Object>> list) {
        log.info("scmc-pm-PurFiServiceImpl.WbPreAmount begin-> param: " + list);
        if (DealServiceParamHelper.isNullValue(list)) {
            log.info("param exception is null");
            Map<String, Object> buildResult = DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_ISNULL);
            return buildResult;
        }
        Map<Long, List<Map<String, Object>>> billIDMap = this.buildParamBillMap(list);
        Map<String, Object> result = this.batchUpdatePreAmount(billIDMap);
        log.info("scmc-pm-PurFiServiceImpl.WbPreAmount end.");
        return result;
    }

    public Map<String, Object> WbPayPlanPayAmount(List<Map<String, Object>> list) {
        log.info("scmc-pm-PurFiServiceImpl.WbPayPlanPayAmount begin-> param: " + list);
        if (DealServiceParamHelper.isNullValue(list)) {
            log.info("param exception is null");
            Map<String, Object> buildResult = DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_ISNULL);
            return buildResult;
        }
        Map<Long, List<Map<String, Object>>> billIDMap = this.buildParamBillMap(list);
        Map<String, Object> result = this.batchUpdatePayPlanPayAmount(billIDMap);
        log.info("scmc-pm-PurFiServiceImpl.WbPayPlanPayAmount end.");
        return result;
    }

    public Map<String, Object> WbPayPlanJoinAmount(List<Map<String, Object>> list) {
        log.info("scmc-pm-PurFiServiceImpl.WbPayPlanJoinAmount begin-> param: " + list);
        if (DealServiceParamHelper.isNullValue(list)) {
            log.info("param exception is null");
            Map<String, Object> buildResult = DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_ISNULL);
            return buildResult;
        }
        Map<Long, List<Map<String, Object>>> billIDMap = this.buildParamBillMap(list);
        Map<String, Object> result = this.batchUpdatePayPlanJoinAmount(billIDMap);
        log.info("scmc-pm-PurFiServiceImpl.WbPayPlanJoinAmount end.");
        return result;
    }

    private Map<Long, List<Map<String, Object>>> buildParamBillMap(List<Map<String, Object>> list) {
        return list.stream().filter(map -> map.get(KEY_MAINBILLID) != null && "pm_purorderbill".equals(map.get(KEY_MAINBILLENTITY))).collect(Collectors.groupingBy(map -> (Long)map.get(KEY_MAINBILLID)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> batchUpdateApQtyAndAmount(Map<Long, List<Map<String, Object>>> billIDMap) {
        if (DealServiceParamHelper.isNullValue(billIDMap)) {
            log.info("param exception mainbillid(pm_purorderbill) is null");
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_MAINBILLID_ISNULL);
        }
        StringBuilder selectField = new StringBuilder();
        selectField.append("id").append(',').append("billno").append(',').append("supplier").append(',').append("billentry").append('.').append("seq").append(',').append("billentry").append('.').append("material").append(',').append("billentry").append('.').append("materialmasterid").append(',').append("billentry").append('.').append("unit").append(',').append("billentry").append('.').append("baseunit").append(',').append("billentry").append('.').append("qty").append(',').append("billentry").append('.').append(KEY_BASEQTY).append(',').append("billentry").append('.').append("amountandtax").append(',').append("billentry").append('.').append("payablepriceqty").append(',').append("billentry").append('.').append("payablebaseqty").append(',').append("billentry").append('.').append("payableamount").append(',').append("billentry").append('.').append("entrysettleorg");
        Set<Long> ids = billIDMap.keySet();
        int size = ids.size();
        HashSet<String> keys = new HashSet<String>(size);
        for (Long l : ids) {
            keys.add("wbpo#" + String.valueOf(l));
        }
        List dLocks = LockHelper.createDLocks(keys, (boolean)true);
        try {
            LockHelper.tryDLocks((List)dLocks, (Long)60000L);
            if (size <= 100) {
                Map<String, Object> map = this.updateApQtyAndAmount(billIDMap, selectField, ids);
                return map;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
            hashMap.put(SUCCESS, Boolean.TRUE);
            StringBuilder msg = new StringBuilder();
            ArrayList<Long> idList = new ArrayList<Long>(ids);
            while (!idList.isEmpty()) {
                Map<String, Object> subResult;
                HashSet<Long> subIds = new HashSet<Long>(100);
                while (!idList.isEmpty() && subIds.size() < 100) {
                    Long next = (Long)idList.get(0);
                    subIds.add(next);
                    idList.remove(next);
                }
                if (DealServiceParamHelper.isNullValue(subIds) || (subResult = this.updateApQtyAndAmount(billIDMap, selectField, subIds)) == null) continue;
                if (!((Boolean)subResult.get(SUCCESS)).booleanValue()) {
                    msg.append(subResult.get(MESSAGE));
                    continue;
                }
                hashMap.putAll(subResult);
            }
            HashMap<String, Object> hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            LockHelper.unDLocks((List)dLocks);
        }
    }

    private Map<String, Object> updateApQtyAndAmount(Map<Long, List<Map<String, Object>>> billIDMap, StringBuilder selectField, Set<Long> ids) {
        QFilter q = new QFilter("id", "in", ids);
        QFilter[] qFilters = new QFilter[]{q};
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)selectField.toString(), (QFilter[])qFilters);
        if (bills == null || bills.length == 0) {
            log.info("mainbillid(pm_purorderbill) no exist in database :" + ids);
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_MAINBILLID_DATABASE_NOT_EXIST);
        }
        int length = bills.length;
        ArrayList loadBillDatas = new ArrayList(length);
        ArrayList updateBillDatas = new ArrayList(length);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(length);
        for (DynamicObject bill : bills) {
            Long id = (Long)bill.getPkValue();
            String billNo = bill.getString("billno");
            HashMap<String, Object> loadBillData = new HashMap<String, Object>(4);
            loadBillData.put("id", id);
            loadBillData.put("billno", billNo);
            loadBillDatas.add(loadBillData);
            List<Map<String, Object>> paramList = billIDMap.get(id);
            if (DealServiceParamHelper.isNullValue(paramList)) continue;
            boolean isUpdate = false;
            block1: for (Map<String, Object> paramMap : paramList) {
                if (DealServiceParamHelper.isNullValue(paramMap)) continue;
                if (DealServiceParamHelper.isNullValue(paramMap.get(KEY_MAINBILLENTRYID))) {
                    log.info("param validation failer, not update: mainbillentryid is null");
                    continue;
                }
                Long mainBillEntryID = (Long)paramMap.get(KEY_MAINBILLENTRYID);
                BigDecimal baseQty = DealServiceParamHelper.getNotNullBigDecimal(paramMap.get(KEY_BASEQTY));
                BigDecimal amount = DealServiceParamHelper.getNotNullBigDecimal(paramMap.get(KEY_AMOUNT));
                if (ZERO.compareTo(baseQty) == 0 && ZERO.compareTo(amount) == 0) {
                    log.info("param validation failer, not update: baseqty and amount is 0");
                    continue;
                }
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    Long entryID = (Long)entry.getPkValue();
                    if (entryID == null || !entryID.equals(mainBillEntryID)) continue;
                    if (this.isWriteBack(paramMap, bill, mainBillEntryID)) {
                        if (ZERO.compareTo(amount) != 0) {
                            BigDecimal oldPayableAmount = DealServiceParamHelper.getNotNullBigDecimal(entry.get("payableamount"));
                            entry.set("payableamount", (Object)oldPayableAmount.add(amount));
                            isUpdate = true;
                        }
                        if (ZERO.compareTo(baseQty) != 0) {
                            BigDecimal oldPayableQty = DealServiceParamHelper.getNotNullBigDecimal(entry.get("payablepriceqty"));
                            BigDecimal oldPayableBaseQty = DealServiceParamHelper.getNotNullBigDecimal(entry.get("payablebaseqty"));
                            Long materialID = null;
                            if (entry.get("materialmasterid") instanceof DynamicObject) {
                                materialID = (Long)entry.getDynamicObject("materialmasterid").getPkValue();
                            } else if (entry.get("material") instanceof DynamicObject && entry.getDynamicObject("material").get("masterid") instanceof DynamicObject) {
                                materialID = (Long)entry.getDynamicObject("material").getDynamicObject("masterid").getPkValue();
                            }
                            DynamicObject unit = entry.getDynamicObject("unit");
                            DynamicObject baseUnit = entry.getDynamicObject("baseunit");
                            if (materialID != null && unit != null && baseUnit != null) {
                                if (ZERO.compareTo(oldPayableBaseQty) == 0 && ZERO.compareTo(oldPayableQty) != 0) {
                                    BigDecimal qty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialID, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit);
                                    entry.set("payablepriceqty", (Object)oldPayableQty.add(qty));
                                } else {
                                    BigDecimal newPayableBaseQty = oldPayableBaseQty.add(baseQty);
                                    BigDecimal newPayableQty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialID, (DynamicObject)baseUnit, (BigDecimal)newPayableBaseQty, (DynamicObject)unit);
                                    entry.set("payablebaseqty", (Object)newPayableBaseQty);
                                    entry.set("payablepriceqty", (Object)newPayableQty);
                                }
                                isUpdate = true;
                            }
                        }
                        this.trackLogWarnByBigDecimal(bill, entry, "payablepriceqty", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u5e94\u4ed8\u6570\u91cf", (String)"PurFiServiceImpl_3", (String)"scmc-pm-mservice", (Object[])new Object[0]), "qty", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u6570\u91cf", (String)"PurFiServiceImpl_4", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                        this.trackLogWarnByBigDecimal(bill, entry, "payablebaseqty", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u5e94\u4ed8\u57fa\u672c\u6570\u91cf", (String)"PurFiServiceImpl_29", (String)"scmc-pm-mservice", (Object[])new Object[0]), KEY_BASEQTY, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u57fa\u672c\u6570\u91cf", (String)"PurFiServiceImpl_30", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                        this.trackLogWarnByBigDecimal(bill, entry, "payableamount", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u5e94\u4ed8\u91d1\u989d", (String)"PurFiServiceImpl_5", (String)"scmc-pm-mservice", (Object[])new Object[0]), "amountandtax", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u4ef7\u7a0e\u5408\u8ba1", (String)"PurFiServiceImpl_6", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                        continue block1;
                    }
                    log.info("isWriteBack validation is failer,not update:" + paramMap);
                    continue block1;
                }
            }
            if (!isUpdate) continue;
            updateList.add(bill);
            HashMap<String, Object> updateBillData = new HashMap<String, Object>(4);
            updateBillData.put("id", id);
            updateBillData.put("billno", billNo);
            updateBillDatas.add(updateBillData);
        }
        trackLog.info("pm_purorderbill(load) -> " + DealServiceParamHelper.serialization(loadBillDatas) + ";(update) -> " + DealServiceParamHelper.serialization(updateBillDatas));
        return this.savePurOrderbill(updateList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> batchUpdatePayAmountOnly(Map<Long, List<Map<String, Object>>> billIDMap) {
        if (DealServiceParamHelper.isNullValue(billIDMap)) {
            log.info("param exception mainbillid(pm_purorderbill) is null");
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_MAINBILLID_ISNULL);
        }
        StringBuilder selectField = new StringBuilder();
        selectField.append("id").append(',').append("billno").append(',').append("supplier").append(',').append("totalallamount").append(',').append("paidallamount").append(',').append("billentry").append('.').append("entrysettleorg");
        Set<Long> ids = billIDMap.keySet();
        int size = ids.size();
        HashSet<String> keys = new HashSet<String>(size);
        for (Long l : ids) {
            keys.add("wbpo#" + String.valueOf(l));
        }
        List dLocks = LockHelper.createDLocks(keys, (boolean)true);
        try {
            LockHelper.tryDLocks((List)dLocks, (Long)60000L);
            if (size <= 100) {
                Map<String, Object> map = this.updatePayAmountOnly(billIDMap, selectField, ids);
                return map;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
            hashMap.put(SUCCESS, Boolean.TRUE);
            StringBuilder msg = new StringBuilder();
            ArrayList<Long> idList = new ArrayList<Long>(ids);
            while (!idList.isEmpty()) {
                Map<String, Object> subResult;
                HashSet<Long> subIds = new HashSet<Long>(100);
                while (!idList.isEmpty() && subIds.size() < 100) {
                    Long next = (Long)idList.get(0);
                    subIds.add(next);
                    idList.remove(next);
                }
                if (DealServiceParamHelper.isNullValue(subIds) || (subResult = this.updatePayAmountOnly(billIDMap, selectField, subIds)) == null) continue;
                if (!((Boolean)subResult.get(SUCCESS)).booleanValue()) {
                    msg.append(subResult.get(MESSAGE));
                    continue;
                }
                hashMap.putAll(subResult);
            }
            HashMap<String, Object> hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            LockHelper.unDLocks((List)dLocks);
        }
    }

    private Map<String, Object> updatePayAmountOnly(Map<Long, List<Map<String, Object>>> billIDMap, StringBuilder selectField, Set<Long> ids) {
        QFilter q = new QFilter("id", "in", ids);
        QFilter[] qFilters = new QFilter[]{q};
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)selectField.toString(), (QFilter[])qFilters);
        if (bills == null || bills.length == 0) {
            log.info("mainbillid(pm_purorderbill) no exist in database :" + ids);
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_MAINBILLID_DATABASE_NOT_EXIST);
        }
        int length = bills.length;
        ArrayList loadBillDatas = new ArrayList(length);
        ArrayList updateBillDatas = new ArrayList(length);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(bills.length);
        for (DynamicObject bill : bills) {
            Long id = (Long)bill.getPkValue();
            String billNo = bill.getString("billno");
            HashMap<String, Object> loadBillData = new HashMap<String, Object>(4);
            loadBillData.put("id", id);
            loadBillData.put("billno", billNo);
            loadBillDatas.add(loadBillData);
            List<Map<String, Object>> paramList = billIDMap.get(id);
            if (DealServiceParamHelper.isNullValue(paramList)) continue;
            boolean isUpdate = false;
            for (Map<String, Object> paramMap : paramList) {
                BigDecimal amount = DealServiceParamHelper.getNotNullBigDecimal(paramMap.get(KEY_AMOUNT));
                if (ZERO.compareTo(amount) == 0) {
                    log.info("param validation failer, not update: amount is null or 0");
                    continue;
                }
                Long mainBillEntryID = (Long)paramMap.get(KEY_MAINBILLENTRYID);
                if (this.isWriteBack(paramMap, bill, mainBillEntryID)) {
                    BigDecimal oldPaidAllAmount = DealServiceParamHelper.getNotNullBigDecimal(bill.get("paidallamount"));
                    bill.set("paidallamount", (Object)oldPaidAllAmount.add(amount));
                    this.trackLogWarnByBigDecimal(bill, null, "paidallamount", ResManager.loadKDString((String)"\u5df2\u4ed8\u91d1\u989d", (String)"PurFiServiceImpl_7", (String)"scmc-pm-mservice", (Object[])new Object[0]), "totalallamount", ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"PurFiServiceImpl_8", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                    isUpdate = true;
                    continue;
                }
                log.info("isWriteBack validation is failer,not update:" + paramMap);
            }
            if (!isUpdate) continue;
            updateList.add(bill);
            HashMap<String, Object> updateBillData = new HashMap<String, Object>(4);
            updateBillData.put("id", id);
            updateBillData.put("billno", billNo);
            updateBillDatas.add(updateBillData);
        }
        trackLog.info("pm_purorderbill(load) -> " + DealServiceParamHelper.serialization(loadBillDatas) + ";(update) -> " + DealServiceParamHelper.serialization(updateBillDatas));
        return this.savePurOrderbill(updateList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> batchUpdatePayPlanJoinAmountOnly(Map<Long, List<Map<String, Object>>> billIDMap) {
        if (DealServiceParamHelper.isNullValue(billIDMap)) {
            log.info("param exception mainbillid(pm_purorderbill) is null");
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_MAINBILLID_ISNULL);
        }
        StringBuilder selectField = new StringBuilder();
        selectField.append("id").append(',').append("billno").append(',').append("supplier").append(',').append("purbillentry_pay").append('.').append("seq").append(',').append("purbillentry_pay").append('.').append("payamount").append(',').append("purbillentry_pay").append('.').append("joinpayamount").append(',').append("billentry").append('.').append("entrysettleorg");
        Set<Long> ids = billIDMap.keySet();
        int size = ids.size();
        HashSet<String> keys = new HashSet<String>(size);
        for (Long l : ids) {
            keys.add("wbpo#" + String.valueOf(l));
        }
        List dLocks = LockHelper.createDLocks(keys, (boolean)true);
        try {
            LockHelper.tryDLocks((List)dLocks, (Long)60000L);
            if (size <= 100) {
                Map<String, Object> map = this.updatePayPlanJoinAmountOnly(billIDMap, selectField, ids);
                return map;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
            hashMap.put(SUCCESS, Boolean.TRUE);
            StringBuilder msg = new StringBuilder();
            ArrayList<Long> idList = new ArrayList<Long>(ids);
            while (!idList.isEmpty()) {
                Map<String, Object> subResult;
                HashSet<Long> subIds = new HashSet<Long>(100);
                while (!idList.isEmpty() && subIds.size() < 100) {
                    Long next = (Long)idList.get(0);
                    subIds.add(next);
                    idList.remove(next);
                }
                if (DealServiceParamHelper.isNullValue(subIds) || (subResult = this.updatePayPlanJoinAmountOnly(billIDMap, selectField, subIds)) == null) continue;
                if (!((Boolean)subResult.get(SUCCESS)).booleanValue()) {
                    msg.append(subResult.get(MESSAGE));
                    continue;
                }
                hashMap.putAll(subResult);
            }
            HashMap<String, Object> hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            LockHelper.unDLocks((List)dLocks);
        }
    }

    private Map<String, Object> updatePayPlanJoinAmountOnly(Map<Long, List<Map<String, Object>>> billIDMap, StringBuilder selectField, Set<Long> ids) {
        QFilter q = new QFilter("id", "in", ids);
        QFilter[] qFilters = new QFilter[]{q};
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)selectField.toString(), (QFilter[])qFilters);
        if (bills == null || bills.length == 0) {
            log.info("mainbillid(pm_purorderbill) no exist in database :" + ids);
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_MAINBILLID_DATABASE_NOT_EXIST);
        }
        int length = bills.length;
        ArrayList loadBillDatas = new ArrayList(length);
        ArrayList updateBillDatas = new ArrayList(length);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(bills.length);
        for (DynamicObject bill : bills) {
            Long id = (Long)bill.getPkValue();
            String billNo = bill.getString("billno");
            HashMap<String, Object> loadBillData = new HashMap<String, Object>(4);
            loadBillData.put("id", id);
            loadBillData.put("billno", billNo);
            loadBillDatas.add(loadBillData);
            List<Map<String, Object>> paramList = billIDMap.get(id);
            if (DealServiceParamHelper.isNullValue(paramList)) continue;
            boolean isUpdate = false;
            block1: for (Map<String, Object> paramMap : paramList) {
                if (DealServiceParamHelper.isNullValue(paramMap.get(KEY_MAINBILLENTRYID))) {
                    log.info("param validation failer, not update: mainbillentryid is null");
                    continue;
                }
                Long mainBillEntryID = (Long)paramMap.get(KEY_MAINBILLENTRYID);
                if (DealServiceParamHelper.isNullValue(paramMap.get(KEY_AMOUNT))) {
                    log.info("param validation failer, not update: amount is null or 0");
                    continue;
                }
                BigDecimal amount = (BigDecimal)paramMap.get(KEY_AMOUNT);
                if (this.isWriteBack(paramMap, bill, null)) {
                    DynamicObjectCollection payEntrys = bill.getDynamicObjectCollection("purbillentry_pay");
                    for (DynamicObject payEntry : payEntrys) {
                        if (!mainBillEntryID.equals(payEntry.getPkValue())) continue;
                        BigDecimal oldJoinPaidAmount = DealServiceParamHelper.getNotNullBigDecimal(payEntry.get("joinpayamount"));
                        payEntry.set("joinpayamount", (Object)oldJoinPaidAmount.add(amount));
                        this.trackLogWarnByBigDecimal(bill, payEntry, "joinpayamount", ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212.\u5173\u8054\u4ed8\u6b3e\u91d1\u989d", (String)"PurFiServiceImpl_10", (String)"scmc-pm-mservice", (Object[])new Object[0]), "payamount", ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212.\u4ed8\u6b3e\u91d1\u989d", (String)"PurFiServiceImpl_14", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                        isUpdate = true;
                        continue block1;
                    }
                    continue;
                }
                log.info("isWriteBack validation is failer,not update:" + paramMap);
            }
            if (!isUpdate) continue;
            updateList.add(bill);
            HashMap<String, Object> updateBillData = new HashMap<String, Object>(4);
            updateBillData.put("id", id);
            updateBillData.put("billno", billNo);
            updateBillDatas.add(updateBillData);
        }
        trackLog.info("pm_purorderbill(load) -> " + DealServiceParamHelper.serialization(loadBillDatas) + ";(update) -> " + DealServiceParamHelper.serialization(updateBillDatas));
        return this.savePurOrderbill(updateList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> batchUpdatePreAmount(Map<Long, List<Map<String, Object>>> billIDMap) {
        if (DealServiceParamHelper.isNullValue(billIDMap)) {
            log.info("param exception mainbillid(pm_purorderbill) is null");
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_MAINBILLID_ISNULL);
        }
        StringBuilder selectField = new StringBuilder();
        selectField.append("id").append(',').append("billno").append(',').append("supplier").append(',').append("totalallamount").append(',').append("paidallamount").append(',').append("paidpreallamount").append(',').append("billentry").append('.').append("entrysettleorg");
        Set<Long> ids = billIDMap.keySet();
        int size = ids.size();
        HashSet<String> keys = new HashSet<String>(size);
        for (Long l : ids) {
            keys.add("wbpo#" + String.valueOf(l));
        }
        List dLocks = LockHelper.createDLocks(keys, (boolean)true);
        try {
            LockHelper.tryDLocks((List)dLocks, (Long)60000L);
            if (size <= 100) {
                Map<String, Object> map = this.updatePreAmount(billIDMap, selectField, ids);
                return map;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
            hashMap.put(SUCCESS, Boolean.TRUE);
            StringBuilder msg = new StringBuilder();
            ArrayList<Long> idList = new ArrayList<Long>(ids);
            while (!idList.isEmpty()) {
                Map<String, Object> subResult;
                HashSet<Long> subIds = new HashSet<Long>(100);
                while (!idList.isEmpty() && subIds.size() < 100) {
                    Long next = (Long)idList.get(0);
                    subIds.add(next);
                    idList.remove(next);
                }
                if (DealServiceParamHelper.isNullValue(subIds) || (subResult = this.updatePreAmount(billIDMap, selectField, subIds)) == null) continue;
                if (!((Boolean)subResult.get(SUCCESS)).booleanValue()) {
                    msg.append(subResult.get(MESSAGE));
                    continue;
                }
                hashMap.putAll(subResult);
            }
            HashMap<String, Object> hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            LockHelper.unDLocks((List)dLocks);
        }
    }

    private Map<String, Object> updatePreAmount(Map<Long, List<Map<String, Object>>> billIDMap, StringBuilder selectField, Set<Long> ids) {
        QFilter q = new QFilter("id", "in", ids);
        QFilter[] qFilters = new QFilter[]{q};
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)selectField.toString(), (QFilter[])qFilters);
        if (bills == null || bills.length == 0) {
            log.info("mainbillid(pm_purorderbill) no exist in database :" + ids);
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_MAINBILLID_DATABASE_NOT_EXIST);
        }
        int length = bills.length;
        ArrayList loadBillDatas = new ArrayList(length);
        ArrayList updateBillDatas = new ArrayList(length);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(bills.length);
        for (DynamicObject bill : bills) {
            Long id = (Long)bill.getPkValue();
            String billNo = bill.getString("billno");
            HashMap<String, Object> loadBillData = new HashMap<String, Object>(4);
            loadBillData.put("id", id);
            loadBillData.put("billno", billNo);
            loadBillDatas.add(loadBillData);
            List<Map<String, Object>> paramList = billIDMap.get(id);
            if (DealServiceParamHelper.isNullValue(paramList)) continue;
            boolean isUpdate = false;
            for (Map<String, Object> paramMap : paramList) {
                BigDecimal amount = DealServiceParamHelper.getNotNullBigDecimal(paramMap.get(KEY_AMOUNT));
                if (ZERO.compareTo(amount) == 0) {
                    log.info("param validation failer, not update: amount is null or 0");
                    continue;
                }
                Long mainBillEntryID = (Long)paramMap.get(KEY_MAINBILLENTRYID);
                if (this.isWriteBack(paramMap, bill, mainBillEntryID)) {
                    BigDecimal oldPaidAllAmount = DealServiceParamHelper.getNotNullBigDecimal(bill.get("paidallamount"));
                    BigDecimal oldPaidPreAllAmount = DealServiceParamHelper.getNotNullBigDecimal(bill.get("paidpreallamount"));
                    bill.set("paidallamount", (Object)oldPaidAllAmount.add(amount));
                    bill.set("paidpreallamount", (Object)oldPaidPreAllAmount.add(amount));
                    this.trackLogWarnByBigDecimal(bill, null, "paidallamount", ResManager.loadKDString((String)"\u5df2\u4ed8\u91d1\u989d", (String)"PurFiServiceImpl_7", (String)"scmc-pm-mservice", (Object[])new Object[0]), "totalallamount", ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"PurFiServiceImpl_8", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                    this.trackLogWarnByBigDecimal(bill, null, "paidpreallamount", ResManager.loadKDString((String)"\u5df2\u9884\u4ed8\u91d1\u989d", (String)"PurFiServiceImpl_12", (String)"scmc-pm-mservice", (Object[])new Object[0]), "totalallamount", ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"PurFiServiceImpl_8", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                    isUpdate = true;
                    continue;
                }
                log.info("isWriteBack validation is failer,not update:" + paramMap);
            }
            if (!isUpdate) continue;
            updateList.add(bill);
            HashMap<String, Object> updateBillData = new HashMap<String, Object>(4);
            updateBillData.put("id", id);
            updateBillData.put("billno", billNo);
            updateBillDatas.add(updateBillData);
        }
        trackLog.info("pm_purorderbill(load) -> " + DealServiceParamHelper.serialization(loadBillDatas) + ";(update) -> " + DealServiceParamHelper.serialization(updateBillDatas));
        return this.savePurOrderbill(updateList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> batchUpdatePayPlanPayAmount(Map<Long, List<Map<String, Object>>> billIDMap) {
        if (DealServiceParamHelper.isNullValue(billIDMap)) {
            log.info("param exception mainbillid(pm_purorderbill) is null");
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_MAINBILLID_ISNULL);
        }
        StringBuilder selectField = new StringBuilder();
        selectField.append("id").append(',').append("billno").append(',').append("supplier").append(',').append("totalallamount").append(',').append("paidallamount").append(',').append("paidpreallamount").append(',').append("purbillentry_pay").append('.').append("seq").append(',').append("purbillentry_pay").append('.').append("payamount").append(',').append("purbillentry_pay").append('.').append("paidamount").append(',').append("billentry").append('.').append("entrysettleorg");
        Set<Long> ids = billIDMap.keySet();
        int size = ids.size();
        HashSet<String> keys = new HashSet<String>(size);
        for (Long l : ids) {
            keys.add("wbpo#" + String.valueOf(l));
        }
        List dLocks = LockHelper.createDLocks(keys, (boolean)true);
        try {
            LockHelper.tryDLocks((List)dLocks, (Long)60000L);
            if (size <= 100) {
                Map<String, Object> map = this.updatePayPlanPayAmount(billIDMap, selectField, ids);
                return map;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
            hashMap.put(SUCCESS, Boolean.TRUE);
            StringBuilder msg = new StringBuilder();
            ArrayList<Long> idList = new ArrayList<Long>(ids);
            while (!idList.isEmpty()) {
                Map<String, Object> subResult;
                HashSet<Long> subIds = new HashSet<Long>(100);
                while (!idList.isEmpty() && subIds.size() < 100) {
                    Long next = (Long)idList.get(0);
                    subIds.add(next);
                    idList.remove(next);
                }
                if (DealServiceParamHelper.isNullValue(subIds) || (subResult = this.updatePayPlanPayAmount(billIDMap, selectField, subIds)) == null) continue;
                if (!((Boolean)subResult.get(SUCCESS)).booleanValue()) {
                    msg.append(subResult.get(MESSAGE));
                    continue;
                }
                hashMap.putAll(subResult);
            }
            HashMap<String, Object> hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            LockHelper.unDLocks((List)dLocks);
        }
    }

    private Map<String, Object> updatePayPlanPayAmount(Map<Long, List<Map<String, Object>>> billIDMap, StringBuilder selectField, Set<Long> ids) {
        QFilter q = new QFilter("id", "in", ids);
        QFilter[] qFilters = new QFilter[]{q};
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)selectField.toString(), (QFilter[])qFilters);
        if (bills == null || bills.length == 0) {
            log.info("mainbillid(pm_purorderbill) no exist in database :" + ids);
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_MAINBILLID_DATABASE_NOT_EXIST);
        }
        int length = bills.length;
        ArrayList loadBillDatas = new ArrayList(length);
        ArrayList updateBillDatas = new ArrayList(length);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(bills.length);
        for (DynamicObject bill : bills) {
            Long id = (Long)bill.getPkValue();
            String billNo = bill.getString("billno");
            HashMap<String, Object> loadBillData = new HashMap<String, Object>(4);
            loadBillData.put("id", id);
            loadBillData.put("billno", billNo);
            loadBillDatas.add(loadBillData);
            List<Map<String, Object>> paramList = billIDMap.get(id);
            if (DealServiceParamHelper.isNullValue(paramList)) continue;
            boolean isUpdate = false;
            block1: for (Map<String, Object> paramMap : paramList) {
                if (DealServiceParamHelper.isNullValue(paramMap.get(KEY_MAINBILLENTRYID))) {
                    log.info("param validation failer, not update: mainbillentryid is null");
                    continue;
                }
                Long mainBillEntryID = (Long)paramMap.get(KEY_MAINBILLENTRYID);
                BigDecimal amount = DealServiceParamHelper.getNotNullBigDecimal(paramMap.get(KEY_AMOUNT));
                if (ZERO.compareTo(amount) == 0) {
                    log.info("param validation failer, not update: amount is null or 0");
                    continue;
                }
                if (this.isWriteBack(paramMap, bill, null)) {
                    DynamicObjectCollection payEntrys = bill.getDynamicObjectCollection("purbillentry_pay");
                    for (DynamicObject payEntry : payEntrys) {
                        if (!mainBillEntryID.equals(payEntry.getPkValue())) continue;
                        BigDecimal oldPaidAllAmount = DealServiceParamHelper.getNotNullBigDecimal(bill.get("paidallamount"));
                        BigDecimal oldPaidPreAllAmount = DealServiceParamHelper.getNotNullBigDecimal(bill.get("paidpreallamount"));
                        BigDecimal oldPaidAmount = DealServiceParamHelper.getNotNullBigDecimal(payEntry.get("paidamount"));
                        bill.set("paidallamount", (Object)oldPaidAllAmount.add(amount));
                        bill.set("paidpreallamount", (Object)oldPaidPreAllAmount.add(amount));
                        payEntry.set("paidamount", (Object)oldPaidAmount.add(amount));
                        this.trackLogWarnByBigDecimal(bill, null, "paidallamount", ResManager.loadKDString((String)"\u5df2\u4ed8\u91d1\u989d", (String)"PurFiServiceImpl_7", (String)"scmc-pm-mservice", (Object[])new Object[0]), "totalallamount", ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"PurFiServiceImpl_8", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                        this.trackLogWarnByBigDecimal(bill, null, "paidpreallamount", ResManager.loadKDString((String)"\u5df2\u9884\u4ed8\u91d1\u989d", (String)"PurFiServiceImpl_12", (String)"scmc-pm-mservice", (Object[])new Object[0]), "totalallamount", ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"PurFiServiceImpl_8", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                        this.trackLogWarnByBigDecimal(bill, payEntry, "paidamount", ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212.\u5df2\u4ed8\u91d1\u989d", (String)"PurFiServiceImpl_13", (String)"scmc-pm-mservice", (Object[])new Object[0]), "payamount", ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212.\u4ed8\u6b3e\u91d1\u989d", (String)"PurFiServiceImpl_14", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                        isUpdate = true;
                        continue block1;
                    }
                    continue;
                }
                log.info("isWriteBack validation is failer,not update:" + paramMap);
            }
            if (!isUpdate) continue;
            updateList.add(bill);
            HashMap<String, Object> updateBillData = new HashMap<String, Object>(4);
            updateBillData.put("id", id);
            updateBillData.put("billno", billNo);
            updateBillDatas.add(updateBillData);
        }
        trackLog.info("pm_purorderbill(load) -> " + DealServiceParamHelper.serialization(loadBillDatas) + ";(update) -> " + DealServiceParamHelper.serialization(updateBillDatas));
        return this.savePurOrderbill(updateList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> batchUpdatePayPlanJoinAmount(Map<Long, List<Map<String, Object>>> billIDMap) {
        if (DealServiceParamHelper.isNullValue(billIDMap)) {
            log.info("param exception mainbillid(pm_purorderbill) is null");
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_PARAM_MAINBILLID_ISNULL);
        }
        StringBuilder selectField = new StringBuilder();
        selectField.append("id").append(',').append("billno").append(',').append("supplier").append(',').append("totalallamount").append(',').append("paidallamount").append(',').append("paidpreallamount").append(',').append("purbillentry_pay").append('.').append("seq").append(',').append("purbillentry_pay").append('.').append("payamount").append(',').append("purbillentry_pay").append('.').append("paidamount").append(',').append("purbillentry_pay").append('.').append("joinpayamount").append(',').append("billentry").append('.').append("entrysettleorg");
        Set<Long> ids = billIDMap.keySet();
        int size = ids.size();
        HashSet<String> keys = new HashSet<String>(size);
        for (Long l : ids) {
            keys.add("wbpo#" + String.valueOf(l));
        }
        List dLocks = LockHelper.createDLocks(keys, (boolean)true);
        try {
            LockHelper.tryDLocks((List)dLocks, (Long)60000L);
            if (size <= 100) {
                Map<String, Object> map = this.updatePayPlanJoinAmount(billIDMap, selectField, ids);
                return map;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
            hashMap.put(SUCCESS, Boolean.TRUE);
            StringBuilder msg = new StringBuilder();
            ArrayList<Long> idList = new ArrayList<Long>(ids);
            while (!idList.isEmpty()) {
                Map<String, Object> subResult;
                HashSet<Long> subIds = new HashSet<Long>(100);
                while (!idList.isEmpty() && subIds.size() < 100) {
                    Long next = (Long)idList.get(0);
                    subIds.add(next);
                    idList.remove(next);
                }
                if (DealServiceParamHelper.isNullValue(subIds) || (subResult = this.updatePayPlanJoinAmount(billIDMap, selectField, subIds)) == null) continue;
                if (!((Boolean)subResult.get(SUCCESS)).booleanValue()) {
                    msg.append(subResult.get(MESSAGE));
                    continue;
                }
                hashMap.putAll(subResult);
            }
            HashMap<String, Object> hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            LockHelper.unDLocks((List)dLocks);
        }
    }

    private Map<String, Object> updatePayPlanJoinAmount(Map<Long, List<Map<String, Object>>> billIDMap, StringBuilder selectField, Set<Long> ids) {
        QFilter q = new QFilter("id", "in", ids);
        QFilter[] qFilters = new QFilter[]{q};
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)selectField.toString(), (QFilter[])qFilters);
        if (bills == null || bills.length == 0) {
            log.info("mainbillid(pm_purorderbill) no exist in database :" + ids);
            return DealServiceParamHelper.buildResult(Boolean.FALSE, this.ERROR_MAINBILLID_DATABASE_NOT_EXIST);
        }
        int length = bills.length;
        ArrayList loadBillDatas = new ArrayList(length);
        ArrayList updateBillDatas = new ArrayList(length);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(bills.length);
        for (DynamicObject bill : bills) {
            Long id = (Long)bill.getPkValue();
            String billNo = bill.getString("billno");
            HashMap<String, Object> loadBillData = new HashMap<String, Object>(4);
            loadBillData.put("id", id);
            loadBillData.put("billno", billNo);
            loadBillDatas.add(loadBillData);
            List<Map<String, Object>> paramList = billIDMap.get(id);
            if (DealServiceParamHelper.isNullValue(paramList)) continue;
            boolean isUpdate = false;
            block1: for (Map<String, Object> paramMap : paramList) {
                if (DealServiceParamHelper.isNullValue(paramMap.get(KEY_MAINBILLENTRYID))) {
                    log.info("param validation failer, not update: mainbillentryid is null");
                    continue;
                }
                Long mainBillEntryID = (Long)paramMap.get(KEY_MAINBILLENTRYID);
                BigDecimal amount = DealServiceParamHelper.getNotNullBigDecimal(paramMap.get(KEY_AMOUNT));
                if (ZERO.compareTo(amount) == 0) {
                    log.info("param validation failer, not update: amount is null or 0");
                    continue;
                }
                if (this.isWriteBack(paramMap, bill, null)) {
                    DynamicObjectCollection payEntrys = bill.getDynamicObjectCollection("purbillentry_pay");
                    for (DynamicObject payEntry : payEntrys) {
                        if (!mainBillEntryID.equals(payEntry.getPkValue())) continue;
                        BigDecimal oldPaidAllAmount = DealServiceParamHelper.getNotNullBigDecimal(bill.get("paidallamount"));
                        BigDecimal oldPaidPreAllAmount = DealServiceParamHelper.getNotNullBigDecimal(bill.get("paidpreallamount"));
                        BigDecimal oldPaidAmount = DealServiceParamHelper.getNotNullBigDecimal(payEntry.get("paidamount"));
                        BigDecimal oldJoinPaidAmount = DealServiceParamHelper.getNotNullBigDecimal(payEntry.get("joinpayamount"));
                        bill.set("paidallamount", (Object)oldPaidAllAmount.add(amount));
                        bill.set("paidpreallamount", (Object)oldPaidPreAllAmount.add(amount));
                        payEntry.set("paidamount", (Object)oldPaidAmount.add(amount));
                        payEntry.set("joinpayamount", (Object)oldJoinPaidAmount.add(amount));
                        this.trackLogWarnByBigDecimal(bill, null, "paidallamount", ResManager.loadKDString((String)"\u5df2\u4ed8\u91d1\u989d", (String)"PurFiServiceImpl_7", (String)"scmc-pm-mservice", (Object[])new Object[0]), "totalallamount", ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"PurFiServiceImpl_8", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                        this.trackLogWarnByBigDecimal(bill, null, "paidpreallamount", ResManager.loadKDString((String)"\u5df2\u9884\u4ed8\u91d1\u989d", (String)"PurFiServiceImpl_12", (String)"scmc-pm-mservice", (Object[])new Object[0]), "totalallamount", ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"PurFiServiceImpl_8", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                        this.trackLogWarnByBigDecimal(bill, payEntry, "paidamount", ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212.\u5df2\u4ed8\u91d1\u989d", (String)"PurFiServiceImpl_13", (String)"scmc-pm-mservice", (Object[])new Object[0]), "payamount", ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212.\u4ed8\u6b3e\u91d1\u989d", (String)"PurFiServiceImpl_14", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                        this.trackLogWarnByBigDecimal(bill, payEntry, "joinpayamount", ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212.\u5173\u8054\u4ed8\u6b3e\u91d1\u989d", (String)"PurFiServiceImpl_10", (String)"scmc-pm-mservice", (Object[])new Object[0]), "payamount", ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212.\u4ed8\u6b3e\u91d1\u989d", (String)"PurFiServiceImpl_14", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                        isUpdate = true;
                        continue block1;
                    }
                    continue;
                }
                log.info("isWriteBack validation is failer,not update:" + paramMap);
            }
            if (!isUpdate) continue;
            updateList.add(bill);
            HashMap<String, Object> updateBillData = new HashMap<String, Object>(4);
            updateBillData.put("id", id);
            updateBillData.put("billno", billNo);
            updateBillDatas.add(updateBillData);
        }
        trackLog.info("pm_purorderbill(load) -> " + DealServiceParamHelper.serialization(loadBillDatas) + ";(update) -> " + DealServiceParamHelper.serialization(updateBillDatas));
        return this.savePurOrderbill(updateList);
    }

    private Map<String, Object> savePurOrderbill(List<DynamicObject> updateList) {
        if (DealServiceParamHelper.isNullValue(updateList)) {
            return DealServiceParamHelper.buildResult(Boolean.TRUE, ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u53cd\u5199\u91c7\u8d2d\u8ba2\u5355\u6761\u4ef6\u3002", (String)"PurFiServiceImpl_15", (String)"scmc-pm-mservice", (Object[])new Object[0]));
        }
        SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        log.info("pm_purorderbill update success");
        return DealServiceParamHelper.buildResult(Boolean.TRUE, ResManager.loadKDString((String)"\u53cd\u5199\u91c7\u8d2d\u8ba2\u5355\u6210\u529f\u3002", (String)"PurFiServiceImpl_16", (String)"scmc-pm-mservice", (Object[])new Object[0]));
    }

    private boolean isWriteBack(Map<String, Object> paramMap, DynamicObject bill, Long mainBillEntryID) {
        Long settleOrgID = (Long)paramMap.get(KEY_SETTLEORGID);
        Long entrySettleOrgIDValue = this.getEntrySettleOrgID(bill, mainBillEntryID);
        return entrySettleOrgIDValue != null && settleOrgID != null && settleOrgID.equals(entrySettleOrgIDValue);
    }

    private Long getEntrySettleOrgID(DynamicObject bill, Long mainBillEntryID) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        Long settleOrgID = null;
        for (DynamicObject entry : entrys) {
            if (entry == null || mainBillEntryID != null && !mainBillEntryID.equals(entry.getPkValue())) continue;
            settleOrgID = entry.get("entrysettleorg") instanceof DynamicObject ? (Long)entry.getDynamicObject("entrysettleorg").getPkValue() : null;
            break;
        }
        return settleOrgID;
    }

    private void trackLogWarnByBigDecimal(DynamicObject bill, DynamicObject entry, String wbBigDecimal, String wbFieldName, String bigDecimal, String fieldName) {
        StringBuilder result = new StringBuilder();
        if (bill != null && StringUtils.isNotBlank((CharSequence)wbBigDecimal) && StringUtils.isNotBlank((CharSequence)bigDecimal)) {
            if (entry != null) {
                BigDecimal wbBigDecimalV = DealServiceParamHelper.getNotNullBigDecimal(entry.get(wbBigDecimal));
                BigDecimal bigDecimalV = DealServiceParamHelper.getNotNullBigDecimal(entry.get(bigDecimal));
                if (wbBigDecimalV.compareTo(ZERO) < 0) {
                    result.append(ResManager.loadKDString((String)"\u8b66\u544a\u539f\u56e0\uff1a", (String)"PurFiServiceImpl_17", (String)"scmc-pm-mservice", (Object[])new Object[0])).append('\n').append(ResManager.loadKDString((String)"\u53cd\u5199\u5b57\u6bb5", (String)"PurFiServiceImpl_18", (String)"scmc-pm-mservice", (Object[])new Object[0])).append("\u3010 ").append(wbFieldName).append("\u3011").append(ResManager.loadKDString((String)"\u53cd\u5199\u540e\u7684\u5b57\u6bb5\u503c\u4e3a\uff1a", (String)"PurFiServiceImpl_19", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(wbBigDecimalV).append("\uff0c").append(ResManager.loadKDString((String)"\u5c0f\u4e8e\u96f6\u3002 ", (String)"PurFiServiceImpl_20", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u53d1\u751f\u8b66\u544a\u7684\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5\uff08pm_purorderbill\uff09-> ", (String)"PurFiServiceImpl_21", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7 \uff1a", (String)"PurFiServiceImpl_22", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(bill.getString("billno")).append("\uff0c").append(ResManager.loadKDString((String)"\u5206\u5f55\u5e8f\u53f7\uff1a", (String)"PurFiServiceImpl_23", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(entry.getInt("seq")).append("\uff0c").append(ResManager.loadKDString((String)"\u5355\u636eID\uff1a", (String)"PurFiServiceImpl_24", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(bill.getPkValue()).append("\uff0c").append(ResManager.loadKDString((String)"\u5206\u5f55ID\uff1a", (String)"PurFiServiceImpl_25", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(entry.getPkValue());
                    trackLog.warn(result.toString());
                } else if (wbBigDecimalV.compareTo(bigDecimalV.multiply(MULTIPLE)) > 0) {
                    result.append(ResManager.loadKDString((String)"\u8b66\u544a\u539f\u56e0\uff1a", (String)"PurFiServiceImpl_17", (String)"scmc-pm-mservice", (Object[])new Object[0])).append('\n').append(ResManager.loadKDString((String)"\u53cd\u5199\u5b57\u6bb5", (String)"PurFiServiceImpl_18", (String)"scmc-pm-mservice", (Object[])new Object[0])).append("\u3010 ").append(wbFieldName).append("\u3011").append(ResManager.loadKDString((String)"\u53cd\u5199\u540e\u7684\u5b57\u6bb5\u503c\u4e3a\uff1a", (String)"PurFiServiceImpl_19", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(wbBigDecimalV).append("\uff0c").append(ResManager.loadKDString((String)"\u5927\u4e8e\u5355\u636e\u5b57\u6bb5", (String)"PurFiServiceImpl_26", (String)"scmc-pm-mservice", (Object[])new Object[0])).append("\u3010 ").append(fieldName).append("\u3011").append(ResManager.loadKDString((String)"\u5b57\u6bb5\u503c\u4e3a\uff1a", (String)"PurFiServiceImpl_27", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(bigDecimalV).append("\u3002").append(ResManager.loadKDString((String)"\u53d1\u751f\u8b66\u544a\u7684\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5\uff08pm_purorderbill\uff09", (String)"PurFiServiceImpl_31", (String)"scmc-pm-mservice", (Object[])new Object[0])).append("-> ").append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7 \uff1a", (String)"PurFiServiceImpl_22", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(bill.getString("billno")).append("\uff0c").append(ResManager.loadKDString((String)"\u5206\u5f55\u5e8f\u53f7\uff1a", (String)"PurFiServiceImpl_23", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(entry.getInt("seq")).append("\uff0c").append(ResManager.loadKDString((String)"\u5355\u636eID\uff1a", (String)"PurFiServiceImpl_24", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(bill.getPkValue()).append("\uff0c").append(ResManager.loadKDString((String)"\u5206\u5f55ID\uff1a", (String)"PurFiServiceImpl_25", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(entry.getPkValue());
                    trackLog.warn(result.toString());
                }
            } else {
                BigDecimal wbBigDecimalV = DealServiceParamHelper.getNotNullBigDecimal(bill.get(wbBigDecimal));
                BigDecimal bigDecimalV = DealServiceParamHelper.getNotNullBigDecimal(bill.get(bigDecimal));
                if (wbBigDecimalV.compareTo(ZERO) < 0) {
                    result.append(ResManager.loadKDString((String)"\u8b66\u544a\u539f\u56e0\uff1a", (String)"PurFiServiceImpl_17", (String)"scmc-pm-mservice", (Object[])new Object[0])).append('\n').append(ResManager.loadKDString((String)"\u53cd\u5199\u5b57\u6bb5", (String)"PurFiServiceImpl_18", (String)"scmc-pm-mservice", (Object[])new Object[0])).append("\u3010 ").append(wbFieldName).append("\u3011").append(ResManager.loadKDString((String)"\u53cd\u5199\u540e\u7684\u5b57\u6bb5\u503c\u4e3a\uff1a", (String)"PurFiServiceImpl_19", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(wbBigDecimalV).append("\uff0c").append(ResManager.loadKDString((String)"\u5c0f\u4e8e\u96f6\u3002 ", (String)"PurFiServiceImpl_20", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u53d1\u751f\u8b66\u544a\u7684\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5\uff08pm_purorderbill\uff09-> ", (String)"PurFiServiceImpl_21", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7 \uff1a", (String)"PurFiServiceImpl_22", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(bill.getString("billno")).append("\uff0c").append(ResManager.loadKDString((String)"\u5355\u636eID\uff1a", (String)"PurFiServiceImpl_24", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(bill.getPkValue());
                    trackLog.warn(result.toString());
                } else if (wbBigDecimalV.compareTo(bigDecimalV.multiply(MULTIPLE)) > 0) {
                    result.append(ResManager.loadKDString((String)"\u8b66\u544a\u539f\u56e0\uff1a", (String)"PurFiServiceImpl_17", (String)"scmc-pm-mservice", (Object[])new Object[0])).append('\n').append(ResManager.loadKDString((String)"\u53cd\u5199\u5b57\u6bb5", (String)"PurFiServiceImpl_18", (String)"scmc-pm-mservice", (Object[])new Object[0])).append("\u3010 ").append(wbFieldName).append("\u3011").append(ResManager.loadKDString((String)"\u53cd\u5199\u540e\u7684\u5b57\u6bb5\u503c\u4e3a\uff1a", (String)"PurFiServiceImpl_19", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(wbBigDecimalV).append("\uff0c").append(ResManager.loadKDString((String)"\u5927\u4e8e\u5355\u636e\u5b57\u6bb5", (String)"PurFiServiceImpl_26", (String)"scmc-pm-mservice", (Object[])new Object[0])).append("\u3010 ").append(fieldName).append("\u3011").append(ResManager.loadKDString((String)"\u5b57\u6bb5\u503c\u4e3a\uff1a", (String)"PurFiServiceImpl_27", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(bigDecimalV).append("\u3002").append(ResManager.loadKDString((String)"\u53d1\u751f\u8b66\u544a\u7684\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5\uff08pm_purorderbill\uff09", (String)"PurFiServiceImpl_31", (String)"scmc-pm-mservice", (Object[])new Object[0])).append("-> ").append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7 \uff1a", (String)"PurFiServiceImpl_22", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(bill.getString("billno")).append("\uff0c").append(ResManager.loadKDString((String)"\u5355\u636eID\uff1a", (String)"PurFiServiceImpl_24", (String)"scmc-pm-mservice", (Object[])new Object[0])).append(bill.getPkValue());
                    trackLog.warn(result.toString());
                }
            }
        }
    }
}

