/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.business.helper.botp.PurOrderDefValueHelper;
import kd.mpscmm.msbd.business.service.TrackLogService;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.business.helper.AttachmentHelper;
import kd.scmc.pm.business.pojo.InvokeResult;
import kd.scmc.pm.mservice.api.PurOrderService;

public class PurOrderServiceImpl
implements PurOrderService {
    private static final Log LOGGER = LogFactory.getLog(PurOrderServiceImpl.class);
    private static final TrackLogService trackLog = new TrackLogService(PurOrderServiceImpl.class, "pm");

    public List<DynamicObject> batchSetPODefValue(List<DynamicObject> bills) {
        List batchSetPurOrderDefValue = PurOrderDefValueHelper.batchSetPurOrderDefValue(bills);
        return batchSetPurOrderDefValue;
    }

    public String changeOrderBillPromiseDate(Map<String, Object> parameter) throws Exception {
        trackLog.startInfo(SerializationUtils.toJsonString(parameter));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("pur order promise date service in parameter-->{}", parameter);
        }
        try {
            InvokeResult checkQuotaCalculate = this.checkProsiseParameter(parameter);
            if (!checkQuotaCalculate.isSuccess()) {
                return SerializationUtils.toJsonString((Object)checkQuotaCalculate);
            }
        }
        catch (Exception e) {
            String expMsg = String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u6539\u53d8\u201c\u627f\u8bfa\u65e5\u671f\u201c\u670d\u52a1\u8bf7\u6c42\u53c2\u6570\u4e2d\uff0c\u5b58\u5728\u5982\u4e0b\u5f02\u5e38\uff1a%s\u3002", (String)"PurOrderServiceImpl_0", (String)"scmc-pm-mservice", (Object[])new Object[0]), Arrays.toString(e.getStackTrace()));
            LOGGER.error(expMsg);
            trackLog.endInfo(expMsg);
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)expMsg));
        }
        List parameterObject = (List)parameter.get("batchBills");
        HashSet billIds = new HashSet(16);
        parameterObject.forEach(entity -> billIds.add((Long)entity.get("orderBillId")));
        String selectProperties = "id,billentry.id,billentry.promisedate";
        DynamicObject[] orderArray = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)selectProperties, (QFilter[])new QFilter("id", "in", billIds).toArray());
        billIds.clear();
        if (orderArray.length <= 0) {
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u5355\u636e\uff0c\u8bf7\u68c0\u67e5\u4f20\u9012\u7684\u8ba2\u5355ID\u53c2\u6570\u3002", (String)"PurOrderServiceImpl_1", (String)"scmc-pm-mservice", (Object[])new Object[0])));
        }
        SimpleDateFormat shortFomate = new SimpleDateFormat("yyyy-MM-dd");
        for (DynamicObject bill : orderArray) {
            Long id = (Long)bill.getPkValue();
            for (Map xxdto : parameterObject) {
                Long parameterId = (Long)xxdto.get("orderBillId");
                List xxdtoEntry = (List)xxdto.get("billEntry");
                if (!id.equals(parameterId)) continue;
                DynamicObjectCollection rows = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject row : rows) {
                    Long entryId = (Long)row.getPkValue();
                    for (Map xxdtoentry : xxdtoEntry) {
                        Long parameterEntryId = (Long)xxdtoentry.get("entryId");
                        if (!entryId.equals(parameterEntryId)) continue;
                        row.set("promisedate", (Object)shortFomate.parse(xxdtoentry.get("promiseDate").toString()));
                    }
                }
            }
        }
        SaveServiceHelper.update((DynamicObject[])orderArray);
        String successResult = SerializationUtils.toJsonString((Object)InvokeResult.success());
        trackLog.endInfo(successResult);
        return successResult;
    }

    public String changeOrderBillAttachment(String parameter) throws Exception {
        trackLog.startInfo(parameter);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("pur order attachment  service in parameter-->{}", (Object)parameter);
        }
        try {
            InvokeResult checkQuotaCalculate = this.checkAttachmentParameter(parameter);
            if (!checkQuotaCalculate.isSuccess()) {
                return SerializationUtils.toJsonString((Object)checkQuotaCalculate);
            }
        }
        catch (Exception e) {
            String expMsg = String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u540c\u6b65\u201c\u9644\u4ef6\u201d\u670d\u52a1\u8bf7\u6c42\u53c2\u6570\u5b58\u5728\u5f02\u5e38\uff1a%s\u3002", (String)"PurOrderServiceImpl_2", (String)"scmc-pm-mservice", (Object[])new Object[0]), Arrays.toString(e.getStackTrace()));
            LOGGER.error(expMsg);
            trackLog.endInfo(expMsg);
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)expMsg));
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)parameter, Map.class);
        Long orderBillId = (Long)map.get("orderBillId");
        List attachmentList = (List)map.get("attachmentList");
        String type = (String)map.get("type");
        try (TXHandle tx = TX.requiresNew((String)PurOrderServiceImpl.class.getName());){
            try {
                if ("A".equals(type)) {
                    for (Map attachment : attachmentList) {
                        String uid = (String)attachment.get("uid");
                        String name = (String)attachment.get("name");
                        Integer size = (Integer)attachment.get("size");
                        String url = (String)attachment.get("url");
                        AttachmentHelper.bindAttachmentFile((String)"pm_purorderbill", (String)"supplierattachmentpanel", (Object)orderBillId, (String)uid, (String)name, (int)size, (String)url);
                    }
                } else if ("B".equals(type)) {
                    List uidList = attachmentList.stream().map(row -> row.get("uid")).collect(Collectors.toList());
                    AttachmentHelper.deleteAttachmentFile((String)"pm_purorderbill", (Object)orderBillId, uidList);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                String expMsg = String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u53d8\u66f4\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a%s\u3002", (String)"PurOrderServiceImpl_3", (String)"scmc-pm-mservice", (Object[])new Object[0]), Arrays.toString(e.getStackTrace()));
                trackLog.endInfo(expMsg);
                LOGGER.error(expMsg);
                String string = SerializationUtils.toJsonString((Object)InvokeResult.failure((String)expMsg));
                if (tx != null) {
                    if (var7_9 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var7_9.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return string;
            }
        }
        String successResult = SerializationUtils.toJsonString((Object)InvokeResult.success());
        trackLog.endInfo(successResult);
        return successResult;
    }

    private InvokeResult checkAttachmentParameter(String parameter) {
        if (parameter == null || "".equals(parameter)) {
            return InvokeResult.failure((String)ResManager.loadKDString((String)"\u8ba2\u5355\u540c\u6b65\u4f9b\u5e94\u5546\u9644\u4ef6\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PurOrderServiceImpl_4", (String)"scmc-pm-mservice", (Object[])new Object[0]));
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)parameter, Map.class);
        Long orderBillId = (Long)map.get("orderBillId");
        if (orderBillId == null) {
            return InvokeResult.failure((String)ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u91c7\u8d2d\u8ba2\u5355ID\u3002", (String)"PurOrderServiceImpl_5", (String)"scmc-pm-mservice", (Object[])new Object[0]));
        }
        List attachmentList = (List)map.get("attachmentList");
        String type = (String)map.get("type");
        if ("A".equals(type)) {
            for (Map attachment : attachmentList) {
                String uid = (String)attachment.get("uid");
                if (uid == null || "".equals(uid)) {
                    return InvokeResult.failure((String)ResManager.loadKDString((String)"\u540c\u6b65\u4f9b\u5e94\u5546\u9644\u4ef6\u65f6\uff0c\u9644\u4ef6\u5217\u8868uid\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PurOrderServiceImpl_6", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                }
                String name = (String)attachment.get("name");
                if (name == null || "".equals(name)) {
                    return InvokeResult.failure((String)ResManager.loadKDString((String)"\u540c\u6b65\u4f9b\u5e94\u5546\u9644\u4ef6\uff0c\u9644\u4ef6\u5217\u8868name\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PurOrderServiceImpl_7", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                }
                Integer size = (Integer)attachment.get("size");
                if (size == null) {
                    return InvokeResult.failure((String)ResManager.loadKDString((String)"\u540c\u6b65\u4f9b\u5e94\u5546\u9644\u4ef6\u65f6\uff0c\u9644\u4ef6\u5217\u8868size\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PurOrderServiceImpl_8", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                }
                String url = (String)attachment.get("url");
                if (url != null && !"".equals(url)) continue;
                return InvokeResult.failure((String)ResManager.loadKDString((String)"\u540c\u6b65\u4f9b\u5e94\u5546\u9644\u4ef6\uff0c\u9644\u4ef6\u5217\u8868url\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PurOrderServiceImpl_9", (String)"scmc-pm-mservice", (Object[])new Object[0]));
            }
        } else if ("B".equals(type)) {
            for (Map attachment : attachmentList) {
                String uid = (String)attachment.get("uid");
                if (uid != null && !"".equals(uid)) continue;
                return InvokeResult.failure((String)ResManager.loadKDString((String)"\u9644\u4ef6\u5217\u8868uid\u53c2\u6570\u4e3a\u7a7a\u65f6\u4e0d\u80fd\u5220\u9664\u3002", (String)"PurOrderServiceImpl_10", (String)"scmc-pm-mservice", (Object[])new Object[0]));
            }
        } else {
            return InvokeResult.failure((String)ResManager.loadKDString((String)"\u9644\u4ef6\u4e0d\u5728\u65b0\u589e\u548c\u5220\u9664\u7c7b\u578b\u4e2d\uff0c\u8bf7\u68c0\u6d4btpye\u7684\u679a\u4e3e\u8303\u56f4\u3002", (String)"PurOrderServiceImpl_16", (String)"scmc-pm-mservice", (Object[])new Object[0]));
        }
        return InvokeResult.success();
    }

    private InvokeResult checkProsiseParameter(Map<String, Object> parameter) {
        SimpleDateFormat shortFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (parameter == null) {
            return InvokeResult.failure((String)ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u6539\u53d8\u201c\u627f\u8bfa\u65e5\u671f\u201d\u670d\u52a1\u8bf7\u6c42\u53c2\u6570\u4e2d\uff0c\u201c\u627f\u8bfa\u65e5\u671f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PurOrderServiceImpl_11", (String)"scmc-pm-mservice", (Object[])new Object[0]));
        }
        List parameterList = (List)parameter.get("batchBills");
        for (Map orderBill : parameterList) {
            Long orderBillId = (Long)orderBill.get("orderBillId");
            if (orderBillId == null) {
                return InvokeResult.failure((String)ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u91c7\u8d2d\u8ba2\u5355ID\u3002", (String)"PurOrderServiceImpl_5", (String)"scmc-pm-mservice", (Object[])new Object[0]));
            }
            List billEntry = (List)orderBill.get("billEntry");
            if (billEntry == null || billEntry.size() == 0) {
                return InvokeResult.failure((String)ResManager.loadKDString((String)"key\u503c\uff1abillEntry\u7684\u53c2\u6570\u65f6\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u60a8\u6309\u7167\u63a5\u53e3\u89c4\u8303\u8bf7\u6c42\u53c2\u6570\u3002", (String)"PurOrderServiceImpl_12", (String)"scmc-pm-mservice", (Object[])new Object[0]));
            }
            for (Map orderBillEntry : billEntry) {
                String promiseDate = (String)orderBillEntry.get("promiseDate");
                if (promiseDate == null) {
                    return InvokeResult.failure((String)ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u627f\u8bfa\u65e5\u671f\u3002", (String)"PurOrderServiceImpl_13", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                }
                try {
                    shortFormat.parse(promiseDate);
                }
                catch (ParseException e) {
                    LOGGER.error(e.getMessage());
                    return InvokeResult.failure((String)ResManager.loadKDString((String)"\u8bf7\u6309\u7167\u4ee5\u4e0b\u683c\u5f0f\u8f93\u5165\u627f\u8bfa\u65e5\u671f\u53c2\u6570\uff1ayyyy-MM-dd\u3002", (String)"PurOrderServiceImpl_14", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                }
                Long entryId = (Long)orderBillEntry.get("entryId");
                if (entryId != null) continue;
                return InvokeResult.failure((String)ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u91c7\u8d2d\u8ba2\u5355\u5206\u5f55ID\u3002", (String)"PurOrderServiceImpl_15", (String)"scmc-pm-mservice", (Object[])new Object[0]));
            }
        }
        return InvokeResult.success();
    }

    public Map<Long, Map<String, Object>> queryPOQty(List<Long> poBillentryIds) {
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(10);
        if (CommonUtils.isNull(poBillentryIds)) {
            return result;
        }
        HashSet<Long> entryIdSet = new HashSet<Long>(poBillentryIds);
        QFilter poEntryPkFilter = new QFilter("billentry.id", "in", entryIdSet);
        DataSet rows = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pm_purorderbill", (String)"billentry.material.masterid as materialmasterid,billentry.baseunit as baseunitid,billentry.baseqty as baseqty,billentry.receivebaseqtyup as receivebaseqtyup,id,billentry.id as entryid", (QFilter[])new QFilter[]{poEntryPkFilter}, null);
        for (Row row : rows) {
            Long materialId = row.getLong("materialmasterid");
            Long baseunitId = row.getLong("baseunitid");
            BigDecimal receivebaseqtyup = row.getBigDecimal("receivebaseqtyup");
            Long entryid = row.getLong("entryid");
            if (receivebaseqtyup == null || receivebaseqtyup.compareTo(BigDecimal.ZERO) == 0) {
                receivebaseqtyup = row.getBigDecimal("baseqty");
            }
            HashMap<String, Number> map = new HashMap<String, Number>(5);
            map.put("materialmasterid", materialId);
            map.put("baseunitid", baseunitId);
            map.put("receivebaseqtyup", receivebaseqtyup);
            result.put(entryid, map);
        }
        return result;
    }

    public List<Map<String, Object>> queryOverPayParamAndAmount(Map<Long, Set<Long>> poidAndEntryIdMap) {
        QFilter poidFilter;
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        LOGGER.info(ResManager.loadKDString((String)"\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u8d85\u989d\u4ed8\u6b3e\u53c2\u6570 \u5165\u53c2\u4e3a\uff1a", (String)"PurOrderServiceImpl_17", (String)"scmc-pm-mservice", (Object[])new Object[0]) + poidAndEntryIdMap);
        if (CommonUtils.isNull(poidAndEntryIdMap)) {
            return result;
        }
        ArrayList<Long> hasNoEntryIdPoIds = new ArrayList<Long>(10);
        HashMap<Long, Set<Long>> hasEntryIdAndPoIdMap = new HashMap<Long, Set<Long>>(10);
        for (Map.Entry<Long, Set<Long>> entry : poidAndEntryIdMap.entrySet()) {
            Long poId = entry.getKey();
            if (poId == null || poId.compareTo(0L) == 0) continue;
            Set<Long> poEntryIds = entry.getValue();
            if (poEntryIds == null || poEntryIds.isEmpty()) {
                hasNoEntryIdPoIds.add(poId);
                continue;
            }
            hasEntryIdAndPoIdMap.put(poId, poEntryIds);
        }
        poidAndEntryIdMap = null;
        LOGGER.info(ResManager.loadKDString((String)"\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u8d85\u989d\u4ed8\u6b3e\u53c2\u6570 \u65e0\u5206\u5f55id\u4e3a\uff1a", (String)"PurOrderServiceImpl_18", (String)"scmc-pm-mservice", (Object[])new Object[0]) + hasNoEntryIdPoIds);
        LOGGER.info(ResManager.loadKDString((String)"\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u8d85\u989d\u4ed8\u6b3e\u53c2\u6570 \u6709\u5206\u5f55id\u4e3a\uff1a", (String)"PurOrderServiceImpl_19", (String)"scmc-pm-mservice", (Object[])new Object[0]) + hasEntryIdAndPoIdMap);
        if ((hasNoEntryIdPoIds == null || hasNoEntryIdPoIds.isEmpty()) && (hasEntryIdAndPoIdMap == null || hasEntryIdAndPoIdMap.isEmpty())) {
            return result;
        }
        DataSet dataSet = null;
        if (hasNoEntryIdPoIds != null && !hasNoEntryIdPoIds.isEmpty()) {
            poidFilter = new QFilter("id", "in", hasNoEntryIdPoIds);
            dataSet = this.queryPoDataSet(poidFilter, null);
        }
        if (hasEntryIdAndPoIdMap != null && !hasEntryIdAndPoIdMap.isEmpty()) {
            poidFilter = new QFilter("id", "in", hasEntryIdAndPoIdMap.keySet());
            DataSet hasEntryIdDataSet = this.queryPoDataSet(poidFilter, this.getHasEntryIdFilter(hasEntryIdAndPoIdMap));
            dataSet = dataSet != null ? dataSet.union(hasEntryIdDataSet).orderBy(new String[]{"id"}) : hasEntryIdDataSet;
        }
        result = this.addPoInfo(result, dataSet);
        result = this.addConmInfo(result);
        return result;
    }

    private List<Map<String, Object>> addConmInfo(List<Map<String, Object>> result) {
        if (result == null || result.isEmpty()) {
            return result;
        }
        Set<Long> conmEntryIds = this.getConmEntryId(result);
        if (conmEntryIds.isEmpty()) {
            return result;
        }
        Map<Long, Map<String, Object>> conmInfo = this.getConmInfo(conmEntryIds);
        if (conmInfo.isEmpty()) {
            return result;
        }
        for (Map<String, Object> billInfo : result) {
            List entryinfoList = (List)billInfo.get("entryinfo");
            if (entryinfoList == null || entryinfoList.isEmpty()) continue;
            for (Map row : entryinfoList) {
                Map<String, Object> map;
                Object conbillentryid;
                if (row == null || !((conbillentryid = row.get("conbillentryid")) instanceof Long) || (map = conmInfo.get(conbillentryid)) == null) continue;
                row.putAll(map);
            }
        }
        return result;
    }

    private Map<Long, Map<String, Object>> getConmInfo(Set<Long> conmEntryIds) {
        HashMap<Long, Map<String, Object>> conmInfo = new HashMap<Long, Map<String, Object>>(10);
        DataSet idDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"conm_purcontract", (String)"id", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", conmEntryIds)}, null);
        HashSet idSet = new HashSet(10);
        idDataSet.forEach(row -> idSet.add(row.getLong("id")));
        if (idSet.isEmpty()) {
            return conmInfo;
        }
        DataSet entryDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"conm_purcontract", (String)"id,billentry.id as entryid,billentry.entrysettleorg as entrysettleorg,billentry.amountandtax as amountandtax", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", conmEntryIds)}, null);
        DataSet headDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"conm_purcontract", (String)"id,isallowoverpay,createtime,settlecurrency,invoicesupplier,receivesupplier,billentry.amountandtax as  amountandtax ,billentry.amount as amount", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)}, null);
        HashSet hasPrePayConmId = new HashSet(10);
        QFilter prePayFilter = new QFilter("payentry.isprepay", "=", (Object)Boolean.TRUE);
        DataSet hasPrePayDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"conm_purcontract", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet), prePayFilter}, null);
        hasPrePayDataSet.forEach(row -> hasPrePayConmId.add(row.getLong("id")));
        DataSet sumAmountDataSet = headDataSet.groupBy(new String[]{"id", "isallowoverpay", "settlecurrency", "invoicesupplier", "receivesupplier", "createtime"}).sum("amountandtax").sum("amount").finish().select(new String[]{"id", "createtime", "isallowoverpay", "settlecurrency", "invoicesupplier", "receivesupplier", "amountandtax as sumamountandtax", "amount as sumamount"});
        DataSet finish = entryDataSet.leftJoin(sumAmountDataSet).on("id", "id").select(new String[]{"id as conbillid", "entryid", "entrysettleorg", "amountandtax"}, new String[]{"isallowoverpay", "settlecurrency", "invoicesupplier", "sumamountandtax", "sumamount", "createtime", "receivesupplier"}).finish();
        for (Row row2 : finish) {
            Long entryid = row2.getLong("entryid");
            HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>(13);
            Long conbillid = row2.getLong("conbillid");
            map.put("conbillid", conbillid);
            map.put("conentrysettleorg", row2.getLong("entrysettleorg"));
            map.put("concreatetime", row2.getDate("createtime"));
            map.put("conisallowoverpay", row2.getBoolean("isallowoverpay"));
            map.put("consettlecurrency", row2.getLong("settlecurrency"));
            map.put("coninvoicesupplier", row2.getLong("invoicesupplier"));
            map.put("conreceivesupplier", row2.getLong("receivesupplier"));
            map.put("conamountandtax", row2.getBigDecimal("amountandtax"));
            map.put("consumamountandtax", row2.getBigDecimal("sumamountandtax"));
            map.put("consumamount", row2.getBigDecimal("sumamount"));
            map.put("conhasprepay", hasPrePayConmId.contains(conbillid) ? Boolean.TRUE : Boolean.FALSE);
            conmInfo.put(entryid, map);
        }
        return conmInfo;
    }

    private Set<Long> getConmEntryId(List<Map<String, Object>> result) {
        HashSet<Long> conmEntryIds = new HashSet<Long>(8);
        for (Map<String, Object> billInfo : result) {
            Object entryinfo = billInfo.get("entryinfo");
            if (!(entryinfo instanceof List)) continue;
            List entry = (List)entryinfo;
            for (Map row : entry) {
                Object conbillentryid = row.get("conbillentryid");
                if (!(conbillentryid instanceof Long) || ((Long)conbillentryid).compareTo(0L) == 0) continue;
                conmEntryIds.add((Long)conbillentryid);
            }
        }
        return conmEntryIds;
    }

    private QFilter getHasEntryIdFilter(Map<Long, Set<Long>> hasEntryIdAndPoIdMap) {
        QFilter filter = null;
        if (hasEntryIdAndPoIdMap != null && !hasEntryIdAndPoIdMap.isEmpty()) {
            HashSet<Long> entryIds = new HashSet<Long>(10);
            for (Map.Entry<Long, Set<Long>> entry : hasEntryIdAndPoIdMap.entrySet()) {
                Set<Long> value;
                if (entry == null || (value = entry.getValue()) == null || value.isEmpty()) continue;
                entryIds.addAll(value);
            }
            filter = new QFilter("billentry.id", "in", entryIds);
        }
        return filter;
    }

    private List<Map<String, Object>> addPoInfo(List<Map<String, Object>> result, DataSet dataSet) {
        HashMap billInfos = new HashMap(10);
        for (Row row : dataSet) {
            Long poEntryId;
            Long id = row.getLong("id");
            Boolean isAllowOverPay = row.getBoolean("isallowoverpay") == null ? Boolean.TRUE : row.getBoolean("isallowoverpay");
            Long settleCurrency = row.getLong("settlecurrency");
            Long invoicesupplier = row.getLong("invoicesupplier");
            Long receivesupplier = row.getLong("receivesupplier");
            String billno = row.getString("billno");
            Date createtime = row.getDate("createtime");
            BigDecimal sumPrePayAmount = row.getBigDecimal("sumprepayamount") == null ? BigDecimal.ZERO : row.getBigDecimal("sumprepayamount");
            HashMap<String, Object> billInfo = (HashMap<String, Object>)billInfos.get(id);
            if (billInfo == null) {
                billInfo = new HashMap<String, Object>(10);
                billInfo.put("billid", id);
                billInfo.put("isallowoverpay", isAllowOverPay);
                billInfo.put("settlecurrency", settleCurrency);
                billInfo.put("invoicesupplier", invoicesupplier);
                billInfo.put("receivesupplier", receivesupplier);
                billInfo.put("sumprepayamount", sumPrePayAmount);
                billInfo.put("billno", billno);
                billInfo.put("createtime", createtime);
                billInfo.put("entryinfo", new ArrayList(10));
            }
            if ((poEntryId = row.getLong("entryid")) == null || poEntryId.compareTo(0L) == 0) continue;
            List entryinfoList = (List)billInfo.get("entryinfo");
            HashMap<String, Number> rowInfoMap = new HashMap<String, Number>(10);
            BigDecimal entryAmount = row.getBigDecimal("amount");
            rowInfoMap.put("entryid", poEntryId);
            rowInfoMap.put("settleorg", row.getLong("settleorg"));
            rowInfoMap.put("amount", entryAmount);
            rowInfoMap.put("amountandtax", row.getBigDecimal("amountandtax"));
            rowInfoMap.put("receivebaseqtyup", row.getBigDecimal("receivebaseqtyup"));
            rowInfoMap.put("baseqty", row.getBigDecimal("baseqty"));
            rowInfoMap.put("seq", row.getInteger("seq"));
            Long conbillentryid = row.getLong("conbillentryid");
            if (conbillentryid != null && conbillentryid.compareTo(0L) != 0) {
                rowInfoMap.put("conbillentryid", conbillentryid);
            }
            entryinfoList.add(rowInfoMap);
            billInfos.put(id, billInfo);
        }
        if (billInfos == null || billInfos.isEmpty()) {
            return result;
        }
        result.addAll(billInfos.values());
        return result;
    }

    private DataSet queryPoDataSet(QFilter poidFilter, QFilter poEntryIdFilter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(poidFilter);
        if (poEntryIdFilter != null) {
            filters.add(poEntryIdFilter);
        }
        DataSet poHeadDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pm_purorderbill", (String)"id,isallowoverpay,createtime,receivesupplier,invoicesupplier,settlecurrency,billno", (QFilter[])new QFilter[]{poidFilter}, null);
        QFilter isPrePayFilter = new QFilter("purbillentry_pay.isprepay", "=", (Object)Boolean.TRUE);
        QFilter pretimepointFilter = new QFilter("purbillentry_pay.pretimepoint", "in", (Object)new String[]{"B", " "});
        DataSet poPayPlanDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pm_purorderbill", (String)"id,purbillentry_pay.payamount as prepayamount", (QFilter[])new QFilter[]{poidFilter, isPrePayFilter, pretimepointFilter}, null);
        poPayPlanDataSet = poPayPlanDataSet.groupBy(new String[]{"id"}).sum("prepayamount").finish().select(new String[]{"id", "prepayamount as sumprepayamount"});
        DataSet headAndPrePayAmountDataSet = poHeadDataSet.leftJoin(poPayPlanDataSet).on("id", "id").select(new String[]{"id", "isallowoverpay", "invoicesupplier", "settlecurrency", "billno", "createtime", "receivesupplier"}, new String[]{"sumprepayamount"}).finish();
        DataSet billEntryDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pm_purorderbill", (String)"id,billentry.entrysettleorg as settleorg,billentry.amount as amount,billentry.amountandtax as amountandtax,billentry.baseqty as baseqty,billentry.receivebaseqtyup as receivebaseqtyup,billentry.id as entryid,billentry.seq as seq,billentry.conbillentryid as conbillentryid,billentry.conbillid as conbillid", (QFilter[])filters.toArray(new QFilter[0]), (String)"id");
        DataSet dataSet = headAndPrePayAmountDataSet.rightJoin(billEntryDataSet).on("id", "id").select(new String[]{"entryid", "receivebaseqtyup", "baseqty", "amountandtax", "amount", "settleorg", "seq", "conbillentryid", "conbillid"}, new String[]{"id", "sumprepayamount", "isallowoverpay", "invoicesupplier", "settlecurrency", "billno", "createtime", "receivesupplier"}).finish();
        dataSet = dataSet.orderBy(new String[]{"id"});
        return dataSet;
    }
}

