/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.business.service.TrackLogService;
import kd.mpscmm.msbd.quotamodel.business.helper.QuotaCalHelper;
import kd.scmc.pm.business.helper.QuotaHelper;
import kd.scmc.pm.business.pojo.InvokeResult;
import kd.scmc.pm.business.service.customMSvalidation.CustomMSValidationUtils;
import kd.scmc.pm.business.service.quotamodel.QuotaStrategyImpl;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.QuotaSchemaInParamDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.QuotaSchemaOutParamDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.QuotamsInDetailDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.QuotamsInParamterDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.QuotamsOutParamterDTO;
import kd.scmc.pm.business.service.quotamodel.quotacalculateservice.QuotaCalculateService;
import kd.scmc.pm.enums.EnableStatusEnum;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.mservice.api.QuotaService;

public class QuotaServiceImpl
implements QuotaService {
    private static final TrackLogService trackLog = new TrackLogService(QuotaServiceImpl.class, "pm");
    private static Log log = LogFactory.getLog(QuotaServiceImpl.class);
    private static final int CONTAINER_SIZE = 16;
    private static final String MATERIAL_MASTERID_ID = "material.masterid.id";

    /*
     * Enabled aggressive exception aggregation
     */
    public String invokeQuotaCalculateService(String invokeparamter) {
        trackLog.startInfo(invokeparamter);
        log.info("\u3010\u91c7\u8d2d\u914d\u989d\u8ba1\u7b97\u3011\u670d\u52a1\u7684\u8bf7\u6c42\u7684\u53c2\u6570\u5982\u4e0b  --> " + invokeparamter);
        QuotamsInParamterDTO invokedto = null;
        try {
            invokedto = (QuotamsInParamterDTO)SerializationUtils.fromJsonString((String)invokeparamter, QuotamsInParamterDTO.class);
            InvokeResult checkQuotaCalculate = CustomMSValidationUtils.checkQuotaCalculate((Object)invokedto);
            if (!checkQuotaCalculate.isSuccess()) {
                return SerializationUtils.toJsonString((Object)checkQuotaCalculate);
            }
        }
        catch (Exception e) {
            log.error("\u4f20\u9012\u7684\u8bf7\u6c42\u53c2\u6570\u7684json\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:", (Throwable)e);
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u4f20\u9012\u7684\u8bf7\u6c42\u53c2\u6570\u7684JSON\u6570\u636e\uff0c\u4e0d\u7b26\u5408\u63a5\u53e3\u8981\u6c42\u3002", (String)"QuotaServiceImpl_0", (String)"scmc-pm-mservice", (Object[])new Object[0])));
        }
        String quotaPattern = null;
        try {
            quotaPattern = QuotaHelper.queryQuotaParam();
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        if (StringUtils.isEmpty((CharSequence)quotaPattern) || "A".equals(quotaPattern)) {
            QuotaCalculateService invokeQuotaServiceImpl = QuotaStrategyImpl.invokeQuotaServiceImpl();
            try (InvokeResult invokeMSServiceResult = invokeQuotaServiceImpl.invokeQuotaCalculateMSService(invokedto);){
                String resultjson = SerializationUtils.toJsonString((Object)invokeMSServiceResult);
                trackLog.endInfo(resultjson);
                log.info("\u3010\u91c7\u8d2d\u914d\u989d\u8ba1\u7b97\u3011\u670d\u52a1\u7684\u8fd4\u56de\u4e1a\u52a1\u6570\u636e\u5982\u4e0b  --> " + resultjson);
                String string = resultjson;
                return string;
            }
            catch (Exception e) {
                log.error("\u914d\u989d\u8ba1\u7b97\u8fc7\u7a0b\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:", (Throwable)e);
                String message = e.getMessage() == null ? "null" : e.getMessage();
                return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u914d\u989d\u8ba1\u7b97\u8fc7\u7a0b\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:", (String)"QuotaServiceImpl_1", (String)"scmc-pm-mservice", (Object[])new Object[0]).concat(message)));
            }
        }
        try {
            HashMap<String, Serializable> QuotaCalParam = new HashMap<String, Serializable>(16);
            HashMap dataInfos = new HashMap(16);
            List quotaIndetailLst = invokedto.getBillentry();
            for (int k = 0; k < quotaIndetailLst.size(); ++k) {
                HashMap<String, Object> dataInfo = new HashMap<String, Object>(16);
                dataInfo.put("org", invokedto.getPurchaseOrgId());
                String bizDate = invokedto.getBizDate();
                dataInfo.put("validdate", bizDate);
                dataInfo.put("material", ((QuotamsInDetailDTO)quotaIndetailLst.get(k)).getMaterialId());
                dataInfo.put("baseQty", ((QuotamsInDetailDTO)quotaIndetailLst.get(k)).getSurplusBaseQty());
                dataInfos.put(((QuotamsInDetailDTO)quotaIndetailLst.get(k)).getSrcBillEntryId().toString(), dataInfo);
            }
            QuotaCalParam.put("quotaSchemeID", Long.valueOf(1685415896346223616L));
            QuotaCalParam.put("dataInfos", dataInfos);
            Map quotaRecord = QuotaCalHelper.getQuotaResult(QuotaCalParam);
            String resultjson = null;
            if (((Boolean)quotaRecord.get("success")).booleanValue()) {
                List quotaRecordDetails = (List)quotaRecord.get("quotaRecordDetails");
                ArrayList<QuotamsOutParamterDTO> outParamter = new ArrayList<QuotamsOutParamterDTO>(16);
                for (int m = 0; m < quotaRecordDetails.size(); ++m) {
                    Map quotaCalResultInfos = (Map)((Map)quotaRecordDetails.get(m)).get("quotaCalculateResultInfos");
                    if (quotaCalResultInfos == null || quotaCalResultInfos.size() == 0) continue;
                    for (Map.Entry rank : quotaCalResultInfos.entrySet()) {
                        List quotaCalResultLst = (List)rank.getValue();
                        for (int n = 0; n < quotaCalResultLst.size(); ++n) {
                            Map quotaCalResultMap = (Map)quotaCalResultLst.get(n);
                            Long purchaseOrgId = (Long)quotaCalResultMap.get("org");
                            Long materialId = (Long)quotaCalResultMap.get("material");
                            Long srcBillEntryId = Long.valueOf(((Map)quotaRecordDetails.get(m)).get("dataKey").toString());
                            Long srcBillId = 0L;
                            for (int w = 0; w < quotaIndetailLst.size(); ++w) {
                                if (!((QuotamsInDetailDTO)quotaIndetailLst.get(w)).getSrcBillEntryId().equals(srcBillEntryId)) continue;
                                srcBillId = ((QuotamsInDetailDTO)quotaIndetailLst.get(w)).getSrcBillId();
                            }
                            Long supplierId = (Long)quotaCalResultMap.get("supplier");
                            BigDecimal quotaBaseQty = (BigDecimal)quotaCalResultMap.get("srcAdjustBaseQty");
                            BigDecimal alloctBaseQty = (BigDecimal)quotaCalResultMap.get("quotaedBaseQty");
                            BigDecimal quotaPercentage = (BigDecimal)quotaCalResultMap.get("quotarate");
                            BigDecimal maxbillqty = (BigDecimal)quotaCalResultMap.get("maxBaseQty");
                            BigDecimal minbillqty = (BigDecimal)quotaCalResultMap.get("minBaseQty");
                            BigDecimal packagebatchqty = (BigDecimal)quotaCalResultMap.get("packageBaseQty");
                            Long basetUnitId = (Long)quotaCalResultMap.get("basetUnitId");
                            Long quotaId = (Long)((Map)quotaCalResultLst.get(n)).get("quotaId");
                            QuotamsOutParamterDTO acceptMSResult = QuotamsOutParamterDTO.acceptResult((Long)supplierId, (Long)purchaseOrgId, (Long)materialId, (Long)srcBillId, (Long)srcBillEntryId, (BigDecimal)quotaBaseQty, (Long)basetUnitId, (BigDecimal)alloctBaseQty, (Long)quotaId, (String)quotaPattern, (BigDecimal)quotaPercentage, (BigDecimal)maxbillqty, (BigDecimal)minbillqty, (BigDecimal)packagebatchqty);
                            outParamter.add(acceptMSResult);
                        }
                    }
                }
                resultjson = SerializationUtils.toJsonString((Object)InvokeResult.success(outParamter));
                return resultjson;
            }
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u914d\u989d\u8ba1\u7b97\u8fc7\u7a0b\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:", (String)"QuotaServiceImpl_1", (String)"scmc-pm-mservice", (Object[])new Object[0]).concat(quotaRecord.get("detail").toString())));
        }
        catch (Exception e) {
            log.error("\u914d\u989d\u8ba1\u7b97\u8fc7\u7a0b\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:", (Throwable)e);
            String message = e.getMessage() == null ? "null" : e.getMessage();
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u914d\u989d\u8ba1\u7b97\u8fc7\u7a0b\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:", (String)"QuotaServiceImpl_1", (String)"scmc-pm-mservice", (Object[])new Object[0]).concat(message)));
        }
    }

    public String invokeQuotaSchemaService(String invokeparamter) {
        trackLog.startInfo(invokeparamter);
        log.info("\u3010\u91c7\u8d2d\u914d\u989dSR\u3011\u670d\u52a1\u7684\u8bf7\u6c42\u7684\u53c2\u6570\u5982\u4e0b  --> " + invokeparamter);
        QuotaSchemaInParamDTO invoke = null;
        try {
            invoke = (QuotaSchemaInParamDTO)JSONObject.parseObject((String)invokeparamter, QuotaSchemaInParamDTO.class);
            InvokeResult checkQuotaCalculate = CustomMSValidationUtils.checkQuotaCalculate((Object)invoke);
            if (!checkQuotaCalculate.isSuccess()) {
                return SerializationUtils.toJsonString((Object)checkQuotaCalculate);
            }
        }
        catch (Exception e) {
            log.error("\u4f20\u9012\u7684\u53c2\u6570json\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:", (Throwable)e);
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u4f20\u9012\u7684\u8bf7\u6c42\u53c2\u6570\u7684JSON\u6570\u636e\uff0c\u4e0d\u7b26\u5408\u63a5\u53e3\u8981\u6c42\u3002", (String)"QuotaServiceImpl_0", (String)"scmc-pm-mservice", (Object[])new Object[0])));
        }
        String resultjson = null;
        String quotaPattern = null;
        try {
            quotaPattern = QuotaHelper.queryQuotaParam();
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        if (StringUtils.isEmpty((CharSequence)quotaPattern) || "A".equals(quotaPattern)) {
            try {
                Long purchaseOrgId = invoke.getPurchaseOrgId();
                Long materialId = invoke.getMaterialId();
                LocalDate bizDate = LocalDate.parse(invoke.getBizDate());
                Long srcBillEntryId = invoke.getSrcBillEntryId();
                Long srcBillId = invoke.getSrcBillId();
                LocalDateTime todaystart = LocalDateTime.of(bizDate, LocalTime.MIN);
                Date bizTime = Date.from(todaystart.atZone(ZoneId.systemDefault()).toInstant());
                QFilter qFilter2 = new QFilter("org", "=", (Object)purchaseOrgId);
                qFilter2.and(MATERIAL_MASTERID_ID, "=", (Object)materialId);
                DynamicObject quotaAssign = BusinessDataServiceHelper.loadSingle((String)"pm_quotaassign", (String)this.getquotaAssinFields(), (QFilter[])new QFilter[]{qFilter2});
                if (quotaAssign == null) {
                    log.warn("\u8be5\u7ec4\u7ec7\u8be5\u7269\u6599\u4e0b\u4e0d\u5b58\u5728\u914d\u989d\u5206\u914d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                    return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0e\u7269\u6599\u4e0b\u65e0\u914d\u989d\u5206\u914d\uff0c\u8bf7\u6838\u5b9e\u3002", (String)"QuotaServiceImpl_2", (String)"scmc-pm-mservice", (Object[])new Object[0])));
                }
                DynamicObject quotaSchema = quotaAssign.getDynamicObject("quota");
                if (quotaSchema == null) {
                    log.warn("\u8be5\u7ec4\u7ec7\u8be5\u7269\u6599\u4e0b\u914d\u989d\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                    return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0e\u7269\u6599\u4e0b\u7684\u914d\u989d\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"QuotaServiceImpl_3", (String)"scmc-pm-mservice", (Object[])new Object[0])));
                }
                DynamicObjectCollection rowEffect = quotaSchema.getDynamicObjectCollection("entryentity");
                String number = quotaSchema.getString("number");
                String quotatype = quotaSchema.getString("quotatype");
                ArrayList<QuotaSchemaOutParamDTO> outParamter = new ArrayList<QuotaSchemaOutParamDTO>(16);
                String enable = quotaSchema.getString("enable");
                String status = quotaSchema.getString("status");
                if (!EnableStatusEnum.ENABLE.getValue().equals(enable)) {
                    return SerializationUtils.toJsonString((Object)InvokeResult.success(outParamter));
                }
                if (!StatusEnum.AUDIT.getValue().equals(status)) {
                    return SerializationUtils.toJsonString((Object)InvokeResult.success(outParamter));
                }
                for (DynamicObject row : rowEffect) {
                    Date effectdate = row.getDate("effectdate");
                    Date expirydate = row.getDate("expirydate");
                    if (bizTime.before(effectdate) || bizTime.after(expirydate)) continue;
                    DynamicObjectCollection subRows = row.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject subRow : subRows) {
                        Long supplierId = (Long)subRow.getDynamicObject("supplier").getPkValue();
                        BigDecimal quotarate = subRow.getBigDecimal("quotarate");
                        int priorityLevelTemp = subRow.getInt("supplyrank");
                        BigDecimal priorityLevel = BigDecimal.valueOf(priorityLevelTemp);
                        QuotaSchemaOutParamDTO acceptMSResult = QuotaSchemaOutParamDTO.acceptMSResult((Long)purchaseOrgId, (Long)materialId, (String)number, (String)quotatype, (Date)effectdate, (Date)expirydate, (Long)supplierId, (BigDecimal)quotarate, (BigDecimal)priorityLevel, (Long)srcBillId, (Long)srcBillEntryId);
                        outParamter.add(acceptMSResult);
                    }
                }
                log.info("\u3010\u91c7\u8d2d\u914d\u989dSR\u3011\u670d\u52a1\u7684\u8fd4\u56de\u4e1a\u52a1\u6570\u636e\u5982\u4e0b  --> " + outParamter);
                resultjson = SerializationUtils.toJsonString((Object)InvokeResult.success(outParamter));
                trackLog.endInfo(resultjson);
                return resultjson;
            }
            catch (Exception e) {
                log.error("\u3010\u91c7\u8d2d\u914d\u989dSR\u3011\u67e5\u8be2\u8fc7\u7a0b\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:", (Throwable)e);
                String message = e.getMessage() == null ? "null" : e.getMessage();
                return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u3010\u91c7\u8d2d\u914d\u989dSR\u3011\u67e5\u8be2\u8fc7\u7a0b\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:", (String)"QuotaServiceImpl_4", (String)"scmc-pm-mservice", (Object[])new Object[0]).concat(message)));
            }
        }
        try {
            HashMap<String, Serializable> QuotaQueryParam = new HashMap<String, Serializable>(16);
            HashMap dataInfos = new HashMap(16);
            HashMap<String, Object> dataInfo = new HashMap<String, Object>(16);
            dataInfo.put("org", invoke.getPurchaseOrgId());
            dataInfo.put("material", invoke.getMaterialId());
            String bizDate = invoke.getBizDate();
            dataInfo.put("validdate", bizDate);
            dataInfos.put(invoke.getSrcBillEntryId().toString(), dataInfo);
            QuotaQueryParam.put("quotaSchemeID", Long.valueOf(1685415896346223616L));
            QuotaQueryParam.put("dataInfos", dataInfos);
            Map quotaRecord = QuotaCalHelper.getQuota(QuotaQueryParam);
            if (((Boolean)quotaRecord.get("success")).booleanValue()) {
                List quotaRecordDetails = (List)quotaRecord.get("quotaRecordDetails");
                ArrayList<QuotaSchemaOutParamDTO> outParamter = new ArrayList<QuotaSchemaOutParamDTO>(16);
                for (int m = 0; m < quotaRecordDetails.size(); ++m) {
                    Map quotaQueryResultInfos;
                    if (!invoke.getSrcBillEntryId().toString().equals(((Map)quotaRecordDetails.get(m)).get("dataKey").toString()) || (quotaQueryResultInfos = (Map)((Map)quotaRecordDetails.get(m)).get("quotaQueryResultInfos")) == null || quotaQueryResultInfos.size() == 0) continue;
                    for (Map.Entry rank : quotaQueryResultInfos.entrySet()) {
                        List quotaQueryResultLst = (List)rank.getValue();
                        for (int n = 0; n < quotaQueryResultLst.size(); ++n) {
                            Map quotaQueryResultMap = (Map)quotaQueryResultLst.get(n);
                            Long purchaseOrgId = invoke.getPurchaseOrgId();
                            Long materialId = invoke.getMaterialId();
                            Long srcBillEntryId = invoke.getSrcBillEntryId();
                            Long srcBillId = invoke.getSrcBillId();
                            Date effectdate = (Date)quotaQueryResultMap.get("effectdate");
                            Date expirydate = (Date)quotaQueryResultMap.get("expirydate");
                            Long supplierId = (Long)quotaQueryResultMap.get("supplier");
                            BigDecimal quotarate = (BigDecimal)quotaQueryResultMap.get("quotarate");
                            BigDecimal priorityLevel = quotaQueryResultMap.get("priority") != null ? new BigDecimal(quotaQueryResultMap.get("priority").toString()) : new BigDecimal(0);
                            String quotatype = "A";
                            DynamicObject purQuota = BusinessDataServiceHelper.loadSingleFromCache((String)"pm_purquota", (QFilter[])new QFilter[]{new QFilter("id", "in", quotaQueryResultMap.get("quotaId"))});
                            String number = purQuota.getString("number");
                            QuotaSchemaOutParamDTO acceptMSResult = QuotaSchemaOutParamDTO.acceptMSResult((Long)purchaseOrgId, (Long)materialId, (String)number, (String)quotatype, (Date)effectdate, (Date)expirydate, (Long)supplierId, (BigDecimal)quotarate, (BigDecimal)priorityLevel, (Long)srcBillId, (Long)srcBillEntryId);
                            outParamter.add(acceptMSResult);
                        }
                    }
                }
                resultjson = SerializationUtils.toJsonString((Object)InvokeResult.success(outParamter));
                return resultjson;
            }
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u3010\u91c7\u8d2d\u914d\u989dSR\u3011\u67e5\u8be2\u8fc7\u7a0b\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:", (String)"QuotaServiceImpl_4", (String)"scmc-pm-mservice", (Object[])new Object[0]).concat(quotaRecord.get("detail").toString())));
        }
        catch (Exception e) {
            log.error("\u3010\u91c7\u8d2d\u914d\u989dSR\u3011\u67e5\u8be2\u8fc7\u7a0b\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:", (Throwable)e);
            String message = e.getMessage() == null ? "null" : e.getMessage();
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u3010\u91c7\u8d2d\u914d\u989dSR\u3011\u67e5\u8be2\u8fc7\u7a0b\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:", (String)"QuotaServiceImpl_4", (String)"scmc-pm-mservice", (Object[])new Object[0]).concat(message)));
        }
    }

    private String getquotaAssinFields() {
        ArrayList selectQuotaAssignFields = new ArrayList(16);
        Collections.addAll(selectQuotaAssignFields, "org", "quota", "material");
        String selectField = selectQuotaAssignFields.stream().collect(Collectors.joining(","));
        return selectField;
    }
}

