/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.business.service.TrackLogService;
import kd.scmc.pm.business.pojo.InvokeResult;
import kd.scmc.pm.business.service.customMSvalidation.CustomMSValidationUtils;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.SourceInDetailDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.SourceInParamterDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.msparameter.SourceOutParamterDTO;
import kd.scmc.pm.enums.EnableStatusEnum;
import kd.scmc.pm.enums.FrozenStatusEnum;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.mservice.api.SourceService;
import kd.scmc.pm.utils.DateUtil;

public class SourceServiceImpl
implements SourceService {
    private static final TrackLogService trackLog = new TrackLogService(SourceServiceImpl.class, "pm");
    private static final Log log = LogFactory.getLog(SourceServiceImpl.class);
    public static final String ISVMI = "entryentity.isvmi";
    private static final int CONTAINER_SIZE = 16;
    public static final String MATERIALMASTERID = "entryentity.material.masterid";

    public String invokeSourceService(String invokeparamter) {
        trackLog.startInfo(invokeparamter);
        log.info("\u3010\u91c7\u8d2d\u8d27\u6e90ASL\u3011\u670d\u52a1\u7684\u8bf7\u6c42\u7684\u53c2\u6570\u5982\u4e0b  --> " + invokeparamter);
        SourceInParamterDTO invoke = null;
        try {
            invoke = (SourceInParamterDTO)JSONObject.parseObject((String)invokeparamter, SourceInParamterDTO.class);
            InvokeResult checkQuotaCalculate = CustomMSValidationUtils.checkQuotaCalculate((Object)invoke);
            if (!checkQuotaCalculate.isSuccess()) {
                String jsonString = SerializationUtils.toJsonString((Object)checkQuotaCalculate);
                trackLog.endInfo(jsonString);
                return jsonString;
            }
        }
        catch (Exception e) {
            String jsonString = SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u4f20\u9012\u7684\u8bf7\u6c42\u53c2\u6570\u7684JSON\u6570\u636e\uff0c\u4e0d\u7b26\u63a5\u53e3\u8981\u6c42\uff0c\u8bf7\u60a8\u4ed4\u7ec6\u9605\u8bfb\u63a5\u53e3\u6587\u6863\u5e76\u68c0\u67e5\u53c2\u6570\u7c7b\u578b\u3002", (String)"SourceServiceImpl_0", (String)"scmc-pm-mservice", (Object[])new Object[0])));
            trackLog.endInfo(jsonString);
            log.error("\u4f20\u9012\u7684\u53c2\u6570json\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:".concat(e.getLocalizedMessage()));
            return jsonString;
        }
        Long purchaseOrgId = invoke.getPurchaseOrgId();
        Long supplierId = invoke.getSupplierId();
        QFilter qFilter = new QFilter("org", "=", (Object)purchaseOrgId);
        qFilter.and(new QFilter("supplier", "=", (Object)supplierId));
        List billentry = invoke.getBillentry();
        HashSet<Long> materialIdSet = new HashSet<Long>(billentry.size());
        for (SourceInDetailDTO dto : billentry) {
            Long materialId = dto.getMaterialId();
            materialIdSet.add(materialId);
        }
        qFilter.and(new QFilter(MATERIALMASTERID, "in", materialIdSet));
        qFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        qFilter.and(new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue()));
        qFilter.and(new QFilter("entryentity.frozenstatus", "=", (Object)FrozenStatusEnum.UNFROZEN.getValue()));
        ArrayList selectlistFields = new ArrayList();
        Collections.addAll(selectlistFields, "id", "entryentity.id", "org", "supplier", "number", MATERIALMASTERID, ISVMI, "entryentity.effectdate", "entryentity.expirydate", "entryentity.purchaseunit", "entryentity.maxbillqty", "entryentity.minbillqty", "entryentity.packagebatchqty", "entryentity.packingbaseqty", "entryentity.packingqty");
        String selectFields = selectlistFields.stream().collect(Collectors.joining(","));
        DynamicObjectCollection rowData = null;
        try {
            rowData = QueryServiceHelper.query((String)"pm_sourcelist", (String)selectFields, (QFilter[])qFilter.toArray(), null);
        }
        catch (Exception e) {
            log.error("\u8d27\u6e90\u6e05\u5355\u67e5\u8be2\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:".concat(e.getLocalizedMessage()));
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u8d27\u6e90\u6e05\u5355\u67e5\u8be2\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:", (String)"SourceServiceImpl_1", (String)"scmc-pm-mservice", (Object[])new Object[0]).concat(e.getLocalizedMessage())));
        }
        ArrayList<SourceOutParamterDTO> outParamter = new ArrayList<SourceOutParamterDTO>(16);
        if (rowData == null || rowData.isEmpty()) {
            log.warn("\u672a\u67e5\u8be2\u51fa\u8d27\u6e90\u6e05\u5355\u7684\u76f8\u5173\u6570\u636e\u3002");
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u51fa\u8d27\u6e90\u6e05\u5355\u7684\u76f8\u5173\u6570\u636e\u3002", (String)"SourceServiceImpl_2", (String)"scmc-pm-mservice", (Object[])new Object[0])));
        }
        block5: for (SourceInDetailDTO dto : billentry) {
            Date bizDate = this.convertStrToDate(dto.getBizDate());
            if (bizDate == null) continue;
            Long materialId = dto.getMaterialId();
            Long srcBillEntryId = dto.getSrcBillEntryId();
            Long srcBillId = dto.getSrcBillId();
            for (DynamicObject row : rowData) {
                Long materid = row.getLong(MATERIALMASTERID);
                Date effectdate = row.getDate("entryentity.effectdate");
                Date expirydate = row.getDate("entryentity.expirydate");
                if (!materialId.equals(materid) || bizDate.before(effectdate) || bizDate.after(expirydate)) continue;
                String number = row.getString("number");
                Boolean isVmi = row.getBoolean(ISVMI);
                Long unitId = row.getLong("entryentity.purchaseunit");
                BigDecimal maxbillqty = row.getBigDecimal("entryentity.maxbillqty");
                BigDecimal minbillqty = row.getBigDecimal("entryentity.minbillqty");
                BigDecimal packagebatchqty = row.getBigDecimal("entryentity.packagebatchqty");
                BigDecimal packingQty = row.getBigDecimal("entryentity.packingqty");
                BigDecimal packingBaseQty = row.getBigDecimal("entryentity.packingbaseqty");
                SourceOutParamterDTO acceptMSResult = SourceOutParamterDTO.acceptMSResult((Long)purchaseOrgId, (Long)materialId, (Long)supplierId, (String)number, (Date)effectdate, (Date)expirydate, (Boolean)isVmi, (Long)unitId, (BigDecimal)maxbillqty, (BigDecimal)minbillqty, (BigDecimal)packagebatchqty, (Long)srcBillId, (Long)srcBillEntryId);
                acceptMSResult.setPackingbaseqty(packingBaseQty);
                acceptMSResult.setPackingqty(packingQty);
                outParamter.add(acceptMSResult);
                continue block5;
            }
        }
        InvokeResult successdata = InvokeResult.success(outParamter);
        log.info("\u3010\u91c7\u8d2d\u8d27\u6e90ASL\u3011\u670d\u52a1\u7684\u8fd4\u56de\u4e1a\u52a1\u6570\u636e\u5982\u4e0b  --> " + successdata);
        return SerializationUtils.toJsonString((Object)successdata);
    }

    public String invokeSourceControl(String invokeparamter) {
        trackLog.startInfo(invokeparamter);
        log.info("\u3010\u91c7\u8d2d\u8d27\u6e90ASL\u3011\u670d\u52a1\u7684\u8bf7\u6c42\u7684\u53c2\u6570\u5982\u4e0b  --> " + invokeparamter);
        SourceInParamterDTO invoke = null;
        try {
            invoke = (SourceInParamterDTO)JSONObject.parseObject((String)invokeparamter, SourceInParamterDTO.class);
            InvokeResult checkQuotaCalculate = CustomMSValidationUtils.checkQuotaCalculate((Object)invoke);
            if (!checkQuotaCalculate.isSuccess()) {
                return SerializationUtils.toJsonString((Object)checkQuotaCalculate);
            }
        }
        catch (Exception e) {
            log.error("\u4f20\u9012\u7684\u53c2\u6570json\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:".concat(e.getLocalizedMessage()));
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u4f20\u9012\u7684\u8bf7\u6c42\u53c2\u6570\u7684JSON\u6570\u636e\uff0c\u4e0d\u7b26\u63a5\u53e3\u8981\u6c42\uff0c\u8bf7\u60a8\u4ed4\u7ec6\u9605\u8bfb\u63a5\u53e3\u6587\u6863\u5e76\u68c0\u67e5\u53c2\u6570\u7c7b\u578b\u3002", (String)"SourceServiceImpl_0", (String)"scmc-pm-mservice", (Object[])new Object[0])));
        }
        Long purchaseOrgId = invoke.getPurchaseOrgId();
        Long supplierId = invoke.getSupplierId();
        QFilter qFilter = new QFilter("org", "=", (Object)purchaseOrgId);
        qFilter.and(new QFilter("supplier", "=", (Object)supplierId));
        List billentry = invoke.getBillentry();
        HashSet<Long> materialIdSet = new HashSet<Long>(billentry.size());
        for (SourceInDetailDTO dto2 : billentry) {
            Long materialId = dto2.getMaterialId();
            materialIdSet.add(materialId);
        }
        qFilter.and(new QFilter(MATERIALMASTERID, "in", materialIdSet));
        qFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        qFilter.and(new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue()));
        qFilter.and(new QFilter("entryentity.frozenstatus", "=", (Object)FrozenStatusEnum.UNFROZEN.getValue()));
        ArrayList selectlistFields = new ArrayList();
        Collections.addAll(selectlistFields, "id", "entryentity.id", MATERIALMASTERID, "entryentity.effectdate", "entryentity.expirydate");
        String selectFields = selectlistFields.stream().collect(Collectors.joining(","));
        DynamicObjectCollection rowData = null;
        try {
            rowData = QueryServiceHelper.query((String)"pm_sourcelist", (String)selectFields, (QFilter[])qFilter.toArray(), null);
        }
        catch (Exception e) {
            log.error("\u8d27\u6e90\u63a7\u5236\u670d\u52a1\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:".concat(e.getLocalizedMessage()));
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u8d27\u6e90\u63a7\u5236\u670d\u52a1\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:", (String)"SourceServiceImpl_3", (String)"scmc-pm-mservice", (Object[])new Object[0]).concat(e.getLocalizedMessage())));
        }
        ArrayList<SourceOutParamterDTO> outdata = new ArrayList<SourceOutParamterDTO>();
        if (rowData == null || rowData.size() == 0) {
            billentry.forEach(dto -> outdata.add(SourceOutParamterDTO.acceptMSResult((Long)dto.getSrcBillId(), (Long)dto.getSrcBillEntryId(), (Boolean)Boolean.FALSE)));
        } else {
            for (SourceInDetailDTO dto3 : billentry) {
                Date bizDate = this.convertStrToDate(dto3.getBizDate());
                if (bizDate == null) continue;
                Long materialId = dto3.getMaterialId();
                Boolean flag = Boolean.FALSE;
                for (DynamicObject row : rowData) {
                    Long materid = row.getLong(MATERIALMASTERID);
                    Date effectdate = row.getDate("entryentity.effectdate");
                    Date expirydate = row.getDate("entryentity.expirydate");
                    if (!materialId.equals(materid) || bizDate.before(effectdate) || bizDate.after(expirydate)) continue;
                    flag = Boolean.TRUE;
                    break;
                }
                SourceOutParamterDTO acceptMSResult = SourceOutParamterDTO.acceptMSResult((Long)dto3.getSrcBillId(), (Long)dto3.getSrcBillEntryId(), (Boolean)flag);
                outdata.add(acceptMSResult);
            }
        }
        InvokeResult success = InvokeResult.success(outdata);
        log.info("\u3010\u91c7\u8d2d\u8d27\u6e90\u63a7\u5236\u3011\u670d\u52a1\u7684\u8fd4\u56de\u4e1a\u52a1\u6570\u636e\u5982\u4e0b  --> " + success);
        String jsonString = SerializationUtils.toJsonString((Object)success);
        trackLog.endInfo(jsonString);
        return jsonString;
    }

    private Date convertStrToDate(String bizDate) {
        SimpleDateFormat simpleFomate = new SimpleDateFormat("yyyy-MM-dd");
        Date bizTime = null;
        try {
            bizTime = simpleFomate.parse(bizDate);
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u683c\u5f0f\u5316\u5f02\u5e38\uff01\uff01\uff01" + e.getMessage());
        }
        return bizTime;
    }

    public String invokeSourceSupplier(String invokeparamter) {
        trackLog.startInfo(invokeparamter);
        if (log.isInfoEnabled()) {
            log.info("\u3010\u91c7\u8d2d\u8d27\u6e90\u4f9b\u5e94\u5546\u3011\u670d\u52a1\u7684\u8bf7\u6c42\u7684\u53c2\u6570\u5982\u4e0b  -->{} ", (Object)invokeparamter);
        }
        SourceInParamterDTO invoke = null;
        try {
            invoke = (SourceInParamterDTO)JSONObject.parseObject((String)invokeparamter, SourceInParamterDTO.class);
            InvokeResult checkQuotaCalculate = CustomMSValidationUtils.checkSourceSupplier((Object)invoke);
            if (!checkQuotaCalculate.isSuccess()) {
                return SerializationUtils.toJsonString((Object)checkQuotaCalculate);
            }
        }
        catch (Exception e) {
            log.error("\u4f20\u9012\u7684\u53c2\u6570json\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:{}", (Object)e.getLocalizedMessage());
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u4f20\u9012\u7684\u8bf7\u6c42\u53c2\u6570\u7684JSON\u6570\u636e\uff0c\u4e0d\u7b26\u63a5\u53e3\u8981\u6c42\uff0c\u8bf7\u60a8\u4ed4\u7ec6\u9605\u8bfb\u63a5\u53e3\u6587\u6863\u5e76\u68c0\u67e5\u53c2\u6570\u7c7b\u578b\u3002", (String)"SourceServiceImpl_0", (String)"scmc-pm-mservice", (Object[])new Object[0])));
        }
        Long purchaseOrgId = invoke.getPurchaseOrgId();
        QFilter qFilter = new QFilter("org", "=", (Object)purchaseOrgId);
        List materialIds = invoke.getMaterialIds();
        qFilter.and(new QFilter(MATERIALMASTERID, "in", (Object)materialIds));
        qFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        qFilter.and(new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue()));
        qFilter.and(new QFilter("entryentity.frozenstatus", "=", (Object)FrozenStatusEnum.UNFROZEN.getValue()));
        String selectFields = "id,entryentity.id,supplier,entryentity.material.masterid,entryentity.effectdate,entryentity.expirydate,org";
        DynamicObjectCollection rowData = null;
        try {
            rowData = QueryServiceHelper.query((String)"pm_sourcelist", (String)selectFields, (QFilter[])qFilter.toArray(), null);
        }
        catch (Exception e) {
            log.error("\u8d27\u6e90\u6e05\u5355\u67e5\u8be2\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:{}", (Object)e.getLocalizedMessage());
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u8d27\u6e90\u6e05\u5355\u67e5\u8be2\u4e2d,\u5b58\u5728\u5982\u4e0b\u95ee\u9898:", (String)"SourceServiceImpl_1", (String)"scmc-pm-mservice", (Object[])new Object[0]).concat(e.getLocalizedMessage())));
        }
        ArrayList<SourceOutParamterDTO> outParamter = new ArrayList<SourceOutParamterDTO>(16);
        HashSet<Long> notExit = new HashSet<Long>();
        if (rowData == null || rowData.isEmpty()) {
            if (log.isWarnEnabled()) {
                log.warn("\u7269\u6599\u5168\u90e8\u4e0d\u5b58\u5728\u76f8\u5e94\u7684\u4f9b\u5e94\u5546\u6570\u636e\u3002");
            }
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u7269\u6599\u65e0\u76f8\u5e94\u4f9b\u5e94\u5546\u6570\u636e\u3002", (String)"SourceServiceImpl_4", (String)"scmc-pm-mservice", (Object[])new Object[0])));
        }
        Date bizDate = this.convertStrToDate(invoke.getBizDate());
        if (bizDate != null) {
            for (Long materialId : materialIds) {
                boolean flag = false;
                for (DynamicObject row : rowData) {
                    Long masterid = row.getLong(MATERIALMASTERID);
                    Date effectdate = row.getDate("entryentity.effectdate");
                    Date expirydate = row.getDate("entryentity.expirydate");
                    if (!materialId.equals(masterid) || bizDate.before(effectdate) || bizDate.after(expirydate)) continue;
                    flag = true;
                    Long supplierId = row.getLong("supplier");
                    outParamter.add(SourceOutParamterDTO.acceptMSResult((Long)materialId, (Long)supplierId));
                }
                if (flag) continue;
                notExit.add(materialId);
                outParamter.add(SourceOutParamterDTO.acceptMSResult((Long)materialId, (Long)0L));
            }
        }
        InvokeResult successdata = null;
        successdata = notExit.size() == materialIds.size() ? InvokeResult.failure((String)ResManager.loadKDString((String)"\u7269\u6599\u65e0\u76f8\u5e94\u4f9b\u5e94\u5546\u6570\u636e\u3002", (String)"SourceServiceImpl_4", (String)"scmc-pm-mservice", (Object[])new Object[0])) : InvokeResult.success(outParamter);
        String result = SerializationUtils.toJsonString((Object)successdata);
        if (log.isInfoEnabled()) {
            log.info("\u3010\u91c7\u8d2d\u8d27\u6e90\u4f9b\u5e94\u5546\u7684\u8fd4\u56de\u53c2\u6570\u5982\u4e0b\u3011  -->{}", (Object)result);
        }
        trackLog.endInfo(result);
        return result;
    }

    public String batchAddSourceList(List<Map<String, Object>> invokeparamter) {
        List successPkIds;
        log.info("\u8bf7\u6c42\u8d27\u6e90\u6e05\u5355\u65b0\u589e\u63a5\u53e3\u53c2\u6570\uff1a{}", invokeparamter);
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        MainEntityType sourcelist = MetadataServiceHelper.getDataEntityType((String)"pm_sourcelist");
        Date bizTime = this.convertStrToDate("2099-12-31");
        try {
            InvokeResult checkParamater = this.checkParamater(invokeparamter);
            if (!checkParamater.isSuccess()) {
                return SerializationUtils.toJsonString((Object)checkParamater);
            }
        }
        catch (Exception e) {
            log.info("\u53c2\u6570\u4e0d\u7b26\u5408\u63a5\u53e3\u7c7b\u578b\uff0c\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\uff1a{}", (Object)e.getLocalizedMessage());
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)String.format(ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\uff1a%1$s\u3002", (String)"SourceServiceImpl_20", (String)"scmc-pm-mservice", (Object[])new Object[0]), e.getMessage())));
        }
        int size = invokeparamter.size();
        int entrysize = this.getParamEntrySize(invokeparamter);
        long[] ids = DBServiceHelper.genLongIds((String)sourcelist.getAlias(), (int)size);
        EntryProp entryEntity = (EntryProp)sourcelist.findProperty("entryentity");
        long[] entryIds = DBServiceHelper.genLongIds((String)entryEntity.getDynamicCollectionItemPropertyType().getAlias(), (int)entrysize);
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(size);
        HashMap<String, Long> bizUniqueIDs = new HashMap<String, Long>(size);
        int idsIndex = 0;
        int entryIdsIndex = 0;
        HashMap<Long, Long> sourceListEntryIdAndParamEntryId = new HashMap<Long, Long>(entrysize);
        Iterator<Map<String, Object>> iterator = invokeparamter.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> billhead = iterator.next();
            DynamicObject sourcelistbill = new DynamicObject((DynamicObjectType)sourcelist);
            Long org = (Long)billhead.get("org");
            Long id = (Long)billhead.get("id");
            Long supplier = (Long)billhead.get("supplier");
            Long modifier = (Long)billhead.get("modifier");
            Date modifytime = (Date)billhead.get("modifytime");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(modifytime);
            calendar.add(13, 10);
            Date audittime = calendar.getTime();
            long pkValue = ids[idsIndex++];
            sourcelistbill.set("id", (Object)pkValue);
            sourcelistbill.set("org", (Object)org);
            sourcelistbill.set("org_id", (Object)org);
            sourcelistbill.set("supplier", (Object)supplier);
            sourcelistbill.set("supplier_id", (Object)supplier);
            sourcelistbill.set("creator", (Object)modifier);
            sourcelistbill.set("createtime", (Object)modifytime);
            sourcelistbill.set("auditor", (Object)modifier);
            sourcelistbill.set("audittime", (Object)audittime);
            sourcelistbill.set("status", (Object)"C");
            sourcelistbill.set("enable", (Object)1);
            List<Map<String, Object>> entryentity = this.getBatchData(billhead);
            DynamicObjectCollection rows = sourcelistbill.getDynamicObjectCollection("entryentity");
            int rowIndex = 1;
            for (Map<String, Object> entity : entryentity) {
                List<Map<String, Object>> tipFailMsg;
                String bizUniqueID;
                long entryPk = entryIds[entryIdsIndex++];
                String type = (String)entity.get("type");
                Long entryid = (Long)entity.get("entryid");
                Date effectdate = (Date)entity.get("effectdate");
                Date expirydate = (Date)entity.get("expirydate");
                if (effectdate == null && expirydate == null) {
                    effectdate = DateUtil.getDate((Date)modifytime);
                    expirydate = bizTime;
                }
                effectdate = DateUtil.getDate((Date)effectdate);
                expirydate = DateUtil.getDate((Date)expirydate);
                Long material = null;
                Long materialSort = null;
                if ("A".equals(type)) {
                    material = (Long)entity.get("material");
                    bizUniqueID = this.getBizUniqueID(org, supplier, material, effectdate, expirydate);
                    if (bizUniqueIDs.containsKey(bizUniqueID)) {
                        tipFailMsg = this.getTipFailMsg(id, entryid);
                        result.addAll(tipFailMsg);
                        iterator.remove();
                        continue;
                    }
                    this.setBizUniqueID(org, supplier, material, effectdate, expirydate, id, bizUniqueIDs);
                } else if ("B".equals(type)) {
                    materialSort = (Long)entity.get("materialsort");
                    bizUniqueID = this.getBizUniqueID(org, supplier, materialSort, effectdate, expirydate);
                    if (bizUniqueIDs.containsKey(bizUniqueID)) {
                        tipFailMsg = this.getTipFailMsg(id, entryid);
                        result.addAll(tipFailMsg);
                        iterator.remove();
                        continue;
                    }
                    this.setBizUniqueID(org, supplier, materialSort, effectdate, expirydate, id, bizUniqueIDs);
                }
                DynamicObject row = rows.addNew();
                row.set("id", (Object)entryPk);
                sourceListEntryIdAndParamEntryId.put(entryPk, entryid);
                row.set("seq", (Object)rowIndex);
                row.set("type", (Object)type);
                row.set("effectdate", (Object)effectdate);
                row.set("expirydate", (Object)expirydate);
                row.set("srctype", (Object)"B");
                row.set("billcontrol", (Object)"A");
                row.set("frozenstatus", (Object)"A");
                if ("A".equals(type)) {
                    row.set("material", (Object)material);
                    row.set("materialmasterid", (Object)material);
                    row.set("packagebatchqty", (Object)1);
                    row.set("packingqty", (Object)1);
                } else if ("B".equals(type)) {
                    row.set("materialsort", (Object)materialSort);
                }
                ++rowIndex;
            }
            if (sourcelistbill.getDynamicObjectCollection("entryentity").isEmpty()) continue;
            bills.add(sourcelistbill);
        }
        List numbers = CodeRuleServiceHelper.getNumbers((String)"pm_sourcelist", bills);
        if (numbers == null) {
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SourceServiceImpl_19", (String)"scmc-pm-mservice", (Object[])new Object[0])));
        }
        List filterNumbers = numbers.stream().filter(Objects::nonNull).collect(Collectors.toList());
        int filterSize = filterNumbers.size();
        if (filterSize < bills.size()) {
            log.info("\u83b7\u53d6\u5230\u8d27\u6e90\u6e05\u5355\u7f16\u7801\u7684\u6570\u91cf\u662f\uff1a{}", (Object)filterSize);
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SourceServiceImpl_19", (String)"scmc-pm-mservice", (Object[])new Object[0])));
        }
        HashMap<String, Long> numberAndSrcId = new HashMap<String, Long>(16);
        for (int i = 0; i < invokeparamter.size(); ++i) {
            Map<String, Object> billhead = invokeparamter.get(i);
            DynamicObject bill = (DynamicObject)bills.get(i);
            String number = (String)numbers.get(i);
            bill.set("number", (Object)number);
            bill.set("name", (Object)number);
            Long id = (Long)billhead.get("id");
            numberAndSrcId.put(number, id);
        }
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"saveterm", (String)"pm_sourcelist", (DynamicObject[])bills.toArray(new DynamicObject[0]), (OperateOption)this.createOperateOption());
        if (!saveResult.isSuccess()) {
            List allErrorOrValidateInfo = saveResult.getAllErrorOrValidateInfo();
            List<Map<String, Object>> tipFailMsg = this.getTipFailMsg(allErrorOrValidateInfo, numberAndSrcId);
            if (result.size() > 0) {
                result.addAll(tipFailMsg);
            } else {
                result = tipFailMsg;
            }
        }
        if ((successPkIds = saveResult.getSuccessPkIds()).isEmpty()) {
            return SerializationUtils.toJsonString((Object)InvokeResult.success(result, (String)ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u5b58\u5728\u5931\u8d25\u3002", (String)"SourceServiceImpl_6", (String)"scmc-pm-mservice", (Object[])new Object[0])));
        }
        result = this.addSourceListEntryId(result, saveResult, sourceListEntryIdAndParamEntryId);
        return SerializationUtils.toJsonString((Object)InvokeResult.success(result, (String)ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u6210\u529f\u3002", (String)"SourceServiceImpl_21", (String)"scmc-pm-mservice", (Object[])new Object[0])));
    }

    private List<Map<String, Object>> addSourceListEntryId(List<Map<String, Object>> result, OperationResult saveResult, Map<Long, Long> sourceListEntryIdAndParamEntryId) {
        List successPkIds = saveResult.getSuccessPkIds();
        if (successPkIds == null || successPkIds.isEmpty()) {
            return result;
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)this.getClass().getName(), (String)"pm_sourcelist", (String)"entryentity.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)successPkIds)}, null);
        for (DynamicObject row : query) {
            Long sourceListEntryId = row.getLong("entryentity.id");
            Long paramEntryId = sourceListEntryIdAndParamEntryId.get(sourceListEntryId);
            HashMap<String, Object> saveSuccessMap = new HashMap<String, Object>();
            saveSuccessMap.put("id", paramEntryId);
            saveSuccessMap.put("entryid", paramEntryId);
            saveSuccessMap.put("suceecss", Boolean.TRUE);
            saveSuccessMap.put("sourcelistentryid", sourceListEntryId);
            saveSuccessMap.put("reason", "");
            result.add(saveSuccessMap);
        }
        return result;
    }

    private int getParamEntrySize(List<Map<String, Object>> invokeparamter) {
        int size = 0;
        for (Map<String, Object> param : invokeparamter) {
            Object entryentity = param.get("entryentity");
            if (!(entryentity instanceof List)) continue;
            size += ((List)entryentity).size();
        }
        return size;
    }

    private List<Map<String, Object>> getTipFailMsg(Long id, Long entryId) {
        ArrayList<Map<String, Object>> notExistDataList = new ArrayList<Map<String, Object>>(16);
        HashMap<String, Object> notExistMap = new HashMap<String, Object>();
        notExistMap.put("id", id);
        notExistMap.put("suceecss", Boolean.FALSE);
        notExistMap.put("entryid", entryId);
        notExistMap.put("reason", ResManager.loadKDString((String)"\u672c\u6279\u6b21\u8bf7\u6c42\u53c2\u6570\u4e0e\u8be5\u6761\u6570\u636e\u91cd\u590d\u3002", (String)"SourceServiceImpl_18", (String)"scmc-pm-mservice", (Object[])new Object[0]));
        notExistDataList.add(notExistMap);
        return notExistDataList;
    }

    private String getBizUniqueID(Long orgID, Long supplierID, Long bizID, Date effectdate, Date expirydate) {
        SimpleDateFormat simpleFomate = new SimpleDateFormat("yyyy-MM-dd");
        String strEffectData = simpleFomate.format(effectdate);
        String strexpiryData = simpleFomate.format(expirydate);
        StringBuilder uniqueKey = new StringBuilder();
        uniqueKey.append(orgID).append('_');
        uniqueKey.append(supplierID).append('_');
        uniqueKey.append(bizID).append('_');
        uniqueKey.append(strEffectData).append('_');
        uniqueKey.append(strexpiryData);
        return uniqueKey.toString();
    }

    private Map<String, Long> setBizUniqueID(Long orgID, Long supplierID, Long bizID, Date effectdate, Date expirydate, Long srcId, Map<String, Long> bizUnique) {
        SimpleDateFormat simpleFomate = new SimpleDateFormat("yyyy-MM-dd");
        String strEffectData = simpleFomate.format(effectdate);
        String strexpiryData = simpleFomate.format(expirydate);
        StringBuilder uniqueKey = new StringBuilder();
        uniqueKey.append(orgID).append('_');
        uniqueKey.append(supplierID).append('_');
        uniqueKey.append(bizID).append('_');
        uniqueKey.append(strEffectData).append('_');
        uniqueKey.append(strexpiryData);
        bizUnique.put(uniqueKey.toString(), srcId);
        return bizUnique;
    }

    private List<Map<String, Object>> getTipFailMsg(List<IOperateInfo> allErrorOrValidateInfo, Map<String, Long> numberAndSrcId) {
        ArrayList<Map<String, Object>> notExistDataList = new ArrayList<Map<String, Object>>(allErrorOrValidateInfo.size());
        HashMap<String, Object> notExistMap = null;
        for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
            String message = iOperateInfo.getMessage();
            String number = iOperateInfo.getTitle();
            Long ID = numberAndSrcId.get(number);
            notExistMap = new HashMap<String, Object>();
            notExistMap.put("id", ID);
            notExistMap.put("entryid", ID);
            notExistMap.put("suceecss", Boolean.FALSE);
            notExistMap.put("reason", message);
            notExistDataList.add(notExistMap);
        }
        return notExistDataList;
    }

    private OperateOption createOperateOption() {
        OperateOption option = OperateOption.create();
        return option;
    }

    private List<Map<String, Object>> getBatchData(Map<String, Object> object) {
        List entryentity = (List)object.get("entryentity");
        return entryentity;
    }

    private InvokeResult checkParamater(List<Map<String, Object>> invokeparamter) {
        if (invokeparamter == null || invokeparamter.size() <= 0) {
            return InvokeResult.failure((String)ResManager.loadKDString((String)"\u65b0\u589e\u8d27\u6e90\u6e05\u5355\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SourceServiceImpl_8", (String)"scmc-pm-mservice", (Object[])new Object[0]));
        }
        for (Map<String, Object> billhead : invokeparamter) {
            Long id = (Long)billhead.get("id");
            Long org = (Long)billhead.get("org");
            Long supplier = (Long)billhead.get("supplier");
            Long modifier = (Long)billhead.get("modifier");
            Date modifytime = (Date)billhead.get("modifytime");
            if (org == null || supplier == null || modifier == null || id == null) {
                return InvokeResult.failure((String)ResManager.loadKDString((String)"\u65b0\u589e\u8d27\u6e90\u6e05\u5355\u7684\u5355\u5934\u53c2\u6570\u4e0d\u7b26\u5408\u89c4\u5219\u3002", (String)"SourceServiceImpl_9", (String)"scmc-pm-mservice", (Object[])new Object[0]));
            }
            List entryentity = (List)billhead.get("entryentity");
            if (entryentity == null || entryentity.size() <= 0) {
                return InvokeResult.failure((String)ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d27\u6e90\u6e05\u5355\u5206\u5f55\u53c2\u6570\u3002", (String)"SourceServiceImpl_10", (String)"scmc-pm-mservice", (Object[])new Object[0]));
            }
            for (Map row : entryentity) {
                Long materialsort;
                Long material;
                String type = (String)row.get("type");
                Long entryid = (Long)row.get("entryid");
                Date effectdate = (Date)row.get("effectdate");
                Date expirydate = (Date)row.get("expirydate");
                if (modifytime == null && (effectdate == null || expirydate == null)) {
                    return InvokeResult.failure((String)ResManager.loadKDString((String)"\u65b0\u589e\u8d27\u6e90\u6e05\u5355\u5206\u5f55\u53c2\u6570:\u66f4\u65b0\u65f6\u95f4\u3001\u751f\u6548\u65e5\u671f\u548c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"SourceServiceImpl_22", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                }
                if (type == null || "".equals(type)) {
                    return InvokeResult.failure((String)ResManager.loadKDString((String)"\u8d27\u6e90\u6e05\u5355\u201c\u5206\u7c7b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SourceServiceImpl_11", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                }
                if (entryid == null) {
                    return InvokeResult.failure((String)ResManager.loadKDString((String)"\u8d27\u6e90\u6e05\u5355\u201c\u6e90\u5355\u5206\u5f55ID\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SourceServiceImpl_12", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                }
                if ("A".equals(type) && (material = (Long)row.get("material")) == null) {
                    return InvokeResult.failure((String)ResManager.loadKDString((String)"\u8d27\u6e90\u6e05\u5355\u201c\u7269\u6599\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SourceServiceImpl_13", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                }
                if (!"B".equals(type) || (materialsort = (Long)row.get("materialsort")) != null) continue;
                return InvokeResult.failure((String)ResManager.loadKDString((String)"\u8d27\u6e90\u6e05\u5355\u201c\u7269\u6599\u5206\u7c7b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SourceServiceImpl_14", (String)"scmc-pm-mservice", (Object[])new Object[0]));
            }
        }
        return InvokeResult.success();
    }

    public String batchUpdateSourceList(List<Map<String, Object>> invokeparamter) {
        log.info("\u6279\u91cf\u66f4\u65b0\u8d27\u6e90\u6e05\u5355\u7684\u8bf7\u6c42\u53c2\u6570\u5982\u4e0b\uff1a{}", invokeparamter);
        try {
            InvokeResult checkParamater = this.checkParamater(invokeparamter);
            if (!checkParamater.isSuccess()) {
                return SerializationUtils.toJsonString((Object)checkParamater);
            }
        }
        catch (Exception e) {
            log.info("\u53c2\u6570\u4e0d\u7b26\u5408\u63a5\u53e3\u7c7b\u578b\uff0c\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\uff1a" + e.getLocalizedMessage());
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)String.format(ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\uff1a%1$s\u3002", (String)"SourceServiceImpl_20", (String)"scmc-pm-mservice", (Object[])new Object[0]), e.getMessage())));
        }
        int size = invokeparamter.size();
        ArrayList<Long> orgs = new ArrayList<Long>(size);
        ArrayList<Long> suppliers = new ArrayList<Long>(size);
        ArrayList<Long> materials = new ArrayList<Long>(size);
        ArrayList<Long> materialsorts = new ArrayList<Long>(size);
        for (Map<String, Object> billhead : invokeparamter) {
            Long org = (Long)billhead.get("org");
            orgs.add(org);
            Long supplier = (Long)billhead.get("supplier");
            suppliers.add(supplier);
            List<Map<String, Object>> entryentity = this.getBatchData(billhead);
            for (Map<String, Object> entity : entryentity) {
                DynamicObject[] type = (DynamicObject[])entity.get("type");
                if ("A".equals(type)) {
                    Long material = (Long)entity.get("material");
                    materials.add(material);
                }
                if (!"B".equals(type)) continue;
                Long materialsort = (Long)entity.get("materialsort");
                materialsorts.add(materialsort);
            }
        }
        QFilter qFilter = new QFilter("org", "in", orgs);
        qFilter.and(new QFilter("supplier", "in", suppliers));
        if (materials.size() > 0 && materialsorts.size() > 0) {
            qFilter.and(new QFilter(MATERIALMASTERID, "in", this.queryPurMaterial(materials)).or(new QFilter("entryentity.materialsort", "in", materialsorts)));
        } else {
            if (materials.size() > 0) {
                qFilter.and(new QFilter(MATERIALMASTERID, "in", this.queryPurMaterial(materials)));
            }
            if (materialsorts.size() > 0) {
                qFilter.and(new QFilter("entryentity.materialsort", "in", materialsorts));
            }
        }
        qFilter.and(new QFilter("entryentity.srctype", "=", (Object)"B"));
        qFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        qFilter.and(new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue()));
        ArrayList selectProperties = new ArrayList();
        Collections.addAll(selectProperties, "id", "entryentity.id", "org", "supplier", "modifier", "modifytime", "number", "entryentity.type", "entryentity.materialsort", "entryentity.material", "entryentity.effectdate", "entryentity.expirydate", "entryentity.srctype");
        String selectFields = selectProperties.stream().collect(Collectors.joining(","));
        DynamicObject[] sourceBills = BusinessDataServiceHelper.load((String)"pm_sourcelist", (String)selectFields, (QFilter[])qFilter.toArray());
        if (sourceBills.length <= 0) {
            log.info("\u6839\u636e\u53c2\u6570\u672a\u67e5\u8be2\u51fa\u8d27\u6e90\u6e05\u5355\u7684\u6570\u636e\u3002");
            return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u6839\u636e\u53c2\u6570\u672a\u67e5\u8be2\u51fa\u8d27\u6e90\u6e05\u5355\u7684\u6570\u636e\u3002", (String)"SourceServiceImpl_15", (String)"scmc-pm-mservice", (Object[])new Object[0])));
        }
        ArrayList<DynamicObject> sourceList = new ArrayList<DynamicObject>(sourceBills.length);
        HashMap<String, Long> existMap = null;
        ArrayList existDataList = new ArrayList();
        for (DynamicObject sourcebill : sourceBills) {
            Long org = sourcebill.getDynamicObject("org").getLong("id");
            Long l = sourcebill.getDynamicObject("supplier").getLong("id");
            Long modifier = null;
            Date modifytime = null;
            boolean flag = false;
            for (Map<String, Object> billhead : invokeparamter) {
                Long xorg = (Long)billhead.get("org");
                Long xsupplier = (Long)billhead.get("supplier");
                modifier = (Long)billhead.get("modifier");
                modifytime = (Date)billhead.get("modifytime");
                Long srcID = (Long)billhead.get("id");
                if (!org.equals(xorg) || !l.equals(xsupplier)) continue;
                DynamicObjectCollection entryentity = sourcebill.getDynamicObjectCollection("entryentity");
                for (DynamicObject entity : entryentity) {
                    String type = entity.getString("type");
                    Date effectdate = entity.getDate("effectdate");
                    Date expirydate = entity.getDate("expirydate");
                    String srctype = entity.getString("srctype");
                    List<Map<String, Object>> rows = this.getBatchData(billhead);
                    for (Map<String, Object> row : rows) {
                        Long xmaterialsort;
                        Long materialsort;
                        Long xmaterial;
                        Long material;
                        String xtype = (String)row.get("type");
                        Long srcEntryID = (Long)row.get("entryid");
                        existMap = new HashMap<String, Long>();
                        if (type.equals(xtype) && "A".equals(type) && "B".equals(srctype) && (material = (Long)entity.getDynamicObject("material.masterid").getPkValue()).equals(xmaterial = (Long)row.get("material")) && !modifytime.before(effectdate) && !modifytime.after(expirydate)) {
                            entity.set("expirydate", (Object)modifytime);
                            existMap.put("id", srcID);
                            existMap.put("entryid", srcEntryID);
                            existDataList.add(existMap);
                            flag = true;
                        }
                        if (!type.equals(xtype) || !"B".equals(type) || !"B".equals(srctype) || !(materialsort = (Long)entity.getDynamicObject("materialsort").getPkValue()).equals(xmaterialsort = (Long)row.get("materialsort")) || modifytime.before(effectdate) || modifytime.after(expirydate)) continue;
                        entity.set("expirydate", (Object)modifytime);
                        existMap.put("id", srcID);
                        existMap.put("entryid", srcEntryID);
                        existDataList.add(existMap);
                        flag = true;
                    }
                }
            }
            if (!flag) continue;
            sourcebill.set("modifier", modifier);
            sourcebill.set("modifytime", modifytime);
            sourceList.add(sourcebill);
        }
        ArrayList<Long> existentryidList = new ArrayList<Long>();
        for (Map<String, Object> billhead : invokeparamter) {
            Long id = (Long)billhead.get("id");
            for (Map map : existDataList) {
                Long srcId = (Long)map.get("id");
                Long srcEntryId = (Long)map.get("entryid");
                if (!id.equals(srcId)) continue;
                List entryentity = (List)billhead.get("entryentity");
                for (Map<String, Object> row : entryentity) {
                    Long entryid = (Long)row.get("entryid");
                    if (!srcEntryId.equals(entryid)) continue;
                    existentryidList.add(entryid);
                }
            }
        }
        ArrayList<Long> allentryidList = new ArrayList<Long>();
        invokeparamter.forEach(entry -> allentryidList.add((Long)entry.get("id")));
        allentryidList.removeAll(existentryidList);
        if (sourceList.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])sourceList.toArray(new DynamicObject[0]));
            if (allentryidList.size() <= 0) {
                log.info("\u8d27\u6e90\u6e05\u5355\u6267\u884c\u66f4\u65b0\u63a5\u53e3\u6210\u529f\u3002");
                return SerializationUtils.toJsonString((Object)InvokeResult.success());
            }
            log.info("\u63a5\u53e3\u8c03\u7528\u5b58\u5728\u5931\u8d25\u3002");
            return SerializationUtils.toJsonString((Object)InvokeResult.failure(this.getfailMsg(allentryidList), (String)ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u5b58\u5728\u5931\u8d25\u3002", (String)"SourceServiceImpl_6", (String)"scmc-pm-mservice", (Object[])new Object[0])));
        }
        log.info("\u80fd\u591f\u67e5\u8be2\u51fa\u6570\u636e\uff0c\u4f46\u662f\u672a\u66f4\u65b0\u4efb\u4f55\u8d27\u6e90\u6e05\u5355\u6570\u636e\u3002");
        return SerializationUtils.toJsonString((Object)InvokeResult.failure((String)ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u6570\u636e\uff0c\u4f46\u672a\u66f4\u65b0\u8d27\u6e90\u6e05\u5355\u6570\u636e\u3002", (String)"SourceServiceImpl_16", (String)"scmc-pm-mservice", (Object[])new Object[0])));
    }

    private List<Long> queryPurMaterial(List<Long> materials) {
        QFilter qFilter = new QFilter("masterid.id", "in", materials);
        DynamicObject[] materialPurchaseInfos = BusinessDataServiceHelper.load((String)"bd_materialpurchaseinfo", (String)"id,masterid", (QFilter[])qFilter.toArray());
        ArrayList<Long> materialPurchaseInfoList = new ArrayList<Long>(16);
        for (DynamicObject materialPurchaseInfo : materialPurchaseInfos) {
            materialPurchaseInfoList.add((Long)materialPurchaseInfo.getPkValue());
        }
        log.info("\u6839\u636e\u7269\u6599\u4e3b\u6570\u636e\u5b9a\u4f4d\u5230\u7684\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u5982\u4e0b\uff1a{}", materialPurchaseInfoList);
        return materialPurchaseInfoList;
    }

    private List<Map<String, Object>> getfailMsg(List<Long> allentryidList) {
        ArrayList<Map<String, Object>> notExistDataList = new ArrayList<Map<String, Object>>(16);
        allentryidList.forEach(entryid -> {
            HashMap<String, Object> notExistMap = new HashMap<String, Object>();
            notExistMap.put("id", entryid);
            notExistMap.put("entryid", entryid);
            notExistMap.put("reason", ResManager.loadKDString((String)"\u672a\u627e\u5230\u9700\u8981\u66f4\u65b0\u7684\u8d27\u6e90\u6e05\u5355\uff0c\u8bf7\u68c0\u67e5\u8c03\u6574\u53c2\u6570\u3002", (String)"SourceServiceImpl_17", (String)"scmc-pm-mservice", (Object[])new Object[0]));
            notExistDataList.add(notExistMap);
        });
        return notExistDataList;
    }

    public List<Map<String, Object>> expirationSourceList(Map<Long, Map<String, Object>> param) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(8);
        if (param == null || param.isEmpty()) {
            return result;
        }
        result.addAll(this.checkInPutParamForUpdate(param, false));
        if (param.isEmpty()) {
            return result;
        }
        Map<Long, Long> sourceListEntryIdAndSrcBaseDataIdMap = this.getIdMapping(param);
        Map<Long, Long> entryIdAndIdMap = this.querySourceListEntryIdAndId(param);
        result.addAll(this.notExistEntryId(param, entryIdAndIdMap, sourceListEntryIdAndSrcBaseDataIdMap));
        if (param.isEmpty()) {
            return result;
        }
        DynamicObject[] sourceListDym = BusinessDataServiceHelper.load((String)"pm_sourcelist", (String)"entryentity.id,status,enable,number,name,org.id,supplier,id,entryentity.seq,entryentity.purchaseunit,entryentity.type,entryentity.material,entryentity.materialmasterid,entryentity.materialsort,entryentity.effectdate,entryentity.expirydate,entryentity.frozenstatus,modifier,modifytime,entryentity.baseunit,entryentity.packingqty,entryentity.packingbaseqty", (QFilter[])new QFilter[]{new QFilter("id", "in", entryIdAndIdMap.values())});
        if (sourceListDym == null || sourceListDym.length == 0) {
            return result;
        }
        OperationResult update = this.modifyTermOfValidityAndUpdate(sourceListDym, param, false);
        result.addAll(this.addResultByOpR(update, entryIdAndIdMap, sourceListEntryIdAndSrcBaseDataIdMap));
        return result;
    }

    private Map<Long, Long> getIdMapping(Map<Long, Map<String, Object>> param) {
        HashMap<Long, Long> idMapping = new HashMap<Long, Long>(8);
        for (Map.Entry<Long, Map<String, Object>> map : param.entrySet()) {
            Long sourceListEntryId = map.getKey();
            Map<String, Object> value = map.getValue();
            Object id = value.get("id");
            idMapping.put(sourceListEntryId, (Long)id);
        }
        return idMapping;
    }

    private OperationResult modifyTermOfValidityAndUpdate(DynamicObject[] sourceListDyms, Map<Long, Map<String, Object>> param, boolean termOfValidity) {
        Set<Long> entryIds = param.keySet();
        ArrayList<DynamicObject> sourceListDymList = new ArrayList<DynamicObject>((int)((double)sourceListDyms.length / 0.75 + 1.0));
        for (DynamicObject sourceList : sourceListDyms) {
            if (sourceList == null) continue;
            DynamicObjectCollection entrys = sourceList.getDynamicObjectCollection("entryentity");
            boolean changed = false;
            for (DynamicObject entry : entrys) {
                Long pkValue = (Long)entry.getPkValue();
                if (!entryIds.contains(pkValue)) continue;
                Map<String, Object> map = param.get(pkValue);
                Date moditydate = (Date)map.get("modifytime");
                Long moditier = (Long)map.get("modifier");
                if (moditydate == null) continue;
                if (!termOfValidity && "C".equals(sourceList.getString("status")) && "1".equals(sourceList.getString("enable")) && "A".equals(entry.getString("frozenstatus"))) {
                    entry.set("frozenstatus", (Object)"B");
                } else {
                    Date effectdate = (Date)map.get("effectdate");
                    Date expirydate = (Date)map.get("expirydate");
                    entry.set("effectdate", (Object)effectdate);
                    entry.set("expirydate", (Object)expirydate);
                    if ("B".equals(entry.getString("frozenstatus"))) {
                        entry.set("frozenstatus", (Object)"A");
                    }
                }
                changed = true;
                sourceList.set("modifier", (Object)moditier);
                sourceList.set("modifytime", (Object)moditydate);
            }
            if (!changed) continue;
            sourceListDymList.add(sourceList);
        }
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"saveterm", (String)"pm_sourcelist", (DynamicObject[])sourceListDymList.toArray(new DynamicObject[0]), (OperateOption)this.createOperateOption());
        return saveResult;
    }

    public List<Map<String, Object>> updateSourceListTermOfValidity(Map<Long, Map<String, Object>> param) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(8);
        if (param == null || param.isEmpty()) {
            return result;
        }
        result.addAll(this.checkInPutParamForUpdate(param, true));
        if (param.isEmpty()) {
            return result;
        }
        Map<Long, Long> sourceListEntryIdAndSrcBaseDataIdMap = this.getIdMapping(param);
        Map<Long, Long> entryIdAndIdMap = this.querySourceListEntryIdAndId(param);
        result.addAll(this.notExistEntryId(param, entryIdAndIdMap, sourceListEntryIdAndSrcBaseDataIdMap));
        if (param.isEmpty()) {
            return result;
        }
        DynamicObject[] sourceListDym = BusinessDataServiceHelper.load((String)"pm_sourcelist", (String)"entryentity.id,status,enable,number,name,org.id,supplier,id,entryentity.purchaseunit,entryentity.seq,entryentity.type,entryentity.material,entryentity.materialmasterid,entryentity.materialsort,entryentity.effectdate,entryentity.expirydate,entryentity.frozenstatus,modifier,modifytime,entryentity.baseunit,entryentity.packingqty,entryentity.packingbaseqty", (QFilter[])new QFilter[]{new QFilter("id", "in", entryIdAndIdMap.values())});
        if (sourceListDym == null || sourceListDym.length == 0) {
            return result;
        }
        OperationResult update = this.modifyTermOfValidityAndUpdate(sourceListDym, param, true);
        result.addAll(this.addResultByOpR(update, entryIdAndIdMap, sourceListEntryIdAndSrcBaseDataIdMap));
        return result;
    }

    private List<Map<String, Object>> addResultByOpR(OperationResult update, Map<Long, Long> entryIdAndIdMap, Map<Long, Long> sourceListEntryIdAndSrcBaseDataIdMap) {
        ArrayList<Map<String, Object>> resultByOpr = new ArrayList<Map<String, Object>>(8);
        if (update.isSuccess()) {
            for (Long entryId : entryIdAndIdMap.keySet()) {
                HashMap<String, Object> map = new HashMap<String, Object>(5);
                map.put("reason", "");
                map.put("success", Boolean.TRUE);
                map.put("sourcelistentryid", entryId);
                map.put("id", sourceListEntryIdAndSrcBaseDataIdMap.get(entryId));
                resultByOpr.add(map);
            }
            return resultByOpr;
        }
        Map<Long, List<Map.Entry>> entryIdgroupById = entryIdAndIdMap.entrySet().stream().collect(Collectors.groupingBy(c -> (Long)c.getValue()));
        List successPkIds = update.getSuccessPkIds();
        List allErrorOrValidateInfo = update.getAllErrorOrValidateInfo();
        for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
            Object pkValue = iOperateInfo.getPkValue();
            String message = iOperateInfo.getMessage();
            List<Map.Entry> entries = entryIdgroupById.get((Long)pkValue);
            if (entries == null || entries.isEmpty()) continue;
            for (Map.Entry entry : entries) {
                Long entryId = (Long)entry.getKey();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("sourcelistentryid", entryId);
                map.put("suceecss", Boolean.FALSE);
                map.put("reason", message);
                map.put("id", sourceListEntryIdAndSrcBaseDataIdMap.get(entryId));
                resultByOpr.add(map);
            }
        }
        for (Object successId : successPkIds) {
            List<Map.Entry> entries = entryIdgroupById.get(successId);
            for (Map.Entry entry : entries) {
                Long entryId = (Long)entry.getKey();
                HashMap<String, Object> map = new HashMap<String, Object>(5);
                map.put("reason", "");
                map.put("success", Boolean.TRUE);
                map.put("sourcelistentryid", entryId);
                map.put("id", sourceListEntryIdAndSrcBaseDataIdMap.get(entryId));
                resultByOpr.add(map);
            }
        }
        return resultByOpr;
    }

    private List<Map<String, Object>> notExistEntryId(Map<Long, Map<String, Object>> param, Map<Long, Long> entryIdAndIdMap, Map<Long, Long> sourceListEntryIdAndSrcBaseDataIdMap) {
        ArrayList<Map<String, Object>> notExistResult = new ArrayList<Map<String, Object>>(8);
        Set<Long> notExistEntryIds = this.getNotExistEntryIds(param, entryIdAndIdMap);
        if (!notExistEntryIds.isEmpty()) {
            for (Long notExistEntryid : notExistEntryIds) {
                HashMap<String, Object> map = new HashMap<String, Object>(5);
                map.put("reason", ResManager.loadKDString((String)"\u672a\u627e\u5230\u5df2\u5ba1\u6838\u53ef\u7528\u7684\u8d27\u6e90\u6e05\u5355\u3002", (String)"SourceServiceImpl_23", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                map.put("success", Boolean.FALSE);
                map.put("sourcelistentryid", notExistEntryid);
                map.put("id", sourceListEntryIdAndSrcBaseDataIdMap.get(notExistEntryid));
                notExistResult.add(map);
                param.remove(notExistEntryid);
            }
        }
        return notExistResult;
    }

    private Map<Long, Long> querySourceListEntryIdAndId(Map<Long, Map<String, Object>> param) {
        QFilter entryIdFilter = new QFilter("entryentity.id", "in", param.keySet());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        QFilter auditFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        DynamicObjectCollection queryId = QueryServiceHelper.query((String)"pm_sourcelist", (String)"id,entryentity.id", (QFilter[])new QFilter[]{entryIdFilter, enableFilter, auditFilter});
        HashMap<Long, Long> entryIdAndIdMap = new HashMap<Long, Long>(10);
        queryId.forEach(row -> entryIdAndIdMap.put((Long)row.get("entryentity.id"), (Long)row.get("id")));
        return entryIdAndIdMap;
    }

    private Set<Long> getNotExistEntryIds(Map<Long, Map<String, Object>> param, Map<Long, Long> entryIdAndIdMap) {
        HashSet<Long> notExistEntryIds = new HashSet<Long>(8);
        if (!entryIdAndIdMap.isEmpty()) {
            for (Long entryId : param.keySet()) {
                if (entryIdAndIdMap.containsKey(entryId)) continue;
                notExistEntryIds.add(entryId);
            }
        } else {
            return param.keySet();
        }
        return notExistEntryIds;
    }

    private List<Map<String, Object>> checkInPutParamForUpdate(Map<Long, Map<String, Object>> params, boolean termOfValidity) {
        ArrayList<Map<String, Object>> errorMsg = new ArrayList<Map<String, Object>>(8);
        Iterator<Map.Entry<Long, Map<String, Object>>> iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            HashMap<String, Object> map;
            HashMap<String, Object> map2;
            Map.Entry<Long, Map<String, Object>> param = iterator.next();
            Long sourcelistentryid = param.getKey();
            Map<String, Object> value = param.getValue();
            if (sourcelistentryid == null || Long.valueOf("0").equals(sourcelistentryid)) {
                map2 = new HashMap<String, Object>(3);
                map2.put("reason", ResManager.loadKDString((String)"\u540c\u6b65\u8d27\u6e90\u53c2\u6570\u9519\u8bef\uff0c\u8d27\u6e90\u6e05\u5355\u884cID\u4e3a\u7a7a\u3002", (String)"SourceServiceImpl_24", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                map2.put("success", Boolean.FALSE);
                map2.put("id", value.get("id"));
                map2.put("sourcelistentryid", sourcelistentryid);
                errorMsg.add(map2);
                iterator.remove();
                continue;
            }
            if (value == null || value.isEmpty()) {
                map2 = new HashMap(3);
                map2.put("reason", ResManager.loadKDString((String)"\u540c\u6b65\u8d27\u6e90\u53c2\u6570\u9519\u8bef\u3002", (String)"SourceServiceImpl_25", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                map2.put("success", Boolean.FALSE);
                map2.put("sourcelistentryid", sourcelistentryid);
                errorMsg.add(map2);
                iterator.remove();
                continue;
            }
            Long modifier = (Long)value.get("modifier");
            Date modifytime = (Date)value.get("modifytime");
            if (modifier == null || modifytime == null) {
                map = new HashMap<String, Object>(3);
                map.put("reason", ResManager.loadKDString((String)"\u540c\u6b65\u8d27\u6e90\u53c2\u6570\u9519\u8bef\uff0c\u4fee\u6539\u4eba\u3001\u4fee\u6539\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SourceServiceImpl_26", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                map.put("success", Boolean.FALSE);
                map.put("id", value.get("id"));
                map.put("sourcelistentryid", sourcelistentryid);
                errorMsg.add(map);
                iterator.remove();
                continue;
            }
            if (!termOfValidity || value.get("effectdate") != null && value.get("expirydate") != null) continue;
            map = new HashMap(3);
            map.put("reason", ResManager.loadKDString((String)"\u540c\u6b65\u8d27\u6e90\u53c2\u6570\u9519\u8bef\uff0c\u751f\u6548\u65e5\u671f\u3001\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SourceServiceImpl_27", (String)"scmc-pm-mservice", (Object[])new Object[0]));
            map.put("success", Boolean.FALSE);
            map.put("id", value.get("id"));
            map.put("sourcelistentryid", sourcelistentryid);
            errorMsg.add(map);
            iterator.remove();
        }
        return errorMsg;
    }
}

