/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice.mobile;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.common.enums.BillStatusEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.helper.AppParameterHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.CurrencyHelper;
import kd.scmc.pm.business.helper.MaterialHelper;
import kd.scmc.pm.business.helper.PurApplyBillHelper;
import kd.scmc.pm.business.pojo.AmountInfo;
import kd.scmc.pm.enums.BizCloseStatusEnum;
import kd.scmc.pm.enums.ChangeStatusEnum;
import kd.scmc.pm.enums.RowCloseStatusEnum;
import kd.scmc.pm.enums.RowTerminateStatusEnum;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.enums.UnitConvertDirEnum;
import kd.scmc.pm.mservice.mobile.IPmEntityService;
import kd.scmc.pm.utils.DateUtil;

public class PurApplyService
implements IPmEntityService {
    private static final String FIELD = "field";
    private static final String ENTRY_ID = "entryId";
    private static final String UNIT_CONVERT_DIR = "unitconvertdir";
    private static final String CUR_AMTPRECISION = "amtprecision";
    private static final String BILL_FORM_ID = "billformid";
    private static final String IS_DEFAULT = "isdefault";
    private static final String STATUS = "status";
    private static final String DEFAULT = "1";
    private static final String BASE_CURRENCY_ID = "baseCurrencyID";
    private static final String BILLENTRY_MATERIAL = "billentry.material";
    private static final String BILLENTRY_APPLY_QTY = "billentry.applyqty";
    private static final String BILLENTRY_PRICE_TAX = "billentry.priceandtax";
    private static final String BILLENTRY_TAX_RATE = "billentry.taxrateid";
    private static final String BD_BIZTYPE = "bd_biztype";
    private static final String BD_CURRENCY = "bd_currency";
    private static final String BOS_ORG = "bos_org";
    private static final String BOS_BILL_TYPE = "bos_billtype";
    private static final String BOS_USER = "bos_user";

    @Override
    public DynamicObject createNewData4Mob(DynamicObject bill) {
        Long baseCurrencyId;
        Long orgId;
        Map currencyAndExRateMap;
        Long bizTypeId;
        BillEntityType entityType;
        DynamicObject billType = this.queryDefaultBillType(bill);
        bill.set("billtype", (Object)billType);
        if (billType != null && (entityType = (BillEntityType)bill.getDataEntityType()) != null && (bizTypeId = BizTypeHelper.getDefaultBizType((String)entityType.getName(), (Long)((Long)billType.getPkValue()), (String)"pm_billtypeparameter")) != null) {
            DynamicObject bizType = BusinessDataServiceHelper.loadSingleFromCache((Object)bizTypeId, (String)BD_BIZTYPE);
            bill.set("biztype", (Object)bizType);
        }
        bill.set("biztime", (Object)DateUtil.getDate((Date)new Date()));
        long userId = UserServiceHelper.getCurrentUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)BOS_USER);
        bill.set("bizuser", (Object)user);
        bill.set("creator", (Object)user);
        Long deptId = UserServiceHelper.getUserMainOrgId((long)userId);
        DynamicObject deptOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)deptId, (String)BOS_ORG);
        bill.set("dept", (Object)deptOrg);
        DynamicObject org = bill.getDynamicObject("org");
        if (org != null && (currencyAndExRateMap = CurrencyHelper.getCurrencyAndExRateTable((Long)(orgId = (Long)org.getPkValue()))) != null && (baseCurrencyId = (Long)currencyAndExRateMap.get(BASE_CURRENCY_ID)) != null) {
            DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)baseCurrencyId, (String)BD_CURRENCY);
            bill.set("currency", (Object)currency);
        }
        bill.set("istax", (Object)Boolean.TRUE);
        bill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        bill.set("changestatus", (Object)ChangeStatusEnum.UNCHANGE.getValue());
        bill.set("closestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
        return bill;
    }

    @Override
    public DynamicObject propChanged(DynamicObject bill, List<Map<String, Object>> changedFields) {
        block14: for (Map<String, Object> changedField : changedFields) {
            String fieldKey;
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
            Long entryId = (Long)changedField.get(ENTRY_ID);
            switch (fieldKey = (String)changedField.get(FIELD)) {
                case "bizuser": {
                    this.changeBizUser(bill);
                    break;
                }
                case "billentry.material": {
                    Long pkValue;
                    DynamicObject entry;
                    int i;
                    for (i = 0; i < billEntry.size(); ++i) {
                        entry = (DynamicObject)billEntry.get(i);
                        pkValue = (Long)entry.getPkValue();
                        if (entryId == null || entryId.compareTo(0L) == 0 || entryId.compareTo(pkValue) != 0) continue;
                        this.materialChanged(bill, i);
                    }
                    continue block14;
                }
                case "billentry.applyqty": {
                    Long pkValue;
                    DynamicObject entry;
                    int i;
                    for (i = 0; i < billEntry.size(); ++i) {
                        entry = (DynamicObject)billEntry.get(i);
                        pkValue = (Long)entry.getPkValue();
                        if (entryId == null || entryId.compareTo(0L) == 0 || entryId.compareTo(pkValue) != 0) continue;
                        this.changeQty(entry);
                        this.calAmount(bill, entry, i);
                    }
                    continue block14;
                }
                case "billentry.priceandtax": {
                    Long pkValue;
                    DynamicObject entry;
                    int i;
                    for (i = 0; i < billEntry.size(); ++i) {
                        entry = (DynamicObject)billEntry.get(i);
                        pkValue = (Long)entry.getPkValue();
                        if (entryId == null || entryId.compareTo(0L) == 0 || entryId.compareTo(pkValue) != 0) continue;
                        this.calAmount(bill, entry, i);
                    }
                    continue block14;
                }
                case "billentry.taxrateid": {
                    Long pkValue;
                    DynamicObject entry;
                    int i;
                    for (i = 0; i < billEntry.size(); ++i) {
                        entry = (DynamicObject)billEntry.get(i);
                        pkValue = (Long)entry.getPkValue();
                        if (entryId == null || entryId.compareTo(0L) == 0 || entryId.compareTo(pkValue) != 0) continue;
                        DynamicObject taxRateId = entry.getDynamicObject("taxrateid");
                        if (taxRateId != null) {
                            entry.set("taxrate", taxRateId.get("taxrate"));
                        } else {
                            entry.set("taxrate", (Object)0);
                        }
                        this.calAmount(bill, entry, i);
                    }
                    continue block14;
                }
            }
        }
        return bill;
    }

    @Override
    public DynamicObject addRow4Mob(DynamicObject bill, String entryKey, List<Long> rowIds) {
        if ("billentry".equals(entryKey)) {
            DynamicObject org = bill.getDynamicObject("org");
            DynamicObjectCollection billentry = bill.getDynamicObjectCollection(entryKey);
            for (DynamicObject entry : billentry) {
                Long rowId = (Long)entry.getPkValue();
                if (rowId == null || rowId.compareTo(0L) == 0) continue;
                for (Long id : rowIds) {
                    Long recOrgId;
                    Long reqOrgId;
                    if (rowId.compareTo(id) != 0) continue;
                    entry.set("entrypurog", (Object)org);
                    DynamicObject bizType = bill.getDynamicObject("biztype");
                    if (bizType != null) {
                        DynamicObject lineType = BizTypeHelper.getDefaultLineTypeObject((Long)((Long)bizType.getPkValue()));
                        entry.set("linetype", (Object)lineType);
                    }
                    if ((reqOrgId = this.getDefaultOrgRelation(null, "02", (Long)org.getPkValue(), "fromorg")) != 0L) {
                        DynamicObject reqOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)reqOrgId, (String)BOS_ORG);
                        entry.set("entryreqorg", (Object)reqOrg);
                    }
                    if ((recOrgId = this.getDefaultOrgRelation("02", "05", (Long)org.getPkValue(), "toorg")) != 0L) {
                        DynamicObject recOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)recOrgId, (String)BOS_ORG);
                        entry.set("entryrecorg", (Object)recOrg);
                    }
                    Date date = DateUtil.getDate((Date)new Date());
                    entry.set("reqdate", (Object)date);
                    entry.set("purdate", (Object)date);
                    entry.set("rowclosestatus", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
                    entry.set("rowterminatestatus", (Object)RowTerminateStatusEnum.UNROWTERMINATE.getValue());
                }
            }
        }
        return bill;
    }

    @Override
    public DynamicObject deleteRow(DynamicObject bill, String entity, List<Long> rowIds) {
        DynamicObjectCollection entryColl = bill.getDynamicObjectCollection(entity);
        block0: for (int i = 0; i < entryColl.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryColl.get(i);
            Long pkValue = (Long)entry.getPkValue();
            if (pkValue == null || pkValue.compareTo(0L) == 0) continue;
            for (Long row : rowIds) {
                if (row == null || row.compareTo(pkValue) != 0) continue;
                this.reCalHeadAmount(bill, i);
                entryColl.remove(i);
                continue block0;
            }
        }
        return bill;
    }

    private void materialChanged(DynamicObject bill, int index) {
        DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
        DynamicObject entry = (DynamicObject)billentry.get(index);
        DynamicObject material = entry.getDynamicObject("material");
        entry.set("materialname", null);
        entry.set("materialmasterid", null);
        entry.set("materialversion", null);
        entry.set("auxpty", null);
        entry.set("unit", null);
        entry.set("auxunit", null);
        entry.set("baseunit", null);
        entry.set("applyqty", (Object)BigDecimal.ZERO);
        entry.set("price", (Object)BigDecimal.ZERO);
        entry.set("priceandtax", (Object)BigDecimal.ZERO);
        entry.set("taxrateid", null);
        entry.set("taxrate", (Object)BigDecimal.ZERO);
        entry.set("amount", (Object)BigDecimal.ZERO);
        entry.set("taxamount", (Object)BigDecimal.ZERO);
        entry.set("qty", (Object)BigDecimal.ZERO);
        entry.set("auxqty", (Object)BigDecimal.ZERO);
        entry.set("baseqty", (Object)BigDecimal.ZERO);
        entry.set("entryoperator", null);
        entry.set("entryoperatorgroup", null);
        BigDecimal oldAmountAndTax = entry.getBigDecimal("amountandtax");
        entry.set("amountandtax", (Object)BigDecimal.ZERO);
        BigDecimal totalAllAmount = bill.getBigDecimal("totalallamount");
        if (oldAmountAndTax != null) {
            totalAllAmount = totalAllAmount.subtract(oldAmountAndTax);
        }
        bill.set("totalallamount", (Object)totalAllAmount);
        if (material != null) {
            DynamicObject supplier;
            DynamicObject defaultTaxRate;
            DynamicObject master = material.getDynamicObject("masterid");
            if (master != null) {
                entry.set("materialmasterid", (Object)master);
                entry.set("materialname", master.getLocaleString("name") != null ? master.getLocaleString("name").toString() : null);
                if (master.getDynamicObject("auxptyunit") != null) {
                    entry.set("auxunit", (Object)master.getDynamicObject("auxptyunit"));
                }
                if (master.getDynamicObject("baseunit") != null) {
                    entry.set("baseunit", (Object)master.getDynamicObject("baseunit"));
                }
            }
            if (material.getDynamicObject("purchaseunit") != null) {
                entry.set("unit", (Object)material.getDynamicObject("purchaseunit"));
            }
            if ((defaultTaxRate = MaterialHelper.getDefaultTaxRate((DynamicObject)(supplier = entry.getDynamicObject("supplier")), (DynamicObject)material)) != null) {
                entry.set("taxrateid", (Object)defaultTaxRate);
                entry.set("taxrate", (Object)defaultTaxRate.getBigDecimal("taxrate"));
            }
            DynamicObject org = bill.getDynamicObject("org");
            if (master != null && org != null) {
                Long orgPkValue = (Long)org.getPkValue();
                Long masterId = (Long)master.getPkValue();
                Object isUpApplyObj = AppParameterHelper.getPmAppParameter((Long)orgPkValue, (String)"purapplyfitoperator");
                String entityName = bill.getDataEntityType().getName();
                if (Boolean.TRUE.equals(isUpApplyObj instanceof Boolean && (Boolean)isUpApplyObj != false) && !entityName.equals("pm_purplanbill")) {
                    Map materFitOpeInfo;
                    HashSet<Long> materialIdSet = new HashSet<Long>();
                    materialIdSet.add(masterId);
                    Map operatorMap = PurApplyBillHelper.getMaterialFitOperatorNew((Long)orgPkValue, materialIdSet);
                    if (operatorMap != null && operatorMap.size() > 0 && (materFitOpeInfo = (Map)operatorMap.get(masterId)) != null) {
                        entry.set("entryoperator", materFitOpeInfo.get("operator"));
                        entry.set("entryoperatorgroup", materFitOpeInfo.get("operatorgroup"));
                    }
                }
            }
        }
    }

    private void changeBizUser(DynamicObject bill) {
        Long userId;
        DynamicObject dept = null;
        DynamicObject bizUser = bill.getDynamicObject("bizuser");
        if (bizUser != null && (userId = (Long)bizUser.getPkValue()) != null) {
            Long deptId = UserServiceHelper.getUserMainOrgId((long)userId);
            dept = BusinessDataServiceHelper.loadSingleFromCache((Object)deptId, (String)BOS_ORG);
        }
        bill.set("dept", dept);
    }

    private void changeQty(DynamicObject entry) {
        BigDecimal applyQty = entry.getBigDecimal("applyqty");
        DynamicObject material = entry.getDynamicObject("material");
        DynamicObject unit = entry.getDynamicObject("unit");
        if (material == null || unit == null) {
            return;
        }
        DynamicObject materialMaster = material.getDynamicObject("masterid");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        DynamicObject auxUnit = entry.getDynamicObject("auxunit");
        entry.set("qty", (Object)applyQty);
        if (baseUnit == null && materialMaster != null && (baseUnit = materialMaster.getDynamicObject("baseunit")) != null) {
            entry.set("baseunit", baseUnit.getPkValue());
        }
        if (baseUnit != null && materialMaster != null) {
            Long materialMasterId = (Long)materialMaster.getPkValue();
            BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialMasterId, (DynamicObject)unit, (BigDecimal)applyQty, (DynamicObject)baseUnit);
            entry.set("baseqty", (Object)baseQty);
            if (auxUnit != null) {
                String unitConvertDir = materialMaster.getString(UNIT_CONVERT_DIR);
                if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                    BigDecimal auxQty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialMasterId, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit);
                    entry.set("auxqty", (Object)auxQty);
                }
            }
        }
    }

    private void calAmount(DynamicObject bill, DynamicObject entry, int i) {
        DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
        DynamicObject row = (DynamicObject)billEntry.get(i);
        boolean isTax = bill.getBoolean("istax");
        DynamicObject currency = bill.getDynamicObject("currency");
        int currencyAmtPrecision = currency == null ? 10 : currency.getInt(CUR_AMTPRECISION);
        BigDecimal qty = entry.getBigDecimal("qty");
        BigDecimal price = entry.getBigDecimal("price");
        BigDecimal priceAndTax = entry.getBigDecimal("priceandtax");
        BigDecimal taxRate = entry.getBigDecimal("taxrate");
        AmountInfo amountInfo = new AmountInfo();
        amountInfo.setTax(isTax);
        amountInfo.setQty(qty);
        amountInfo.setPrice(price);
        amountInfo.setPriceAndTax(priceAndTax);
        amountInfo.setTaxRate(taxRate);
        amountInfo.setSettleAmtPrecision(currencyAmtPrecision);
        AmountHelper.getAmount((AmountInfo)amountInfo);
        if (isTax) {
            row.set("price", (Object)amountInfo.getPrice());
        } else {
            row.set("priceandtax", (Object)amountInfo.getPriceAndTax());
        }
        BigDecimal oldAmountAndTax = entry.getBigDecimal("amountandtax");
        BigDecimal amountAndTax = amountInfo.getAmountAndTax();
        row.set("amount", (Object)amountInfo.getAmount());
        row.set("taxamount", (Object)amountInfo.getTaxAmount());
        row.set("amountandtax", (Object)amountAndTax);
        BigDecimal totalAllAmount = (BigDecimal)bill.get("totalallamount");
        totalAllAmount = totalAllAmount.subtract(oldAmountAndTax).add(amountAndTax);
        bill.set("totalallamount", (Object)totalAllAmount);
    }

    private void reCalHeadAmount(DynamicObject bill, int i) {
        DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
        DynamicObject entry = (DynamicObject)billentry.get(i);
        BigDecimal totalAllAmount = BigDecimalUtil.getNotNull((Object)bill.getBigDecimal("totalallamount"));
        BigDecimal amountAndTax = BigDecimalUtil.getNotNull((Object)entry.getBigDecimal("amountandtax"));
        totalAllAmount = totalAllAmount.subtract(amountAndTax);
        bill.set("totalallamount", (Object)totalAllAmount);
    }

    private DynamicObject queryDefaultBillType(DynamicObject bill) {
        QFilter qFilter = new QFilter(BILL_FORM_ID, "=", (Object)bill.getDataEntityType().getName());
        qFilter.and(new QFilter(IS_DEFAULT, "=", (Object)DEFAULT));
        qFilter.and(new QFilter(STATUS, "=", (Object)StatusEnum.AUDIT.getValue()));
        return BusinessDataServiceHelper.loadSingleFromCache((String)BOS_BILL_TYPE, (QFilter[])qFilter.toArray());
    }

    private Long getDefaultOrgRelation(String fromOrgType, String toOrgType, Long orgId, String orgRelationParam) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(orgId.longValue());
        param.setFromViewType(fromOrgType);
        param.setToViewType(toOrgType);
        param.setDirectViewType(orgRelationParam);
        Long orgIdFromRelation = OrgUnitServiceHelper.getDefaultOrgRelation((OrgRelationParam)param);
        return orgIdFromRelation;
    }
}

