/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPools;
import kd.scmc.plat.business.service.upgrade.BillTplUpgradeImpl;

public class MultilingualUpgradeServiceImpl
extends BillTplUpgradeImpl {
    private static final Map<String, Set<String>> upgradedata = new HashMap<String, Set<String>>(9, 1.0f){
        {
            this.put("t_pm_quota", new HashSet<String>(){
                {
                    this.add("fname");
                }
            });
            this.put("t_pm_settleparam", new HashSet<String>(){
                {
                    this.add("fname");
                }
            });
            this.put("t_pm_sourcelist", new HashSet<String>(){
                {
                    this.add("fname");
                    this.add("fcomment");
                }
            });
            this.put("t_pm_requirapplybill", new HashSet<String>(){
                {
                    this.add("fcomment");
                }
            });
            this.put("t_pm_purapplybill", new HashSet<String>(){
                {
                    this.add("fcomment");
                }
            });
            this.put("t_pm_purorderbill", new HashSet<String>(){
                {
                    this.add("fcomment");
                }
            });
            this.put("t_pm_xpurorderbill", new HashSet<String>(){
                {
                    this.add("fcomment");
                }
            });
            this.put("t_pm_purrefundapplybill", new HashSet<String>(){
                {
                    this.add("fcomment");
                }
            });
        }
    };

    public UpgradeResult beforeExecuteSqlWithResult() {
        UpgradeResult result = new UpgradeResult();
        upgradedata.forEach((key, value) -> ThreadPools.executeOnce((String)((Object)((Object)this)).getClass().getName(), () -> this.doUpdateMul(new DBRoute("scm"), result, key.concat("_l"), (String)key, value.toArray(new String[0]), "FID", 1000)));
        result.setSuccess(true);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UpgradeResult doUpdateMul(DBRoute dbRoute, UpgradeResult result, String t_old, String t_new, String[] fs, String f_key, int rows) {
        Throwable throwable;
        StringBuilder sql_query = new StringBuilder(" SELECT ");
        StringBuilder sql_update = new StringBuilder(" UPDATE ").append(t_new).append(" ").append(" SET ");
        for (String f : fs) {
            sql_query.append(f).append(',');
            sql_update.append(f).append("=?,");
        }
        sql_query.append(f_key);
        sql_query.append(" FROM ").append(t_old).append(" WHERE  FLOCALEID='zh_CN'");
        sql_update = new StringBuilder(sql_update.substring(0, sql_update.length() - 1));
        sql_update.append(" WHERE ").append(f_key).append("=?");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        try {
            throwable = null;
            try (DataSet ds = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)dbRoute, (String)sql_query.toString(), null);){
                for (Row row : ds) {
                    ArrayList<Object> params = new ArrayList<Object>();
                    for (String f : fs) {
                        params.add(row.get(f));
                    }
                    params.add(row.get(f_key));
                    paramList.add(params.toArray());
                    if (rows == 0 || paramList.size() < rows) continue;
                    TXHandle h = TX.required((String)((Object)((Object)this)).getClass().getName());
                    Throwable throwable2 = null;
                    try {
                        try {
                            this.executeSqlBatch(dbRoute, sql_update.toString(), paramList);
                            paramList.clear();
                        }
                        catch (Throwable e) {
                            h.markRollback();
                            result.setSuccess(false);
                            String err = "database execution failed,errorInfo" + e.getMessage();
                            result.setErrorInfo(err);
                            result.setLog("database execution failed,errorMsgInfo" + e.getMessage());
                            logger.info(err);
                            UpgradeResult upgradeResult = result;
                            if (h != null) {
                                if (throwable2 != null) {
                                    try {
                                        h.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                } else {
                                    h.close();
                                }
                            }
                            if (ds == null) return upgradeResult;
                            if (throwable != null) {
                                try {
                                    ds.close();
                                    return upgradeResult;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    return upgradeResult;
                                }
                            }
                            ds.close();
                            return upgradeResult;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (h == null) continue;
                        if (throwable2 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        h.close();
                    }
                }
            }
            catch (Throwable f) {
                throwable = f;
                throw f;
            }
        }
        catch (Throwable e) {
            result.setSuccess(false);
            String err = "query data field failed,errorMsgInfo\uff1a" + e.getMessage();
            result.setErrorInfo(err);
            result.setLog(err);
            logger.info(err);
            return result;
        }
        logger.info("query update successful.");
        if (paramList.isEmpty()) {
            logger.info("query update data is empty.");
            result.setSuccess(true);
            result.setLog("data update successful.");
            logger.info("data update successful.");
            return result;
        }
        throwable = null;
        try (TXHandle h = TX.required((String)((Object)((Object)this)).getClass().getName());){
            try {
                DB.executeBatch((DBRoute)dbRoute, (String)sql_update.toString(), paramList);
            }
            catch (Throwable e) {
                h.markRollback();
                result.setSuccess(false);
                String err = "database execution failed,errorInfo" + e.getMessage();
                result.setErrorInfo(err);
                result.setLog("database execution failed,errorMsgInfo" + e.getMessage());
                logger.info(err);
                UpgradeResult upgradeResult = result;
                if (h == null) return upgradeResult;
                if (throwable == null) {
                    h.close();
                    return upgradeResult;
                }
                try {
                    h.close();
                    return upgradeResult;
                }
                catch (Throwable throwable7) {
                    throwable.addSuppressed(throwable7);
                    return upgradeResult;
                }
            }
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
        result.setSuccess(true);
        result.setLog("data update successful.");
        logger.info("data update successful.");
        return result;
    }

    private void executeSqlBatch(DBRoute dbRoute, String sql, List<Object[]> paramList) {
        DB.executeBatch((DBRoute)dbRoute, (String)sql, paramList);
    }
}

