/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice.upgrade.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class EntryMaterialMasteridUpgradeService
implements IUpgradeService {
    private static Log log = LogFactory.getLog(EntryMaterialMasteridUpgradeService.class);
    private static final int BATCH_SIZE = 2000;
    private Map MaterialMasteridMap = new HashMap(16){
        {
            this.put("fmaterialid", "fmaterialmasterid");
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdate(DBRoute dbRoute, String sourceTable, String materialpurinfoTable, UpgradeResult result) {
        for (Map.Entry entry : this.MaterialMasteridMap.entrySet()) {
            String sql_material = "select FID,FEntryID, " + (String)entry.getKey() + " from " + sourceTable + " WHERE " + (String)entry.getValue() + " = 0  and " + (String)entry.getKey() + " <> 0";
            DataSet ds = null;
            DataSet masterids = null;
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            ArrayList<Object> materialIDs = new ArrayList<Object>();
            HashMap<Object, Object> materialEntryIDs = new HashMap<Object, Object>();
            HashMap<Object, Object> materialMasterids = new HashMap<Object, Object>();
            try {
                ds = this.queryDataSet(dbRoute, sql_material);
                for (Row row : ds) {
                    materialIDs.add(row.get((String)entry.getKey()));
                    materialEntryIDs.put(row.get("FEntryID"), row.get((String)entry.getKey()));
                }
                if (materialIDs.size() == 0) {
                    if (ds != null) {
                        ds.close();
                    }
                    return;
                }
                DBRoute sysRoute = new DBRoute("sys");
                SqlBuilder sql_materialpurinfo = new SqlBuilder();
                sql_materialpurinfo.append("SELECT fmasterid,fid FROM " + materialpurinfoTable + " WHERE ", new Object[0]);
                sql_materialpurinfo.appendIn("fid", materialIDs.toArray());
                masterids = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (SqlBuilder)sql_materialpurinfo);
                for (Row row : masterids) {
                    materialMasterids.put(row.get("fid"), row.get("fmasterid") != null ? row.get("fmasterid") : Integer.valueOf(0));
                }
                if (materialEntryIDs.size() == 0 || materialMasterids.size() == 0) {
                    return;
                }
                Iterator materialEntryIDsIterator = materialEntryIDs.entrySet().iterator();
                log.info("\u9700\u8981\u66f4\u65b0\u7684\u7269\u6599\u4fe1\u606f\u96c6\u5408materialMasterids\uff1a" + materialMasterids);
                String sql_update = "UPDATE " + sourceTable + " SET fmaterialmasterid = ? WHERE FEntryID = ? AND fmaterialmasterid = 0";
                while (materialEntryIDsIterator.hasNext()) {
                    Map.Entry objectEntry = materialEntryIDsIterator.next();
                    if (objectEntry.getValue() != null && materialMasterids.get(objectEntry.getValue()) != null) {
                        Object[] params = new Object[]{materialMasterids.get(objectEntry.getValue()), objectEntry.getKey()};
                        paramList.add(params);
                    }
                    if (paramList.size() < 2000) continue;
                    try {
                        this.executeBatch(dbRoute, sql_update, paramList);
                        paramList.clear();
                    }
                    catch (Throwable e) {
                        result.setSuccess(false);
                        String err = "materialmasterid field upgrade failed! table name: " + sourceTable + " field name : " + (String)entry.getValue() + e.getMessage();
                        result.setErrorInfo(err);
                        result.setLog(err);
                        log.info(err);
                    }
                }
                if (!paramList.isEmpty() && paramList.size() < 2000) {
                    try {
                        this.executeBatch(dbRoute, sql_update, paramList);
                    }
                    catch (Throwable e) {
                        result.setSuccess(false);
                        String err = "materialmasterid field upgrade failed! table name: " + sourceTable + " field name : " + (String)entry.getValue() + e.getMessage();
                        result.setErrorInfo(err);
                        result.setLog(err);
                        log.info(err);
                    }
                }
            }
            catch (Throwable e) {
                result.setSuccess(false);
                String err = "materialmasterid field upgrade failed! table name: " + sourceTable + " field name : " + (String)entry.getValue() + e.getMessage();
                result.setErrorInfo(err);
                result.setLog(err);
                log.info(err);
            }
            finally {
                if (ds != null) {
                    ds.close();
                }
                if (masterids != null) {
                    masterids.close();
                }
            }
            result.setSuccess(true);
            result.setLog("Amount field upgrade success!");
        }
    }

    private void executeBatch(DBRoute dbRoute, String sql_update, List<Object[]> paramList) {
        DB.executeBatch((DBRoute)dbRoute, (String)sql_update, paramList);
    }

    private DataSet queryDataSet(DBRoute dbRoute, String sql_query) {
        return DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (String)sql_query);
    }
}

