/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice.upgrade.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import org.apache.commons.lang.StringUtils;

public class ResourceBaseQtyUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(ResourceBaseQtyUpgradeService.class);
    private static final int BATCHSIZE = 10000;
    private static final DBRoute SCMROUTE = new DBRoute("scm");
    private static final DBRoute SYSROUTE = new DBRoute("sys");
    private static final String SRCFIELD_KEY = "SRCFIELD_KEY";
    private static final String ENTRYIDS_KEY = "ENTRYIDLIST_KEY";
    protected String tableName;
    protected String noBaseQtySql;
    protected Map<String, String> srcFieldAndTarFieldMap = new HashMap<String, String>(6);

    public UpgradeResult doUpdate() {
        log.info("\u6570\u636e\u5347\u7ea7\u670d\u52a1 " + this.tableName + " \u5f00\u59cb");
        UpgradeResult result = new UpgradeResult();
        String inputUpdateSql = this.noBaseQtySql;
        Map<Long, Map<String, Object>> unitInfoMap = this.getUsedUnitInfoMap();
        for (Map.Entry<String, String> entry : this.srcFieldAndTarFieldMap.entrySet()) {
            String srcField = entry.getKey();
            String tarField = entry.getValue();
            String queryEntryIdSql = "SELECT FENTRYID FROM " + this.tableName + "  WHERE  " + tarField + " = 0 AND " + srcField + " <> 0 ";
            List<Long> entryIdList = this.getUpdateEntryIds(queryEntryIdSql);
            if (entryIdList.isEmpty()) {
                return result;
            }
            List<List<Long>> batchs = this.splitList(entryIdList);
            entryIdList = null;
            for (List<Long> oneBatch : batchs) {
                result = this.excuteOneBatch(oneBatch, result, srcField, tarField, unitInfoMap);
            }
            this.noBaseQtySql = inputUpdateSql;
        }
        return result;
    }

    private UpgradeResult excuteOneBatch(List<Long> oneBatch, UpgradeResult result, String srcField, String tarField, Map<Long, Map<String, Object>> unitInfoMap) {
        if (oneBatch == null || oneBatch.isEmpty()) {
            return result;
        }
        String queryEntryInfoSql = this.getQueryEntryInfoSql(oneBatch, srcField);
        if (queryEntryInfoSql == null) {
            return result;
        }
        oneBatch = null;
        ArrayList<Object[]> sqlParam = new ArrayList<Object[]>(10);
        HashMap<Long, CalQtyInfo> calQtyInfoMap = new HashMap<Long, CalQtyInfo>(16);
        try (DataSet rows = null;){
            rows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)SCMROUTE, (String)queryEntryInfoSql);
            for (Row row : rows) {
                Long baseunitId = row.getLong("FBASEUNITID");
                Long unitId = row.getLong("FUNITID");
                Long materialId = row.getLong("FMATERIALID");
                Long fentryid = row.getLong("FENTRYID");
                BigDecimal baseQty = row.getBigDecimal("FBASEQTY");
                BigDecimal qty = row.getBigDecimal("FQTY");
                BigDecimal srcQty = row.getBigDecimal(srcField);
                if (baseunitId == null || unitId == null || materialId == null || baseQty == null || qty == null || srcQty == null || baseunitId.equals(0L) || unitId.equals(0L) || materialId.equals(0L) || BigDecimal.ZERO.compareTo(baseQty) == 0 || BigDecimal.ZERO.compareTo(qty) == 0 || BigDecimal.ZERO.compareTo(srcQty) == 0) {
                    log.info("\u6570\u636e\u5347\u7ea7\u670d\u52a1 " + this.tableName + " \u7269\u6599,\u5355\u4f4d\u4fe1\u606f,\u6570\u91cf,\u57fa\u672c\u6570\u91cf,\u6e90\u6570\u91cf\u4e3a\u7a7a\u62160\u3002\u884cid\u4e3a\uff1a" + fentryid);
                    continue;
                }
                if (baseunitId.equals(unitId)) {
                    sqlParam.add(this.getParamArray(row, srcField));
                    continue;
                }
                calQtyInfoMap.put(fentryid, new CalQtyInfo(unitId, baseunitId, srcQty, qty, baseQty));
            }
        }
        if (!calQtyInfoMap.isEmpty()) {
            sqlParam.addAll(this.getCalQtyParam(calQtyInfoMap, unitInfoMap));
        }
        calQtyInfoMap = null;
        if (sqlParam == null || sqlParam.isEmpty()) {
            return result;
        }
        try (TXHandle tx = TX.required((String)this.getClass().getName());){
            try {
                String updateSql = "UPDATE " + this.tableName + " SET " + tarField + " = ? WHERE FENTRYID = ?";
                DB.executeBatch((DBRoute)SCMROUTE, (String)updateSql, sqlParam);
                sqlParam = null;
                tx.commit();
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error("\u6570\u636e\u5347\u7ea7\u670d\u52a1 " + this.tableName + "\u6267\u884c\u5931\u8d25\u3002" + e.getMessage());
                result.setSuccess(false);
                String errorInfo = "database execution failed,errorInfo" + e.getMessage();
                result.setErrorInfo(errorInfo);
                result.setLog(errorInfo);
                throw e;
            }
        }
        return result;
    }

    private List<Object[]> getCalQtyParam(Map<Long, CalQtyInfo> calQtyInfoMap, Map<Long, Map<String, Object>> unitInfoMap) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        for (Map.Entry<Long, CalQtyInfo> entry : calQtyInfoMap.entrySet()) {
            Long entryId = entry.getKey();
            CalQtyInfo info = entry.getValue();
            Long baseUnitId = info.getBaseUnitId();
            BigDecimal srcQty = info.getSrcQty();
            BigDecimal qty = info.getQty();
            BigDecimal baseQty = info.getBaseQty();
            Object[] param = new Object[2];
            Map<String, Object> baseUnitInfo = unitInfoMap.get(baseUnitId);
            if (baseUnitInfo == null) {
                log.info("\u6570\u636e\u5347\u7ea7\u670d\u52a1 " + this.tableName + " \u57fa\u672c\u5355\u4f4d\u5df2\u4e0d\u5b58\u5728\u3002 " + entry);
                continue;
            }
            if (srcQty == null) continue;
            param[0] = BigDecimal.ZERO.compareTo(srcQty) == 0 ? BigDecimal.ZERO : this.getDesQty(srcQty, qty, baseQty, baseUnitInfo);
            param[1] = entryId;
            paramList.add(param);
        }
        unitInfoMap = null;
        calQtyInfoMap = null;
        return paramList;
    }

    private Map<Long, Map<String, Object>> getUsedUnitInfoMap() {
        String queryUnitSql = "SELECT FID , FPRECISIONTYPE , FPRECISION FROM T_BD_MEASUREUNIT ;";
        HashMap<Long, Map<String, Object>> unitInfoMap = new HashMap<Long, Map<String, Object>>(100);
        try (DataSet unitDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)SYSROUTE, (String)queryUnitSql);){
            for (Row row : unitDataSet) {
                Long fid = row.getLong("FID");
                Integer fprecision = row.getInteger("FPRECISION");
                String fprecisiontype = row.getString("FPRECISIONTYPE");
                HashMap<String, Object> oneUnitInfo = new HashMap<String, Object>(3);
                oneUnitInfo.put("precision", fprecision);
                oneUnitInfo.put("id", fid);
                oneUnitInfo.put("precisiontype", fprecisiontype);
                unitInfoMap.put(fid, oneUnitInfo);
            }
        }
        return unitInfoMap;
    }

    private Object getDesQty(BigDecimal srcQty, BigDecimal qty, BigDecimal baseQty, Map<String, Object> baseUnitInfo) {
        int precision = baseUnitInfo.get("precision") == null ? 10 : (Integer)baseUnitInfo.get("precision");
        String precisionAccount = (String)baseUnitInfo.get("precisionaccount");
        RoundingMode roundingMode = RoundingMode.HALF_UP;
        if ("3".equals(precisionAccount)) {
            roundingMode = RoundingMode.UP;
        } else if ("2".equals(precisionAccount)) {
            roundingMode = RoundingMode.DOWN;
        }
        BigDecimal desQty = srcQty.multiply(baseQty).divide(qty, precision, roundingMode);
        return desQty;
    }

    private Object[] getParamArray(Row row, String fieldKeys) {
        Object[] param = new Object[]{row.getBigDecimal(fieldKeys) == null ? BigDecimal.ZERO : row.getBigDecimal(fieldKeys), row.getLong("FENTRYID")};
        return param;
    }

    private String getQueryEntryInfoSql(List<Long> oneBatch, String srcField) {
        if (oneBatch == null || oneBatch.isEmpty()) {
            return null;
        }
        String entryIds = StringUtils.strip((String)oneBatch.toString(), (String)"[]");
        String queryBillEntryInfoSql = this.noBaseQtySql.replace(ENTRYIDS_KEY, entryIds);
        queryBillEntryInfoSql = queryBillEntryInfoSql.replace(SRCFIELD_KEY, srcField);
        return queryBillEntryInfoSql;
    }

    private List<Long> getUpdateEntryIds(String queryEntryIdSql) {
        DataSet entryIdDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)SCMROUTE, (String)queryEntryIdSql);
        ArrayList<Long> entryIdList = new ArrayList<Long>(1000);
        for (Row row : entryIdDataSet) {
            entryIdList.add(row.getLong("FENTRYID"));
        }
        return entryIdList;
    }

    private List<List<Long>> splitList(List<Long> list) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>(10);
        if (list == null || list.size() == 0) {
            return result;
        }
        int size = list.size();
        int count = (size + 10000 - 1) / 10000;
        for (int i = 0; i < count; ++i) {
            List<Long> subList = list.subList(i * 10000, (i + 1) * 10000 > size ? size : 10000 * (i + 1));
            result.add(subList);
        }
        return result;
    }

    static class CalQtyInfo {
        private Long unitId;
        private Long baseUnitId;
        private BigDecimal srcQty;
        private BigDecimal qty;
        private BigDecimal baseQty;

        public CalQtyInfo(Long unitId, Long baseUnitId, BigDecimal srcQty, BigDecimal qty, BigDecimal baseQty) {
            this.unitId = unitId;
            this.baseUnitId = baseUnitId;
            this.srcQty = srcQty;
            this.qty = qty;
            this.baseQty = baseQty;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        public BigDecimal getBaseQty() {
            return this.baseQty;
        }

        public void setBaseQty(BigDecimal baseQty) {
            this.baseQty = baseQty;
        }

        public Long getUnitId() {
            return this.unitId;
        }

        public void setUnitId(Long unitId) {
            this.unitId = unitId;
        }

        public Long getBaseUnitId() {
            return this.baseUnitId;
        }

        public void setBaseUnitId(Long baseUnitId) {
            this.baseUnitId = baseUnitId;
        }

        public BigDecimal getSrcQty() {
            return this.srcQty;
        }

        public void setSrcQty(BigDecimal srcQty) {
            this.srcQty = srcQty;
        }

        public String toString() {
            return "CalQtyInfo{unitId=" + this.unitId + ", baseUnitId=" + this.baseUnitId + ", srcQty=" + this.srcQty + ", qty=" + this.qty + ", baseQty=" + this.baseQty + '}';
        }
    }
}

