/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.enums.DiscountTypeEnum;
import kd.scmc.pm.enums.ExchangeTypeEnum;

public class BackCalculationHelper {
    public static final int PRECISION = 10;

    public static void backCalculation(DynamicObject bill, int[] rowIndexs, String propName, IDataModel model) {
        DynamicObjectCollection dynamicObject = bill.getDynamicObjectCollection("billentry");
        for (int rowindex : rowIndexs) {
            DynamicObject coll = (DynamicObject)dynamicObject.get(rowindex);
            BackCalculationHelper.calculationAmount(bill, coll, propName, model);
        }
    }

    private static void calculWholeBill(DynamicObjectCollection dynamicObject, DynamicObject bill, String propName, IDataModel model) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalAllAmount = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        for (int i = 0; i < dynamicObject.size(); ++i) {
            DynamicObject coll = (DynamicObject)dynamicObject.get(i);
            BackCalculationHelper.calculationAmount(bill, coll, propName, model);
            totalAllAmount = totalAllAmount.add(coll.getBigDecimal("amountandtax"));
            totalAmount = totalAmount.add(coll.getBigDecimal("amount"));
            totalTaxAmount = totalTaxAmount.add(coll.getBigDecimal("taxamount"));
        }
        if (model != null) {
            model.setValue("totalallamount", (Object)totalAllAmount);
            model.setValue("totalamount", (Object)totalAmount);
            model.setValue("totaltaxamount", (Object)totalTaxAmount);
        } else {
            bill.set("totalallamount", (Object)totalAllAmount);
            bill.set("totalamount", (Object)totalAmount);
            bill.set("totaltaxamount", (Object)totalTaxAmount);
        }
    }

    public static void backCalculsettlecurrencyIstax(DynamicObject bill, String propName, IDataModel model) {
        DynamicObjectCollection dynamicObject = bill.getDynamicObjectCollection("billentry");
        BigDecimal totalAllAmount = BigDecimal.ZERO;
        for (int i = 0; i < dynamicObject.size(); ++i) {
            DynamicObject coll = (DynamicObject)dynamicObject.get(i);
            BackCalculationHelper.calculationAmount(bill, coll, propName, model);
            BigDecimal amountAndTax = coll.getBigDecimal("amountandtax");
            totalAllAmount = totalAllAmount.add(amountAndTax);
        }
        if (model != null) {
            model.setValue("totalallamount", (Object)totalAllAmount);
        } else {
            bill.set("totalallamount", (Object)totalAllAmount);
        }
    }

    public static void backCalculsettlecurrency(DynamicObject bill, String propName, IDataModel model) {
        DynamicObjectCollection dynamicObject = bill.getDynamicObjectCollection("billentry");
        BackCalculationHelper.calculWholeBill(dynamicObject, bill, propName, model);
    }

    private static void calculationAmount(DynamicObject bill, DynamicObject coll, String propName, IDataModel model) {
        Boolean istax = (Boolean)bill.get("istax");
        BigDecimal taxRate = coll.getBigDecimal("taxrate");
        taxRate = taxRate.divide(new BigDecimal(100), 10, RoundingMode.HALF_UP);
        int precision = BackCalculationHelper.getPrecision(bill);
        int currencyPrecision = BackCalculationHelper.getCurrencyPrecision(bill);
        BigDecimal totalBalance = BigDecimal.ZERO;
        BigDecimal amountAndTax = BigDecimal.ZERO;
        BigDecimal curAmountAndTax = BigDecimal.ZERO;
        BigDecimal taxAmout = BigDecimal.ZERO;
        BigDecimal curTaxAmount = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal curamount = BigDecimal.ZERO;
        BigDecimal priceAndTax = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        BigDecimal discountamount = BigDecimal.ZERO;
        BigDecimal exChangeRate = bill.getBigDecimal("exchangerate");
        boolean isIndirectRate = ExchangeTypeEnum.isIndirectRate((Object)bill.getString("exchangetype"));
        if (istax.booleanValue() && "amountandtax".equals(propName)) {
            amountAndTax = coll.getBigDecimal("amountandtax");
            amountAndTax = amountAndTax.setScale(precision, RoundingMode.HALF_UP);
            curAmountAndTax = AmountHelper.convertByExRate(amountAndTax, exChangeRate, isIndirectRate, currencyPrecision);
            taxAmout = amountAndTax.divide(BigDecimal.ONE.add(taxRate), 10, RoundingMode.HALF_UP).multiply(taxRate);
            taxAmout = taxAmout.setScale(precision, RoundingMode.HALF_UP);
            curTaxAmount = AmountHelper.convertByExRate(taxAmout, exChangeRate, isIndirectRate, currencyPrecision);
            amount = amountAndTax.subtract(taxAmout);
            amount = amount.setScale(precision, RoundingMode.HALF_UP);
            curamount = curAmountAndTax.subtract(curTaxAmount);
            curamount = curamount.setScale(currencyPrecision, RoundingMode.HALF_UP);
            Map<String, BigDecimal> result = BackCalculationHelper.calPriceAndDiscountamount(bill, coll, Boolean.FALSE);
            priceAndTax = result.get("priceandtax");
            price = result.get("price");
            discountamount = result.get("discountamount");
            BackCalculationHelper.changeTotalAmount(bill, coll, taxAmout, "taxamount", "totaltaxamount");
            BackCalculationHelper.changeTotalAmount(bill, coll, amount, "amount", "totalamount");
        } else if ("amount".equals(propName)) {
            amount = coll.getBigDecimal("amount");
            amount = amount.setScale(precision, RoundingMode.HALF_UP);
            curamount = AmountHelper.convertByExRate(amount, exChangeRate, isIndirectRate, currencyPrecision);
            taxAmout = amount.multiply(taxRate);
            taxAmout = taxAmout.setScale(precision, RoundingMode.HALF_UP);
            curTaxAmount = AmountHelper.convertByExRate(taxAmout, exChangeRate, isIndirectRate, currencyPrecision);
            amountAndTax = amount.add(taxAmout);
            amountAndTax = amountAndTax.setScale(precision, RoundingMode.HALF_UP);
            curAmountAndTax = curamount.add(curTaxAmount);
            curAmountAndTax = curAmountAndTax.setScale(currencyPrecision, RoundingMode.HALF_UP);
            Map<String, BigDecimal> result = BackCalculationHelper.calPriceAndDiscountamount(bill, coll, Boolean.FALSE);
            priceAndTax = result.get("priceandtax");
            price = result.get("price");
            discountamount = result.get("discountamount");
            BackCalculationHelper.changeTotalAmount(bill, coll, taxAmout, "taxamount", "totaltaxamount");
            BigDecimal balance = BackCalculationHelper.calcTotalBalance(coll, amountAndTax, "amountandtax");
            totalBalance = totalBalance.add(balance);
            model.setValue("totalallamount", (Object)bill.getBigDecimal("totalallamount").add(totalBalance));
        }
        coll.set("amount", (Object)amount);
        coll.set("curamount", (Object)curamount);
        coll.set("taxamount", (Object)taxAmout);
        coll.set("curtaxamount", (Object)curTaxAmount);
        coll.set("amountandtax", (Object)amountAndTax);
        coll.set("curamountandtax", (Object)curAmountAndTax);
        coll.set("price", (Object)price);
        coll.set("priceandtax", (Object)priceAndTax);
        coll.set("discountamount", (Object)discountamount);
    }

    public static void backCalculationPrice(DynamicObject bill, int[] rowIndexs) {
        BackCalculationHelper.backCalculationPrice(bill, rowIndexs, Boolean.FALSE);
    }

    public static void backCalculationPrice(DynamicObject bill, int[] rowIndexs, Boolean isCalDiscountRate) {
        for (int rowindex : rowIndexs) {
            DynamicObjectCollection dynamicObject = bill.getDynamicObjectCollection("billentry");
            DynamicObject coll = (DynamicObject)dynamicObject.get(rowindex);
            Map<String, BigDecimal> result = BackCalculationHelper.calPriceAndDiscountamount(bill, coll, isCalDiscountRate);
            BigDecimal priceAndTax = result.get("priceandtax");
            BigDecimal price = result.get("price");
            BigDecimal discountamount = result.get("discountamount");
            BigDecimal discountrate = result.get("discountrate");
            coll.set("priceandtax", (Object)priceAndTax);
            coll.set("price", (Object)price);
            coll.set("discountamount", (Object)discountamount);
            coll.set("discountrate", (Object)discountrate);
        }
    }

    public static void backCalculationTaxRate(DynamicObject bill, int[] rowIndexs, IDataModel model) {
        Boolean istax = (Boolean)bill.get("istax");
        BigDecimal totalBalance = BigDecimal.ZERO;
        for (int rowindex : rowIndexs) {
            DynamicObjectCollection dynamicObject = bill.getDynamicObjectCollection("billentry");
            DynamicObject coll = (DynamicObject)dynamicObject.get(rowindex);
            BigDecimal taxRate = coll.getBigDecimal("taxrate");
            taxRate = taxRate.divide(new BigDecimal(100), 10, RoundingMode.HALF_UP);
            BigDecimal exChangeRate = bill.getBigDecimal("exchangerate");
            boolean isIndirectRate = ExchangeTypeEnum.isIndirectRate((Object)bill.getString("exchangetype"));
            int precision = BackCalculationHelper.getPrecision(bill);
            int currencyPrecision = BackCalculationHelper.getCurrencyPrecision(bill);
            if (istax.booleanValue()) {
                BigDecimal curAmountAndTax = coll.getBigDecimal("curamountandtax");
                BigDecimal amountAndTax = coll.getBigDecimal("amountandtax");
                BigDecimal priceAndTax = coll.getBigDecimal("priceandtax");
                BigDecimal taxAmout = amountAndTax.divide(BigDecimal.ONE.add(taxRate), 10, RoundingMode.HALF_UP).multiply(taxRate);
                taxAmout = taxAmout.setScale(precision, RoundingMode.HALF_UP);
                BigDecimal curTaxAmount = AmountHelper.convertByExRate(taxAmout, exChangeRate, isIndirectRate, currencyPrecision);
                BigDecimal amount = amountAndTax.subtract(taxAmout);
                amount = amount.setScale(precision, RoundingMode.HALF_UP);
                BigDecimal curamount = curAmountAndTax.subtract(curTaxAmount);
                curamount = curamount.setScale(currencyPrecision, RoundingMode.HALF_UP);
                BigDecimal price = priceAndTax.divide(BigDecimal.ONE.add(taxRate), 10, RoundingMode.HALF_UP);
                BackCalculationHelper.changeTotalAmount(bill, coll, taxAmout, "taxamount", "totaltaxamount");
                BackCalculationHelper.changeTotalAmount(bill, coll, amount, "amount", "totalamount");
                coll.set("taxamount", (Object)taxAmout);
                coll.set("curtaxamount", (Object)curTaxAmount);
                coll.set("amount", (Object)amount);
                coll.set("curamount", (Object)curamount);
                coll.set("price", (Object)price);
                continue;
            }
            BigDecimal amount = coll.getBigDecimal("amount");
            BigDecimal price = coll.getBigDecimal("price");
            BigDecimal curamount = coll.getBigDecimal("curamount");
            String discountType = coll.getString("discounttype");
            BigDecimal discountrate = coll.getBigDecimal("discountrate");
            BigDecimal taxAmout = amount.multiply(taxRate);
            taxAmout = taxAmout.setScale(precision, RoundingMode.HALF_UP);
            BigDecimal curTaxAmount = AmountHelper.convertByExRate(taxAmout, exChangeRate, isIndirectRate, currencyPrecision);
            BigDecimal amountAndTax = amount.add(taxAmout);
            amountAndTax = amountAndTax.setScale(precision, RoundingMode.HALF_UP);
            BigDecimal curAmountAndTax = curamount.add(curTaxAmount);
            curAmountAndTax = curAmountAndTax.setScale(currencyPrecision, RoundingMode.HALF_UP);
            BigDecimal priceAndTax = price.multiply(BigDecimal.ONE.add(taxRate));
            BigDecimal discountamount = BigDecimal.ZERO;
            BigDecimal qty = coll.getBigDecimal("qty");
            if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                discountrate = discountrate.divide(new BigDecimal(100), 10, RoundingMode.HALF_UP);
                discountamount = priceAndTax.multiply(qty).multiply(discountrate);
                discountamount = discountamount.setScale(precision, RoundingMode.HALF_UP);
            } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType)) {
                discountamount = discountrate.multiply(qty).multiply(BigDecimal.ONE.add(taxRate));
                discountamount = discountamount.setScale(precision, RoundingMode.HALF_UP);
            }
            BackCalculationHelper.changeTotalAmount(bill, coll, taxAmout, "taxamount", "totaltaxamount");
            BigDecimal balance = BackCalculationHelper.calcTotalBalance(coll, amountAndTax, "amountandtax");
            totalBalance = totalBalance.add(balance);
            model.setValue("totalallamount", (Object)bill.getBigDecimal("totalallamount").add(totalBalance));
            coll.set("taxamount", (Object)taxAmout);
            coll.set("curtaxamount", (Object)curTaxAmount);
            coll.set("amountandtax", (Object)amountAndTax);
            coll.set("curamountandtax", (Object)curAmountAndTax);
            coll.set("priceandtax", (Object)priceAndTax);
            coll.set("discountamount", (Object)discountamount);
        }
    }

    public static void backCalculationWholeBillIsTax(DynamicObject bill, Boolean istax, IDataModel model) {
        DynamicObjectCollection dynamicObject = bill.getDynamicObjectCollection("billentry");
        String propName = "";
        propName = istax != false ? "amountandtax" : "amount";
        BackCalculationHelper.calculWholeBill(dynamicObject, bill, propName, model);
    }

    public static void backCalculationWholeBillExchangeRate(DynamicObject bill) {
        Boolean istax = (Boolean)bill.get("istax");
        int currencyPrecision = BackCalculationHelper.getCurrencyPrecision(bill);
        DynamicObjectCollection dynamicObject = bill.getDynamicObjectCollection("billentry");
        BigDecimal exchangerate = bill.getBigDecimal("exchangerate");
        boolean isIndirectRate = ExchangeTypeEnum.isIndirectRate((Object)bill.getString("exchangetype"));
        if (istax.booleanValue()) {
            BigDecimal curTotalAllAmount = BigDecimal.ZERO;
            BigDecimal curTotalAmount = BigDecimal.ZERO;
            for (int i = 0; i < dynamicObject.size(); ++i) {
                DynamicObject entry = (DynamicObject)dynamicObject.get(i);
                BigDecimal amountAndTax = entry.getBigDecimal("amountandtax");
                BigDecimal taxamount = entry.getBigDecimal("taxamount");
                BigDecimal curAmountAndTax = AmountHelper.convertByExRate(amountAndTax, exchangerate, isIndirectRate, currencyPrecision);
                BigDecimal curtaxamount = AmountHelper.convertByExRate(taxamount, exchangerate, isIndirectRate, currencyPrecision);
                BigDecimal curamount = curAmountAndTax.subtract(curtaxamount);
                curamount = curamount.setScale(currencyPrecision, RoundingMode.HALF_UP);
                entry.set("curamount", (Object)curamount);
                entry.set("curtaxamount", (Object)curtaxamount);
                entry.set("curamountandtax", (Object)curAmountAndTax);
                curamount = curamount.setScale(currencyPrecision, RoundingMode.HALF_UP);
                curTotalAllAmount = curTotalAllAmount.add(curAmountAndTax);
                curTotalAmount = curTotalAmount.add(curamount);
            }
        } else {
            BigDecimal curTotalAllAmount = BigDecimal.ZERO;
            BigDecimal curTotalAmount = BigDecimal.ZERO;
            for (int i = 0; i < dynamicObject.size(); ++i) {
                DynamicObject entry = (DynamicObject)dynamicObject.get(i);
                BigDecimal entryAmount = entry.getBigDecimal("amount");
                BigDecimal entryTaxAmount = entry.getBigDecimal("taxamount");
                BigDecimal curamount = AmountHelper.convertByExRate(entryAmount, exchangerate, isIndirectRate, currencyPrecision);
                BigDecimal curtaxamount = AmountHelper.convertByExRate(entryTaxAmount, exchangerate, isIndirectRate, currencyPrecision);
                BigDecimal curAmountAndTax = curamount.add(curtaxamount);
                curAmountAndTax = curAmountAndTax.setScale(currencyPrecision, RoundingMode.HALF_UP);
                entry.set("curamount", (Object)curamount);
                entry.set("curtaxamount", (Object)curtaxamount);
                entry.set("curamountandtax", (Object)curAmountAndTax);
                curTotalAllAmount = curTotalAllAmount.add(curAmountAndTax);
                curTotalAmount = curTotalAmount.add(curamount);
            }
        }
    }

    private static void changeTotalAmount(DynamicObject bill, DynamicObject entryInfo, BigDecimal amount, String entryAmountField, String headAmountField) {
        BigDecimal balance = amount.subtract(entryInfo.getBigDecimal(entryAmountField));
        bill.set(headAmountField, (Object)bill.getBigDecimal(headAmountField).add(balance));
    }

    private static BigDecimal calcTotalBalance(DynamicObject entryInfo, BigDecimal amount, String entryAmountField) {
        BigDecimal balance = amount.subtract(entryInfo.getBigDecimal(entryAmountField));
        return balance;
    }

    private static int getPrecision(DynamicObject bill) {
        int precision = 10;
        DynamicObject currency = bill.getDynamicObject("settlecurrency");
        if (currency != null) {
            precision = currency.getInt("amtprecision");
        }
        return precision;
    }

    private static int getCurrencyPrecision(DynamicObject bill) {
        DynamicObject currencyObj = bill.getDynamicObject("currency");
        int currencyPrecision = 10;
        if (currencyObj != null) {
            currencyPrecision = currencyObj.getInt("amtprecision");
        }
        return currencyPrecision;
    }

    private static Map<String, BigDecimal> calPriceAndDiscountamount(DynamicObject bill, DynamicObject coll, Boolean isCalDiscountRate) {
        BigDecimal qty;
        BigDecimal priceAndTax = BigDecimal.ZERO;
        BigDecimal discountamount = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        Boolean istax = (Boolean)bill.get("istax");
        String discountType = coll.getString("discounttype");
        BigDecimal discountrate = coll.getBigDecimal("discountrate");
        if (isCalDiscountRate == null) {
            isCalDiscountRate = Boolean.FALSE;
        }
        if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && isCalDiscountRate.booleanValue()) {
            discountrate = BigDecimal.ZERO;
            discountamount = coll.getBigDecimal("discountamount");
        }
        if ((qty = coll.getBigDecimal("qty")).compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal taxRate = coll.getBigDecimal("taxrate");
            taxRate = taxRate.divide(new BigDecimal(100), 10, RoundingMode.HALF_UP);
            int precision = BackCalculationHelper.getPrecision(bill);
            if (istax.booleanValue()) {
                BigDecimal amountAndTax = coll.getBigDecimal("amountandtax");
                amountAndTax = amountAndTax.setScale(precision, RoundingMode.HALF_UP);
                if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    BigDecimal dividedDiscountRate = discountrate.divide(new BigDecimal(100), 10, RoundingMode.HALF_UP);
                    priceAndTax = amountAndTax.divide(qty, 10, RoundingMode.HALF_UP).divide(BigDecimal.ONE.subtract(dividedDiscountRate), 10, RoundingMode.HALF_UP);
                    discountamount = priceAndTax.multiply(qty).multiply(dividedDiscountRate);
                    discountamount = discountamount.setScale(precision, RoundingMode.HALF_UP);
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && !isCalDiscountRate.booleanValue()) {
                    priceAndTax = amountAndTax.divide(qty, 10, RoundingMode.HALF_UP).add(discountrate);
                    discountamount = discountrate.multiply(qty);
                    discountamount = discountamount.setScale(precision, RoundingMode.HALF_UP);
                } else if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && isCalDiscountRate.booleanValue()) {
                    discountrate = discountamount.divide(qty, 10, RoundingMode.HALF_UP);
                    priceAndTax = amountAndTax.add(discountamount).divide(qty, 10, RoundingMode.HALF_UP);
                } else {
                    priceAndTax = amountAndTax.divide(qty, 10, RoundingMode.HALF_UP);
                }
                price = priceAndTax.divide(BigDecimal.ONE.add(taxRate), 10, RoundingMode.HALF_UP);
            } else {
                BigDecimal amount = coll.getBigDecimal("amount");
                amount = amount.setScale(precision, RoundingMode.HALF_UP);
                if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    BigDecimal dividedDiscountRate = discountrate.divide(new BigDecimal(100), 10, RoundingMode.HALF_UP);
                    price = amount.divide(qty, 10, RoundingMode.HALF_UP).divide(BigDecimal.ONE.subtract(dividedDiscountRate), 10, RoundingMode.HALF_UP);
                    priceAndTax = price.multiply(BigDecimal.ONE.add(taxRate));
                    discountamount = priceAndTax.multiply(qty).multiply(dividedDiscountRate);
                    discountamount = discountamount.setScale(precision, RoundingMode.HALF_UP);
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && !isCalDiscountRate.booleanValue()) {
                    price = amount.divide(qty, 10, RoundingMode.HALF_UP).add(discountrate);
                    priceAndTax = price.multiply(BigDecimal.ONE.add(taxRate));
                    discountamount = discountrate.multiply(qty).multiply(BigDecimal.ONE.add(taxRate));
                    discountamount = discountamount.setScale(precision, RoundingMode.HALF_UP);
                } else if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && isCalDiscountRate.booleanValue()) {
                    discountrate = discountamount.divide(qty, 10, RoundingMode.HALF_UP).divide(BigDecimal.ONE.add(taxRate), 10, RoundingMode.HALF_UP);
                    price = amount.divide(qty, 10, RoundingMode.HALF_UP).add(discountrate);
                    priceAndTax = price.multiply(BigDecimal.ONE.add(taxRate)).setScale(10, RoundingMode.HALF_UP);
                } else {
                    price = amount.divide(qty, 10, RoundingMode.HALF_UP);
                    priceAndTax = price.multiply(BigDecimal.ONE.add(taxRate));
                    priceAndTax = priceAndTax.setScale(10, RoundingMode.HALF_UP);
                }
            }
        }
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        result.put("priceandtax", priceAndTax);
        result.put("price", price);
        result.put("discountamount", discountamount);
        result.put("discountrate", discountrate);
        return result;
    }

    public static Boolean cheackDiscountRateToEntry(DynamicObject bill) {
        BigDecimal discountrate = BigDecimal.ZERO;
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        Boolean result = Boolean.TRUE;
        for (int j = 0; j < entrys.size(); ++j) {
            DynamicObject entry = (DynamicObject)entrys.get(j);
            discountrate = (BigDecimal)entry.get("discountrate");
            String discounttype = (String)entry.get("discounttype");
            if (discountrate.compareTo(new BigDecimal("100")) <= 0 && discountrate.compareTo(new BigDecimal("100")) != 0 || !DiscountTypeEnum.DISRATE.getValue().equals(discounttype)) continue;
            result = Boolean.FALSE;
            break;
        }
        return result;
    }

    public static Boolean checkDiscountRateToOther(int[] rowIndexs, IDataModel model) {
        Boolean result = Boolean.TRUE;
        for (int i = 0; i < rowIndexs.length; ++i) {
            int rowIndex = rowIndexs[i];
            BigDecimal discountrate = BigDecimal.ZERO;
            discountrate = (BigDecimal)model.getValue("discountrate", rowIndex);
            String discounttype = (String)model.getValue("discounttype", rowIndex);
            if (discountrate == null || discountrate.compareTo(new BigDecimal("100")) <= 0 && discountrate.compareTo(new BigDecimal("100")) != 0 || !DiscountTypeEnum.DISRATE.getValue().equals(discounttype)) continue;
            result = Boolean.FALSE;
        }
        return result;
    }
}

