/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.enums.ExchangeTypeEnum;

public class CurrencyHelper {
    private static final Log logger = LogFactory.getLog(CurrencyHelper.class);
    private static final String CURRENCY_DT = "bd_currency";
    private static final String EXRATETABLE_DT = "bd_exratetable";
    private static final String BASECURRRENCY = "baseCurrencyID";
    private static final String EXRATETABLE = "exchangeRateTableID";

    public static DynamicObject getCurrency(Long orgId) {
        Long currencyId;
        Map<String, Long> map;
        if (orgId != 0L && (map = CurrencyHelper.getCurrencyAndExRateTable(orgId)) != null && (currencyId = map.get(BASECURRRENCY)) != null && currencyId != 0L) {
            return BusinessDataServiceHelper.loadSingle((Object)currencyId, (String)CURRENCY_DT);
        }
        return null;
    }

    public static DynamicObject getExRateTable(Long orgId) {
        Map<String, Long> map;
        if (orgId != null && (map = CurrencyHelper.getCurrencyAndExRateTable(orgId)) != null) {
            return BusinessDataServiceHelper.loadSingle((Object)map.get(EXRATETABLE), (String)EXRATETABLE_DT);
        }
        return null;
    }

    public static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map<String, Object> mapOrg;
        if (orgId != null && (mapOrg = OrgHelper.getCompanyByOrg(orgId, Boolean.FALSE, Boolean.TRUE)) != null && mapOrg.get("id") != null) {
            logger.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u9700\u6c42\u7ec4\u7ec7\u7684\u6838\u7b97\u4e3b\u4f53\uff1a" + mapOrg);
            Map map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")));
            if (map != null && map.size() != 0) {
                logger.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u6838\u7b97\u4e3b\u4f53\u7684\u672c\u4f4d\u5e01\u548c\u6c47\u7387\u8868\uff1a" + map);
                return map;
            }
        }
        return null;
    }

    public static BigDecimal getExChangeRate(Long srcCurId, Long tarCurId, Long exRateTableId, Date date) {
        BigDecimal exchangeRate = BigDecimal.ZERO;
        if (srcCurId == null || tarCurId == null || exRateTableId == null || date == null) {
            return exchangeRate;
        }
        exchangeRate = srcCurId.equals(tarCurId) ? BigDecimal.ONE : BaseDataServiceHelper.getExchangeRate((Long)exRateTableId, (Long)srcCurId, (Long)tarCurId, (Date)date);
        return exchangeRate;
    }

    public static BigDecimal getExRate(Long srcCurId, Long tarCurId, Long exRateTableId, Date date, String exchangeType) {
        BigDecimal exchangeRate = BigDecimal.ZERO;
        if (srcCurId == null || tarCurId == null || exRateTableId == null || date == null || exchangeType == null) {
            return exchangeRate;
        }
        if (srcCurId.equals(tarCurId)) {
            exchangeRate = BigDecimal.ONE;
        } else {
            boolean isIndirect = ExchangeTypeEnum.isIndirectRate((Object)exchangeType);
            exchangeRate = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)exRateTableId, (Long)srcCurId, (Long)tarCurId, (Date)date, (boolean)isIndirect);
        }
        return exchangeRate;
    }

    public static Map<String, Object> getExRateMap(Long srcCurId, Long tarCurId, Long exRateTableId, Date date) {
        BigDecimal exRate;
        BigDecimal exchangeRate = BigDecimal.ZERO;
        String exchangeType = ExchangeTypeEnum.DIRECT.getValue();
        HashMap<String, Object> exRateMap = new HashMap<String, Object>(4);
        if (srcCurId == null || tarCurId == null || exRateTableId == null || date == null) {
            exRateMap.put("exchangerate", exchangeRate);
            exRateMap.put("exchangetype", exchangeType);
            return exRateMap;
        }
        Map exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)srcCurId, (Long)tarCurId, (Long)exRateTableId, (Date)date);
        Boolean isIndirectRate = (Boolean)exchangeRateMap.get("quoteType");
        if (isIndirectRate != null && isIndirectRate.booleanValue()) {
            exchangeType = ExchangeTypeEnum.INDIRECT.getValue();
        }
        if ((exRate = (BigDecimal)exchangeRateMap.get("exchangeRate")) != null) {
            exchangeRate = exRate;
        }
        exRateMap.put("exchangerate", exchangeRate);
        exRateMap.put("exchangetype", exchangeType);
        return exRateMap;
    }
}

