/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.scmc.pm.utils.CommonUtils;

public class OrgHelper {
    public static Map<String, Object> getCompanyByOrg(Long orgId, Boolean isBizUnit, Boolean isSerrchUpward) {
        Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)isBizUnit, (Boolean)isSerrchUpward);
        return map;
    }

    public static Long getToOrg(String fromOrgType, String toOrgType, Long fromOrgId, boolean isIncludeFromOrgSelf) {
        Long toOrgId = OrgUnitServiceHelper.getToOrg((String)fromOrgType, (String)toOrgType, (Long)fromOrgId, (boolean)isIncludeFromOrgSelf);
        return toOrgId;
    }

    public static List<Long> getAllToOrg(String fromOrgType, String toOrgType, Long fromOrgId, boolean isIncludeFromOrgSelf) {
        List toOrgIds = OrgUnitServiceHelper.getAllToOrg((String)fromOrgType, (String)toOrgType, (Long)fromOrgId, (boolean)isIncludeFromOrgSelf);
        return toOrgIds;
    }

    public static List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        ArrayList<Long> orgs = new ArrayList<Long>(hasPermissionOrgs.size());
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
            orgs.add(tempOrgId);
        }
        return orgs;
    }

    public static Long getDefaultOrg(String entityName, String orgViewType) {
        long orgId = RequestContext.get().getOrgId();
        List<Long> orgs = OrgHelper.getHasPermissionOrg(entityName, orgViewType);
        if (orgs == null) {
            return null;
        }
        if (orgs.contains(orgId)) {
            return orgId;
        }
        return orgs.get(0);
    }

    public static Map<String, Object> getOrgRelation(Long orgId, String fromViewType, String toViewType, String getDirectOrgType) {
        if (orgId == null) {
            return null;
        }
        OrgRelationParam orgRelationParam = OrgHelper.buildOrgRelationParam(orgId, fromViewType, toViewType, getDirectOrgType);
        Map orgRelation = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)orgRelationParam);
        return orgRelation;
    }

    public static Long getOrgForFormDefValue(Long orgId, String fromViewType, String toViewType, String getDirectOrgType) {
        if (orgId == null) {
            return null;
        }
        OrgRelationParam orgRelationParam = OrgHelper.buildOrgRelationParam(orgId, fromViewType, toViewType, getDirectOrgType);
        long defaultOrgId = OrgUnitServiceHelper.getOrgForFormDefValue((OrgRelationParam)orgRelationParam);
        return defaultOrgId;
    }

    public static OrgRelationParam buildOrgRelationParam(Long orgId, String fromViewType, String toViewType, String getDirectOrgType) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(orgId.longValue());
        param.setFromViewType(fromViewType);
        param.setToViewType(toViewType);
        param.setDirectViewType(getDirectOrgType);
        return param;
    }
}

