/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.MetaDataHelper;
import kd.scmc.pm.business.helper.PurOrderBillModelHelper;
import kd.scmc.pm.enums.ChangeTypeEnum;

public class PurOrderBillLogHelper {
    private static final String UNIT_PRECISION = "precision";
    private static final String UNIT_PRECISIONTYPE = "precisionaccount";
    private static final String SETTLECURRENCY = "settlecurrency";
    private static final String PRICEPRECISION = "priceprecision";
    private static final String AMTPRECISION = "amtprecision";

    public static Map<String, String> compareOrderBillNXOrderBill(DynamicObject purOrderBill, DynamicObject xPurOrderBill) {
        if (purOrderBill != null && xPurOrderBill != null && "pm_purorderbill".equals(purOrderBill.getDataEntityType().getName()) && "pm_xpurorderbill".equals(xPurOrderBill.getDataEntityType().getName())) {
            HashMap<String, String> rs = new HashMap<String, String>();
            String[] billfields = PurOrderBillModelHelper.canLogBillField;
            StringBuilder billMD = new StringBuilder();
            billMD.append("### ");
            String billNo = String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u3010%s\u3011", (String)"PurOrderBillLogHelper_0", (String)"scmc-pm-business", (Object[])new Object[0]), purOrderBill.getString("billno"));
            billMD.append(billNo);
            billMD.append(ResManager.loadKDString((String)"\u53d8\u66f4\u60c5\u51b5", (String)"PurOrderBillLogHelper_10", (String)"scmc-pm-business", (Object[])new Object[0]));
            billMD.append(" ### ");
            billMD.append("\n --- \n");
            billMD.append("> ");
            String changer = ResManager.loadKDString((String)"\u53d8\u66f4\u4eba\uff1a", (String)"PurOrderBillLogHelper_2", (String)"scmc-pm-business", (Object[])new Object[0]);
            billMD.append(changer);
            billMD.append(PurOrderBillModelHelper.displayFieldValue("modifier", xPurOrderBill.get("modifier")));
            billMD.append("  \n");
            String format = InteServiceHelper.getUserFormat((Long)UserServiceHelper.getCurrentUserId()).getDateFormat().getDateFormat();
            SimpleDateFormat df = new SimpleDateFormat(format);
            billMD.append("> ");
            String changeDate = ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u65e5\u671f\uff1a", (String)"PurOrderBillLogHelper_3", (String)"scmc-pm-business", (Object[])new Object[0]);
            billMD.append(changeDate);
            billMD.append(PurOrderBillModelHelper.displayFieldValue("biztime", df.format((Date)xPurOrderBill.get("biztime"))));
            billMD.append("  \n");
            billMD.append("> ");
            String changeVersion = ResManager.loadKDString((String)"\u53d8\u66f4\u7248\u672c\uff1a", (String)"PurOrderBillLogHelper_4", (String)"scmc-pm-business", (Object[])new Object[0]);
            billMD.append(changeVersion);
            billMD.append(xPurOrderBill.get("version"));
            billMD.append("  \n");
            billMD.append("> ");
            String changeReason = ResManager.loadKDString((String)"\u53d8\u66f4\u539f\u56e0\uff1a", (String)"PurOrderBillLogHelper_5", (String)"scmc-pm-business", (Object[])new Object[0]);
            billMD.append(changeReason);
            billMD.append(xPurOrderBill.get("reason"));
            billMD.append("  \n");
            billMD.append(ResManager.loadKDString((String)"#### \u91c7\u8d2d\u8ba2\u5355\u53d8\u66f4\u5185\u5bb9 ####", (String)"PurOrderBillLogHelper_6", (String)"scmc-pm-business", (Object[])new Object[0])).append('\n');
            billMD.append(ResManager.loadKDString((String)"|\u5b57\u6bb5\u540d\u79f0|\u539f\u503c|\u53d8\u66f4\u503c|", (String)"PurOrderBillLogHelper_7", (String)"scmc-pm-business", (Object[])new Object[0])).append('\n').append("|-|-|-|").append('\n');
            for (int fi = 0; fi < billfields.length; ++fi) {
                Object newField;
                Object srcField = purOrderBill.get(billfields[fi]);
                if (PurOrderBillModelHelper.compareField(srcField, newField = xPurOrderBill.get(billfields[fi]))) continue;
                billMD.append('|');
                billMD.append(MetaDataHelper.getPropertyAlias(purOrderBill.getDataEntityType(), billfields[fi]));
                billMD.append("");
                billMD.append('|');
                if (srcField != null && StringUtils.isNotEmpty((CharSequence)srcField.toString())) {
                    billMD.append(PurOrderBillModelHelper.displayFieldValue("", srcField));
                } else {
                    billMD.append("");
                }
                billMD.append('|');
                billMD.append(PurOrderBillModelHelper.displayFieldValue("", newField));
                billMD.append("|\n");
            }
            rs.put("pm_purorderbill", billMD.toString());
            String[] billEntryFields = PurOrderBillModelHelper.canLogBillEntryField;
            String billEntryMD = "\n" + ResManager.loadKDString((String)"#### \u7269\u6599\u660e\u7ec6\u53d8\u66f4\u5185\u5bb9 ####", (String)"PurOrderBillLogHelper_8", (String)"scmc-pm-business", (Object[])new Object[0]) + "\n";
            billEntryMD = billEntryMD + PurOrderBillLogHelper.genMDFormatString(purOrderBill, xPurOrderBill, "billentry", "billentry", billEntryFields, "sourceentryid", "entrychangetype");
            rs.put("billentry", billEntryMD);
            String[] payEntryFields = PurOrderBillModelHelper.canLogPayEntryField;
            String billPayEntryMD = "\n" + ResManager.loadKDString((String)"#### \u4ed8\u6b3e\u8ba1\u5212\u53d8\u66f4\u5185\u5bb9 ####", (String)"PurOrderBillLogHelper_9", (String)"scmc-pm-business", (Object[])new Object[0]) + "\n";
            billPayEntryMD = billPayEntryMD + PurOrderBillLogHelper.genMDFormatString(purOrderBill, xPurOrderBill, "purbillentry_pay", "purbillentry_pay", payEntryFields, "sourcepayentryid", "payentrychangetype");
            rs.put("purbillentry_pay", billPayEntryMD);
            return rs;
        }
        return null;
    }

    public static String genMDFormatString(DynamicObject purOrderBill, DynamicObject xPurOrderBill, String entryName, String xEntryName, String[] billEntryFields, String SrcBillEntryID, String EntryChangeType) {
        StringBuilder billEntryMDTemp = new StringBuilder();
        billEntryMDTemp.append('|');
        for (int fi = 0; fi < billEntryFields.length; ++fi) {
            billEntryMDTemp.append(MetaDataHelper.getEntryPropertyAlias(purOrderBill.getDataEntityType(), entryName, billEntryFields[fi]));
            billEntryMDTemp.append('|');
        }
        DynamicObjectCollection srcBillEntrys = purOrderBill.getDynamicObjectCollection(entryName);
        DynamicObjectCollection xBillEntrys = xPurOrderBill.getDynamicObjectCollection(xEntryName);
        if (xBillEntrys != null) {
            DynamicObject xBillEntry;
            int i;
            billEntryMDTemp.append("\n|");
            for (int fi = 0; fi < billEntryFields.length; ++fi) {
                billEntryMDTemp.append(":-:|");
            }
            for (i = 0; i < xBillEntrys.size(); ++i) {
                xBillEntry = (DynamicObject)xBillEntrys.get(i);
                Long srcBillEntryID = xBillEntry.getLong(SrcBillEntryID);
                if (!ChangeTypeEnum.UPDATE.getValue().equals(xBillEntry.get(EntryChangeType))) continue;
                for (int j = 0; j < srcBillEntrys.size(); ++j) {
                    DynamicObject srcBillEntry = (DynamicObject)srcBillEntrys.get(j);
                    Long xBillEntryID = (Long)srcBillEntry.getPkValue();
                    if (srcBillEntryID.longValue() != xBillEntryID.longValue()) continue;
                    StringBuilder rowMD = new StringBuilder("\n|");
                    boolean isChange = false;
                    for (int fi = 0; fi < billEntryFields.length; ++fi) {
                        Object srcField = srcBillEntry.get(billEntryFields[fi]);
                        Object newField = xBillEntry.get(billEntryFields[fi]);
                        if (PurOrderBillModelHelper.compareField(srcField = PurOrderBillLogHelper.unit(xPurOrderBill, xBillEntry, billEntryFields[fi], srcField), newField = PurOrderBillLogHelper.unit(xPurOrderBill, xBillEntry, billEntryFields[fi], newField))) {
                            if ("taxrate".equals(billEntryFields[fi]) && newField != null && BigDecimal.ZERO.compareTo(new BigDecimal((String)newField)) == 0) {
                                newField = null;
                            }
                            rowMD = rowMD.append(PurOrderBillModelHelper.displayFieldValue(billEntryFields[fi], newField));
                            rowMD = rowMD.append('|');
                            continue;
                        }
                        rowMD = rowMD.append(PurOrderBillModelHelper.displayCompareFieldValue(srcField, newField));
                        rowMD = rowMD.append('|');
                        isChange = true;
                    }
                    if (!isChange) continue;
                    billEntryMDTemp.append((CharSequence)rowMD);
                }
            }
            for (i = 0; i < xBillEntrys.size(); ++i) {
                xBillEntry = (DynamicObject)xBillEntrys.get(i);
                if (!ChangeTypeEnum.ADDNEW.getValue().equals(xBillEntry.get(EntryChangeType))) continue;
                billEntryMDTemp.append("\n|");
                for (int fi = 0; fi < billEntryFields.length; ++fi) {
                    Object newField = xBillEntry.get(billEntryFields[fi]);
                    if (newField instanceof BigDecimal) {
                        newField = "taxrate".equals(billEntryFields[fi]) && BigDecimal.ZERO.compareTo((BigDecimal)newField) == 0 ? null : PurOrderBillLogHelper.unit(xPurOrderBill, xBillEntry, billEntryFields[fi], newField);
                    }
                    if (newField == null) {
                        billEntryMDTemp.append(PurOrderBillModelHelper.displayFieldValue(billEntryFields[fi], newField));
                        billEntryMDTemp.append('|');
                        continue;
                    }
                    if (!newField.equals("")) {
                        billEntryMDTemp.append('*');
                        billEntryMDTemp.append(PurOrderBillModelHelper.displayFieldValue(billEntryFields[fi], newField));
                        billEntryMDTemp.append("*|");
                        continue;
                    }
                    billEntryMDTemp.append(PurOrderBillModelHelper.displayFieldValue(billEntryFields[fi], newField));
                    billEntryMDTemp.append('|');
                }
            }
            for (i = 0; i < xBillEntrys.size(); ++i) {
                xBillEntry = (DynamicObject)xBillEntrys.get(i);
                if (!ChangeTypeEnum.CANCEL.getValue().equals(xBillEntry.get(EntryChangeType))) continue;
                billEntryMDTemp.append("\n|");
                for (int fi = 0; fi < billEntryFields.length; ++fi) {
                    Object newField = xBillEntry.get(billEntryFields[fi]);
                    newField = null != newField && "taxrate".equals(billEntryFields[fi]) && BigDecimal.ZERO.compareTo((BigDecimal)newField) == 0 ? null : PurOrderBillLogHelper.unit(xPurOrderBill, xBillEntry, billEntryFields[fi], newField);
                    billEntryMDTemp.append("~~");
                    billEntryMDTemp.append(PurOrderBillModelHelper.displayFieldValue(billEntryFields[fi], newField));
                    billEntryMDTemp.append("~~|");
                }
            }
        }
        return billEntryMDTemp.toString();
    }

    private static Object unit(DynamicObject XpurOrderBill, DynamicObject xBillEntry, String newFieldName, Object newField) {
        if (!(newField instanceof BigDecimal)) {
            return newField;
        }
        int baseUnitPrecisionType = 4;
        int baseUnitPrecision = 10;
        BigDecimal b = (BigDecimal)newField;
        if ("price".equals(newFieldName) || "priceandtax".equals(newFieldName)) {
            DynamicObject settlecurrency = (DynamicObject)XpurOrderBill.get(SETTLECURRENCY);
            baseUnitPrecision = settlecurrency.getInt(PRICEPRECISION);
            b = b.setScale(baseUnitPrecision, baseUnitPrecisionType);
            return b;
        }
        if ("amount".equals(newFieldName) || "payamount".equals(newFieldName)) {
            DynamicObject settlecurrency = (DynamicObject)XpurOrderBill.get(SETTLECURRENCY);
            baseUnitPrecision = settlecurrency.getInt(AMTPRECISION);
            b = b.setScale(baseUnitPrecision, baseUnitPrecisionType);
            return b;
        }
        switch (newFieldName) {
            case "qty": 
            case "auxqty": 
            case "receiveqtyup": 
            case "receiveqtydown": {
                DynamicObject unit = (DynamicObject)xBillEntry.get("unit");
                if ("auxqty".equals(newFieldName) && (unit = (DynamicObject)xBillEntry.get("auxunit")) == null) {
                    DecimalFormat df = new DecimalFormat("#0.000000");
                    return df.format(b.doubleValue());
                }
                baseUnitPrecision = unit.getInt(UNIT_PRECISION);
                baseUnitPrecisionType = BillQtyAndUnitHelper.getPrecisionType(unit);
                b = b.setScale(baseUnitPrecision, baseUnitPrecisionType);
                return b;
            }
            case "taxrate": 
            case "receiveratedown": 
            case "receiverateup": 
            case "payrate": {
                return new DecimalFormat("#0.00").format(b.doubleValue());
            }
        }
        DecimalFormat df = new DecimalFormat("#0.000000");
        return df.format(b.doubleValue());
    }
}

