/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.service.quotamodel.pojo.QuotaCalculateDTO;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class QuotaCalHelper {
    private static final Log log = LogFactory.getLog(QuotaCalHelper.class);
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final String HUNDRED = "100";
    private static final int zero = 0;

    public static Map<Long, BigDecimal> calQuotaQty(Map<String, Object> srcInfo, DynamicObjectCollection subSchemeEntry, Map<Long, BigDecimal> supplierHistoryQty, String quotaCalType, Map<String, DynamicObject> sourceListMap) {
        log.info("QuotaCalHelper\u914d\u989d\u8ba1\u7b97\u5165\u53c2\u4e3a\uff1a \u6e90\u5355\u4fe1\u606f " + srcInfo + " \u914d\u989d\u65b9\u6848\u4f9b\u5e94\u5546\u4fe1\u606f\uff1a" + subSchemeEntry + " \u5386\u53f2\u6570\u91cf\u4e3a\uff1a" + supplierHistoryQty + " \u8ba1\u7b97\u7c7b\u578b\u4e3a\uff1a" + quotaCalType);
        if (CommonUtils.isNull(srcInfo) || subSchemeEntry == null || subSchemeEntry.isEmpty() || CommonUtils.isNull((Object)quotaCalType)) {
            return null;
        }
        if (supplierHistoryQty == null && "C".equals(quotaCalType)) {
            log.error("QuotaCalHelper\u914d\u989d\u8ba1\u7b97\u5165\u53c2 \u5f53\u914d\u989d\u4e3a\u52a8\u6001\u914d\u989d\u65f6\u5fc5\u987b\u4f20\u5165\u5386\u53f2\u6570\u91cf\u3002");
            return null;
        }
        HashMap<Long, BigDecimal> result = new HashMap(16);
        if ("A".equals(quotaCalType)) {
            result = QuotaCalHelper.calFixedQuotaQty(srcInfo, subSchemeEntry, sourceListMap);
        } else if ("C".equals(quotaCalType)) {
            result = QuotaCalHelper.calDynamicQuotaQty(srcInfo, subSchemeEntry, supplierHistoryQty, sourceListMap);
        }
        log.info("QuotaCalHelper\u914d\u989d\u8ba1\u7b97\u51fa\u53c2\u4e3a\uff1a" + result);
        return result;
    }

    private static Map<Long, BigDecimal> calDynamicQuotaQty(Map<String, Object> srcInfo, DynamicObjectCollection subSchemeEntry, Map<Long, BigDecimal> supplierHistoryQty, Map<String, DynamicObject> sourceListMap) {
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>(10);
        Object baseQtyObj = srcInfo.get("baseqty");
        Object baseunitObj = srcInfo.get("baseunit");
        Object orgIdObj = srcInfo.get("orgid");
        Object materialObj = srcInfo.get("material");
        Object materialmasteridObj = srcInfo.get("materialmasterid");
        if (!(baseQtyObj instanceof BigDecimal && baseunitObj instanceof DynamicObject && orgIdObj instanceof Long && materialObj instanceof Long && materialmasteridObj instanceof Long)) {
            return null;
        }
        BigDecimal baseQty = (BigDecimal)baseQtyObj;
        DynamicObject baseUnit = (DynamicObject)baseunitObj;
        Long orgId = (Long)orgIdObj;
        Long materialId = (Long)materialObj;
        Long materialmasterid = (Long)materialmasteridObj;
        BigDecimal allBillBaseQty = BigDecimal.ZERO;
        if (supplierHistoryQty != null && supplierHistoryQty.size() > 0) {
            for (BigDecimal oneSupQty : supplierHistoryQty.values()) {
                allBillBaseQty = allBillBaseQty.add(oneSupQty);
            }
        }
        ArrayList<QuotaCalculateDTO> dto = new ArrayList<QuotaCalculateDTO>(subSchemeEntry.size());
        for (int i = 0; i < subSchemeEntry.size(); ++i) {
            DynamicObject subEntry = (DynamicObject)subSchemeEntry.get(i);
            DynamicObject supplier = subEntry.getDynamicObject("supplier");
            int rank = subEntry.getInt("supplyrank");
            BigDecimal targetRate = subEntry.getBigDecimal("quotarate");
            BigDecimal historyRate = ZERO;
            if (ZERO.compareTo(allBillBaseQty) == 0) {
                historyRate = ZERO;
            } else if (supplier != null && supplierHistoryQty != null && supplierHistoryQty.size() > 0) {
                Long supplierId = (Long)supplier.getPkValue();
                BigDecimal supplierQty = supplierHistoryQty.get(supplierId);
                if (supplierQty == null) {
                    supplierQty = ZERO;
                }
                historyRate = supplierQty.divide(allBillBaseQty, 2, 4).multiply(BigDecimal.valueOf(100L));
            }
            BigDecimal surplusRate = targetRate.subtract(historyRate);
            QuotaCalculateDTO acceptDynamicQuota = QuotaCalculateDTO.acceptDynamicQuota(supplier, rank, surplusRate, targetRate);
            dto.add(acceptDynamicQuota);
        }
        List<QuotaCalculateDTO> sortDynamicQuota = QuotaCalculateDTO.sortDynamicQuota(dto);
        for (int i = 0; i < sortDynamicQuota.size() && baseQty.compareTo(ZERO) > 0; ++i) {
            QuotaCalculateDTO quotaCalculateDTO = sortDynamicQuota.get(i);
            DynamicObject supplier = quotaCalculateDTO.getSupplier();
            Long supplierid = (Long)supplier.getPkValue();
            String bizUniqueKey = QuotaCalHelper.getBizUniqueKey(orgId, supplierid, materialId);
            DynamicObject sourceList = sourceListMap.get(bizUniqueKey);
            QuotaCalculateDTO sourceDTO = QuotaCalHelper.calculateQuotaQtyBySourceList(supplierid, orgId, materialId, baseQty, baseUnit, materialmasterid, sourceList);
            BigDecimal quotaBaseQty = sourceDTO.getQuotaBaseQty();
            baseQty = baseQty.subtract(quotaBaseQty);
            result.put(supplierid, quotaBaseQty);
        }
        return result;
    }

    private static Map<Long, BigDecimal> calFixedQuotaQty(Map<String, Object> srcInfo, DynamicObjectCollection subEntries, Map<String, DynamicObject> sourceListMap) {
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>(10);
        Object baseQtyObj = srcInfo.get("baseqty");
        Object baseunitObj = srcInfo.get("baseunit");
        Object orgIdObj = srcInfo.get("orgid");
        Object materialObj = srcInfo.get("material");
        Object materialmasteridObj = srcInfo.get("materialmasterid");
        if (!(baseQtyObj instanceof BigDecimal && baseunitObj instanceof DynamicObject && orgIdObj instanceof Long && materialObj instanceof Long && materialmasteridObj instanceof Long)) {
            return null;
        }
        BigDecimal baseQty = (BigDecimal)baseQtyObj;
        DynamicObject baseUnit = (DynamicObject)baseunitObj;
        Long orgId = (Long)orgIdObj;
        Long materialId = (Long)materialObj;
        Long materialmasterid = (Long)materialmasteridObj;
        ArrayListValuedHashMap mapSuppierRow = new ArrayListValuedHashMap(subEntries.size());
        for (int i = 0; i < subEntries.size(); ++i) {
            DynamicObject subEntry = (DynamicObject)subEntries.get(i);
            int rank = subEntry.getInt("supplyrank");
            mapSuppierRow.put((Object)rank, (Object)subEntry);
        }
        Map asMap = mapSuppierRow.asMap();
        BigDecimal sumbasequotaQty = ZERO;
        for (Map.Entry rankRowEntrty : asMap.entrySet()) {
            Collection rowEntrtyTemp = (Collection)rankRowEntrty.getValue();
            List rowEntrty = (List)rowEntrtyTemp;
            baseQty = baseQty.subtract(sumbasequotaQty);
            sumbasequotaQty = ZERO;
            if (baseQty.compareTo(ZERO) <= 0) break;
            for (int i = 0; i < rowEntrty.size(); ++i) {
                QuotaCalculateDTO sourceDTO;
                BigDecimal quotaBaseQty;
                DynamicObject tempobject;
                DynamicObject row = (DynamicObject)rowEntrty.get(i);
                DynamicObject supplier = row.getDynamicObject("supplier");
                Long supplierid = (Long)supplier.getPkValue();
                BigDecimal allotBaseQty = ZERO;
                allotBaseQty = i == rowEntrty.size() - 1 ? baseQty.subtract(sumbasequotaQty) : baseQty.multiply(row.getBigDecimal("quotarate")).divide(new BigDecimal(HUNDRED), BillQtyAndUnitHelper.getPrecision(baseUnit), BillQtyAndUnitHelper.getPrecisionType(baseUnit));
                DynamicObject sourceList = null;
                String bizUniqueKey = QuotaCalHelper.getBizUniqueKey(orgId, supplierid, materialId);
                if (sourceListMap != null && null != (tempobject = sourceListMap.get(bizUniqueKey))) {
                    sourceList = tempobject;
                }
                if ((quotaBaseQty = (sourceDTO = QuotaCalHelper.calculateQuotaQtyBySourceList(supplierid, orgId, materialId, allotBaseQty, baseUnit, materialmasterid, sourceList)).getQuotaBaseQty()) != null && quotaBaseQty.compareTo(ZERO) <= 0) continue;
                if (quotaBaseQty != null) {
                    sumbasequotaQty = sumbasequotaQty.add(quotaBaseQty);
                }
                result.put(supplierid, quotaBaseQty);
            }
        }
        return result;
    }

    private static QuotaCalculateDTO calculateQuotaQtyBySourceList(Long supplierid, Long orgid, Long materialId, BigDecimal baseUnitQty, DynamicObject baseUnit, Long materialmasterid, DynamicObject sourceListEntry) throws KDBizException {
        BigDecimal quotaQty = ZERO;
        Date bizTime = TimeServiceHelper.today();
        if (sourceListEntry == null) {
            quotaQty = baseUnitQty;
            return QuotaCalculateDTO.acceptSourceList(quotaQty, ZERO, ZERO, ZERO);
        }
        Date startdate = sourceListEntry.getDate("entryentity.effectdate");
        Date enddate = sourceListEntry.getDate("entryentity.expirydate");
        if (!bizTime.before(startdate) && !bizTime.after(enddate)) {
            BigDecimal maxbillqty = sourceListEntry.getBigDecimal("entryentity.maxbillqty");
            BigDecimal minbillqty = sourceListEntry.getBigDecimal("entryentity.minbillqty");
            BigDecimal packagebatchqty = sourceListEntry.getBigDecimal("entryentity.packagebatchqty");
            Long purchaseunit = sourceListEntry.getLong("entryentity.purchaseunit");
            BigDecimal finalmaxbillqty = BillQtyAndUnitHelper.getDesQtyConv(materialmasterid, purchaseunit, maxbillqty, baseUnit);
            BigDecimal finalminbillqty = BillQtyAndUnitHelper.getDesQtyConv(materialmasterid, purchaseunit, minbillqty, baseUnit);
            if (ZERO.compareTo(maxbillqty) == 0) {
                quotaQty = ZERO.compareTo(packagebatchqty) == 0 ? baseUnitQty : baseUnitQty.divide(packagebatchqty, 0, 0).multiply(packagebatchqty);
            }
            if (baseUnitQty.compareTo(finalmaxbillqty) >= 0 && finalmaxbillqty.compareTo(ZERO) > 0) {
                quotaQty = finalmaxbillqty;
            }
            if (baseUnitQty.compareTo(finalminbillqty) > 0 && baseUnitQty.compareTo(finalmaxbillqty) < 0) {
                quotaQty = ZERO.compareTo(packagebatchqty) == 0 ? baseUnitQty : baseUnitQty.divide(packagebatchqty, 0, 0).multiply(packagebatchqty);
            }
            if (baseUnitQty.compareTo(finalminbillqty) <= 0) {
                quotaQty = finalminbillqty;
            }
            return QuotaCalculateDTO.acceptSourceList(quotaQty, finalmaxbillqty, finalminbillqty, packagebatchqty);
        }
        quotaQty = baseUnitQty;
        return QuotaCalculateDTO.acceptSourceList(quotaQty, ZERO, ZERO, ZERO);
    }

    private static String getBizUniqueKey(Long orgId, Long supplierId, Long bizPkvalue) {
        StringBuilder bizKey = new StringBuilder();
        bizKey.append(orgId).append('_');
        bizKey.append(supplierId).append('_');
        bizKey.append(bizPkvalue);
        return bizKey.toString();
    }
}

