/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.service.quotamodel.pojo.CalculateCycleDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.QuotaCalculateDTO;
import kd.scmc.pm.enums.EnableStatusEnum;
import kd.scmc.pm.enums.FrozenStatusEnum;
import kd.scmc.pm.enums.StatusEnum;

public class QuotaCalculImpHelper {
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final int ONE = 1;
    private static final int zero = 0;
    private static final String DATASETSYMBOL = "QuotaCalculImpHelper";
    private static final String BILLENTRYBASEQTY = "billentry.baseqty";
    private static final String BILLENTRYMATERIAL = "billentry.material";

    public static QuotaCalculateDTO calculateQuotaQty(Long supplierid, Long orgid, Long materialId, BigDecimal baseUnitQty, DynamicObject baseUnit, Long materialmasterid) throws KDBizException {
        LocalDateTime todaystart = LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
        Date bizTime = Date.from(todaystart.atZone(ZoneId.systemDefault()).toInstant());
        QFilter qFilter = new QFilter("org", "=", (Object)orgid);
        qFilter.and(new QFilter("supplier", "=", (Object)supplierid));
        qFilter.and(new QFilter("entryentity.material", "=", (Object)materialId));
        qFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        qFilter.and(new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue()));
        qFilter.and(new QFilter("entryentity.effectdate", "<=", (Object)bizTime));
        qFilter.and(new QFilter("entryentity.expirydate", ">=", (Object)bizTime));
        qFilter.and(new QFilter("entryentity.frozenstatus", "=", (Object)FrozenStatusEnum.UNFROZEN.getValue()));
        ArrayList selectlistFields = new ArrayList();
        Collections.addAll(selectlistFields, "id", "entryentity.id", "entryentity.material", "entryentity.purchaseunit", "entryentity.expirydate");
        Collections.addAll(selectlistFields, "entryentity.maxbillqty", "entryentity.minbillqty", "entryentity.packingbaseqty", "entryentity.effectdate");
        String selectFields = selectlistFields.stream().collect(Collectors.joining(","));
        DynamicObject sourceListEntry = QueryServiceHelper.queryOne((String)"pm_sourcelist", (String)selectFields, (QFilter[])qFilter.toArray());
        BigDecimal quotaQty = ZERO;
        if (sourceListEntry == null) {
            quotaQty = baseUnitQty;
            return QuotaCalculateDTO.acceptSourceList(quotaQty, ZERO, ZERO, ZERO);
        }
        Date startdate = sourceListEntry.getDate("entryentity.effectdate");
        Date enddate = sourceListEntry.getDate("entryentity.expirydate");
        if (!bizTime.before(startdate) && !bizTime.after(enddate)) {
            BigDecimal maxbillqty = sourceListEntry.getBigDecimal("entryentity.maxbillqty");
            BigDecimal minbillqty = sourceListEntry.getBigDecimal("entryentity.minbillqty");
            BigDecimal packingBaseQty = sourceListEntry.getBigDecimal("entryentity.packingbaseqty");
            Long purchaseunit = sourceListEntry.getLong("entryentity.purchaseunit");
            BigDecimal finalmaxbillqty = BillQtyAndUnitHelper.getDesQtyConv(materialmasterid, purchaseunit, maxbillqty, baseUnit);
            BigDecimal finalminbillqty = BillQtyAndUnitHelper.getDesQtyConv(materialmasterid, purchaseunit, minbillqty, baseUnit);
            if (ZERO.compareTo(maxbillqty) == 0) {
                quotaQty = ZERO.compareTo(packingBaseQty) == 0 ? baseUnitQty : baseUnitQty.divide(packingBaseQty, 0, 0).multiply(packingBaseQty);
            }
            if (baseUnitQty.compareTo(finalmaxbillqty) >= 0 && finalmaxbillqty.compareTo(ZERO) > 0) {
                quotaQty = finalmaxbillqty;
            }
            if (baseUnitQty.compareTo(finalminbillqty) > 0 && baseUnitQty.compareTo(finalmaxbillqty) < 0) {
                quotaQty = ZERO.compareTo(packingBaseQty) == 0 ? baseUnitQty : baseUnitQty.divide(packingBaseQty, 0, 0).multiply(packingBaseQty);
            }
            if (baseUnitQty.compareTo(finalminbillqty) <= 0) {
                quotaQty = finalminbillqty;
            }
            return QuotaCalculateDTO.acceptSourceList(quotaQty, finalmaxbillqty, finalminbillqty, packingBaseQty);
        }
        quotaQty = baseUnitQty;
        return QuotaCalculateDTO.acceptSourceList(quotaQty, ZERO, ZERO, ZERO);
    }

    public static QuotaCalculateDTO calculateMSQuotaQty(Long supplierid, Long orgid, Long materialId, BigDecimal baseUnitQty, DynamicObject baseUnit, Date bizTime, Long materialmasterid) throws KDBizException {
        QFilter qFilter = new QFilter("org", "=", (Object)orgid);
        qFilter.and(new QFilter("supplier", "=", (Object)supplierid));
        qFilter.and(new QFilter("entryentity.material", "=", (Object)materialId));
        qFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        qFilter.and(new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue()));
        qFilter.and(new QFilter("entryentity.effectdate", "<=", (Object)bizTime));
        qFilter.and(new QFilter("entryentity.expirydate", ">=", (Object)bizTime));
        qFilter.and(new QFilter("entryentity.frozenstatus", "=", (Object)FrozenStatusEnum.UNFROZEN.getValue()));
        ArrayList selectlistFields = new ArrayList();
        Collections.addAll(selectlistFields, "id", "entryentity.id", "entryentity.material", "entryentity.purchaseunit", "entryentity.expirydate");
        Collections.addAll(selectlistFields, "entryentity.maxbillqty", "entryentity.minbillqty", "entryentity.packingbaseqty", "entryentity.effectdate");
        String selectFields = selectlistFields.stream().collect(Collectors.joining(","));
        DynamicObject sourceListEntry = QueryServiceHelper.queryOne((String)"pm_sourcelist", (String)selectFields, (QFilter[])qFilter.toArray());
        BigDecimal quotaQty = ZERO;
        if (sourceListEntry == null) {
            quotaQty = baseUnitQty;
            return QuotaCalculateDTO.acceptSourceList(quotaQty, ZERO, ZERO, ZERO);
        }
        Date startdate = sourceListEntry.getDate("entryentity.effectdate");
        Date enddate = sourceListEntry.getDate("entryentity.expirydate");
        if (!bizTime.before(startdate) && !bizTime.after(enddate)) {
            BigDecimal maxbillqty = sourceListEntry.getBigDecimal("entryentity.maxbillqty");
            BigDecimal minbillqty = sourceListEntry.getBigDecimal("entryentity.minbillqty");
            BigDecimal packingBaseQty = sourceListEntry.getBigDecimal("entryentity.packingbaseqty");
            Long purchaseunit = sourceListEntry.getLong("entryentity.purchaseunit");
            BigDecimal finalmaxbillqty = BillQtyAndUnitHelper.getDesQtyConv(materialmasterid, purchaseunit, maxbillqty, baseUnit);
            BigDecimal finalminbillqty = BillQtyAndUnitHelper.getDesQtyConv(materialmasterid, purchaseunit, minbillqty, baseUnit);
            if (ZERO.compareTo(maxbillqty) == 0) {
                quotaQty = ZERO.compareTo(packingBaseQty) == 0 ? baseUnitQty : baseUnitQty.divide(packingBaseQty, 0, 0).multiply(packingBaseQty);
            }
            if (baseUnitQty.compareTo(finalmaxbillqty) >= 0 && finalmaxbillqty.compareTo(ZERO) > 0) {
                quotaQty = finalmaxbillqty;
            }
            if (baseUnitQty.compareTo(finalminbillqty) > 0 && baseUnitQty.compareTo(finalmaxbillqty) < 0) {
                quotaQty = ZERO.compareTo(packingBaseQty) == 0 ? baseUnitQty : baseUnitQty.divide(packingBaseQty, 0, 0).multiply(packingBaseQty);
            }
            if (baseUnitQty.compareTo(finalminbillqty) <= 0) {
                quotaQty = finalminbillqty;
            }
            return QuotaCalculateDTO.acceptSourceList(quotaQty, finalmaxbillqty, finalminbillqty, packingBaseQty);
        }
        quotaQty = baseUnitQty;
        return QuotaCalculateDTO.acceptSourceList(quotaQty, ZERO, ZERO, ZERO);
    }

    public static HashMap<Long, BigDecimal> calculateHistoryPurchaseBillQty(Long orgid, DynamicObject material, DynamicObject quotaSchema, DynamicObject unit) throws KDBizException {
        String calculatecycle = quotaSchema.getString("calculatecycle");
        Long materialId = (Long)material.getPkValue();
        LocalDate localDate = LocalDate.now();
        QFilter qFilter = null;
        LocalDate startDate = null;
        switch (calculatecycle) {
            case "A": {
                Date startday = quotaSchema.getDate("startday");
                qFilter = new QFilter("biztime", "=", (Object)startday);
                break;
            }
            case "B": {
                String startweekday = quotaSchema.getString("startweekday");
                int convertingWeekNum = CalculateCycleDTO.convertWeekNum(startweekday);
                int dayOfWeek = localDate.getDayOfWeek().getValue();
                if (dayOfWeek >= convertingWeekNum) {
                    int sumDay = dayOfWeek - convertingWeekNum;
                    startDate = localDate.minusDays(sumDay);
                } else {
                    int beleft = dayOfWeek - convertingWeekNum;
                    startDate = localDate.minusWeeks(1L).minusDays(beleft);
                }
                qFilter = new QFilter("biztime", ">=", (Object)startDate);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
            case "C": {
                String startmonthday = quotaSchema.getString("startmonthday");
                int dayOfMonth = localDate.getDayOfMonth();
                int monthNum = CalculateCycleDTO.convertMonthNum(startmonthday);
                if (dayOfMonth >= monthNum) {
                    int sumDay = dayOfMonth - monthNum;
                    startDate = localDate.minusDays(sumDay);
                } else {
                    int beleft = dayOfMonth - monthNum;
                    startDate = localDate.minusMonths(1L).minusDays(beleft);
                }
                qFilter = new QFilter("biztime", ">=", (Object)startDate);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
            case "D": {
                startDate = QuotaCalculImpHelper.getCurrentQuarterStartDate();
                qFilter = new QFilter("biztime", ">=", (Object)startDate);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
            case "E": {
                startDate = LocalDate.of(localDate.getYear(), 1, 1);
                qFilter = new QFilter("biztime", ">=", (Object)startDate);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
            case "F": {
                Date startotherday = quotaSchema.getDate("startotherday");
                qFilter = new QFilter("biztime", ">=", (Object)startotherday);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
        }
        HashMap<Long, BigDecimal> allSupplierQtyMap = new HashMap<Long, BigDecimal>(10);
        if (qFilter != null) {
            qFilter.and(new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue()));
            qFilter.and(new QFilter("org", "=", (Object)orgid));
            qFilter.and(new QFilter("billentry".concat(".").concat("material"), "=", (Object)materialId));
            DataSet alldataSet = QueryServiceHelper.queryDataSet((String)DATASETSYMBOL, (String)"pm_purorderbill", (String)"billentry.baseqty,supplier", (QFilter[])qFilter.toArray(), (String)BILLENTRYBASEQTY);
            DataSet allresult = alldataSet.groupBy(new String[]{"supplier"}).sum(BILLENTRYBASEQTY).finish();
            for (Row row : allresult) {
                Long supplierId = row.getLong("supplier");
                BigDecimal oneSupplierBaseqty = row.getBigDecimal(BILLENTRYBASEQTY);
                allSupplierQtyMap.put(supplierId, oneSupplierBaseqty);
            }
        }
        return allSupplierQtyMap;
    }

    public static BigDecimal calculateMSHistoryPurchaseBillQty(Long orgid, DynamicObject material, DynamicObject quotaSchema, DynamicObject unit, LocalDate localDate) throws KDBizException {
        String calculatecycle = quotaSchema.getString("calculatecycle");
        Long materialId = (Long)material.getPkValue();
        QFilter qFilter = null;
        LocalDate startDate = null;
        switch (calculatecycle) {
            case "A": {
                Date startday = quotaSchema.getDate("startday");
                qFilter = new QFilter("biztime", "=", (Object)startday);
                break;
            }
            case "B": {
                String startweekday = quotaSchema.getString("startweekday");
                int convertingWeekNum = CalculateCycleDTO.convertWeekNum(startweekday);
                int dayOfWeek = localDate.getDayOfWeek().getValue();
                if (dayOfWeek >= convertingWeekNum) {
                    int sumDay = dayOfWeek - convertingWeekNum;
                    startDate = localDate.minusDays(sumDay);
                } else {
                    int beleft = dayOfWeek - convertingWeekNum;
                    startDate = localDate.minusWeeks(1L).minusDays(beleft);
                }
                qFilter = new QFilter("biztime", ">=", (Object)startDate);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
            case "C": {
                String startmonthday = quotaSchema.getString("startmonthday");
                int dayOfMonth = localDate.getDayOfMonth();
                int monthNum = CalculateCycleDTO.convertMonthNum(startmonthday);
                if (dayOfMonth >= monthNum) {
                    int sumDay = dayOfMonth - monthNum;
                    startDate = localDate.minusDays(sumDay);
                } else {
                    int beleft = dayOfMonth - monthNum;
                    startDate = localDate.minusMonths(1L).minusDays(beleft);
                }
                qFilter = new QFilter("biztime", ">=", (Object)startDate);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
            case "D": {
                startDate = QuotaCalculImpHelper.getCurrentQuarterStartDate();
                qFilter = new QFilter("biztime", ">=", (Object)startDate);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
            case "E": {
                startDate = LocalDate.of(localDate.getYear(), 1, 1);
                qFilter = new QFilter("biztime", ">=", (Object)startDate);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
            case "F": {
                Date startotherday = quotaSchema.getDate("startotherday");
                qFilter = new QFilter("biztime", ">=", (Object)startotherday);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
        }
        BigDecimal totalBaseqty = ZERO;
        if (qFilter != null) {
            qFilter.and(new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue()));
            qFilter.and(new QFilter("org", "=", (Object)orgid));
            qFilter.and(new QFilter("billentry".concat(".").concat("material"), "=", (Object)materialId));
            DataSet alldataSet = QueryServiceHelper.queryDataSet((String)DATASETSYMBOL, (String)"pm_purorderbill", (String)BILLENTRYBASEQTY, (QFilter[])qFilter.toArray(), (String)BILLENTRYBASEQTY);
            DataSet allresult = alldataSet.groupBy().sum(BILLENTRYBASEQTY).finish();
            for (Row row : allresult) {
                totalBaseqty = row.getBigDecimal(BILLENTRYBASEQTY);
            }
        }
        return totalBaseqty;
    }

    public static BigDecimal calculateHistoryQuotaRate(Long orgid, DynamicObject material, DynamicObject quotaSchema, DynamicObject supplier, DynamicObject unit, BigDecimal allBillQty) throws KDBizException {
        String calculatecycle = quotaSchema.getString("calculatecycle");
        Long materialId = (Long)material.getPkValue();
        LocalDate localDate = LocalDate.now();
        QFilter qFilter = null;
        LocalDate startDate = null;
        switch (calculatecycle) {
            case "A": {
                Date startday = quotaSchema.getDate("startday");
                qFilter = new QFilter("biztime", "=", (Object)startday);
                break;
            }
            case "B": {
                String startweekday = quotaSchema.getString("startweekday");
                int convertingWeekNum = CalculateCycleDTO.convertWeekNum(startweekday);
                int dayOfWeek = localDate.getDayOfWeek().getValue();
                if (dayOfWeek >= convertingWeekNum) {
                    int sumDay = dayOfWeek - convertingWeekNum;
                    startDate = localDate.minusDays(sumDay);
                } else {
                    int beleft = dayOfWeek - convertingWeekNum;
                    startDate = localDate.minusWeeks(1L).minusDays(beleft);
                }
                qFilter = new QFilter("biztime", ">=", (Object)startDate);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
            case "C": {
                String startmonthday = quotaSchema.getString("startmonthday");
                int dayOfMonth = localDate.getDayOfMonth();
                int monthNum = CalculateCycleDTO.convertMonthNum(startmonthday);
                if (dayOfMonth >= monthNum) {
                    int sumDay = dayOfMonth - monthNum;
                    startDate = localDate.minusDays(sumDay);
                } else {
                    int beleft = dayOfMonth - monthNum;
                    startDate = localDate.minusMonths(1L).minusDays(beleft);
                }
                qFilter = new QFilter("biztime", ">=", (Object)startDate);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
            case "D": {
                startDate = QuotaCalculImpHelper.getCurrentQuarterStartDate();
                qFilter = new QFilter("biztime", ">=", (Object)startDate);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
            case "E": {
                startDate = LocalDate.of(localDate.getYear(), 1, 1);
                qFilter = new QFilter("biztime", ">=", (Object)startDate);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
            case "F": {
                Date startotherday = quotaSchema.getDate("startotherday");
                qFilter = new QFilter("biztime", ">=", (Object)startotherday);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
        }
        BigDecimal supplierBaseqty = ZERO;
        if (qFilter != null) {
            qFilter.and(new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue()));
            qFilter.and(new QFilter("org", "=", (Object)orgid));
            qFilter.and(new QFilter(BILLENTRYMATERIAL, "=", (Object)materialId));
            qFilter.and(new QFilter("supplier", "=", supplier.getPkValue()));
            DataSet supplierdataSet = QueryServiceHelper.queryDataSet((String)DATASETSYMBOL, (String)"pm_purorderbill", (String)BILLENTRYBASEQTY, (QFilter[])qFilter.toArray(), (String)BILLENTRYBASEQTY);
            DataSet supplierresult = supplierdataSet.groupBy().sum(BILLENTRYBASEQTY).finish();
            for (Row row : supplierresult) {
                supplierBaseqty = row.getBigDecimal(BILLENTRYBASEQTY);
            }
        }
        BigDecimal historyRate = supplierBaseqty.divide(allBillQty, 2, 4).multiply(BigDecimal.valueOf(100L));
        return historyRate;
    }

    public static BigDecimal calculateMSHistoryQuotaRate(Long orgid, DynamicObject material, DynamicObject quotaSchema, DynamicObject supplier, DynamicObject unit, BigDecimal allBillQty, LocalDate localDate) throws KDBizException {
        String calculatecycle = quotaSchema.getString("calculatecycle");
        Long materialId = (Long)material.getPkValue();
        QFilter qFilter = null;
        LocalDate startDate = null;
        switch (calculatecycle) {
            case "A": {
                Date startday = quotaSchema.getDate("startday");
                qFilter = new QFilter("biztime", "=", (Object)startday);
                break;
            }
            case "B": {
                String startweekday = quotaSchema.getString("startweekday");
                int convertingWeekNum = CalculateCycleDTO.convertWeekNum(startweekday);
                int dayOfWeek = localDate.getDayOfWeek().getValue();
                if (dayOfWeek >= convertingWeekNum) {
                    int sumDay = dayOfWeek - convertingWeekNum;
                    startDate = localDate.minusDays(sumDay);
                } else {
                    int beleft = dayOfWeek - convertingWeekNum;
                    startDate = localDate.minusWeeks(1L).minusDays(beleft);
                }
                qFilter = new QFilter("biztime", ">=", (Object)startDate);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
            case "C": {
                String startmonthday = quotaSchema.getString("startmonthday");
                int dayOfMonth = localDate.getDayOfMonth();
                int monthNum = CalculateCycleDTO.convertMonthNum(startmonthday);
                if (dayOfMonth >= monthNum) {
                    int sumDay = dayOfMonth - monthNum;
                    startDate = localDate.minusDays(sumDay);
                } else {
                    int beleft = dayOfMonth - monthNum;
                    startDate = localDate.minusMonths(1L).minusDays(beleft);
                }
                qFilter = new QFilter("biztime", ">=", (Object)startDate);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
            case "D": {
                startDate = QuotaCalculImpHelper.getQuarterStartDate(localDate);
                qFilter = new QFilter("biztime", ">=", (Object)startDate);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
            case "E": {
                startDate = LocalDate.of(localDate.getYear(), 1, 1);
                qFilter = new QFilter("biztime", ">=", (Object)startDate);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
            case "F": {
                Date startotherday = quotaSchema.getDate("startotherday");
                qFilter = new QFilter("biztime", ">=", (Object)startotherday);
                qFilter.and(new QFilter("biztime", "<=", (Object)localDate));
                break;
            }
        }
        BigDecimal supplierBaseqty = ZERO;
        if (qFilter != null) {
            qFilter.and(new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue()));
            qFilter.and(new QFilter("org", "=", (Object)orgid));
            qFilter.and(new QFilter(BILLENTRYMATERIAL, "=", (Object)materialId));
            qFilter.and(new QFilter("supplier", "=", supplier.getPkValue()));
            DataSet supplierdataSet = QueryServiceHelper.queryDataSet((String)DATASETSYMBOL, (String)"pm_purorderbill", (String)BILLENTRYBASEQTY, (QFilter[])qFilter.toArray(), (String)BILLENTRYBASEQTY);
            DataSet supplierresult = supplierdataSet.groupBy().sum(BILLENTRYBASEQTY).finish();
            for (Row row : supplierresult) {
                supplierBaseqty = row.getBigDecimal(BILLENTRYBASEQTY);
            }
        }
        BigDecimal historyRate = supplierBaseqty.divide(allBillQty, 2, 4).multiply(BigDecimal.valueOf(100L));
        return historyRate;
    }

    public static LocalDate getCurrentQuarterStartDate() {
        LocalDate localDate = LocalDate.now();
        int month = localDate.getMonthValue();
        LocalDate quarterstartdate = null;
        if (1 <= month && month <= 3) {
            quarterstartdate = LocalDate.of(localDate.getYear(), 1, 1);
        }
        if (4 <= month && month <= 6) {
            quarterstartdate = LocalDate.of(localDate.getYear(), 4, 1);
        }
        if (7 <= month && month <= 9) {
            quarterstartdate = LocalDate.of(localDate.getYear(), 7, 1);
        }
        if (10 <= month && month < 12) {
            quarterstartdate = LocalDate.of(localDate.getYear(), 10, 1);
        }
        return quarterstartdate;
    }

    public static LocalDate getQuarterStartDate(LocalDate localDate) {
        int month = localDate.getMonthValue();
        LocalDate quarterstartdate = null;
        if (1 <= month && month <= 3) {
            quarterstartdate = LocalDate.of(localDate.getYear(), 1, 1);
        }
        if (4 <= month && month <= 6) {
            quarterstartdate = LocalDate.of(localDate.getYear(), 4, 1);
        }
        if (7 <= month && month <= 9) {
            quarterstartdate = LocalDate.of(localDate.getYear(), 7, 1);
        }
        if (10 <= month && month < 12) {
            quarterstartdate = LocalDate.of(localDate.getYear(), 10, 1);
        }
        return quarterstartdate;
    }

    public static BigDecimal changeAuxQty(DynamicObject material, DynamicObject auxUnit, DynamicObject resultUnit, BigDecimal quotaQty) throws KDBizException {
        BigDecimal resultUnitAuxQty = BigDecimal.ZERO;
        if (material != null) {
            DynamicObject master = material.getDynamicObject("masterid");
            if (resultUnit != null && auxUnit != null && master != null) {
                BigDecimal calculQty;
                Long masterId = (Long)master.getPkValue();
                resultUnitAuxQty = calculQty = BillQtyAndUnitHelper.getDesQtyConv(masterId, resultUnit, quotaQty, auxUnit);
            }
        }
        return resultUnitAuxQty;
    }
}

