/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.business.helper;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;

public class ReqApplyBillHelper {
    public static void calSumReqApplyLogical(List<DynamicObject> reqList) {
        for (DynamicObject reqApplyBill : reqList) {
            DynamicObjectCollection billEntry = reqApplyBill.getDynamicObjectCollection("billentry");
            for (DynamicObject row : billEntry) {
                DynamicObject materialMaster = row.getDynamicObject("materialmasterid");
                DynamicObject unit = row.getDynamicObject("unit");
                if (materialMaster == null || unit == null) {
                    return;
                }
                DynamicObject baseUnit = row.getDynamicObject("baseunit");
                if (baseUnit == null && (baseUnit = materialMaster.getDynamicObject("baseunit")) != null) {
                    row.set("baseunit", (Object)baseUnit);
                }
                if (baseUnit == null) continue;
                BigDecimal baseQty = row.getBigDecimal("baseqty");
                row.set("unit", (Object)baseUnit);
                row.set("qty", (Object)baseQty);
            }
        }
    }

    public static void calDefaultReqApplyLogical(List<DynamicObject> reqList) {
        for (DynamicObject reqApplyBill : reqList) {
            DynamicObjectCollection billEntry = reqApplyBill.getDynamicObjectCollection("billentry");
            for (DynamicObject row : billEntry) {
                DynamicObject materialMaster = row.getDynamicObject("materialmasterid");
                DynamicObject unit = row.getDynamicObject("unit");
                if (materialMaster == null || unit == null) {
                    return;
                }
                DynamicObject baseUnit = row.getDynamicObject("baseunit");
                if (baseUnit == null && (baseUnit = materialMaster.getDynamicObject("baseunit")) != null) {
                    row.set("baseunit", (Object)baseUnit);
                }
                if (baseUnit == null) continue;
                Long materialMasterId = (Long)materialMaster.getPkValue();
                BigDecimal baseQty = row.getBigDecimal("baseqty");
                BigDecimal qty = BillQtyAndUnitHelper.getDesQtyConv(materialMasterId, baseUnit, baseQty, unit);
                row.set("qty", (Object)qty);
            }
        }
    }
}

